<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfBillUserNote Array
 * @subpackage Arrays
 */
class ArrayOfBillUserNote extends AbstractStructArrayBase
{
    /**
     * The BillUserNote
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\BillUserNote[]
     */
    public $BillUserNote;
    /**
     * Constructor method for ArrayOfBillUserNote
     * @uses ArrayOfBillUserNote::setBillUserNote()
     * @param \SGCIS\Struct\BillUserNote[] $billUserNote
     */
    public function __construct(array $billUserNote = array())
    {
        $this
            ->setBillUserNote($billUserNote);
    }
    /**
     * Get BillUserNote value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\BillUserNote[]|null
     */
    public function getBillUserNote()
    {
        return isset($this->BillUserNote) ? $this->BillUserNote : null;
    }
    /**
     * Set BillUserNote value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\BillUserNote[] $billUserNote
     * @return \SGCIS\Array\ArrayOfBillUserNote
     */
    public function setBillUserNote(array $billUserNote = array())
    {
        foreach ($billUserNote as $arrayOfBillUserNoteBillUserNoteItem) {
            // validation for constraint: itemType
            if (!$arrayOfBillUserNoteBillUserNoteItem instanceof \SGCIS\Struct\BillUserNote) {
                throw new \InvalidArgumentException(sprintf('The BillUserNote property can only contain items of \SGCIS\Struct\BillUserNote, "%s" given', is_object($arrayOfBillUserNoteBillUserNoteItem) ? get_class($arrayOfBillUserNoteBillUserNoteItem) : gettype($arrayOfBillUserNoteBillUserNoteItem)), __LINE__);
            }
        }
        if (is_null($billUserNote) || (is_array($billUserNote) && empty($billUserNote))) {
            unset($this->BillUserNote);
        } else {
            $this->BillUserNote = $billUserNote;
        }
        return $this;
    }
    /**
     * Add item to BillUserNote value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\BillUserNote $item
     * @return \SGCIS\Array\ArrayOfBillUserNote
     */
    public function addToBillUserNote(\SGCIS\Struct\BillUserNote $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\BillUserNote) {
            throw new \InvalidArgumentException(sprintf('The BillUserNote property can only contain items of \SGCIS\Struct\BillUserNote, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->BillUserNote[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\BillUserNote|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\BillUserNote|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\BillUserNote|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\BillUserNote|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\BillUserNote|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string BillUserNote
     */
    public function getAttributeName()
    {
        return 'BillUserNote';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfBillUserNote
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
