<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfBillServicePointMeteredUsage Array
 * @subpackage Arrays
 */
class ArrayOfBillServicePointMeteredUsage extends AbstractStructArrayBase
{
    /**
     * The BillServicePointMeteredUsage
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\BillServicePointMeteredUsage[]
     */
    public $BillServicePointMeteredUsage;
    /**
     * Constructor method for ArrayOfBillServicePointMeteredUsage
     * @uses ArrayOfBillServicePointMeteredUsage::setBillServicePointMeteredUsage()
     * @param \SGCIS\Struct\BillServicePointMeteredUsage[] $billServicePointMeteredUsage
     */
    public function __construct(array $billServicePointMeteredUsage = array())
    {
        $this
            ->setBillServicePointMeteredUsage($billServicePointMeteredUsage);
    }
    /**
     * Get BillServicePointMeteredUsage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\BillServicePointMeteredUsage[]|null
     */
    public function getBillServicePointMeteredUsage()
    {
        return isset($this->BillServicePointMeteredUsage) ? $this->BillServicePointMeteredUsage : null;
    }
    /**
     * Set BillServicePointMeteredUsage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\BillServicePointMeteredUsage[] $billServicePointMeteredUsage
     * @return \SGCIS\Array\ArrayOfBillServicePointMeteredUsage
     */
    public function setBillServicePointMeteredUsage(array $billServicePointMeteredUsage = array())
    {
        foreach ($billServicePointMeteredUsage as $arrayOfBillServicePointMeteredUsageBillServicePointMeteredUsageItem) {
            // validation for constraint: itemType
            if (!$arrayOfBillServicePointMeteredUsageBillServicePointMeteredUsageItem instanceof \SGCIS\Struct\BillServicePointMeteredUsage) {
                throw new \InvalidArgumentException(sprintf('The BillServicePointMeteredUsage property can only contain items of \SGCIS\Struct\BillServicePointMeteredUsage, "%s" given', is_object($arrayOfBillServicePointMeteredUsageBillServicePointMeteredUsageItem) ? get_class($arrayOfBillServicePointMeteredUsageBillServicePointMeteredUsageItem) : gettype($arrayOfBillServicePointMeteredUsageBillServicePointMeteredUsageItem)), __LINE__);
            }
        }
        if (is_null($billServicePointMeteredUsage) || (is_array($billServicePointMeteredUsage) && empty($billServicePointMeteredUsage))) {
            unset($this->BillServicePointMeteredUsage);
        } else {
            $this->BillServicePointMeteredUsage = $billServicePointMeteredUsage;
        }
        return $this;
    }
    /**
     * Add item to BillServicePointMeteredUsage value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\BillServicePointMeteredUsage $item
     * @return \SGCIS\Array\ArrayOfBillServicePointMeteredUsage
     */
    public function addToBillServicePointMeteredUsage(\SGCIS\Struct\BillServicePointMeteredUsage $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\BillServicePointMeteredUsage) {
            throw new \InvalidArgumentException(sprintf('The BillServicePointMeteredUsage property can only contain items of \SGCIS\Struct\BillServicePointMeteredUsage, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->BillServicePointMeteredUsage[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\BillServicePointMeteredUsage|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\BillServicePointMeteredUsage|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\BillServicePointMeteredUsage|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\BillServicePointMeteredUsage|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\BillServicePointMeteredUsage|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string BillServicePointMeteredUsage
     */
    public function getAttributeName()
    {
        return 'BillServicePointMeteredUsage';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfBillServicePointMeteredUsage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
