<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAuditLog Array
 * @subpackage Arrays
 */
class ArrayOfAuditLog extends AbstractStructArrayBase
{
    /**
     * The AuditLog
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\AuditLog[]
     */
    public $AuditLog;
    /**
     * Constructor method for ArrayOfAuditLog
     * @uses ArrayOfAuditLog::setAuditLog()
     * @param \SGCIS\Struct\AuditLog[] $auditLog
     */
    public function __construct(array $auditLog = array())
    {
        $this
            ->setAuditLog($auditLog);
    }
    /**
     * Get AuditLog value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\AuditLog[]|null
     */
    public function getAuditLog()
    {
        return isset($this->AuditLog) ? $this->AuditLog : null;
    }
    /**
     * Set AuditLog value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\AuditLog[] $auditLog
     * @return \SGCIS\Array\ArrayOfAuditLog
     */
    public function setAuditLog(array $auditLog = array())
    {
        foreach ($auditLog as $arrayOfAuditLogAuditLogItem) {
            // validation for constraint: itemType
            if (!$arrayOfAuditLogAuditLogItem instanceof \SGCIS\Struct\AuditLog) {
                throw new \InvalidArgumentException(sprintf('The AuditLog property can only contain items of \SGCIS\Struct\AuditLog, "%s" given', is_object($arrayOfAuditLogAuditLogItem) ? get_class($arrayOfAuditLogAuditLogItem) : gettype($arrayOfAuditLogAuditLogItem)), __LINE__);
            }
        }
        if (is_null($auditLog) || (is_array($auditLog) && empty($auditLog))) {
            unset($this->AuditLog);
        } else {
            $this->AuditLog = $auditLog;
        }
        return $this;
    }
    /**
     * Add item to AuditLog value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\AuditLog $item
     * @return \SGCIS\Array\ArrayOfAuditLog
     */
    public function addToAuditLog(\SGCIS\Struct\AuditLog $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\AuditLog) {
            throw new \InvalidArgumentException(sprintf('The AuditLog property can only contain items of \SGCIS\Struct\AuditLog, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AuditLog[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\AuditLog|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\AuditLog|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\AuditLog|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\AuditLog|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\AuditLog|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AuditLog
     */
    public function getAttributeName()
    {
        return 'AuditLog';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfAuditLog
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
