<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAccountType Array
 * @subpackage Arrays
 */
class ArrayOfAccountType extends AbstractStructArrayBase
{
    /**
     * The AccountType
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\AccountType[]
     */
    public $AccountType;
    /**
     * Constructor method for ArrayOfAccountType
     * @uses ArrayOfAccountType::setAccountType()
     * @param \SGCIS\Struct\AccountType[] $accountType
     */
    public function __construct(array $accountType = array())
    {
        $this
            ->setAccountType($accountType);
    }
    /**
     * Get AccountType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\AccountType[]|null
     */
    public function getAccountType()
    {
        return isset($this->AccountType) ? $this->AccountType : null;
    }
    /**
     * Set AccountType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\AccountType[] $accountType
     * @return \SGCIS\Array\ArrayOfAccountType
     */
    public function setAccountType(array $accountType = array())
    {
        foreach ($accountType as $arrayOfAccountTypeAccountTypeItem) {
            // validation for constraint: itemType
            if (!$arrayOfAccountTypeAccountTypeItem instanceof \SGCIS\Struct\AccountType) {
                throw new \InvalidArgumentException(sprintf('The AccountType property can only contain items of \SGCIS\Struct\AccountType, "%s" given', is_object($arrayOfAccountTypeAccountTypeItem) ? get_class($arrayOfAccountTypeAccountTypeItem) : gettype($arrayOfAccountTypeAccountTypeItem)), __LINE__);
            }
        }
        if (is_null($accountType) || (is_array($accountType) && empty($accountType))) {
            unset($this->AccountType);
        } else {
            $this->AccountType = $accountType;
        }
        return $this;
    }
    /**
     * Add item to AccountType value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\AccountType $item
     * @return \SGCIS\Array\ArrayOfAccountType
     */
    public function addToAccountType(\SGCIS\Struct\AccountType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\AccountType) {
            throw new \InvalidArgumentException(sprintf('The AccountType property can only contain items of \SGCIS\Struct\AccountType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AccountType[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\AccountType|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\AccountType|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\AccountType|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\AccountType|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\AccountType|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AccountType
     */
    public function getAttributeName()
    {
        return 'AccountType';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfAccountType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
