<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAccountPerson Array
 * @subpackage Arrays
 */
class ArrayOfAccountPerson extends AbstractStructArrayBase
{
    /**
     * The AccountPerson
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\AccountPerson[]
     */
    public $AccountPerson;
    /**
     * Constructor method for ArrayOfAccountPerson
     * @uses ArrayOfAccountPerson::setAccountPerson()
     * @param \SGCIS\Struct\AccountPerson[] $accountPerson
     */
    public function __construct(array $accountPerson = array())
    {
        $this
            ->setAccountPerson($accountPerson);
    }
    /**
     * Get AccountPerson value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\AccountPerson[]|null
     */
    public function getAccountPerson()
    {
        return isset($this->AccountPerson) ? $this->AccountPerson : null;
    }
    /**
     * Set AccountPerson value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\AccountPerson[] $accountPerson
     * @return \SGCIS\Array\ArrayOfAccountPerson
     */
    public function setAccountPerson(array $accountPerson = array())
    {
        foreach ($accountPerson as $arrayOfAccountPersonAccountPersonItem) {
            // validation for constraint: itemType
            if (!$arrayOfAccountPersonAccountPersonItem instanceof \SGCIS\Struct\AccountPerson) {
                throw new \InvalidArgumentException(sprintf('The AccountPerson property can only contain items of \SGCIS\Struct\AccountPerson, "%s" given', is_object($arrayOfAccountPersonAccountPersonItem) ? get_class($arrayOfAccountPersonAccountPersonItem) : gettype($arrayOfAccountPersonAccountPersonItem)), __LINE__);
            }
        }
        if (is_null($accountPerson) || (is_array($accountPerson) && empty($accountPerson))) {
            unset($this->AccountPerson);
        } else {
            $this->AccountPerson = $accountPerson;
        }
        return $this;
    }
    /**
     * Add item to AccountPerson value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\AccountPerson $item
     * @return \SGCIS\Array\ArrayOfAccountPerson
     */
    public function addToAccountPerson(\SGCIS\Struct\AccountPerson $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\AccountPerson) {
            throw new \InvalidArgumentException(sprintf('The AccountPerson property can only contain items of \SGCIS\Struct\AccountPerson, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AccountPerson[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\AccountPerson|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\AccountPerson|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\AccountPerson|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\AccountPerson|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\AccountPerson|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AccountPerson
     */
    public function getAttributeName()
    {
        return 'AccountPerson';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfAccountPerson
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
