<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAccountFee Array
 * @subpackage Arrays
 */
class ArrayOfAccountFee extends AbstractStructArrayBase
{
    /**
     * The AccountFee
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\AccountFee[]
     */
    public $AccountFee;
    /**
     * Constructor method for ArrayOfAccountFee
     * @uses ArrayOfAccountFee::setAccountFee()
     * @param \SGCIS\Struct\AccountFee[] $accountFee
     */
    public function __construct(array $accountFee = array())
    {
        $this
            ->setAccountFee($accountFee);
    }
    /**
     * Get AccountFee value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\AccountFee[]|null
     */
    public function getAccountFee()
    {
        return isset($this->AccountFee) ? $this->AccountFee : null;
    }
    /**
     * Set AccountFee value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\AccountFee[] $accountFee
     * @return \SGCIS\Array\ArrayOfAccountFee
     */
    public function setAccountFee(array $accountFee = array())
    {
        foreach ($accountFee as $arrayOfAccountFeeAccountFeeItem) {
            // validation for constraint: itemType
            if (!$arrayOfAccountFeeAccountFeeItem instanceof \SGCIS\Struct\AccountFee) {
                throw new \InvalidArgumentException(sprintf('The AccountFee property can only contain items of \SGCIS\Struct\AccountFee, "%s" given', is_object($arrayOfAccountFeeAccountFeeItem) ? get_class($arrayOfAccountFeeAccountFeeItem) : gettype($arrayOfAccountFeeAccountFeeItem)), __LINE__);
            }
        }
        if (is_null($accountFee) || (is_array($accountFee) && empty($accountFee))) {
            unset($this->AccountFee);
        } else {
            $this->AccountFee = $accountFee;
        }
        return $this;
    }
    /**
     * Add item to AccountFee value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\AccountFee $item
     * @return \SGCIS\Array\ArrayOfAccountFee
     */
    public function addToAccountFee(\SGCIS\Struct\AccountFee $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\AccountFee) {
            throw new \InvalidArgumentException(sprintf('The AccountFee property can only contain items of \SGCIS\Struct\AccountFee, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AccountFee[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\AccountFee|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\AccountFee|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\AccountFee|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\AccountFee|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\AccountFee|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AccountFee
     */
    public function getAttributeName()
    {
        return 'AccountFee';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfAccountFee
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
