<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAccountDocumentType Array
 * @subpackage Arrays
 */
class ArrayOfAccountDocumentType extends AbstractStructArrayBase
{
    /**
     * The AccountDocumentType
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\AccountDocumentType[]
     */
    public $AccountDocumentType;
    /**
     * Constructor method for ArrayOfAccountDocumentType
     * @uses ArrayOfAccountDocumentType::setAccountDocumentType()
     * @param \SGCIS\Struct\AccountDocumentType[] $accountDocumentType
     */
    public function __construct(array $accountDocumentType = array())
    {
        $this
            ->setAccountDocumentType($accountDocumentType);
    }
    /**
     * Get AccountDocumentType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\AccountDocumentType[]|null
     */
    public function getAccountDocumentType()
    {
        return isset($this->AccountDocumentType) ? $this->AccountDocumentType : null;
    }
    /**
     * Set AccountDocumentType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\AccountDocumentType[] $accountDocumentType
     * @return \SGCIS\Array\ArrayOfAccountDocumentType
     */
    public function setAccountDocumentType(array $accountDocumentType = array())
    {
        foreach ($accountDocumentType as $arrayOfAccountDocumentTypeAccountDocumentTypeItem) {
            // validation for constraint: itemType
            if (!$arrayOfAccountDocumentTypeAccountDocumentTypeItem instanceof \SGCIS\Struct\AccountDocumentType) {
                throw new \InvalidArgumentException(sprintf('The AccountDocumentType property can only contain items of \SGCIS\Struct\AccountDocumentType, "%s" given', is_object($arrayOfAccountDocumentTypeAccountDocumentTypeItem) ? get_class($arrayOfAccountDocumentTypeAccountDocumentTypeItem) : gettype($arrayOfAccountDocumentTypeAccountDocumentTypeItem)), __LINE__);
            }
        }
        if (is_null($accountDocumentType) || (is_array($accountDocumentType) && empty($accountDocumentType))) {
            unset($this->AccountDocumentType);
        } else {
            $this->AccountDocumentType = $accountDocumentType;
        }
        return $this;
    }
    /**
     * Add item to AccountDocumentType value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\AccountDocumentType $item
     * @return \SGCIS\Array\ArrayOfAccountDocumentType
     */
    public function addToAccountDocumentType(\SGCIS\Struct\AccountDocumentType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\AccountDocumentType) {
            throw new \InvalidArgumentException(sprintf('The AccountDocumentType property can only contain items of \SGCIS\Struct\AccountDocumentType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AccountDocumentType[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\AccountDocumentType|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\AccountDocumentType|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\AccountDocumentType|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\AccountDocumentType|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\AccountDocumentType|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AccountDocumentType
     */
    public function getAttributeName()
    {
        return 'AccountDocumentType';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfAccountDocumentType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
