<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAccountAutoPay Array
 * @subpackage Arrays
 */
class ArrayOfAccountAutoPay extends AbstractStructArrayBase
{
    /**
     * The AccountAutoPay
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\AccountAutoPay[]
     */
    public $AccountAutoPay;
    /**
     * Constructor method for ArrayOfAccountAutoPay
     * @uses ArrayOfAccountAutoPay::setAccountAutoPay()
     * @param \SGCIS\Struct\AccountAutoPay[] $accountAutoPay
     */
    public function __construct(array $accountAutoPay = array())
    {
        $this
            ->setAccountAutoPay($accountAutoPay);
    }
    /**
     * Get AccountAutoPay value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\AccountAutoPay[]|null
     */
    public function getAccountAutoPay()
    {
        return isset($this->AccountAutoPay) ? $this->AccountAutoPay : null;
    }
    /**
     * Set AccountAutoPay value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\AccountAutoPay[] $accountAutoPay
     * @return \SGCIS\Array\ArrayOfAccountAutoPay
     */
    public function setAccountAutoPay(array $accountAutoPay = array())
    {
        foreach ($accountAutoPay as $arrayOfAccountAutoPayAccountAutoPayItem) {
            // validation for constraint: itemType
            if (!$arrayOfAccountAutoPayAccountAutoPayItem instanceof \SGCIS\Struct\AccountAutoPay) {
                throw new \InvalidArgumentException(sprintf('The AccountAutoPay property can only contain items of \SGCIS\Struct\AccountAutoPay, "%s" given', is_object($arrayOfAccountAutoPayAccountAutoPayItem) ? get_class($arrayOfAccountAutoPayAccountAutoPayItem) : gettype($arrayOfAccountAutoPayAccountAutoPayItem)), __LINE__);
            }
        }
        if (is_null($accountAutoPay) || (is_array($accountAutoPay) && empty($accountAutoPay))) {
            unset($this->AccountAutoPay);
        } else {
            $this->AccountAutoPay = $accountAutoPay;
        }
        return $this;
    }
    /**
     * Add item to AccountAutoPay value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\AccountAutoPay $item
     * @return \SGCIS\Array\ArrayOfAccountAutoPay
     */
    public function addToAccountAutoPay(\SGCIS\Struct\AccountAutoPay $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\AccountAutoPay) {
            throw new \InvalidArgumentException(sprintf('The AccountAutoPay property can only contain items of \SGCIS\Struct\AccountAutoPay, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AccountAutoPay[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\AccountAutoPay|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\AccountAutoPay|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\AccountAutoPay|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\AccountAutoPay|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\AccountAutoPay|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AccountAutoPay
     */
    public function getAttributeName()
    {
        return 'AccountAutoPay';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfAccountAutoPay
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
