<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ZipCodeWeatherRequest Struct
 * @subpackage Structs
 */
class ZipCodeWeatherRequest extends ServiceRequestBase
{
    /**
     * The ZipCodeWeatherID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ZipCodeWeatherID;
    /**
     * The FromDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $FromDate;
    /**
     * The ToDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ToDate;
    /**
     * The AccountActivityGroupTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountActivityGroupTypeID;
    /**
     * The ZipCodeWeather
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\ZipCodeWeather
     */
    public $ZipCodeWeather;
    /**
     * The ZipCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ZipCode;
    /**
     * Constructor method for ZipCodeWeatherRequest
     * @uses ZipCodeWeatherRequest::setZipCodeWeatherID()
     * @uses ZipCodeWeatherRequest::setFromDate()
     * @uses ZipCodeWeatherRequest::setToDate()
     * @uses ZipCodeWeatherRequest::setAccountActivityGroupTypeID()
     * @uses ZipCodeWeatherRequest::setZipCodeWeather()
     * @uses ZipCodeWeatherRequest::setZipCode()
     * @param int $zipCodeWeatherID
     * @param string $fromDate
     * @param string $toDate
     * @param int $accountActivityGroupTypeID
     * @param \SGCIS\Struct\ZipCodeWeather $zipCodeWeather
     * @param string $zipCode
     */
    public function __construct($zipCodeWeatherID = null, $fromDate = null, $toDate = null, $accountActivityGroupTypeID = null, \SGCIS\Struct\ZipCodeWeather $zipCodeWeather = null, $zipCode = null)
    {
        $this
            ->setZipCodeWeatherID($zipCodeWeatherID)
            ->setFromDate($fromDate)
            ->setToDate($toDate)
            ->setAccountActivityGroupTypeID($accountActivityGroupTypeID)
            ->setZipCodeWeather($zipCodeWeather)
            ->setZipCode($zipCode);
    }
    /**
     * Get ZipCodeWeatherID value
     * @return int
     */
    public function getZipCodeWeatherID()
    {
        return $this->ZipCodeWeatherID;
    }
    /**
     * Set ZipCodeWeatherID value
     * @param int $zipCodeWeatherID
     * @return \SGCIS\Struct\ZipCodeWeatherRequest
     */
    public function setZipCodeWeatherID($zipCodeWeatherID = null)
    {
        // validation for constraint: int
        if (!is_null($zipCodeWeatherID) && !is_numeric($zipCodeWeatherID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($zipCodeWeatherID)), __LINE__);
        }
        $this->ZipCodeWeatherID = $zipCodeWeatherID;
        return $this;
    }
    /**
     * Get FromDate value
     * @return string
     */
    public function getFromDate()
    {
        return $this->FromDate;
    }
    /**
     * Set FromDate value
     * @param string $fromDate
     * @return \SGCIS\Struct\ZipCodeWeatherRequest
     */
    public function setFromDate($fromDate = null)
    {
        // validation for constraint: string
        if (!is_null($fromDate) && !is_string($fromDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fromDate)), __LINE__);
        }
        $this->FromDate = $fromDate;
        return $this;
    }
    /**
     * Get ToDate value
     * @return string
     */
    public function getToDate()
    {
        return $this->ToDate;
    }
    /**
     * Set ToDate value
     * @param string $toDate
     * @return \SGCIS\Struct\ZipCodeWeatherRequest
     */
    public function setToDate($toDate = null)
    {
        // validation for constraint: string
        if (!is_null($toDate) && !is_string($toDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($toDate)), __LINE__);
        }
        $this->ToDate = $toDate;
        return $this;
    }
    /**
     * Get AccountActivityGroupTypeID value
     * @return int
     */
    public function getAccountActivityGroupTypeID()
    {
        return $this->AccountActivityGroupTypeID;
    }
    /**
     * Set AccountActivityGroupTypeID value
     * @param int $accountActivityGroupTypeID
     * @return \SGCIS\Struct\ZipCodeWeatherRequest
     */
    public function setAccountActivityGroupTypeID($accountActivityGroupTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($accountActivityGroupTypeID) && !is_numeric($accountActivityGroupTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountActivityGroupTypeID)), __LINE__);
        }
        $this->AccountActivityGroupTypeID = $accountActivityGroupTypeID;
        return $this;
    }
    /**
     * Get ZipCodeWeather value
     * @return \SGCIS\Struct\ZipCodeWeather|null
     */
    public function getZipCodeWeather()
    {
        return $this->ZipCodeWeather;
    }
    /**
     * Set ZipCodeWeather value
     * @param \SGCIS\Struct\ZipCodeWeather $zipCodeWeather
     * @return \SGCIS\Struct\ZipCodeWeatherRequest
     */
    public function setZipCodeWeather(\SGCIS\Struct\ZipCodeWeather $zipCodeWeather = null)
    {
        $this->ZipCodeWeather = $zipCodeWeather;
        return $this;
    }
    /**
     * Get ZipCode value
     * @return string|null
     */
    public function getZipCode()
    {
        return $this->ZipCode;
    }
    /**
     * Set ZipCode value
     * @param string $zipCode
     * @return \SGCIS\Struct\ZipCodeWeatherRequest
     */
    public function setZipCode($zipCode = null)
    {
        // validation for constraint: string
        if (!is_null($zipCode) && !is_string($zipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zipCode)), __LINE__);
        }
        $this->ZipCode = $zipCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\ZipCodeWeatherRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
