<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ZipCodeWeather Struct
 * @subpackage Structs
 */
class ZipCodeWeather extends AbstractStructBase
{
    /**
     * The ZipCodeWeatherID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ZipCodeWeatherID;
    /**
     * The WeatherDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $WeatherDate;
    /**
     * The MinTemp
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $MinTemp;
    /**
     * The MaxTemp
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $MaxTemp;
    /**
     * The AvgTemp
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AvgTemp;
    /**
     * The ZipCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ZipCode;
    /**
     * Constructor method for ZipCodeWeather
     * @uses ZipCodeWeather::setZipCodeWeatherID()
     * @uses ZipCodeWeather::setWeatherDate()
     * @uses ZipCodeWeather::setMinTemp()
     * @uses ZipCodeWeather::setMaxTemp()
     * @uses ZipCodeWeather::setAvgTemp()
     * @uses ZipCodeWeather::setZipCode()
     * @param int $zipCodeWeatherID
     * @param string $weatherDate
     * @param float $minTemp
     * @param float $maxTemp
     * @param float $avgTemp
     * @param string $zipCode
     */
    public function __construct($zipCodeWeatherID = null, $weatherDate = null, $minTemp = null, $maxTemp = null, $avgTemp = null, $zipCode = null)
    {
        $this
            ->setZipCodeWeatherID($zipCodeWeatherID)
            ->setWeatherDate($weatherDate)
            ->setMinTemp($minTemp)
            ->setMaxTemp($maxTemp)
            ->setAvgTemp($avgTemp)
            ->setZipCode($zipCode);
    }
    /**
     * Get ZipCodeWeatherID value
     * @return int
     */
    public function getZipCodeWeatherID()
    {
        return $this->ZipCodeWeatherID;
    }
    /**
     * Set ZipCodeWeatherID value
     * @param int $zipCodeWeatherID
     * @return \SGCIS\Struct\ZipCodeWeather
     */
    public function setZipCodeWeatherID($zipCodeWeatherID = null)
    {
        // validation for constraint: int
        if (!is_null($zipCodeWeatherID) && !is_numeric($zipCodeWeatherID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($zipCodeWeatherID)), __LINE__);
        }
        $this->ZipCodeWeatherID = $zipCodeWeatherID;
        return $this;
    }
    /**
     * Get WeatherDate value
     * @return string
     */
    public function getWeatherDate()
    {
        return $this->WeatherDate;
    }
    /**
     * Set WeatherDate value
     * @param string $weatherDate
     * @return \SGCIS\Struct\ZipCodeWeather
     */
    public function setWeatherDate($weatherDate = null)
    {
        // validation for constraint: string
        if (!is_null($weatherDate) && !is_string($weatherDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($weatherDate)), __LINE__);
        }
        $this->WeatherDate = $weatherDate;
        return $this;
    }
    /**
     * Get MinTemp value
     * @return float
     */
    public function getMinTemp()
    {
        return $this->MinTemp;
    }
    /**
     * Set MinTemp value
     * @param float $minTemp
     * @return \SGCIS\Struct\ZipCodeWeather
     */
    public function setMinTemp($minTemp = null)
    {
        $this->MinTemp = $minTemp;
        return $this;
    }
    /**
     * Get MaxTemp value
     * @return float
     */
    public function getMaxTemp()
    {
        return $this->MaxTemp;
    }
    /**
     * Set MaxTemp value
     * @param float $maxTemp
     * @return \SGCIS\Struct\ZipCodeWeather
     */
    public function setMaxTemp($maxTemp = null)
    {
        $this->MaxTemp = $maxTemp;
        return $this;
    }
    /**
     * Get AvgTemp value
     * @return float
     */
    public function getAvgTemp()
    {
        return $this->AvgTemp;
    }
    /**
     * Set AvgTemp value
     * @param float $avgTemp
     * @return \SGCIS\Struct\ZipCodeWeather
     */
    public function setAvgTemp($avgTemp = null)
    {
        $this->AvgTemp = $avgTemp;
        return $this;
    }
    /**
     * Get ZipCode value
     * @return string|null
     */
    public function getZipCode()
    {
        return $this->ZipCode;
    }
    /**
     * Set ZipCode value
     * @param string $zipCode
     * @return \SGCIS\Struct\ZipCodeWeather
     */
    public function setZipCode($zipCode = null)
    {
        // validation for constraint: string
        if (!is_null($zipCode) && !is_string($zipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zipCode)), __LINE__);
        }
        $this->ZipCode = $zipCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\ZipCodeWeather
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
