<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValidateEnrollmentServiceLocationResponse Struct
 * @subpackage Structs
 */
class ValidateEnrollmentServiceLocationResponse extends ServiceResponseBase
{
    /**
     * The IsBusinessDay
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsBusinessDay;
    /**
     * The NextAvailableBusinessDay
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $NextAvailableBusinessDay;
    /**
     * The DistributionPoints
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfDistributionPoint
     */
    public $DistributionPoints;
    /**
     * Constructor method for ValidateEnrollmentServiceLocationResponse
     * @uses ValidateEnrollmentServiceLocationResponse::setIsBusinessDay()
     * @uses ValidateEnrollmentServiceLocationResponse::setNextAvailableBusinessDay()
     * @uses ValidateEnrollmentServiceLocationResponse::setDistributionPoints()
     * @param bool $isBusinessDay
     * @param string $nextAvailableBusinessDay
     * @param \SGCIS\Array\ArrayOfDistributionPoint $distributionPoints
     */
    public function __construct($isBusinessDay = null, $nextAvailableBusinessDay = null, \SGCIS\Array\ArrayOfDistributionPoint $distributionPoints = null)
    {
        $this
            ->setIsBusinessDay($isBusinessDay)
            ->setNextAvailableBusinessDay($nextAvailableBusinessDay)
            ->setDistributionPoints($distributionPoints);
    }
    /**
     * Get IsBusinessDay value
     * @return bool
     */
    public function getIsBusinessDay()
    {
        return $this->IsBusinessDay;
    }
    /**
     * Set IsBusinessDay value
     * @param bool $isBusinessDay
     * @return \SGCIS\Struct\ValidateEnrollmentServiceLocationResponse
     */
    public function setIsBusinessDay($isBusinessDay = null)
    {
        // validation for constraint: boolean
        if (!is_null($isBusinessDay) && !is_bool($isBusinessDay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isBusinessDay)), __LINE__);
        }
        $this->IsBusinessDay = $isBusinessDay;
        return $this;
    }
    /**
     * Get NextAvailableBusinessDay value
     * @return string
     */
    public function getNextAvailableBusinessDay()
    {
        return $this->NextAvailableBusinessDay;
    }
    /**
     * Set NextAvailableBusinessDay value
     * @param string $nextAvailableBusinessDay
     * @return \SGCIS\Struct\ValidateEnrollmentServiceLocationResponse
     */
    public function setNextAvailableBusinessDay($nextAvailableBusinessDay = null)
    {
        // validation for constraint: string
        if (!is_null($nextAvailableBusinessDay) && !is_string($nextAvailableBusinessDay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nextAvailableBusinessDay)), __LINE__);
        }
        $this->NextAvailableBusinessDay = $nextAvailableBusinessDay;
        return $this;
    }
    /**
     * Get DistributionPoints value
     * @return \SGCIS\Array\ArrayOfDistributionPoint|null
     */
    public function getDistributionPoints()
    {
        return $this->DistributionPoints;
    }
    /**
     * Set DistributionPoints value
     * @param \SGCIS\Array\ArrayOfDistributionPoint $distributionPoints
     * @return \SGCIS\Struct\ValidateEnrollmentServiceLocationResponse
     */
    public function setDistributionPoints(\SGCIS\Array\ArrayOfDistributionPoint $distributionPoints = null)
    {
        $this->DistributionPoints = $distributionPoints;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\ValidateEnrollmentServiceLocationResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
