<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VEEValidationRule Struct
 * @subpackage Structs
 */
class VEEValidationRule extends AbstractStructBase
{
    /**
     * The VEEValidationRuleID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $VEEValidationRuleID;
    /**
     * The VEEValidationRuleFailSettingID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $VEEValidationRuleFailSettingID;
    /**
     * The LastUpdateDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $LastUpdateDate;
    /**
     * The IsActive
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsActive;
    /**
     * The RuleName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RuleName;
    /**
     * The RuleDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RuleDescription;
    /**
     * The AppliesToReadType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AppliesToReadType;
    /**
     * The LastUpdateUserName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastUpdateUserName;
    /**
     * Constructor method for VEEValidationRule
     * @uses VEEValidationRule::setVEEValidationRuleID()
     * @uses VEEValidationRule::setVEEValidationRuleFailSettingID()
     * @uses VEEValidationRule::setLastUpdateDate()
     * @uses VEEValidationRule::setIsActive()
     * @uses VEEValidationRule::setRuleName()
     * @uses VEEValidationRule::setRuleDescription()
     * @uses VEEValidationRule::setAppliesToReadType()
     * @uses VEEValidationRule::setLastUpdateUserName()
     * @param int $vEEValidationRuleID
     * @param int $vEEValidationRuleFailSettingID
     * @param string $lastUpdateDate
     * @param bool $isActive
     * @param string $ruleName
     * @param string $ruleDescription
     * @param string $appliesToReadType
     * @param string $lastUpdateUserName
     */
    public function __construct($vEEValidationRuleID = null, $vEEValidationRuleFailSettingID = null, $lastUpdateDate = null, $isActive = null, $ruleName = null, $ruleDescription = null, $appliesToReadType = null, $lastUpdateUserName = null)
    {
        $this
            ->setVEEValidationRuleID($vEEValidationRuleID)
            ->setVEEValidationRuleFailSettingID($vEEValidationRuleFailSettingID)
            ->setLastUpdateDate($lastUpdateDate)
            ->setIsActive($isActive)
            ->setRuleName($ruleName)
            ->setRuleDescription($ruleDescription)
            ->setAppliesToReadType($appliesToReadType)
            ->setLastUpdateUserName($lastUpdateUserName);
    }
    /**
     * Get VEEValidationRuleID value
     * @return int
     */
    public function getVEEValidationRuleID()
    {
        return $this->VEEValidationRuleID;
    }
    /**
     * Set VEEValidationRuleID value
     * @param int $vEEValidationRuleID
     * @return \SGCIS\Struct\VEEValidationRule
     */
    public function setVEEValidationRuleID($vEEValidationRuleID = null)
    {
        // validation for constraint: int
        if (!is_null($vEEValidationRuleID) && !is_numeric($vEEValidationRuleID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($vEEValidationRuleID)), __LINE__);
        }
        $this->VEEValidationRuleID = $vEEValidationRuleID;
        return $this;
    }
    /**
     * Get VEEValidationRuleFailSettingID value
     * @return int
     */
    public function getVEEValidationRuleFailSettingID()
    {
        return $this->VEEValidationRuleFailSettingID;
    }
    /**
     * Set VEEValidationRuleFailSettingID value
     * @param int $vEEValidationRuleFailSettingID
     * @return \SGCIS\Struct\VEEValidationRule
     */
    public function setVEEValidationRuleFailSettingID($vEEValidationRuleFailSettingID = null)
    {
        // validation for constraint: int
        if (!is_null($vEEValidationRuleFailSettingID) && !is_numeric($vEEValidationRuleFailSettingID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($vEEValidationRuleFailSettingID)), __LINE__);
        }
        $this->VEEValidationRuleFailSettingID = $vEEValidationRuleFailSettingID;
        return $this;
    }
    /**
     * Get LastUpdateDate value
     * @return string
     */
    public function getLastUpdateDate()
    {
        return $this->LastUpdateDate;
    }
    /**
     * Set LastUpdateDate value
     * @param string $lastUpdateDate
     * @return \SGCIS\Struct\VEEValidationRule
     */
    public function setLastUpdateDate($lastUpdateDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastUpdateDate) && !is_string($lastUpdateDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastUpdateDate)), __LINE__);
        }
        $this->LastUpdateDate = $lastUpdateDate;
        return $this;
    }
    /**
     * Get IsActive value
     * @return bool
     */
    public function getIsActive()
    {
        return $this->IsActive;
    }
    /**
     * Set IsActive value
     * @param bool $isActive
     * @return \SGCIS\Struct\VEEValidationRule
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isActive)), __LINE__);
        }
        $this->IsActive = $isActive;
        return $this;
    }
    /**
     * Get RuleName value
     * @return string|null
     */
    public function getRuleName()
    {
        return $this->RuleName;
    }
    /**
     * Set RuleName value
     * @param string $ruleName
     * @return \SGCIS\Struct\VEEValidationRule
     */
    public function setRuleName($ruleName = null)
    {
        // validation for constraint: string
        if (!is_null($ruleName) && !is_string($ruleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ruleName)), __LINE__);
        }
        $this->RuleName = $ruleName;
        return $this;
    }
    /**
     * Get RuleDescription value
     * @return string|null
     */
    public function getRuleDescription()
    {
        return $this->RuleDescription;
    }
    /**
     * Set RuleDescription value
     * @param string $ruleDescription
     * @return \SGCIS\Struct\VEEValidationRule
     */
    public function setRuleDescription($ruleDescription = null)
    {
        // validation for constraint: string
        if (!is_null($ruleDescription) && !is_string($ruleDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ruleDescription)), __LINE__);
        }
        $this->RuleDescription = $ruleDescription;
        return $this;
    }
    /**
     * Get AppliesToReadType value
     * @return string|null
     */
    public function getAppliesToReadType()
    {
        return $this->AppliesToReadType;
    }
    /**
     * Set AppliesToReadType value
     * @param string $appliesToReadType
     * @return \SGCIS\Struct\VEEValidationRule
     */
    public function setAppliesToReadType($appliesToReadType = null)
    {
        // validation for constraint: string
        if (!is_null($appliesToReadType) && !is_string($appliesToReadType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($appliesToReadType)), __LINE__);
        }
        $this->AppliesToReadType = $appliesToReadType;
        return $this;
    }
    /**
     * Get LastUpdateUserName value
     * @return string|null
     */
    public function getLastUpdateUserName()
    {
        return $this->LastUpdateUserName;
    }
    /**
     * Set LastUpdateUserName value
     * @param string $lastUpdateUserName
     * @return \SGCIS\Struct\VEEValidationRule
     */
    public function setLastUpdateUserName($lastUpdateUserName = null)
    {
        // validation for constraint: string
        if (!is_null($lastUpdateUserName) && !is_string($lastUpdateUserName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastUpdateUserName)), __LINE__);
        }
        $this->LastUpdateUserName = $lastUpdateUserName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\VEEValidationRule
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
