<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UserResponse Struct
 * @subpackage Structs
 */
class UserResponse extends ServiceResponseBase
{
    /**
     * The UserID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UserID;
    /**
     * The User
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\User
     */
    public $User;
    /**
     * The Users
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfUser
     */
    public $Users;
    /**
     * The UserAgentCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\UserAgentCode
     */
    public $UserAgentCode;
    /**
     * The UserAgentCodes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfUserAgentCode
     */
    public $UserAgentCodes;
    /**
     * The SalesCompany
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\SalesAgentCompany
     */
    public $SalesCompany;
    /**
     * Constructor method for UserResponse
     * @uses UserResponse::setUserID()
     * @uses UserResponse::setUser()
     * @uses UserResponse::setUsers()
     * @uses UserResponse::setUserAgentCode()
     * @uses UserResponse::setUserAgentCodes()
     * @uses UserResponse::setSalesCompany()
     * @param int $userID
     * @param \SGCIS\Struct\User $user
     * @param \SGCIS\Array\ArrayOfUser $users
     * @param \SGCIS\Struct\UserAgentCode $userAgentCode
     * @param \SGCIS\Array\ArrayOfUserAgentCode $userAgentCodes
     * @param \SGCIS\Struct\SalesAgentCompany $salesCompany
     */
    public function __construct($userID = null, \SGCIS\Struct\User $user = null, \SGCIS\Array\ArrayOfUser $users = null, \SGCIS\Struct\UserAgentCode $userAgentCode = null, \SGCIS\Array\ArrayOfUserAgentCode $userAgentCodes = null, \SGCIS\Struct\SalesAgentCompany $salesCompany = null)
    {
        $this
            ->setUserID($userID)
            ->setUser($user)
            ->setUsers($users)
            ->setUserAgentCode($userAgentCode)
            ->setUserAgentCodes($userAgentCodes)
            ->setSalesCompany($salesCompany);
    }
    /**
     * Get UserID value
     * @return int
     */
    public function getUserID()
    {
        return $this->UserID;
    }
    /**
     * Set UserID value
     * @param int $userID
     * @return \SGCIS\Struct\UserResponse
     */
    public function setUserID($userID = null)
    {
        // validation for constraint: int
        if (!is_null($userID) && !is_numeric($userID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($userID)), __LINE__);
        }
        $this->UserID = $userID;
        return $this;
    }
    /**
     * Get User value
     * @return \SGCIS\Struct\User|null
     */
    public function getUser()
    {
        return $this->User;
    }
    /**
     * Set User value
     * @param \SGCIS\Struct\User $user
     * @return \SGCIS\Struct\UserResponse
     */
    public function setUser(\SGCIS\Struct\User $user = null)
    {
        $this->User = $user;
        return $this;
    }
    /**
     * Get Users value
     * @return \SGCIS\Array\ArrayOfUser|null
     */
    public function getUsers()
    {
        return $this->Users;
    }
    /**
     * Set Users value
     * @param \SGCIS\Array\ArrayOfUser $users
     * @return \SGCIS\Struct\UserResponse
     */
    public function setUsers(\SGCIS\Array\ArrayOfUser $users = null)
    {
        $this->Users = $users;
        return $this;
    }
    /**
     * Get UserAgentCode value
     * @return \SGCIS\Struct\UserAgentCode|null
     */
    public function getUserAgentCode()
    {
        return $this->UserAgentCode;
    }
    /**
     * Set UserAgentCode value
     * @param \SGCIS\Struct\UserAgentCode $userAgentCode
     * @return \SGCIS\Struct\UserResponse
     */
    public function setUserAgentCode(\SGCIS\Struct\UserAgentCode $userAgentCode = null)
    {
        $this->UserAgentCode = $userAgentCode;
        return $this;
    }
    /**
     * Get UserAgentCodes value
     * @return \SGCIS\Array\ArrayOfUserAgentCode|null
     */
    public function getUserAgentCodes()
    {
        return $this->UserAgentCodes;
    }
    /**
     * Set UserAgentCodes value
     * @param \SGCIS\Array\ArrayOfUserAgentCode $userAgentCodes
     * @return \SGCIS\Struct\UserResponse
     */
    public function setUserAgentCodes(\SGCIS\Array\ArrayOfUserAgentCode $userAgentCodes = null)
    {
        $this->UserAgentCodes = $userAgentCodes;
        return $this;
    }
    /**
     * Get SalesCompany value
     * @return \SGCIS\Struct\SalesAgentCompany|null
     */
    public function getSalesCompany()
    {
        return $this->SalesCompany;
    }
    /**
     * Set SalesCompany value
     * @param \SGCIS\Struct\SalesAgentCompany $salesCompany
     * @return \SGCIS\Struct\UserResponse
     */
    public function setSalesCompany(\SGCIS\Struct\SalesAgentCompany $salesCompany = null)
    {
        $this->SalesCompany = $salesCompany;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\UserResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
