<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for User Struct
 * @subpackage Structs
 */
class User extends BaseDTO
{
    /**
     * The UserID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UserID;
    /**
     * The CallCenterLocationID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CallCenterLocationID;
    /**
     * The AccountLocked
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $AccountLocked;
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Active;
    /**
     * The DashboardLayout
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DashboardLayout;
    /**
     * The LeadSourceID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LeadSourceID;
    /**
     * The SalesModelLevelID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SalesModelLevelID;
    /**
     * The SalesModelID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SalesModelID;
    /**
     * The SalesModelUserManagerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SalesModelUserManagerID;
    /**
     * The IsPrivlegedUser
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsPrivlegedUser;
    /**
     * The IsManager
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsManager;
    /**
     * The IsLOARequired
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsLOARequired;
    /**
     * The MaxChargeAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $MaxChargeAmount;
    /**
     * The MaxCreditAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $MaxCreditAmount;
    /**
     * The HasLoggedIn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $HasLoggedIn;
    /**
     * The UserTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UserTypeID;
    /**
     * The SalesAgentCompanyID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SalesAgentCompanyID;
    /**
     * The CompanyID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CompanyID;
    /**
     * The UserName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserName;
    /**
     * The Password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * The FirstName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FirstName;
    /**
     * The LastName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastName;
    /**
     * The FullName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FullName;
    /**
     * The EmailAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EmailAddress;
    /**
     * The AgentID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AgentID;
    /**
     * The AgentExtension
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AgentExtension;
    /**
     * The CallCenterLocationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CallCenterLocationName;
    /**
     * The Broker
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Broker;
    /**
     * The InContactUserName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InContactUserName;
    /**
     * The PhoneNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PhoneNumber;
    /**
     * The SalesAgentCompanyName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SalesAgentCompanyName;
    /**
     * The CompanyName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CompanyName;
    /**
     * The UserSystemRolesString
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserSystemRolesString;
    /**
     * The QCContactID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $QCContactID;
    /**
     * The UserSystemRoles
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfUserSystemRole
     */
    public $UserSystemRoles;
    /**
     * The UserCommunities
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfCommunity
     */
    public $UserCommunities;
    /**
     * The UserCharacteristics
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfUserCharacteristic
     */
    public $UserCharacteristics;
    /**
     * The UserAgentCodes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfUserAgentCode
     */
    public $UserAgentCodes;
    /**
     * Constructor method for User
     * @uses User::setUserID()
     * @uses User::setCallCenterLocationID()
     * @uses User::setAccountLocked()
     * @uses User::setActive()
     * @uses User::setDashboardLayout()
     * @uses User::setLeadSourceID()
     * @uses User::setSalesModelLevelID()
     * @uses User::setSalesModelID()
     * @uses User::setSalesModelUserManagerID()
     * @uses User::setIsPrivlegedUser()
     * @uses User::setIsManager()
     * @uses User::setIsLOARequired()
     * @uses User::setMaxChargeAmount()
     * @uses User::setMaxCreditAmount()
     * @uses User::setHasLoggedIn()
     * @uses User::setUserTypeID()
     * @uses User::setSalesAgentCompanyID()
     * @uses User::setCompanyID()
     * @uses User::setUserName()
     * @uses User::setPassword()
     * @uses User::setFirstName()
     * @uses User::setLastName()
     * @uses User::setFullName()
     * @uses User::setEmailAddress()
     * @uses User::setAgentID()
     * @uses User::setAgentExtension()
     * @uses User::setCallCenterLocationName()
     * @uses User::setBroker()
     * @uses User::setInContactUserName()
     * @uses User::setPhoneNumber()
     * @uses User::setSalesAgentCompanyName()
     * @uses User::setCompanyName()
     * @uses User::setUserSystemRolesString()
     * @uses User::setQCContactID()
     * @uses User::setUserSystemRoles()
     * @uses User::setUserCommunities()
     * @uses User::setUserCharacteristics()
     * @uses User::setUserAgentCodes()
     * @param int $userID
     * @param int $callCenterLocationID
     * @param bool $accountLocked
     * @param bool $active
     * @param int $dashboardLayout
     * @param int $leadSourceID
     * @param int $salesModelLevelID
     * @param int $salesModelID
     * @param int $salesModelUserManagerID
     * @param bool $isPrivlegedUser
     * @param bool $isManager
     * @param bool $isLOARequired
     * @param float $maxChargeAmount
     * @param float $maxCreditAmount
     * @param bool $hasLoggedIn
     * @param int $userTypeID
     * @param int $salesAgentCompanyID
     * @param int $companyID
     * @param string $userName
     * @param string $password
     * @param string $firstName
     * @param string $lastName
     * @param string $fullName
     * @param string $emailAddress
     * @param string $agentID
     * @param string $agentExtension
     * @param string $callCenterLocationName
     * @param string $broker
     * @param string $inContactUserName
     * @param string $phoneNumber
     * @param string $salesAgentCompanyName
     * @param string $companyName
     * @param string $userSystemRolesString
     * @param string $qCContactID
     * @param \SGCIS\Array\ArrayOfUserSystemRole $userSystemRoles
     * @param \SGCIS\Array\ArrayOfCommunity $userCommunities
     * @param \SGCIS\Array\ArrayOfUserCharacteristic $userCharacteristics
     * @param \SGCIS\Array\ArrayOfUserAgentCode $userAgentCodes
     */
    public function __construct($userID = null, $callCenterLocationID = null, $accountLocked = null, $active = null, $dashboardLayout = null, $leadSourceID = null, $salesModelLevelID = null, $salesModelID = null, $salesModelUserManagerID = null, $isPrivlegedUser = null, $isManager = null, $isLOARequired = null, $maxChargeAmount = null, $maxCreditAmount = null, $hasLoggedIn = null, $userTypeID = null, $salesAgentCompanyID = null, $companyID = null, $userName = null, $password = null, $firstName = null, $lastName = null, $fullName = null, $emailAddress = null, $agentID = null, $agentExtension = null, $callCenterLocationName = null, $broker = null, $inContactUserName = null, $phoneNumber = null, $salesAgentCompanyName = null, $companyName = null, $userSystemRolesString = null, $qCContactID = null, \SGCIS\Array\ArrayOfUserSystemRole $userSystemRoles = null, \SGCIS\Array\ArrayOfCommunity $userCommunities = null, \SGCIS\Array\ArrayOfUserCharacteristic $userCharacteristics = null, \SGCIS\Array\ArrayOfUserAgentCode $userAgentCodes = null)
    {
        $this
            ->setUserID($userID)
            ->setCallCenterLocationID($callCenterLocationID)
            ->setAccountLocked($accountLocked)
            ->setActive($active)
            ->setDashboardLayout($dashboardLayout)
            ->setLeadSourceID($leadSourceID)
            ->setSalesModelLevelID($salesModelLevelID)
            ->setSalesModelID($salesModelID)
            ->setSalesModelUserManagerID($salesModelUserManagerID)
            ->setIsPrivlegedUser($isPrivlegedUser)
            ->setIsManager($isManager)
            ->setIsLOARequired($isLOARequired)
            ->setMaxChargeAmount($maxChargeAmount)
            ->setMaxCreditAmount($maxCreditAmount)
            ->setHasLoggedIn($hasLoggedIn)
            ->setUserTypeID($userTypeID)
            ->setSalesAgentCompanyID($salesAgentCompanyID)
            ->setCompanyID($companyID)
            ->setUserName($userName)
            ->setPassword($password)
            ->setFirstName($firstName)
            ->setLastName($lastName)
            ->setFullName($fullName)
            ->setEmailAddress($emailAddress)
            ->setAgentID($agentID)
            ->setAgentExtension($agentExtension)
            ->setCallCenterLocationName($callCenterLocationName)
            ->setBroker($broker)
            ->setInContactUserName($inContactUserName)
            ->setPhoneNumber($phoneNumber)
            ->setSalesAgentCompanyName($salesAgentCompanyName)
            ->setCompanyName($companyName)
            ->setUserSystemRolesString($userSystemRolesString)
            ->setQCContactID($qCContactID)
            ->setUserSystemRoles($userSystemRoles)
            ->setUserCommunities($userCommunities)
            ->setUserCharacteristics($userCharacteristics)
            ->setUserAgentCodes($userAgentCodes);
    }
    /**
     * Get UserID value
     * @return int
     */
    public function getUserID()
    {
        return $this->UserID;
    }
    /**
     * Set UserID value
     * @param int $userID
     * @return \SGCIS\Struct\User
     */
    public function setUserID($userID = null)
    {
        // validation for constraint: int
        if (!is_null($userID) && !is_numeric($userID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($userID)), __LINE__);
        }
        $this->UserID = $userID;
        return $this;
    }
    /**
     * Get CallCenterLocationID value
     * @return int
     */
    public function getCallCenterLocationID()
    {
        return $this->CallCenterLocationID;
    }
    /**
     * Set CallCenterLocationID value
     * @param int $callCenterLocationID
     * @return \SGCIS\Struct\User
     */
    public function setCallCenterLocationID($callCenterLocationID = null)
    {
        // validation for constraint: int
        if (!is_null($callCenterLocationID) && !is_numeric($callCenterLocationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($callCenterLocationID)), __LINE__);
        }
        $this->CallCenterLocationID = $callCenterLocationID;
        return $this;
    }
    /**
     * Get AccountLocked value
     * @return bool
     */
    public function getAccountLocked()
    {
        return $this->AccountLocked;
    }
    /**
     * Set AccountLocked value
     * @param bool $accountLocked
     * @return \SGCIS\Struct\User
     */
    public function setAccountLocked($accountLocked = null)
    {
        // validation for constraint: boolean
        if (!is_null($accountLocked) && !is_bool($accountLocked)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($accountLocked)), __LINE__);
        }
        $this->AccountLocked = $accountLocked;
        return $this;
    }
    /**
     * Get Active value
     * @return bool
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \SGCIS\Struct\User
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get DashboardLayout value
     * @return int
     */
    public function getDashboardLayout()
    {
        return $this->DashboardLayout;
    }
    /**
     * Set DashboardLayout value
     * @param int $dashboardLayout
     * @return \SGCIS\Struct\User
     */
    public function setDashboardLayout($dashboardLayout = null)
    {
        // validation for constraint: int
        if (!is_null($dashboardLayout) && !is_numeric($dashboardLayout)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($dashboardLayout)), __LINE__);
        }
        $this->DashboardLayout = $dashboardLayout;
        return $this;
    }
    /**
     * Get LeadSourceID value
     * @return int
     */
    public function getLeadSourceID()
    {
        return $this->LeadSourceID;
    }
    /**
     * Set LeadSourceID value
     * @param int $leadSourceID
     * @return \SGCIS\Struct\User
     */
    public function setLeadSourceID($leadSourceID = null)
    {
        // validation for constraint: int
        if (!is_null($leadSourceID) && !is_numeric($leadSourceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($leadSourceID)), __LINE__);
        }
        $this->LeadSourceID = $leadSourceID;
        return $this;
    }
    /**
     * Get SalesModelLevelID value
     * @return int
     */
    public function getSalesModelLevelID()
    {
        return $this->SalesModelLevelID;
    }
    /**
     * Set SalesModelLevelID value
     * @param int $salesModelLevelID
     * @return \SGCIS\Struct\User
     */
    public function setSalesModelLevelID($salesModelLevelID = null)
    {
        // validation for constraint: int
        if (!is_null($salesModelLevelID) && !is_numeric($salesModelLevelID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($salesModelLevelID)), __LINE__);
        }
        $this->SalesModelLevelID = $salesModelLevelID;
        return $this;
    }
    /**
     * Get SalesModelID value
     * @return int
     */
    public function getSalesModelID()
    {
        return $this->SalesModelID;
    }
    /**
     * Set SalesModelID value
     * @param int $salesModelID
     * @return \SGCIS\Struct\User
     */
    public function setSalesModelID($salesModelID = null)
    {
        // validation for constraint: int
        if (!is_null($salesModelID) && !is_numeric($salesModelID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($salesModelID)), __LINE__);
        }
        $this->SalesModelID = $salesModelID;
        return $this;
    }
    /**
     * Get SalesModelUserManagerID value
     * @return int
     */
    public function getSalesModelUserManagerID()
    {
        return $this->SalesModelUserManagerID;
    }
    /**
     * Set SalesModelUserManagerID value
     * @param int $salesModelUserManagerID
     * @return \SGCIS\Struct\User
     */
    public function setSalesModelUserManagerID($salesModelUserManagerID = null)
    {
        // validation for constraint: int
        if (!is_null($salesModelUserManagerID) && !is_numeric($salesModelUserManagerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($salesModelUserManagerID)), __LINE__);
        }
        $this->SalesModelUserManagerID = $salesModelUserManagerID;
        return $this;
    }
    /**
     * Get IsPrivlegedUser value
     * @return bool
     */
    public function getIsPrivlegedUser()
    {
        return $this->IsPrivlegedUser;
    }
    /**
     * Set IsPrivlegedUser value
     * @param bool $isPrivlegedUser
     * @return \SGCIS\Struct\User
     */
    public function setIsPrivlegedUser($isPrivlegedUser = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPrivlegedUser) && !is_bool($isPrivlegedUser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isPrivlegedUser)), __LINE__);
        }
        $this->IsPrivlegedUser = $isPrivlegedUser;
        return $this;
    }
    /**
     * Get IsManager value
     * @return bool
     */
    public function getIsManager()
    {
        return $this->IsManager;
    }
    /**
     * Set IsManager value
     * @param bool $isManager
     * @return \SGCIS\Struct\User
     */
    public function setIsManager($isManager = null)
    {
        // validation for constraint: boolean
        if (!is_null($isManager) && !is_bool($isManager)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isManager)), __LINE__);
        }
        $this->IsManager = $isManager;
        return $this;
    }
    /**
     * Get IsLOARequired value
     * @return bool
     */
    public function getIsLOARequired()
    {
        return $this->IsLOARequired;
    }
    /**
     * Set IsLOARequired value
     * @param bool $isLOARequired
     * @return \SGCIS\Struct\User
     */
    public function setIsLOARequired($isLOARequired = null)
    {
        // validation for constraint: boolean
        if (!is_null($isLOARequired) && !is_bool($isLOARequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isLOARequired)), __LINE__);
        }
        $this->IsLOARequired = $isLOARequired;
        return $this;
    }
    /**
     * Get MaxChargeAmount value
     * @return float
     */
    public function getMaxChargeAmount()
    {
        return $this->MaxChargeAmount;
    }
    /**
     * Set MaxChargeAmount value
     * @param float $maxChargeAmount
     * @return \SGCIS\Struct\User
     */
    public function setMaxChargeAmount($maxChargeAmount = null)
    {
        $this->MaxChargeAmount = $maxChargeAmount;
        return $this;
    }
    /**
     * Get MaxCreditAmount value
     * @return float
     */
    public function getMaxCreditAmount()
    {
        return $this->MaxCreditAmount;
    }
    /**
     * Set MaxCreditAmount value
     * @param float $maxCreditAmount
     * @return \SGCIS\Struct\User
     */
    public function setMaxCreditAmount($maxCreditAmount = null)
    {
        $this->MaxCreditAmount = $maxCreditAmount;
        return $this;
    }
    /**
     * Get HasLoggedIn value
     * @return bool
     */
    public function getHasLoggedIn()
    {
        return $this->HasLoggedIn;
    }
    /**
     * Set HasLoggedIn value
     * @param bool $hasLoggedIn
     * @return \SGCIS\Struct\User
     */
    public function setHasLoggedIn($hasLoggedIn = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasLoggedIn) && !is_bool($hasLoggedIn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($hasLoggedIn)), __LINE__);
        }
        $this->HasLoggedIn = $hasLoggedIn;
        return $this;
    }
    /**
     * Get UserTypeID value
     * @return int
     */
    public function getUserTypeID()
    {
        return $this->UserTypeID;
    }
    /**
     * Set UserTypeID value
     * @param int $userTypeID
     * @return \SGCIS\Struct\User
     */
    public function setUserTypeID($userTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($userTypeID) && !is_numeric($userTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($userTypeID)), __LINE__);
        }
        $this->UserTypeID = $userTypeID;
        return $this;
    }
    /**
     * Get SalesAgentCompanyID value
     * @return int
     */
    public function getSalesAgentCompanyID()
    {
        return $this->SalesAgentCompanyID;
    }
    /**
     * Set SalesAgentCompanyID value
     * @param int $salesAgentCompanyID
     * @return \SGCIS\Struct\User
     */
    public function setSalesAgentCompanyID($salesAgentCompanyID = null)
    {
        // validation for constraint: int
        if (!is_null($salesAgentCompanyID) && !is_numeric($salesAgentCompanyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($salesAgentCompanyID)), __LINE__);
        }
        $this->SalesAgentCompanyID = $salesAgentCompanyID;
        return $this;
    }
    /**
     * Get CompanyID value
     * @return int
     */
    public function getCompanyID()
    {
        return $this->CompanyID;
    }
    /**
     * Set CompanyID value
     * @param int $companyID
     * @return \SGCIS\Struct\User
     */
    public function setCompanyID($companyID = null)
    {
        // validation for constraint: int
        if (!is_null($companyID) && !is_numeric($companyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($companyID)), __LINE__);
        }
        $this->CompanyID = $companyID;
        return $this;
    }
    /**
     * Get UserName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->UserName;
    }
    /**
     * Set UserName value
     * @param string $userName
     * @return \SGCIS\Struct\User
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userName)), __LINE__);
        }
        $this->UserName = $userName;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \SGCIS\Struct\User
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \SGCIS\Struct\User
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get LastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return \SGCIS\Struct\User
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
    /**
     * Get FullName value
     * @return string|null
     */
    public function getFullName()
    {
        return $this->FullName;
    }
    /**
     * Set FullName value
     * @param string $fullName
     * @return \SGCIS\Struct\User
     */
    public function setFullName($fullName = null)
    {
        // validation for constraint: string
        if (!is_null($fullName) && !is_string($fullName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fullName)), __LINE__);
        }
        $this->FullName = $fullName;
        return $this;
    }
    /**
     * Get EmailAddress value
     * @return string|null
     */
    public function getEmailAddress()
    {
        return $this->EmailAddress;
    }
    /**
     * Set EmailAddress value
     * @param string $emailAddress
     * @return \SGCIS\Struct\User
     */
    public function setEmailAddress($emailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($emailAddress) && !is_string($emailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emailAddress)), __LINE__);
        }
        $this->EmailAddress = $emailAddress;
        return $this;
    }
    /**
     * Get AgentID value
     * @return string|null
     */
    public function getAgentID()
    {
        return $this->AgentID;
    }
    /**
     * Set AgentID value
     * @param string $agentID
     * @return \SGCIS\Struct\User
     */
    public function setAgentID($agentID = null)
    {
        // validation for constraint: string
        if (!is_null($agentID) && !is_string($agentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($agentID)), __LINE__);
        }
        $this->AgentID = $agentID;
        return $this;
    }
    /**
     * Get AgentExtension value
     * @return string|null
     */
    public function getAgentExtension()
    {
        return $this->AgentExtension;
    }
    /**
     * Set AgentExtension value
     * @param string $agentExtension
     * @return \SGCIS\Struct\User
     */
    public function setAgentExtension($agentExtension = null)
    {
        // validation for constraint: string
        if (!is_null($agentExtension) && !is_string($agentExtension)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($agentExtension)), __LINE__);
        }
        $this->AgentExtension = $agentExtension;
        return $this;
    }
    /**
     * Get CallCenterLocationName value
     * @return string|null
     */
    public function getCallCenterLocationName()
    {
        return $this->CallCenterLocationName;
    }
    /**
     * Set CallCenterLocationName value
     * @param string $callCenterLocationName
     * @return \SGCIS\Struct\User
     */
    public function setCallCenterLocationName($callCenterLocationName = null)
    {
        // validation for constraint: string
        if (!is_null($callCenterLocationName) && !is_string($callCenterLocationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callCenterLocationName)), __LINE__);
        }
        $this->CallCenterLocationName = $callCenterLocationName;
        return $this;
    }
    /**
     * Get Broker value
     * @return string|null
     */
    public function getBroker()
    {
        return $this->Broker;
    }
    /**
     * Set Broker value
     * @param string $broker
     * @return \SGCIS\Struct\User
     */
    public function setBroker($broker = null)
    {
        // validation for constraint: string
        if (!is_null($broker) && !is_string($broker)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($broker)), __LINE__);
        }
        $this->Broker = $broker;
        return $this;
    }
    /**
     * Get InContactUserName value
     * @return string|null
     */
    public function getInContactUserName()
    {
        return $this->InContactUserName;
    }
    /**
     * Set InContactUserName value
     * @param string $inContactUserName
     * @return \SGCIS\Struct\User
     */
    public function setInContactUserName($inContactUserName = null)
    {
        // validation for constraint: string
        if (!is_null($inContactUserName) && !is_string($inContactUserName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($inContactUserName)), __LINE__);
        }
        $this->InContactUserName = $inContactUserName;
        return $this;
    }
    /**
     * Get PhoneNumber value
     * @return string|null
     */
    public function getPhoneNumber()
    {
        return $this->PhoneNumber;
    }
    /**
     * Set PhoneNumber value
     * @param string $phoneNumber
     * @return \SGCIS\Struct\User
     */
    public function setPhoneNumber($phoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($phoneNumber) && !is_string($phoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phoneNumber)), __LINE__);
        }
        $this->PhoneNumber = $phoneNumber;
        return $this;
    }
    /**
     * Get SalesAgentCompanyName value
     * @return string|null
     */
    public function getSalesAgentCompanyName()
    {
        return $this->SalesAgentCompanyName;
    }
    /**
     * Set SalesAgentCompanyName value
     * @param string $salesAgentCompanyName
     * @return \SGCIS\Struct\User
     */
    public function setSalesAgentCompanyName($salesAgentCompanyName = null)
    {
        // validation for constraint: string
        if (!is_null($salesAgentCompanyName) && !is_string($salesAgentCompanyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($salesAgentCompanyName)), __LINE__);
        }
        $this->SalesAgentCompanyName = $salesAgentCompanyName;
        return $this;
    }
    /**
     * Get CompanyName value
     * @return string|null
     */
    public function getCompanyName()
    {
        return $this->CompanyName;
    }
    /**
     * Set CompanyName value
     * @param string $companyName
     * @return \SGCIS\Struct\User
     */
    public function setCompanyName($companyName = null)
    {
        // validation for constraint: string
        if (!is_null($companyName) && !is_string($companyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($companyName)), __LINE__);
        }
        $this->CompanyName = $companyName;
        return $this;
    }
    /**
     * Get UserSystemRolesString value
     * @return string|null
     */
    public function getUserSystemRolesString()
    {
        return $this->UserSystemRolesString;
    }
    /**
     * Set UserSystemRolesString value
     * @param string $userSystemRolesString
     * @return \SGCIS\Struct\User
     */
    public function setUserSystemRolesString($userSystemRolesString = null)
    {
        // validation for constraint: string
        if (!is_null($userSystemRolesString) && !is_string($userSystemRolesString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userSystemRolesString)), __LINE__);
        }
        $this->UserSystemRolesString = $userSystemRolesString;
        return $this;
    }
    /**
     * Get QCContactID value
     * @return string|null
     */
    public function getQCContactID()
    {
        return $this->QCContactID;
    }
    /**
     * Set QCContactID value
     * @param string $qCContactID
     * @return \SGCIS\Struct\User
     */
    public function setQCContactID($qCContactID = null)
    {
        // validation for constraint: string
        if (!is_null($qCContactID) && !is_string($qCContactID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($qCContactID)), __LINE__);
        }
        $this->QCContactID = $qCContactID;
        return $this;
    }
    /**
     * Get UserSystemRoles value
     * @return \SGCIS\Array\ArrayOfUserSystemRole|null
     */
    public function getUserSystemRoles()
    {
        return $this->UserSystemRoles;
    }
    /**
     * Set UserSystemRoles value
     * @param \SGCIS\Array\ArrayOfUserSystemRole $userSystemRoles
     * @return \SGCIS\Struct\User
     */
    public function setUserSystemRoles(\SGCIS\Array\ArrayOfUserSystemRole $userSystemRoles = null)
    {
        $this->UserSystemRoles = $userSystemRoles;
        return $this;
    }
    /**
     * Get UserCommunities value
     * @return \SGCIS\Array\ArrayOfCommunity|null
     */
    public function getUserCommunities()
    {
        return $this->UserCommunities;
    }
    /**
     * Set UserCommunities value
     * @param \SGCIS\Array\ArrayOfCommunity $userCommunities
     * @return \SGCIS\Struct\User
     */
    public function setUserCommunities(\SGCIS\Array\ArrayOfCommunity $userCommunities = null)
    {
        $this->UserCommunities = $userCommunities;
        return $this;
    }
    /**
     * Get UserCharacteristics value
     * @return \SGCIS\Array\ArrayOfUserCharacteristic|null
     */
    public function getUserCharacteristics()
    {
        return $this->UserCharacteristics;
    }
    /**
     * Set UserCharacteristics value
     * @param \SGCIS\Array\ArrayOfUserCharacteristic $userCharacteristics
     * @return \SGCIS\Struct\User
     */
    public function setUserCharacteristics(\SGCIS\Array\ArrayOfUserCharacteristic $userCharacteristics = null)
    {
        $this->UserCharacteristics = $userCharacteristics;
        return $this;
    }
    /**
     * Get UserAgentCodes value
     * @return \SGCIS\Array\ArrayOfUserAgentCode|null
     */
    public function getUserAgentCodes()
    {
        return $this->UserAgentCodes;
    }
    /**
     * Set UserAgentCodes value
     * @param \SGCIS\Array\ArrayOfUserAgentCode $userAgentCodes
     * @return \SGCIS\Struct\User
     */
    public function setUserAgentCodes(\SGCIS\Array\ArrayOfUserAgentCode $userAgentCodes = null)
    {
        $this->UserAgentCodes = $userAgentCodes;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\User
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
