<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UsageChargeTier Struct
 * @subpackage Structs
 */
class UsageChargeTier extends AbstractStructBase
{
    /**
     * The UsageChargeTierID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UsageChargeTierID;
    /**
     * The UsageChargeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UsageChargeID;
    /**
     * The FromAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $FromAmount;
    /**
     * The ToAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ToAmount;
    /**
     * The Rate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Rate;
    /**
     * The TierLevel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TierLevel;
    /**
     * The CreateDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CreateDate;
    /**
     * Constructor method for UsageChargeTier
     * @uses UsageChargeTier::setUsageChargeTierID()
     * @uses UsageChargeTier::setUsageChargeID()
     * @uses UsageChargeTier::setFromAmount()
     * @uses UsageChargeTier::setToAmount()
     * @uses UsageChargeTier::setRate()
     * @uses UsageChargeTier::setTierLevel()
     * @uses UsageChargeTier::setCreateDate()
     * @param int $usageChargeTierID
     * @param int $usageChargeID
     * @param float $fromAmount
     * @param float $toAmount
     * @param float $rate
     * @param string $tierLevel
     * @param string $createDate
     */
    public function __construct($usageChargeTierID = null, $usageChargeID = null, $fromAmount = null, $toAmount = null, $rate = null, $tierLevel = null, $createDate = null)
    {
        $this
            ->setUsageChargeTierID($usageChargeTierID)
            ->setUsageChargeID($usageChargeID)
            ->setFromAmount($fromAmount)
            ->setToAmount($toAmount)
            ->setRate($rate)
            ->setTierLevel($tierLevel)
            ->setCreateDate($createDate);
    }
    /**
     * Get UsageChargeTierID value
     * @return int
     */
    public function getUsageChargeTierID()
    {
        return $this->UsageChargeTierID;
    }
    /**
     * Set UsageChargeTierID value
     * @param int $usageChargeTierID
     * @return \SGCIS\Struct\UsageChargeTier
     */
    public function setUsageChargeTierID($usageChargeTierID = null)
    {
        // validation for constraint: int
        if (!is_null($usageChargeTierID) && !is_numeric($usageChargeTierID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($usageChargeTierID)), __LINE__);
        }
        $this->UsageChargeTierID = $usageChargeTierID;
        return $this;
    }
    /**
     * Get UsageChargeID value
     * @return int
     */
    public function getUsageChargeID()
    {
        return $this->UsageChargeID;
    }
    /**
     * Set UsageChargeID value
     * @param int $usageChargeID
     * @return \SGCIS\Struct\UsageChargeTier
     */
    public function setUsageChargeID($usageChargeID = null)
    {
        // validation for constraint: int
        if (!is_null($usageChargeID) && !is_numeric($usageChargeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($usageChargeID)), __LINE__);
        }
        $this->UsageChargeID = $usageChargeID;
        return $this;
    }
    /**
     * Get FromAmount value
     * @return float
     */
    public function getFromAmount()
    {
        return $this->FromAmount;
    }
    /**
     * Set FromAmount value
     * @param float $fromAmount
     * @return \SGCIS\Struct\UsageChargeTier
     */
    public function setFromAmount($fromAmount = null)
    {
        $this->FromAmount = $fromAmount;
        return $this;
    }
    /**
     * Get ToAmount value
     * @return float
     */
    public function getToAmount()
    {
        return $this->ToAmount;
    }
    /**
     * Set ToAmount value
     * @param float $toAmount
     * @return \SGCIS\Struct\UsageChargeTier
     */
    public function setToAmount($toAmount = null)
    {
        $this->ToAmount = $toAmount;
        return $this;
    }
    /**
     * Get Rate value
     * @return float
     */
    public function getRate()
    {
        return $this->Rate;
    }
    /**
     * Set Rate value
     * @param float $rate
     * @return \SGCIS\Struct\UsageChargeTier
     */
    public function setRate($rate = null)
    {
        $this->Rate = $rate;
        return $this;
    }
    /**
     * Get TierLevel value
     * @return string|null
     */
    public function getTierLevel()
    {
        return $this->TierLevel;
    }
    /**
     * Set TierLevel value
     * @param string $tierLevel
     * @return \SGCIS\Struct\UsageChargeTier
     */
    public function setTierLevel($tierLevel = null)
    {
        // validation for constraint: string
        if (!is_null($tierLevel) && !is_string($tierLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tierLevel)), __LINE__);
        }
        $this->TierLevel = $tierLevel;
        return $this;
    }
    /**
     * Get CreateDate value
     * @return string|null
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \SGCIS\Struct\UsageChargeTier
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\UsageChargeTier
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
