<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransactionsNotImportedQueryParameters Struct
 * @subpackage Structs
 */
class TransactionsNotImportedQueryParameters extends AbstractStructBase
{
    /**
     * The TransactionDateFrom
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TransactionDateFrom;
    /**
     * The TransactionDateTo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TransactionDateTo;
    /**
     * The ImportStatusID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ImportStatusID;
    /**
     * The MarketID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MarketID;
    /**
     * The TransactionType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionType;
    /**
     * Constructor method for TransactionsNotImportedQueryParameters
     * @uses TransactionsNotImportedQueryParameters::setTransactionDateFrom()
     * @uses TransactionsNotImportedQueryParameters::setTransactionDateTo()
     * @uses TransactionsNotImportedQueryParameters::setImportStatusID()
     * @uses TransactionsNotImportedQueryParameters::setMarketID()
     * @uses TransactionsNotImportedQueryParameters::setTransactionType()
     * @param string $transactionDateFrom
     * @param string $transactionDateTo
     * @param int $importStatusID
     * @param string $marketID
     * @param string $transactionType
     */
    public function __construct($transactionDateFrom = null, $transactionDateTo = null, $importStatusID = null, $marketID = null, $transactionType = null)
    {
        $this
            ->setTransactionDateFrom($transactionDateFrom)
            ->setTransactionDateTo($transactionDateTo)
            ->setImportStatusID($importStatusID)
            ->setMarketID($marketID)
            ->setTransactionType($transactionType);
    }
    /**
     * Get TransactionDateFrom value
     * @return string
     */
    public function getTransactionDateFrom()
    {
        return $this->TransactionDateFrom;
    }
    /**
     * Set TransactionDateFrom value
     * @param string $transactionDateFrom
     * @return \SGCIS\Struct\TransactionsNotImportedQueryParameters
     */
    public function setTransactionDateFrom($transactionDateFrom = null)
    {
        // validation for constraint: string
        if (!is_null($transactionDateFrom) && !is_string($transactionDateFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionDateFrom)), __LINE__);
        }
        $this->TransactionDateFrom = $transactionDateFrom;
        return $this;
    }
    /**
     * Get TransactionDateTo value
     * @return string
     */
    public function getTransactionDateTo()
    {
        return $this->TransactionDateTo;
    }
    /**
     * Set TransactionDateTo value
     * @param string $transactionDateTo
     * @return \SGCIS\Struct\TransactionsNotImportedQueryParameters
     */
    public function setTransactionDateTo($transactionDateTo = null)
    {
        // validation for constraint: string
        if (!is_null($transactionDateTo) && !is_string($transactionDateTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionDateTo)), __LINE__);
        }
        $this->TransactionDateTo = $transactionDateTo;
        return $this;
    }
    /**
     * Get ImportStatusID value
     * @return int
     */
    public function getImportStatusID()
    {
        return $this->ImportStatusID;
    }
    /**
     * Set ImportStatusID value
     * @param int $importStatusID
     * @return \SGCIS\Struct\TransactionsNotImportedQueryParameters
     */
    public function setImportStatusID($importStatusID = null)
    {
        // validation for constraint: int
        if (!is_null($importStatusID) && !is_numeric($importStatusID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($importStatusID)), __LINE__);
        }
        $this->ImportStatusID = $importStatusID;
        return $this;
    }
    /**
     * Get MarketID value
     * @return string|null
     */
    public function getMarketID()
    {
        return $this->MarketID;
    }
    /**
     * Set MarketID value
     * @param string $marketID
     * @return \SGCIS\Struct\TransactionsNotImportedQueryParameters
     */
    public function setMarketID($marketID = null)
    {
        // validation for constraint: string
        if (!is_null($marketID) && !is_string($marketID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($marketID)), __LINE__);
        }
        $this->MarketID = $marketID;
        return $this;
    }
    /**
     * Get TransactionType value
     * @return string|null
     */
    public function getTransactionType()
    {
        return $this->TransactionType;
    }
    /**
     * Set TransactionType value
     * @param string $transactionType
     * @return \SGCIS\Struct\TransactionsNotImportedQueryParameters
     */
    public function setTransactionType($transactionType = null)
    {
        // validation for constraint: string
        if (!is_null($transactionType) && !is_string($transactionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionType)), __LINE__);
        }
        $this->TransactionType = $transactionType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\TransactionsNotImportedQueryParameters
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
