<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransactionSummaryItem Struct
 * @subpackage Structs
 */
class TransactionSummaryItem extends AbstractStructBase
{
    /**
     * The Date
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Date;
    /**
     * The TotalUsage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalUsage;
    /**
     * The TotalTD
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalTD;
    /**
     * The TotalPromotion
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalPromotion;
    /**
     * The TotalReconciliation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalReconciliation;
    /**
     * The TotalDebtRecovery
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalDebtRecovery;
    /**
     * The TotalAdjustment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalAdjustment;
    /**
     * The TotalMisc
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalMisc;
    /**
     * The TotalTax
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalTax;
    /**
     * The Total
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Total;
    /**
     * The TotalPayments
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalPayments;
    /**
     * The AccountBalance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AccountBalance;
    /**
     * The Consumption
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Consumption;
    /**
     * The ChangeTotal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ChangeTotal;
    /**
     * Constructor method for TransactionSummaryItem
     * @uses TransactionSummaryItem::setDate()
     * @uses TransactionSummaryItem::setTotalUsage()
     * @uses TransactionSummaryItem::setTotalTD()
     * @uses TransactionSummaryItem::setTotalPromotion()
     * @uses TransactionSummaryItem::setTotalReconciliation()
     * @uses TransactionSummaryItem::setTotalDebtRecovery()
     * @uses TransactionSummaryItem::setTotalAdjustment()
     * @uses TransactionSummaryItem::setTotalMisc()
     * @uses TransactionSummaryItem::setTotalTax()
     * @uses TransactionSummaryItem::setTotal()
     * @uses TransactionSummaryItem::setTotalPayments()
     * @uses TransactionSummaryItem::setAccountBalance()
     * @uses TransactionSummaryItem::setConsumption()
     * @uses TransactionSummaryItem::setChangeTotal()
     * @param string $date
     * @param float $totalUsage
     * @param float $totalTD
     * @param float $totalPromotion
     * @param float $totalReconciliation
     * @param float $totalDebtRecovery
     * @param float $totalAdjustment
     * @param float $totalMisc
     * @param float $totalTax
     * @param float $total
     * @param float $totalPayments
     * @param float $accountBalance
     * @param float $consumption
     * @param float $changeTotal
     */
    public function __construct($date = null, $totalUsage = null, $totalTD = null, $totalPromotion = null, $totalReconciliation = null, $totalDebtRecovery = null, $totalAdjustment = null, $totalMisc = null, $totalTax = null, $total = null, $totalPayments = null, $accountBalance = null, $consumption = null, $changeTotal = null)
    {
        $this
            ->setDate($date)
            ->setTotalUsage($totalUsage)
            ->setTotalTD($totalTD)
            ->setTotalPromotion($totalPromotion)
            ->setTotalReconciliation($totalReconciliation)
            ->setTotalDebtRecovery($totalDebtRecovery)
            ->setTotalAdjustment($totalAdjustment)
            ->setTotalMisc($totalMisc)
            ->setTotalTax($totalTax)
            ->setTotal($total)
            ->setTotalPayments($totalPayments)
            ->setAccountBalance($accountBalance)
            ->setConsumption($consumption)
            ->setChangeTotal($changeTotal);
    }
    /**
     * Get Date value
     * @return string
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \SGCIS\Struct\TransactionSummaryItem
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get TotalUsage value
     * @return float
     */
    public function getTotalUsage()
    {
        return $this->TotalUsage;
    }
    /**
     * Set TotalUsage value
     * @param float $totalUsage
     * @return \SGCIS\Struct\TransactionSummaryItem
     */
    public function setTotalUsage($totalUsage = null)
    {
        $this->TotalUsage = $totalUsage;
        return $this;
    }
    /**
     * Get TotalTD value
     * @return float
     */
    public function getTotalTD()
    {
        return $this->TotalTD;
    }
    /**
     * Set TotalTD value
     * @param float $totalTD
     * @return \SGCIS\Struct\TransactionSummaryItem
     */
    public function setTotalTD($totalTD = null)
    {
        $this->TotalTD = $totalTD;
        return $this;
    }
    /**
     * Get TotalPromotion value
     * @return float
     */
    public function getTotalPromotion()
    {
        return $this->TotalPromotion;
    }
    /**
     * Set TotalPromotion value
     * @param float $totalPromotion
     * @return \SGCIS\Struct\TransactionSummaryItem
     */
    public function setTotalPromotion($totalPromotion = null)
    {
        $this->TotalPromotion = $totalPromotion;
        return $this;
    }
    /**
     * Get TotalReconciliation value
     * @return float
     */
    public function getTotalReconciliation()
    {
        return $this->TotalReconciliation;
    }
    /**
     * Set TotalReconciliation value
     * @param float $totalReconciliation
     * @return \SGCIS\Struct\TransactionSummaryItem
     */
    public function setTotalReconciliation($totalReconciliation = null)
    {
        $this->TotalReconciliation = $totalReconciliation;
        return $this;
    }
    /**
     * Get TotalDebtRecovery value
     * @return float
     */
    public function getTotalDebtRecovery()
    {
        return $this->TotalDebtRecovery;
    }
    /**
     * Set TotalDebtRecovery value
     * @param float $totalDebtRecovery
     * @return \SGCIS\Struct\TransactionSummaryItem
     */
    public function setTotalDebtRecovery($totalDebtRecovery = null)
    {
        $this->TotalDebtRecovery = $totalDebtRecovery;
        return $this;
    }
    /**
     * Get TotalAdjustment value
     * @return float
     */
    public function getTotalAdjustment()
    {
        return $this->TotalAdjustment;
    }
    /**
     * Set TotalAdjustment value
     * @param float $totalAdjustment
     * @return \SGCIS\Struct\TransactionSummaryItem
     */
    public function setTotalAdjustment($totalAdjustment = null)
    {
        $this->TotalAdjustment = $totalAdjustment;
        return $this;
    }
    /**
     * Get TotalMisc value
     * @return float
     */
    public function getTotalMisc()
    {
        return $this->TotalMisc;
    }
    /**
     * Set TotalMisc value
     * @param float $totalMisc
     * @return \SGCIS\Struct\TransactionSummaryItem
     */
    public function setTotalMisc($totalMisc = null)
    {
        $this->TotalMisc = $totalMisc;
        return $this;
    }
    /**
     * Get TotalTax value
     * @return float
     */
    public function getTotalTax()
    {
        return $this->TotalTax;
    }
    /**
     * Set TotalTax value
     * @param float $totalTax
     * @return \SGCIS\Struct\TransactionSummaryItem
     */
    public function setTotalTax($totalTax = null)
    {
        $this->TotalTax = $totalTax;
        return $this;
    }
    /**
     * Get Total value
     * @return float
     */
    public function getTotal()
    {
        return $this->Total;
    }
    /**
     * Set Total value
     * @param float $total
     * @return \SGCIS\Struct\TransactionSummaryItem
     */
    public function setTotal($total = null)
    {
        $this->Total = $total;
        return $this;
    }
    /**
     * Get TotalPayments value
     * @return float
     */
    public function getTotalPayments()
    {
        return $this->TotalPayments;
    }
    /**
     * Set TotalPayments value
     * @param float $totalPayments
     * @return \SGCIS\Struct\TransactionSummaryItem
     */
    public function setTotalPayments($totalPayments = null)
    {
        $this->TotalPayments = $totalPayments;
        return $this;
    }
    /**
     * Get AccountBalance value
     * @return float
     */
    public function getAccountBalance()
    {
        return $this->AccountBalance;
    }
    /**
     * Set AccountBalance value
     * @param float $accountBalance
     * @return \SGCIS\Struct\TransactionSummaryItem
     */
    public function setAccountBalance($accountBalance = null)
    {
        $this->AccountBalance = $accountBalance;
        return $this;
    }
    /**
     * Get Consumption value
     * @return float
     */
    public function getConsumption()
    {
        return $this->Consumption;
    }
    /**
     * Set Consumption value
     * @param float $consumption
     * @return \SGCIS\Struct\TransactionSummaryItem
     */
    public function setConsumption($consumption = null)
    {
        $this->Consumption = $consumption;
        return $this;
    }
    /**
     * Get ChangeTotal value
     * @return float
     */
    public function getChangeTotal()
    {
        return $this->ChangeTotal;
    }
    /**
     * Set ChangeTotal value
     * @param float $changeTotal
     * @return \SGCIS\Struct\TransactionSummaryItem
     */
    public function setChangeTotal($changeTotal = null)
    {
        $this->ChangeTotal = $changeTotal;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\TransactionSummaryItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
