<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TicketTypeQueue Struct
 * @subpackage Structs
 */
class TicketTypeQueue extends AbstractStructBase
{
    /**
     * The TicketTypeQueueID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TicketTypeQueueID;
    /**
     * The TicketTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TicketTypeID;
    /**
     * The QueueTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $QueueTypeID;
    /**
     * The IsDBRecord
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsDBRecord;
    /**
     * The QueueLevel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $QueueLevel;
    /**
     * The MaxQueueEscalationLevel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MaxQueueEscalationLevel;
    /**
     * The QueueName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $QueueName;
    /**
     * The QueueDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $QueueDescription;
    /**
     * Constructor method for TicketTypeQueue
     * @uses TicketTypeQueue::setTicketTypeQueueID()
     * @uses TicketTypeQueue::setTicketTypeID()
     * @uses TicketTypeQueue::setQueueTypeID()
     * @uses TicketTypeQueue::setIsDBRecord()
     * @uses TicketTypeQueue::setQueueLevel()
     * @uses TicketTypeQueue::setMaxQueueEscalationLevel()
     * @uses TicketTypeQueue::setQueueName()
     * @uses TicketTypeQueue::setQueueDescription()
     * @param int $ticketTypeQueueID
     * @param int $ticketTypeID
     * @param int $queueTypeID
     * @param bool $isDBRecord
     * @param int $queueLevel
     * @param int $maxQueueEscalationLevel
     * @param string $queueName
     * @param string $queueDescription
     */
    public function __construct($ticketTypeQueueID = null, $ticketTypeID = null, $queueTypeID = null, $isDBRecord = null, $queueLevel = null, $maxQueueEscalationLevel = null, $queueName = null, $queueDescription = null)
    {
        $this
            ->setTicketTypeQueueID($ticketTypeQueueID)
            ->setTicketTypeID($ticketTypeID)
            ->setQueueTypeID($queueTypeID)
            ->setIsDBRecord($isDBRecord)
            ->setQueueLevel($queueLevel)
            ->setMaxQueueEscalationLevel($maxQueueEscalationLevel)
            ->setQueueName($queueName)
            ->setQueueDescription($queueDescription);
    }
    /**
     * Get TicketTypeQueueID value
     * @return int
     */
    public function getTicketTypeQueueID()
    {
        return $this->TicketTypeQueueID;
    }
    /**
     * Set TicketTypeQueueID value
     * @param int $ticketTypeQueueID
     * @return \SGCIS\Struct\TicketTypeQueue
     */
    public function setTicketTypeQueueID($ticketTypeQueueID = null)
    {
        // validation for constraint: int
        if (!is_null($ticketTypeQueueID) && !is_numeric($ticketTypeQueueID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ticketTypeQueueID)), __LINE__);
        }
        $this->TicketTypeQueueID = $ticketTypeQueueID;
        return $this;
    }
    /**
     * Get TicketTypeID value
     * @return int
     */
    public function getTicketTypeID()
    {
        return $this->TicketTypeID;
    }
    /**
     * Set TicketTypeID value
     * @param int $ticketTypeID
     * @return \SGCIS\Struct\TicketTypeQueue
     */
    public function setTicketTypeID($ticketTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($ticketTypeID) && !is_numeric($ticketTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ticketTypeID)), __LINE__);
        }
        $this->TicketTypeID = $ticketTypeID;
        return $this;
    }
    /**
     * Get QueueTypeID value
     * @return int
     */
    public function getQueueTypeID()
    {
        return $this->QueueTypeID;
    }
    /**
     * Set QueueTypeID value
     * @param int $queueTypeID
     * @return \SGCIS\Struct\TicketTypeQueue
     */
    public function setQueueTypeID($queueTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($queueTypeID) && !is_numeric($queueTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($queueTypeID)), __LINE__);
        }
        $this->QueueTypeID = $queueTypeID;
        return $this;
    }
    /**
     * Get IsDBRecord value
     * @return bool
     */
    public function getIsDBRecord()
    {
        return $this->IsDBRecord;
    }
    /**
     * Set IsDBRecord value
     * @param bool $isDBRecord
     * @return \SGCIS\Struct\TicketTypeQueue
     */
    public function setIsDBRecord($isDBRecord = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDBRecord) && !is_bool($isDBRecord)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isDBRecord)), __LINE__);
        }
        $this->IsDBRecord = $isDBRecord;
        return $this;
    }
    /**
     * Get QueueLevel value
     * @return int
     */
    public function getQueueLevel()
    {
        return $this->QueueLevel;
    }
    /**
     * Set QueueLevel value
     * @param int $queueLevel
     * @return \SGCIS\Struct\TicketTypeQueue
     */
    public function setQueueLevel($queueLevel = null)
    {
        // validation for constraint: int
        if (!is_null($queueLevel) && !is_numeric($queueLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($queueLevel)), __LINE__);
        }
        $this->QueueLevel = $queueLevel;
        return $this;
    }
    /**
     * Get MaxQueueEscalationLevel value
     * @return int
     */
    public function getMaxQueueEscalationLevel()
    {
        return $this->MaxQueueEscalationLevel;
    }
    /**
     * Set MaxQueueEscalationLevel value
     * @param int $maxQueueEscalationLevel
     * @return \SGCIS\Struct\TicketTypeQueue
     */
    public function setMaxQueueEscalationLevel($maxQueueEscalationLevel = null)
    {
        // validation for constraint: int
        if (!is_null($maxQueueEscalationLevel) && !is_numeric($maxQueueEscalationLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxQueueEscalationLevel)), __LINE__);
        }
        $this->MaxQueueEscalationLevel = $maxQueueEscalationLevel;
        return $this;
    }
    /**
     * Get QueueName value
     * @return string|null
     */
    public function getQueueName()
    {
        return $this->QueueName;
    }
    /**
     * Set QueueName value
     * @param string $queueName
     * @return \SGCIS\Struct\TicketTypeQueue
     */
    public function setQueueName($queueName = null)
    {
        // validation for constraint: string
        if (!is_null($queueName) && !is_string($queueName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($queueName)), __LINE__);
        }
        $this->QueueName = $queueName;
        return $this;
    }
    /**
     * Get QueueDescription value
     * @return string|null
     */
    public function getQueueDescription()
    {
        return $this->QueueDescription;
    }
    /**
     * Set QueueDescription value
     * @param string $queueDescription
     * @return \SGCIS\Struct\TicketTypeQueue
     */
    public function setQueueDescription($queueDescription = null)
    {
        // validation for constraint: string
        if (!is_null($queueDescription) && !is_string($queueDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($queueDescription)), __LINE__);
        }
        $this->QueueDescription = $queueDescription;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\TicketTypeQueue
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
