<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TicketStatusHistory Struct
 * @subpackage Structs
 */
class TicketStatusHistory extends BaseDTO
{
    /**
     * The TicketStatusHistoryID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TicketStatusHistoryID;
    /**
     * The TicketID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TicketID;
    /**
     * The TicketStatusID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TicketStatusID;
    /**
     * The StatusName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StatusName;
    /**
     * The UserName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserName;
    /**
     * Constructor method for TicketStatusHistory
     * @uses TicketStatusHistory::setTicketStatusHistoryID()
     * @uses TicketStatusHistory::setTicketID()
     * @uses TicketStatusHistory::setTicketStatusID()
     * @uses TicketStatusHistory::setStatusName()
     * @uses TicketStatusHistory::setUserName()
     * @param int $ticketStatusHistoryID
     * @param int $ticketID
     * @param int $ticketStatusID
     * @param string $statusName
     * @param string $userName
     */
    public function __construct($ticketStatusHistoryID = null, $ticketID = null, $ticketStatusID = null, $statusName = null, $userName = null)
    {
        $this
            ->setTicketStatusHistoryID($ticketStatusHistoryID)
            ->setTicketID($ticketID)
            ->setTicketStatusID($ticketStatusID)
            ->setStatusName($statusName)
            ->setUserName($userName);
    }
    /**
     * Get TicketStatusHistoryID value
     * @return int
     */
    public function getTicketStatusHistoryID()
    {
        return $this->TicketStatusHistoryID;
    }
    /**
     * Set TicketStatusHistoryID value
     * @param int $ticketStatusHistoryID
     * @return \SGCIS\Struct\TicketStatusHistory
     */
    public function setTicketStatusHistoryID($ticketStatusHistoryID = null)
    {
        // validation for constraint: int
        if (!is_null($ticketStatusHistoryID) && !is_numeric($ticketStatusHistoryID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ticketStatusHistoryID)), __LINE__);
        }
        $this->TicketStatusHistoryID = $ticketStatusHistoryID;
        return $this;
    }
    /**
     * Get TicketID value
     * @return int
     */
    public function getTicketID()
    {
        return $this->TicketID;
    }
    /**
     * Set TicketID value
     * @param int $ticketID
     * @return \SGCIS\Struct\TicketStatusHistory
     */
    public function setTicketID($ticketID = null)
    {
        // validation for constraint: int
        if (!is_null($ticketID) && !is_numeric($ticketID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ticketID)), __LINE__);
        }
        $this->TicketID = $ticketID;
        return $this;
    }
    /**
     * Get TicketStatusID value
     * @return int
     */
    public function getTicketStatusID()
    {
        return $this->TicketStatusID;
    }
    /**
     * Set TicketStatusID value
     * @param int $ticketStatusID
     * @return \SGCIS\Struct\TicketStatusHistory
     */
    public function setTicketStatusID($ticketStatusID = null)
    {
        // validation for constraint: int
        if (!is_null($ticketStatusID) && !is_numeric($ticketStatusID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ticketStatusID)), __LINE__);
        }
        $this->TicketStatusID = $ticketStatusID;
        return $this;
    }
    /**
     * Get StatusName value
     * @return string|null
     */
    public function getStatusName()
    {
        return $this->StatusName;
    }
    /**
     * Set StatusName value
     * @param string $statusName
     * @return \SGCIS\Struct\TicketStatusHistory
     */
    public function setStatusName($statusName = null)
    {
        // validation for constraint: string
        if (!is_null($statusName) && !is_string($statusName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($statusName)), __LINE__);
        }
        $this->StatusName = $statusName;
        return $this;
    }
    /**
     * Get UserName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->UserName;
    }
    /**
     * Set UserName value
     * @param string $userName
     * @return \SGCIS\Struct\TicketStatusHistory
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userName)), __LINE__);
        }
        $this->UserName = $userName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\TicketStatusHistory
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
