<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TicketSla Struct
 * @subpackage Structs
 */
class TicketSla extends BaseDTO
{
    /**
     * The TicketSlaID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TicketSlaID;
    /**
     * The SlaHours
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SlaHours;
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Active;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * Constructor method for TicketSla
     * @uses TicketSla::setTicketSlaID()
     * @uses TicketSla::setSlaHours()
     * @uses TicketSla::setActive()
     * @uses TicketSla::setName()
     * @uses TicketSla::setDescription()
     * @param int $ticketSlaID
     * @param int $slaHours
     * @param bool $active
     * @param string $name
     * @param string $description
     */
    public function __construct($ticketSlaID = null, $slaHours = null, $active = null, $name = null, $description = null)
    {
        $this
            ->setTicketSlaID($ticketSlaID)
            ->setSlaHours($slaHours)
            ->setActive($active)
            ->setName($name)
            ->setDescription($description);
    }
    /**
     * Get TicketSlaID value
     * @return int
     */
    public function getTicketSlaID()
    {
        return $this->TicketSlaID;
    }
    /**
     * Set TicketSlaID value
     * @param int $ticketSlaID
     * @return \SGCIS\Struct\TicketSla
     */
    public function setTicketSlaID($ticketSlaID = null)
    {
        // validation for constraint: int
        if (!is_null($ticketSlaID) && !is_numeric($ticketSlaID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ticketSlaID)), __LINE__);
        }
        $this->TicketSlaID = $ticketSlaID;
        return $this;
    }
    /**
     * Get SlaHours value
     * @return int
     */
    public function getSlaHours()
    {
        return $this->SlaHours;
    }
    /**
     * Set SlaHours value
     * @param int $slaHours
     * @return \SGCIS\Struct\TicketSla
     */
    public function setSlaHours($slaHours = null)
    {
        // validation for constraint: int
        if (!is_null($slaHours) && !is_numeric($slaHours)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($slaHours)), __LINE__);
        }
        $this->SlaHours = $slaHours;
        return $this;
    }
    /**
     * Get Active value
     * @return bool
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \SGCIS\Struct\TicketSla
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \SGCIS\Struct\TicketSla
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \SGCIS\Struct\TicketSla
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\TicketSla
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
