<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TicketQueue Struct
 * @subpackage Structs
 */
class TicketQueue extends BaseDTO
{
    /**
     * The TicketQueueID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TicketQueueID;
    /**
     * The TicketID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TicketID;
    /**
     * The TicketQueueTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TicketQueueTypeID;
    /**
     * The AssignedToUserID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AssignedToUserID;
    /**
     * The IsEscalated
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsEscalated;
    /**
     * The EscalationReasonID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $EscalationReasonID;
    /**
     * The DemoteReasonID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DemoteReasonID;
    /**
     * The IsActive
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsActive;
    /**
     * The TicketTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TicketTypeID;
    /**
     * The TicketSlaID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TicketSlaID;
    /**
     * The SlaHours
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $SlaHours;
    /**
     * The TicketQueueName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TicketQueueName;
    /**
     * The Tickets
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfTicket
     */
    public $Tickets;
    /**
     * Constructor method for TicketQueue
     * @uses TicketQueue::setTicketQueueID()
     * @uses TicketQueue::setTicketID()
     * @uses TicketQueue::setTicketQueueTypeID()
     * @uses TicketQueue::setAssignedToUserID()
     * @uses TicketQueue::setIsEscalated()
     * @uses TicketQueue::setEscalationReasonID()
     * @uses TicketQueue::setDemoteReasonID()
     * @uses TicketQueue::setIsActive()
     * @uses TicketQueue::setTicketTypeID()
     * @uses TicketQueue::setTicketSlaID()
     * @uses TicketQueue::setSlaHours()
     * @uses TicketQueue::setTicketQueueName()
     * @uses TicketQueue::setTickets()
     * @param int $ticketQueueID
     * @param int $ticketID
     * @param int $ticketQueueTypeID
     * @param int $assignedToUserID
     * @param bool $isEscalated
     * @param int $escalationReasonID
     * @param int $demoteReasonID
     * @param bool $isActive
     * @param int $ticketTypeID
     * @param int $ticketSlaID
     * @param float $slaHours
     * @param string $ticketQueueName
     * @param \SGCIS\Array\ArrayOfTicket $tickets
     */
    public function __construct($ticketQueueID = null, $ticketID = null, $ticketQueueTypeID = null, $assignedToUserID = null, $isEscalated = null, $escalationReasonID = null, $demoteReasonID = null, $isActive = null, $ticketTypeID = null, $ticketSlaID = null, $slaHours = null, $ticketQueueName = null, \SGCIS\Array\ArrayOfTicket $tickets = null)
    {
        $this
            ->setTicketQueueID($ticketQueueID)
            ->setTicketID($ticketID)
            ->setTicketQueueTypeID($ticketQueueTypeID)
            ->setAssignedToUserID($assignedToUserID)
            ->setIsEscalated($isEscalated)
            ->setEscalationReasonID($escalationReasonID)
            ->setDemoteReasonID($demoteReasonID)
            ->setIsActive($isActive)
            ->setTicketTypeID($ticketTypeID)
            ->setTicketSlaID($ticketSlaID)
            ->setSlaHours($slaHours)
            ->setTicketQueueName($ticketQueueName)
            ->setTickets($tickets);
    }
    /**
     * Get TicketQueueID value
     * @return int
     */
    public function getTicketQueueID()
    {
        return $this->TicketQueueID;
    }
    /**
     * Set TicketQueueID value
     * @param int $ticketQueueID
     * @return \SGCIS\Struct\TicketQueue
     */
    public function setTicketQueueID($ticketQueueID = null)
    {
        // validation for constraint: int
        if (!is_null($ticketQueueID) && !is_numeric($ticketQueueID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ticketQueueID)), __LINE__);
        }
        $this->TicketQueueID = $ticketQueueID;
        return $this;
    }
    /**
     * Get TicketID value
     * @return int
     */
    public function getTicketID()
    {
        return $this->TicketID;
    }
    /**
     * Set TicketID value
     * @param int $ticketID
     * @return \SGCIS\Struct\TicketQueue
     */
    public function setTicketID($ticketID = null)
    {
        // validation for constraint: int
        if (!is_null($ticketID) && !is_numeric($ticketID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ticketID)), __LINE__);
        }
        $this->TicketID = $ticketID;
        return $this;
    }
    /**
     * Get TicketQueueTypeID value
     * @return int
     */
    public function getTicketQueueTypeID()
    {
        return $this->TicketQueueTypeID;
    }
    /**
     * Set TicketQueueTypeID value
     * @param int $ticketQueueTypeID
     * @return \SGCIS\Struct\TicketQueue
     */
    public function setTicketQueueTypeID($ticketQueueTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($ticketQueueTypeID) && !is_numeric($ticketQueueTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ticketQueueTypeID)), __LINE__);
        }
        $this->TicketQueueTypeID = $ticketQueueTypeID;
        return $this;
    }
    /**
     * Get AssignedToUserID value
     * @return int
     */
    public function getAssignedToUserID()
    {
        return $this->AssignedToUserID;
    }
    /**
     * Set AssignedToUserID value
     * @param int $assignedToUserID
     * @return \SGCIS\Struct\TicketQueue
     */
    public function setAssignedToUserID($assignedToUserID = null)
    {
        // validation for constraint: int
        if (!is_null($assignedToUserID) && !is_numeric($assignedToUserID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($assignedToUserID)), __LINE__);
        }
        $this->AssignedToUserID = $assignedToUserID;
        return $this;
    }
    /**
     * Get IsEscalated value
     * @return bool
     */
    public function getIsEscalated()
    {
        return $this->IsEscalated;
    }
    /**
     * Set IsEscalated value
     * @param bool $isEscalated
     * @return \SGCIS\Struct\TicketQueue
     */
    public function setIsEscalated($isEscalated = null)
    {
        // validation for constraint: boolean
        if (!is_null($isEscalated) && !is_bool($isEscalated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isEscalated)), __LINE__);
        }
        $this->IsEscalated = $isEscalated;
        return $this;
    }
    /**
     * Get EscalationReasonID value
     * @return int
     */
    public function getEscalationReasonID()
    {
        return $this->EscalationReasonID;
    }
    /**
     * Set EscalationReasonID value
     * @param int $escalationReasonID
     * @return \SGCIS\Struct\TicketQueue
     */
    public function setEscalationReasonID($escalationReasonID = null)
    {
        // validation for constraint: int
        if (!is_null($escalationReasonID) && !is_numeric($escalationReasonID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($escalationReasonID)), __LINE__);
        }
        $this->EscalationReasonID = $escalationReasonID;
        return $this;
    }
    /**
     * Get DemoteReasonID value
     * @return int
     */
    public function getDemoteReasonID()
    {
        return $this->DemoteReasonID;
    }
    /**
     * Set DemoteReasonID value
     * @param int $demoteReasonID
     * @return \SGCIS\Struct\TicketQueue
     */
    public function setDemoteReasonID($demoteReasonID = null)
    {
        // validation for constraint: int
        if (!is_null($demoteReasonID) && !is_numeric($demoteReasonID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($demoteReasonID)), __LINE__);
        }
        $this->DemoteReasonID = $demoteReasonID;
        return $this;
    }
    /**
     * Get IsActive value
     * @return bool
     */
    public function getIsActive()
    {
        return $this->IsActive;
    }
    /**
     * Set IsActive value
     * @param bool $isActive
     * @return \SGCIS\Struct\TicketQueue
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isActive)), __LINE__);
        }
        $this->IsActive = $isActive;
        return $this;
    }
    /**
     * Get TicketTypeID value
     * @return int
     */
    public function getTicketTypeID()
    {
        return $this->TicketTypeID;
    }
    /**
     * Set TicketTypeID value
     * @param int $ticketTypeID
     * @return \SGCIS\Struct\TicketQueue
     */
    public function setTicketTypeID($ticketTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($ticketTypeID) && !is_numeric($ticketTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ticketTypeID)), __LINE__);
        }
        $this->TicketTypeID = $ticketTypeID;
        return $this;
    }
    /**
     * Get TicketSlaID value
     * @return int
     */
    public function getTicketSlaID()
    {
        return $this->TicketSlaID;
    }
    /**
     * Set TicketSlaID value
     * @param int $ticketSlaID
     * @return \SGCIS\Struct\TicketQueue
     */
    public function setTicketSlaID($ticketSlaID = null)
    {
        // validation for constraint: int
        if (!is_null($ticketSlaID) && !is_numeric($ticketSlaID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ticketSlaID)), __LINE__);
        }
        $this->TicketSlaID = $ticketSlaID;
        return $this;
    }
    /**
     * Get SlaHours value
     * @return float
     */
    public function getSlaHours()
    {
        return $this->SlaHours;
    }
    /**
     * Set SlaHours value
     * @param float $slaHours
     * @return \SGCIS\Struct\TicketQueue
     */
    public function setSlaHours($slaHours = null)
    {
        $this->SlaHours = $slaHours;
        return $this;
    }
    /**
     * Get TicketQueueName value
     * @return string|null
     */
    public function getTicketQueueName()
    {
        return $this->TicketQueueName;
    }
    /**
     * Set TicketQueueName value
     * @param string $ticketQueueName
     * @return \SGCIS\Struct\TicketQueue
     */
    public function setTicketQueueName($ticketQueueName = null)
    {
        // validation for constraint: string
        if (!is_null($ticketQueueName) && !is_string($ticketQueueName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ticketQueueName)), __LINE__);
        }
        $this->TicketQueueName = $ticketQueueName;
        return $this;
    }
    /**
     * Get Tickets value
     * @return \SGCIS\Array\ArrayOfTicket|null
     */
    public function getTickets()
    {
        return $this->Tickets;
    }
    /**
     * Set Tickets value
     * @param \SGCIS\Array\ArrayOfTicket $tickets
     * @return \SGCIS\Struct\TicketQueue
     */
    public function setTickets(\SGCIS\Array\ArrayOfTicket $tickets = null)
    {
        $this->Tickets = $tickets;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\TicketQueue
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
