<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TicketPriority Struct
 * @subpackage Structs
 */
class TicketPriority extends BaseDTO
{
    /**
     * The TicketPriorityID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TicketPriorityID;
    /**
     * The PriorityLevel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PriorityLevel;
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Active;
    /**
     * The IsDefault
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsDefault;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * Constructor method for TicketPriority
     * @uses TicketPriority::setTicketPriorityID()
     * @uses TicketPriority::setPriorityLevel()
     * @uses TicketPriority::setActive()
     * @uses TicketPriority::setIsDefault()
     * @uses TicketPriority::setName()
     * @uses TicketPriority::setDescription()
     * @param int $ticketPriorityID
     * @param int $priorityLevel
     * @param bool $active
     * @param bool $isDefault
     * @param string $name
     * @param string $description
     */
    public function __construct($ticketPriorityID = null, $priorityLevel = null, $active = null, $isDefault = null, $name = null, $description = null)
    {
        $this
            ->setTicketPriorityID($ticketPriorityID)
            ->setPriorityLevel($priorityLevel)
            ->setActive($active)
            ->setIsDefault($isDefault)
            ->setName($name)
            ->setDescription($description);
    }
    /**
     * Get TicketPriorityID value
     * @return int
     */
    public function getTicketPriorityID()
    {
        return $this->TicketPriorityID;
    }
    /**
     * Set TicketPriorityID value
     * @param int $ticketPriorityID
     * @return \SGCIS\Struct\TicketPriority
     */
    public function setTicketPriorityID($ticketPriorityID = null)
    {
        // validation for constraint: int
        if (!is_null($ticketPriorityID) && !is_numeric($ticketPriorityID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ticketPriorityID)), __LINE__);
        }
        $this->TicketPriorityID = $ticketPriorityID;
        return $this;
    }
    /**
     * Get PriorityLevel value
     * @return int
     */
    public function getPriorityLevel()
    {
        return $this->PriorityLevel;
    }
    /**
     * Set PriorityLevel value
     * @param int $priorityLevel
     * @return \SGCIS\Struct\TicketPriority
     */
    public function setPriorityLevel($priorityLevel = null)
    {
        // validation for constraint: int
        if (!is_null($priorityLevel) && !is_numeric($priorityLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($priorityLevel)), __LINE__);
        }
        $this->PriorityLevel = $priorityLevel;
        return $this;
    }
    /**
     * Get Active value
     * @return bool
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \SGCIS\Struct\TicketPriority
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get IsDefault value
     * @return bool
     */
    public function getIsDefault()
    {
        return $this->IsDefault;
    }
    /**
     * Set IsDefault value
     * @param bool $isDefault
     * @return \SGCIS\Struct\TicketPriority
     */
    public function setIsDefault($isDefault = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDefault) && !is_bool($isDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isDefault)), __LINE__);
        }
        $this->IsDefault = $isDefault;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \SGCIS\Struct\TicketPriority
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \SGCIS\Struct\TicketPriority
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\TicketPriority
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
