<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TicketField Struct
 * @subpackage Structs
 */
class TicketField extends AbstractStructBase
{
    /**
     * The TicketFieldID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TicketFieldID;
    /**
     * The TicketFieldValueID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TicketFieldValueID;
    /**
     * The IsActive
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsActive;
    /**
     * The DBRecord
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $DBRecord;
    /**
     * The IsRequired
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsRequired;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The FieldValueList
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FieldValueList;
    /**
     * The Value
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Value;
    /**
     * Constructor method for TicketField
     * @uses TicketField::setTicketFieldID()
     * @uses TicketField::setTicketFieldValueID()
     * @uses TicketField::setIsActive()
     * @uses TicketField::setDBRecord()
     * @uses TicketField::setIsRequired()
     * @uses TicketField::setName()
     * @uses TicketField::setDescription()
     * @uses TicketField::setFieldValueList()
     * @uses TicketField::setValue()
     * @param int $ticketFieldID
     * @param int $ticketFieldValueID
     * @param bool $isActive
     * @param bool $dBRecord
     * @param bool $isRequired
     * @param string $name
     * @param string $description
     * @param string $fieldValueList
     * @param string $value
     */
    public function __construct($ticketFieldID = null, $ticketFieldValueID = null, $isActive = null, $dBRecord = null, $isRequired = null, $name = null, $description = null, $fieldValueList = null, $value = null)
    {
        $this
            ->setTicketFieldID($ticketFieldID)
            ->setTicketFieldValueID($ticketFieldValueID)
            ->setIsActive($isActive)
            ->setDBRecord($dBRecord)
            ->setIsRequired($isRequired)
            ->setName($name)
            ->setDescription($description)
            ->setFieldValueList($fieldValueList)
            ->setValue($value);
    }
    /**
     * Get TicketFieldID value
     * @return int
     */
    public function getTicketFieldID()
    {
        return $this->TicketFieldID;
    }
    /**
     * Set TicketFieldID value
     * @param int $ticketFieldID
     * @return \SGCIS\Struct\TicketField
     */
    public function setTicketFieldID($ticketFieldID = null)
    {
        // validation for constraint: int
        if (!is_null($ticketFieldID) && !is_numeric($ticketFieldID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ticketFieldID)), __LINE__);
        }
        $this->TicketFieldID = $ticketFieldID;
        return $this;
    }
    /**
     * Get TicketFieldValueID value
     * @return int
     */
    public function getTicketFieldValueID()
    {
        return $this->TicketFieldValueID;
    }
    /**
     * Set TicketFieldValueID value
     * @param int $ticketFieldValueID
     * @return \SGCIS\Struct\TicketField
     */
    public function setTicketFieldValueID($ticketFieldValueID = null)
    {
        // validation for constraint: int
        if (!is_null($ticketFieldValueID) && !is_numeric($ticketFieldValueID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ticketFieldValueID)), __LINE__);
        }
        $this->TicketFieldValueID = $ticketFieldValueID;
        return $this;
    }
    /**
     * Get IsActive value
     * @return bool
     */
    public function getIsActive()
    {
        return $this->IsActive;
    }
    /**
     * Set IsActive value
     * @param bool $isActive
     * @return \SGCIS\Struct\TicketField
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isActive)), __LINE__);
        }
        $this->IsActive = $isActive;
        return $this;
    }
    /**
     * Get DBRecord value
     * @return bool
     */
    public function getDBRecord()
    {
        return $this->DBRecord;
    }
    /**
     * Set DBRecord value
     * @param bool $dBRecord
     * @return \SGCIS\Struct\TicketField
     */
    public function setDBRecord($dBRecord = null)
    {
        // validation for constraint: boolean
        if (!is_null($dBRecord) && !is_bool($dBRecord)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($dBRecord)), __LINE__);
        }
        $this->DBRecord = $dBRecord;
        return $this;
    }
    /**
     * Get IsRequired value
     * @return bool
     */
    public function getIsRequired()
    {
        return $this->IsRequired;
    }
    /**
     * Set IsRequired value
     * @param bool $isRequired
     * @return \SGCIS\Struct\TicketField
     */
    public function setIsRequired($isRequired = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRequired) && !is_bool($isRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isRequired)), __LINE__);
        }
        $this->IsRequired = $isRequired;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \SGCIS\Struct\TicketField
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \SGCIS\Struct\TicketField
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get FieldValueList value
     * @return string|null
     */
    public function getFieldValueList()
    {
        return $this->FieldValueList;
    }
    /**
     * Set FieldValueList value
     * @param string $fieldValueList
     * @return \SGCIS\Struct\TicketField
     */
    public function setFieldValueList($fieldValueList = null)
    {
        // validation for constraint: string
        if (!is_null($fieldValueList) && !is_string($fieldValueList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fieldValueList)), __LINE__);
        }
        $this->FieldValueList = $fieldValueList;
        return $this;
    }
    /**
     * Get Value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param string $value
     * @return \SGCIS\Struct\TicketField
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\TicketField
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
