<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TOUChargeSchedule Struct
 * @subpackage Structs
 */
class TOUChargeSchedule extends AbstractStructBase
{
    /**
     * The TOUChargeScheduleID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $TOUChargeScheduleID;
    /**
     * The Sun
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Sun;
    /**
     * The Mon
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Mon;
    /**
     * The Tue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Tue;
    /**
     * The Wed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Wed;
    /**
     * The Thu
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Thu;
    /**
     * The Fri
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Fri;
    /**
     * The Sat
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Sat;
    /**
     * The Start
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Start;
    /**
     * The End
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $End;
    /**
     * The AppliesToDays
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AppliesToDays;
    /**
     * Constructor method for TOUChargeSchedule
     * @uses TOUChargeSchedule::setTOUChargeScheduleID()
     * @uses TOUChargeSchedule::setSun()
     * @uses TOUChargeSchedule::setMon()
     * @uses TOUChargeSchedule::setTue()
     * @uses TOUChargeSchedule::setWed()
     * @uses TOUChargeSchedule::setThu()
     * @uses TOUChargeSchedule::setFri()
     * @uses TOUChargeSchedule::setSat()
     * @uses TOUChargeSchedule::setStart()
     * @uses TOUChargeSchedule::setEnd()
     * @uses TOUChargeSchedule::setAppliesToDays()
     * @param string $tOUChargeScheduleID
     * @param bool $sun
     * @param bool $mon
     * @param bool $tue
     * @param bool $wed
     * @param bool $thu
     * @param bool $fri
     * @param bool $sat
     * @param string $start
     * @param string $end
     * @param string $appliesToDays
     */
    public function __construct($tOUChargeScheduleID = null, $sun = null, $mon = null, $tue = null, $wed = null, $thu = null, $fri = null, $sat = null, $start = null, $end = null, $appliesToDays = null)
    {
        $this
            ->setTOUChargeScheduleID($tOUChargeScheduleID)
            ->setSun($sun)
            ->setMon($mon)
            ->setTue($tue)
            ->setWed($wed)
            ->setThu($thu)
            ->setFri($fri)
            ->setSat($sat)
            ->setStart($start)
            ->setEnd($end)
            ->setAppliesToDays($appliesToDays);
    }
    /**
     * Get TOUChargeScheduleID value
     * @return string
     */
    public function getTOUChargeScheduleID()
    {
        return $this->TOUChargeScheduleID;
    }
    /**
     * Set TOUChargeScheduleID value
     * @param string $tOUChargeScheduleID
     * @return \SGCIS\Struct\TOUChargeSchedule
     */
    public function setTOUChargeScheduleID($tOUChargeScheduleID = null)
    {
        // validation for constraint: pattern
        if (is_scalar($tOUChargeScheduleID) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $tOUChargeScheduleID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}", "%s" given', var_export($tOUChargeScheduleID, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($tOUChargeScheduleID) && !is_string($tOUChargeScheduleID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tOUChargeScheduleID)), __LINE__);
        }
        $this->TOUChargeScheduleID = $tOUChargeScheduleID;
        return $this;
    }
    /**
     * Get Sun value
     * @return bool
     */
    public function getSun()
    {
        return $this->Sun;
    }
    /**
     * Set Sun value
     * @param bool $sun
     * @return \SGCIS\Struct\TOUChargeSchedule
     */
    public function setSun($sun = null)
    {
        // validation for constraint: boolean
        if (!is_null($sun) && !is_bool($sun)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($sun)), __LINE__);
        }
        $this->Sun = $sun;
        return $this;
    }
    /**
     * Get Mon value
     * @return bool
     */
    public function getMon()
    {
        return $this->Mon;
    }
    /**
     * Set Mon value
     * @param bool $mon
     * @return \SGCIS\Struct\TOUChargeSchedule
     */
    public function setMon($mon = null)
    {
        // validation for constraint: boolean
        if (!is_null($mon) && !is_bool($mon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($mon)), __LINE__);
        }
        $this->Mon = $mon;
        return $this;
    }
    /**
     * Get Tue value
     * @return bool
     */
    public function getTue()
    {
        return $this->Tue;
    }
    /**
     * Set Tue value
     * @param bool $tue
     * @return \SGCIS\Struct\TOUChargeSchedule
     */
    public function setTue($tue = null)
    {
        // validation for constraint: boolean
        if (!is_null($tue) && !is_bool($tue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($tue)), __LINE__);
        }
        $this->Tue = $tue;
        return $this;
    }
    /**
     * Get Wed value
     * @return bool
     */
    public function getWed()
    {
        return $this->Wed;
    }
    /**
     * Set Wed value
     * @param bool $wed
     * @return \SGCIS\Struct\TOUChargeSchedule
     */
    public function setWed($wed = null)
    {
        // validation for constraint: boolean
        if (!is_null($wed) && !is_bool($wed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($wed)), __LINE__);
        }
        $this->Wed = $wed;
        return $this;
    }
    /**
     * Get Thu value
     * @return bool
     */
    public function getThu()
    {
        return $this->Thu;
    }
    /**
     * Set Thu value
     * @param bool $thu
     * @return \SGCIS\Struct\TOUChargeSchedule
     */
    public function setThu($thu = null)
    {
        // validation for constraint: boolean
        if (!is_null($thu) && !is_bool($thu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($thu)), __LINE__);
        }
        $this->Thu = $thu;
        return $this;
    }
    /**
     * Get Fri value
     * @return bool
     */
    public function getFri()
    {
        return $this->Fri;
    }
    /**
     * Set Fri value
     * @param bool $fri
     * @return \SGCIS\Struct\TOUChargeSchedule
     */
    public function setFri($fri = null)
    {
        // validation for constraint: boolean
        if (!is_null($fri) && !is_bool($fri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($fri)), __LINE__);
        }
        $this->Fri = $fri;
        return $this;
    }
    /**
     * Get Sat value
     * @return bool
     */
    public function getSat()
    {
        return $this->Sat;
    }
    /**
     * Set Sat value
     * @param bool $sat
     * @return \SGCIS\Struct\TOUChargeSchedule
     */
    public function setSat($sat = null)
    {
        // validation for constraint: boolean
        if (!is_null($sat) && !is_bool($sat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($sat)), __LINE__);
        }
        $this->Sat = $sat;
        return $this;
    }
    /**
     * Get Start value
     * @return string
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \SGCIS\Struct\TOUChargeSchedule
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get End value
     * @return string
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \SGCIS\Struct\TOUChargeSchedule
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($end)), __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Get AppliesToDays value
     * @return string|null
     */
    public function getAppliesToDays()
    {
        return $this->AppliesToDays;
    }
    /**
     * Set AppliesToDays value
     * @param string $appliesToDays
     * @return \SGCIS\Struct\TOUChargeSchedule
     */
    public function setAppliesToDays($appliesToDays = null)
    {
        // validation for constraint: string
        if (!is_null($appliesToDays) && !is_string($appliesToDays)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($appliesToDays)), __LINE__);
        }
        $this->AppliesToDays = $appliesToDays;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\TOUChargeSchedule
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
