<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SystemRoleApplicationSearchEntityView Struct
 * @subpackage Structs
 */
class SystemRoleApplicationSearchEntityView extends AbstractStructBase
{
    /**
     * The SystemRoleApplicationSearchEntityViewID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SystemRoleApplicationSearchEntityViewID;
    /**
     * The SystemRoleApplicationID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SystemRoleApplicationID;
    /**
     * The SearchEntityViewID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SearchEntityViewID;
    /**
     * The SearchEntityName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SearchEntityName;
    /**
     * Constructor method for SystemRoleApplicationSearchEntityView
     * @uses SystemRoleApplicationSearchEntityView::setSystemRoleApplicationSearchEntityViewID()
     * @uses SystemRoleApplicationSearchEntityView::setSystemRoleApplicationID()
     * @uses SystemRoleApplicationSearchEntityView::setSearchEntityViewID()
     * @uses SystemRoleApplicationSearchEntityView::setSearchEntityName()
     * @param int $systemRoleApplicationSearchEntityViewID
     * @param int $systemRoleApplicationID
     * @param int $searchEntityViewID
     * @param string $searchEntityName
     */
    public function __construct($systemRoleApplicationSearchEntityViewID = null, $systemRoleApplicationID = null, $searchEntityViewID = null, $searchEntityName = null)
    {
        $this
            ->setSystemRoleApplicationSearchEntityViewID($systemRoleApplicationSearchEntityViewID)
            ->setSystemRoleApplicationID($systemRoleApplicationID)
            ->setSearchEntityViewID($searchEntityViewID)
            ->setSearchEntityName($searchEntityName);
    }
    /**
     * Get SystemRoleApplicationSearchEntityViewID value
     * @return int
     */
    public function getSystemRoleApplicationSearchEntityViewID()
    {
        return $this->SystemRoleApplicationSearchEntityViewID;
    }
    /**
     * Set SystemRoleApplicationSearchEntityViewID value
     * @param int $systemRoleApplicationSearchEntityViewID
     * @return \SGCIS\Struct\SystemRoleApplicationSearchEntityView
     */
    public function setSystemRoleApplicationSearchEntityViewID($systemRoleApplicationSearchEntityViewID = null)
    {
        // validation for constraint: int
        if (!is_null($systemRoleApplicationSearchEntityViewID) && !is_numeric($systemRoleApplicationSearchEntityViewID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($systemRoleApplicationSearchEntityViewID)), __LINE__);
        }
        $this->SystemRoleApplicationSearchEntityViewID = $systemRoleApplicationSearchEntityViewID;
        return $this;
    }
    /**
     * Get SystemRoleApplicationID value
     * @return int
     */
    public function getSystemRoleApplicationID()
    {
        return $this->SystemRoleApplicationID;
    }
    /**
     * Set SystemRoleApplicationID value
     * @param int $systemRoleApplicationID
     * @return \SGCIS\Struct\SystemRoleApplicationSearchEntityView
     */
    public function setSystemRoleApplicationID($systemRoleApplicationID = null)
    {
        // validation for constraint: int
        if (!is_null($systemRoleApplicationID) && !is_numeric($systemRoleApplicationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($systemRoleApplicationID)), __LINE__);
        }
        $this->SystemRoleApplicationID = $systemRoleApplicationID;
        return $this;
    }
    /**
     * Get SearchEntityViewID value
     * @return int
     */
    public function getSearchEntityViewID()
    {
        return $this->SearchEntityViewID;
    }
    /**
     * Set SearchEntityViewID value
     * @param int $searchEntityViewID
     * @return \SGCIS\Struct\SystemRoleApplicationSearchEntityView
     */
    public function setSearchEntityViewID($searchEntityViewID = null)
    {
        // validation for constraint: int
        if (!is_null($searchEntityViewID) && !is_numeric($searchEntityViewID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($searchEntityViewID)), __LINE__);
        }
        $this->SearchEntityViewID = $searchEntityViewID;
        return $this;
    }
    /**
     * Get SearchEntityName value
     * @return string|null
     */
    public function getSearchEntityName()
    {
        return $this->SearchEntityName;
    }
    /**
     * Set SearchEntityName value
     * @param string $searchEntityName
     * @return \SGCIS\Struct\SystemRoleApplicationSearchEntityView
     */
    public function setSearchEntityName($searchEntityName = null)
    {
        // validation for constraint: string
        if (!is_null($searchEntityName) && !is_string($searchEntityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($searchEntityName)), __LINE__);
        }
        $this->SearchEntityName = $searchEntityName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\SystemRoleApplicationSearchEntityView
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
