<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SystemPropertyRequest Struct
 * @subpackage Structs
 */
class SystemPropertyRequest extends ServiceRequestBase
{
    /**
     * The SystemCategoryID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SystemCategoryID;
    /**
     * The CompanyID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CompanyID;
    /**
     * The SystemPropertyName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SystemPropertyName;
    /**
     * The SystemPropertyNames
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfString
     */
    public $SystemPropertyNames;
    /**
     * The SystemProperty
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\SystemProperty
     */
    public $SystemProperty;
    /**
     * The SystemProperties
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfSystemProperty
     */
    public $SystemProperties;
    /**
     * Constructor method for SystemPropertyRequest
     * @uses SystemPropertyRequest::setSystemCategoryID()
     * @uses SystemPropertyRequest::setCompanyID()
     * @uses SystemPropertyRequest::setSystemPropertyName()
     * @uses SystemPropertyRequest::setSystemPropertyNames()
     * @uses SystemPropertyRequest::setSystemProperty()
     * @uses SystemPropertyRequest::setSystemProperties()
     * @param int $systemCategoryID
     * @param int $companyID
     * @param string $systemPropertyName
     * @param \SGCIS\Array\ArrayOfString $systemPropertyNames
     * @param \SGCIS\Struct\SystemProperty $systemProperty
     * @param \SGCIS\Array\ArrayOfSystemProperty $systemProperties
     */
    public function __construct($systemCategoryID = null, $companyID = null, $systemPropertyName = null, \SGCIS\Array\ArrayOfString $systemPropertyNames = null, \SGCIS\Struct\SystemProperty $systemProperty = null, \SGCIS\Array\ArrayOfSystemProperty $systemProperties = null)
    {
        $this
            ->setSystemCategoryID($systemCategoryID)
            ->setCompanyID($companyID)
            ->setSystemPropertyName($systemPropertyName)
            ->setSystemPropertyNames($systemPropertyNames)
            ->setSystemProperty($systemProperty)
            ->setSystemProperties($systemProperties);
    }
    /**
     * Get SystemCategoryID value
     * @return int
     */
    public function getSystemCategoryID()
    {
        return $this->SystemCategoryID;
    }
    /**
     * Set SystemCategoryID value
     * @param int $systemCategoryID
     * @return \SGCIS\Struct\SystemPropertyRequest
     */
    public function setSystemCategoryID($systemCategoryID = null)
    {
        // validation for constraint: int
        if (!is_null($systemCategoryID) && !is_numeric($systemCategoryID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($systemCategoryID)), __LINE__);
        }
        $this->SystemCategoryID = $systemCategoryID;
        return $this;
    }
    /**
     * Get CompanyID value
     * @return int
     */
    public function getCompanyID()
    {
        return $this->CompanyID;
    }
    /**
     * Set CompanyID value
     * @param int $companyID
     * @return \SGCIS\Struct\SystemPropertyRequest
     */
    public function setCompanyID($companyID = null)
    {
        // validation for constraint: int
        if (!is_null($companyID) && !is_numeric($companyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($companyID)), __LINE__);
        }
        $this->CompanyID = $companyID;
        return $this;
    }
    /**
     * Get SystemPropertyName value
     * @return string|null
     */
    public function getSystemPropertyName()
    {
        return $this->SystemPropertyName;
    }
    /**
     * Set SystemPropertyName value
     * @param string $systemPropertyName
     * @return \SGCIS\Struct\SystemPropertyRequest
     */
    public function setSystemPropertyName($systemPropertyName = null)
    {
        // validation for constraint: string
        if (!is_null($systemPropertyName) && !is_string($systemPropertyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($systemPropertyName)), __LINE__);
        }
        $this->SystemPropertyName = $systemPropertyName;
        return $this;
    }
    /**
     * Get SystemPropertyNames value
     * @return \SGCIS\Array\ArrayOfString|null
     */
    public function getSystemPropertyNames()
    {
        return $this->SystemPropertyNames;
    }
    /**
     * Set SystemPropertyNames value
     * @param \SGCIS\Array\ArrayOfString $systemPropertyNames
     * @return \SGCIS\Struct\SystemPropertyRequest
     */
    public function setSystemPropertyNames(\SGCIS\Array\ArrayOfString $systemPropertyNames = null)
    {
        $this->SystemPropertyNames = $systemPropertyNames;
        return $this;
    }
    /**
     * Get SystemProperty value
     * @return \SGCIS\Struct\SystemProperty|null
     */
    public function getSystemProperty()
    {
        return $this->SystemProperty;
    }
    /**
     * Set SystemProperty value
     * @param \SGCIS\Struct\SystemProperty $systemProperty
     * @return \SGCIS\Struct\SystemPropertyRequest
     */
    public function setSystemProperty(\SGCIS\Struct\SystemProperty $systemProperty = null)
    {
        $this->SystemProperty = $systemProperty;
        return $this;
    }
    /**
     * Get SystemProperties value
     * @return \SGCIS\Array\ArrayOfSystemProperty|null
     */
    public function getSystemProperties()
    {
        return $this->SystemProperties;
    }
    /**
     * Set SystemProperties value
     * @param \SGCIS\Array\ArrayOfSystemProperty $systemProperties
     * @return \SGCIS\Struct\SystemPropertyRequest
     */
    public function setSystemProperties(\SGCIS\Array\ArrayOfSystemProperty $systemProperties = null)
    {
        $this->SystemProperties = $systemProperties;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\SystemPropertyRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
