<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SystemEvent Struct
 * @subpackage Structs
 */
class SystemEvent extends BaseDTO
{
    /**
     * The SystemEventID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SystemEventID;
    /**
     * The IsCommissionEvent
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsCommissionEvent;
    /**
     * The IsPromotionEvent
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsPromotionEvent;
    /**
     * The TriggerNotification
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $TriggerNotification;
    /**
     * The IsAutomationEligible
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsAutomationEligible;
    /**
     * The IsThresholdDayNeeded
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsThresholdDayNeeded;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * Constructor method for SystemEvent
     * @uses SystemEvent::setSystemEventID()
     * @uses SystemEvent::setIsCommissionEvent()
     * @uses SystemEvent::setIsPromotionEvent()
     * @uses SystemEvent::setTriggerNotification()
     * @uses SystemEvent::setIsAutomationEligible()
     * @uses SystemEvent::setIsThresholdDayNeeded()
     * @uses SystemEvent::setName()
     * @uses SystemEvent::setDescription()
     * @param int $systemEventID
     * @param bool $isCommissionEvent
     * @param bool $isPromotionEvent
     * @param bool $triggerNotification
     * @param bool $isAutomationEligible
     * @param bool $isThresholdDayNeeded
     * @param string $name
     * @param string $description
     */
    public function __construct($systemEventID = null, $isCommissionEvent = null, $isPromotionEvent = null, $triggerNotification = null, $isAutomationEligible = null, $isThresholdDayNeeded = null, $name = null, $description = null)
    {
        $this
            ->setSystemEventID($systemEventID)
            ->setIsCommissionEvent($isCommissionEvent)
            ->setIsPromotionEvent($isPromotionEvent)
            ->setTriggerNotification($triggerNotification)
            ->setIsAutomationEligible($isAutomationEligible)
            ->setIsThresholdDayNeeded($isThresholdDayNeeded)
            ->setName($name)
            ->setDescription($description);
    }
    /**
     * Get SystemEventID value
     * @return int
     */
    public function getSystemEventID()
    {
        return $this->SystemEventID;
    }
    /**
     * Set SystemEventID value
     * @param int $systemEventID
     * @return \SGCIS\Struct\SystemEvent
     */
    public function setSystemEventID($systemEventID = null)
    {
        // validation for constraint: int
        if (!is_null($systemEventID) && !is_numeric($systemEventID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($systemEventID)), __LINE__);
        }
        $this->SystemEventID = $systemEventID;
        return $this;
    }
    /**
     * Get IsCommissionEvent value
     * @return bool
     */
    public function getIsCommissionEvent()
    {
        return $this->IsCommissionEvent;
    }
    /**
     * Set IsCommissionEvent value
     * @param bool $isCommissionEvent
     * @return \SGCIS\Struct\SystemEvent
     */
    public function setIsCommissionEvent($isCommissionEvent = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCommissionEvent) && !is_bool($isCommissionEvent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isCommissionEvent)), __LINE__);
        }
        $this->IsCommissionEvent = $isCommissionEvent;
        return $this;
    }
    /**
     * Get IsPromotionEvent value
     * @return bool
     */
    public function getIsPromotionEvent()
    {
        return $this->IsPromotionEvent;
    }
    /**
     * Set IsPromotionEvent value
     * @param bool $isPromotionEvent
     * @return \SGCIS\Struct\SystemEvent
     */
    public function setIsPromotionEvent($isPromotionEvent = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPromotionEvent) && !is_bool($isPromotionEvent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isPromotionEvent)), __LINE__);
        }
        $this->IsPromotionEvent = $isPromotionEvent;
        return $this;
    }
    /**
     * Get TriggerNotification value
     * @return bool
     */
    public function getTriggerNotification()
    {
        return $this->TriggerNotification;
    }
    /**
     * Set TriggerNotification value
     * @param bool $triggerNotification
     * @return \SGCIS\Struct\SystemEvent
     */
    public function setTriggerNotification($triggerNotification = null)
    {
        // validation for constraint: boolean
        if (!is_null($triggerNotification) && !is_bool($triggerNotification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($triggerNotification)), __LINE__);
        }
        $this->TriggerNotification = $triggerNotification;
        return $this;
    }
    /**
     * Get IsAutomationEligible value
     * @return bool
     */
    public function getIsAutomationEligible()
    {
        return $this->IsAutomationEligible;
    }
    /**
     * Set IsAutomationEligible value
     * @param bool $isAutomationEligible
     * @return \SGCIS\Struct\SystemEvent
     */
    public function setIsAutomationEligible($isAutomationEligible = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAutomationEligible) && !is_bool($isAutomationEligible)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isAutomationEligible)), __LINE__);
        }
        $this->IsAutomationEligible = $isAutomationEligible;
        return $this;
    }
    /**
     * Get IsThresholdDayNeeded value
     * @return bool
     */
    public function getIsThresholdDayNeeded()
    {
        return $this->IsThresholdDayNeeded;
    }
    /**
     * Set IsThresholdDayNeeded value
     * @param bool $isThresholdDayNeeded
     * @return \SGCIS\Struct\SystemEvent
     */
    public function setIsThresholdDayNeeded($isThresholdDayNeeded = null)
    {
        // validation for constraint: boolean
        if (!is_null($isThresholdDayNeeded) && !is_bool($isThresholdDayNeeded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isThresholdDayNeeded)), __LINE__);
        }
        $this->IsThresholdDayNeeded = $isThresholdDayNeeded;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \SGCIS\Struct\SystemEvent
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \SGCIS\Struct\SystemEvent
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\SystemEvent
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
