<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServicePointMeterRead Struct
 * @subpackage Structs
 */
class ServicePointMeterRead extends BaseDTO
{
    /**
     * The ServicePointMeterReadID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ServicePointMeterReadID;
    /**
     * The ServicePointMeterID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ServicePointMeterID;
    /**
     * The Consumption
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Consumption;
    /**
     * The ReadDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ReadDate;
    /**
     * The AccountID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountID;
    /**
     * The AveragekWhRate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AveragekWhRate;
    /**
     * The AverageConsumption
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AverageConsumption;
    /**
     * The ConsumptionDollars
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ConsumptionDollars;
    /**
     * The ReadDateFrom
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ReadDateFrom;
    /**
     * The ReadDateTo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ReadDateTo;
    /**
     * The Posted
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Posted;
    /**
     * The MeterReadID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MeterReadID;
    /**
     * The ServicePointMeterReadTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ServicePointMeterReadTypeID;
    /**
     * The StartRegisterRead
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $StartRegisterRead;
    /**
     * The EndRegisterRead
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $EndRegisterRead;
    /**
     * The BillID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BillID;
    /**
     * The ReadDateDisplay
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReadDateDisplay;
    /**
     * The AccountServicePoint
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\AccountServicePoint
     */
    public $AccountServicePoint;
    /**
     * The ReadTypeName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReadTypeName;
    /**
     * The VolumetricChargeCodes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VolumetricChargeCodes;
    /**
     * The MeterReads
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfServicePointMeterReadDetail
     */
    public $MeterReads;
    /**
     * Constructor method for ServicePointMeterRead
     * @uses ServicePointMeterRead::setServicePointMeterReadID()
     * @uses ServicePointMeterRead::setServicePointMeterID()
     * @uses ServicePointMeterRead::setConsumption()
     * @uses ServicePointMeterRead::setReadDate()
     * @uses ServicePointMeterRead::setAccountID()
     * @uses ServicePointMeterRead::setAveragekWhRate()
     * @uses ServicePointMeterRead::setAverageConsumption()
     * @uses ServicePointMeterRead::setConsumptionDollars()
     * @uses ServicePointMeterRead::setReadDateFrom()
     * @uses ServicePointMeterRead::setReadDateTo()
     * @uses ServicePointMeterRead::setPosted()
     * @uses ServicePointMeterRead::setMeterReadID()
     * @uses ServicePointMeterRead::setServicePointMeterReadTypeID()
     * @uses ServicePointMeterRead::setStartRegisterRead()
     * @uses ServicePointMeterRead::setEndRegisterRead()
     * @uses ServicePointMeterRead::setBillID()
     * @uses ServicePointMeterRead::setReadDateDisplay()
     * @uses ServicePointMeterRead::setAccountServicePoint()
     * @uses ServicePointMeterRead::setReadTypeName()
     * @uses ServicePointMeterRead::setVolumetricChargeCodes()
     * @uses ServicePointMeterRead::setMeterReads()
     * @param int $servicePointMeterReadID
     * @param int $servicePointMeterID
     * @param float $consumption
     * @param string $readDate
     * @param int $accountID
     * @param float $averagekWhRate
     * @param float $averageConsumption
     * @param float $consumptionDollars
     * @param string $readDateFrom
     * @param string $readDateTo
     * @param bool $posted
     * @param int $meterReadID
     * @param int $servicePointMeterReadTypeID
     * @param float $startRegisterRead
     * @param float $endRegisterRead
     * @param int $billID
     * @param string $readDateDisplay
     * @param \SGCIS\Struct\AccountServicePoint $accountServicePoint
     * @param string $readTypeName
     * @param string $volumetricChargeCodes
     * @param \SGCIS\Array\ArrayOfServicePointMeterReadDetail $meterReads
     */
    public function __construct($servicePointMeterReadID = null, $servicePointMeterID = null, $consumption = null, $readDate = null, $accountID = null, $averagekWhRate = null, $averageConsumption = null, $consumptionDollars = null, $readDateFrom = null, $readDateTo = null, $posted = null, $meterReadID = null, $servicePointMeterReadTypeID = null, $startRegisterRead = null, $endRegisterRead = null, $billID = null, $readDateDisplay = null, \SGCIS\Struct\AccountServicePoint $accountServicePoint = null, $readTypeName = null, $volumetricChargeCodes = null, \SGCIS\Array\ArrayOfServicePointMeterReadDetail $meterReads = null)
    {
        $this
            ->setServicePointMeterReadID($servicePointMeterReadID)
            ->setServicePointMeterID($servicePointMeterID)
            ->setConsumption($consumption)
            ->setReadDate($readDate)
            ->setAccountID($accountID)
            ->setAveragekWhRate($averagekWhRate)
            ->setAverageConsumption($averageConsumption)
            ->setConsumptionDollars($consumptionDollars)
            ->setReadDateFrom($readDateFrom)
            ->setReadDateTo($readDateTo)
            ->setPosted($posted)
            ->setMeterReadID($meterReadID)
            ->setServicePointMeterReadTypeID($servicePointMeterReadTypeID)
            ->setStartRegisterRead($startRegisterRead)
            ->setEndRegisterRead($endRegisterRead)
            ->setBillID($billID)
            ->setReadDateDisplay($readDateDisplay)
            ->setAccountServicePoint($accountServicePoint)
            ->setReadTypeName($readTypeName)
            ->setVolumetricChargeCodes($volumetricChargeCodes)
            ->setMeterReads($meterReads);
    }
    /**
     * Get ServicePointMeterReadID value
     * @return int
     */
    public function getServicePointMeterReadID()
    {
        return $this->ServicePointMeterReadID;
    }
    /**
     * Set ServicePointMeterReadID value
     * @param int $servicePointMeterReadID
     * @return \SGCIS\Struct\ServicePointMeterRead
     */
    public function setServicePointMeterReadID($servicePointMeterReadID = null)
    {
        // validation for constraint: int
        if (!is_null($servicePointMeterReadID) && !is_numeric($servicePointMeterReadID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($servicePointMeterReadID)), __LINE__);
        }
        $this->ServicePointMeterReadID = $servicePointMeterReadID;
        return $this;
    }
    /**
     * Get ServicePointMeterID value
     * @return int
     */
    public function getServicePointMeterID()
    {
        return $this->ServicePointMeterID;
    }
    /**
     * Set ServicePointMeterID value
     * @param int $servicePointMeterID
     * @return \SGCIS\Struct\ServicePointMeterRead
     */
    public function setServicePointMeterID($servicePointMeterID = null)
    {
        // validation for constraint: int
        if (!is_null($servicePointMeterID) && !is_numeric($servicePointMeterID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($servicePointMeterID)), __LINE__);
        }
        $this->ServicePointMeterID = $servicePointMeterID;
        return $this;
    }
    /**
     * Get Consumption value
     * @return float
     */
    public function getConsumption()
    {
        return $this->Consumption;
    }
    /**
     * Set Consumption value
     * @param float $consumption
     * @return \SGCIS\Struct\ServicePointMeterRead
     */
    public function setConsumption($consumption = null)
    {
        $this->Consumption = $consumption;
        return $this;
    }
    /**
     * Get ReadDate value
     * @return string
     */
    public function getReadDate()
    {
        return $this->ReadDate;
    }
    /**
     * Set ReadDate value
     * @param string $readDate
     * @return \SGCIS\Struct\ServicePointMeterRead
     */
    public function setReadDate($readDate = null)
    {
        // validation for constraint: string
        if (!is_null($readDate) && !is_string($readDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($readDate)), __LINE__);
        }
        $this->ReadDate = $readDate;
        return $this;
    }
    /**
     * Get AccountID value
     * @return int
     */
    public function getAccountID()
    {
        return $this->AccountID;
    }
    /**
     * Set AccountID value
     * @param int $accountID
     * @return \SGCIS\Struct\ServicePointMeterRead
     */
    public function setAccountID($accountID = null)
    {
        // validation for constraint: int
        if (!is_null($accountID) && !is_numeric($accountID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountID)), __LINE__);
        }
        $this->AccountID = $accountID;
        return $this;
    }
    /**
     * Get AveragekWhRate value
     * @return float
     */
    public function getAveragekWhRate()
    {
        return $this->AveragekWhRate;
    }
    /**
     * Set AveragekWhRate value
     * @param float $averagekWhRate
     * @return \SGCIS\Struct\ServicePointMeterRead
     */
    public function setAveragekWhRate($averagekWhRate = null)
    {
        $this->AveragekWhRate = $averagekWhRate;
        return $this;
    }
    /**
     * Get AverageConsumption value
     * @return float
     */
    public function getAverageConsumption()
    {
        return $this->AverageConsumption;
    }
    /**
     * Set AverageConsumption value
     * @param float $averageConsumption
     * @return \SGCIS\Struct\ServicePointMeterRead
     */
    public function setAverageConsumption($averageConsumption = null)
    {
        $this->AverageConsumption = $averageConsumption;
        return $this;
    }
    /**
     * Get ConsumptionDollars value
     * @return float
     */
    public function getConsumptionDollars()
    {
        return $this->ConsumptionDollars;
    }
    /**
     * Set ConsumptionDollars value
     * @param float $consumptionDollars
     * @return \SGCIS\Struct\ServicePointMeterRead
     */
    public function setConsumptionDollars($consumptionDollars = null)
    {
        $this->ConsumptionDollars = $consumptionDollars;
        return $this;
    }
    /**
     * Get ReadDateFrom value
     * @return string
     */
    public function getReadDateFrom()
    {
        return $this->ReadDateFrom;
    }
    /**
     * Set ReadDateFrom value
     * @param string $readDateFrom
     * @return \SGCIS\Struct\ServicePointMeterRead
     */
    public function setReadDateFrom($readDateFrom = null)
    {
        // validation for constraint: string
        if (!is_null($readDateFrom) && !is_string($readDateFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($readDateFrom)), __LINE__);
        }
        $this->ReadDateFrom = $readDateFrom;
        return $this;
    }
    /**
     * Get ReadDateTo value
     * @return string
     */
    public function getReadDateTo()
    {
        return $this->ReadDateTo;
    }
    /**
     * Set ReadDateTo value
     * @param string $readDateTo
     * @return \SGCIS\Struct\ServicePointMeterRead
     */
    public function setReadDateTo($readDateTo = null)
    {
        // validation for constraint: string
        if (!is_null($readDateTo) && !is_string($readDateTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($readDateTo)), __LINE__);
        }
        $this->ReadDateTo = $readDateTo;
        return $this;
    }
    /**
     * Get Posted value
     * @return bool
     */
    public function getPosted()
    {
        return $this->Posted;
    }
    /**
     * Set Posted value
     * @param bool $posted
     * @return \SGCIS\Struct\ServicePointMeterRead
     */
    public function setPosted($posted = null)
    {
        // validation for constraint: boolean
        if (!is_null($posted) && !is_bool($posted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($posted)), __LINE__);
        }
        $this->Posted = $posted;
        return $this;
    }
    /**
     * Get MeterReadID value
     * @return int
     */
    public function getMeterReadID()
    {
        return $this->MeterReadID;
    }
    /**
     * Set MeterReadID value
     * @param int $meterReadID
     * @return \SGCIS\Struct\ServicePointMeterRead
     */
    public function setMeterReadID($meterReadID = null)
    {
        // validation for constraint: int
        if (!is_null($meterReadID) && !is_numeric($meterReadID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($meterReadID)), __LINE__);
        }
        $this->MeterReadID = $meterReadID;
        return $this;
    }
    /**
     * Get ServicePointMeterReadTypeID value
     * @return int
     */
    public function getServicePointMeterReadTypeID()
    {
        return $this->ServicePointMeterReadTypeID;
    }
    /**
     * Set ServicePointMeterReadTypeID value
     * @param int $servicePointMeterReadTypeID
     * @return \SGCIS\Struct\ServicePointMeterRead
     */
    public function setServicePointMeterReadTypeID($servicePointMeterReadTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($servicePointMeterReadTypeID) && !is_numeric($servicePointMeterReadTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($servicePointMeterReadTypeID)), __LINE__);
        }
        $this->ServicePointMeterReadTypeID = $servicePointMeterReadTypeID;
        return $this;
    }
    /**
     * Get StartRegisterRead value
     * @return float
     */
    public function getStartRegisterRead()
    {
        return $this->StartRegisterRead;
    }
    /**
     * Set StartRegisterRead value
     * @param float $startRegisterRead
     * @return \SGCIS\Struct\ServicePointMeterRead
     */
    public function setStartRegisterRead($startRegisterRead = null)
    {
        $this->StartRegisterRead = $startRegisterRead;
        return $this;
    }
    /**
     * Get EndRegisterRead value
     * @return float
     */
    public function getEndRegisterRead()
    {
        return $this->EndRegisterRead;
    }
    /**
     * Set EndRegisterRead value
     * @param float $endRegisterRead
     * @return \SGCIS\Struct\ServicePointMeterRead
     */
    public function setEndRegisterRead($endRegisterRead = null)
    {
        $this->EndRegisterRead = $endRegisterRead;
        return $this;
    }
    /**
     * Get BillID value
     * @return int
     */
    public function getBillID()
    {
        return $this->BillID;
    }
    /**
     * Set BillID value
     * @param int $billID
     * @return \SGCIS\Struct\ServicePointMeterRead
     */
    public function setBillID($billID = null)
    {
        // validation for constraint: int
        if (!is_null($billID) && !is_numeric($billID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($billID)), __LINE__);
        }
        $this->BillID = $billID;
        return $this;
    }
    /**
     * Get ReadDateDisplay value
     * @return string|null
     */
    public function getReadDateDisplay()
    {
        return $this->ReadDateDisplay;
    }
    /**
     * Set ReadDateDisplay value
     * @param string $readDateDisplay
     * @return \SGCIS\Struct\ServicePointMeterRead
     */
    public function setReadDateDisplay($readDateDisplay = null)
    {
        // validation for constraint: string
        if (!is_null($readDateDisplay) && !is_string($readDateDisplay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($readDateDisplay)), __LINE__);
        }
        $this->ReadDateDisplay = $readDateDisplay;
        return $this;
    }
    /**
     * Get AccountServicePoint value
     * @return \SGCIS\Struct\AccountServicePoint|null
     */
    public function getAccountServicePoint()
    {
        return $this->AccountServicePoint;
    }
    /**
     * Set AccountServicePoint value
     * @param \SGCIS\Struct\AccountServicePoint $accountServicePoint
     * @return \SGCIS\Struct\ServicePointMeterRead
     */
    public function setAccountServicePoint(\SGCIS\Struct\AccountServicePoint $accountServicePoint = null)
    {
        $this->AccountServicePoint = $accountServicePoint;
        return $this;
    }
    /**
     * Get ReadTypeName value
     * @return string|null
     */
    public function getReadTypeName()
    {
        return $this->ReadTypeName;
    }
    /**
     * Set ReadTypeName value
     * @param string $readTypeName
     * @return \SGCIS\Struct\ServicePointMeterRead
     */
    public function setReadTypeName($readTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($readTypeName) && !is_string($readTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($readTypeName)), __LINE__);
        }
        $this->ReadTypeName = $readTypeName;
        return $this;
    }
    /**
     * Get VolumetricChargeCodes value
     * @return string|null
     */
    public function getVolumetricChargeCodes()
    {
        return $this->VolumetricChargeCodes;
    }
    /**
     * Set VolumetricChargeCodes value
     * @param string $volumetricChargeCodes
     * @return \SGCIS\Struct\ServicePointMeterRead
     */
    public function setVolumetricChargeCodes($volumetricChargeCodes = null)
    {
        // validation for constraint: string
        if (!is_null($volumetricChargeCodes) && !is_string($volumetricChargeCodes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($volumetricChargeCodes)), __LINE__);
        }
        $this->VolumetricChargeCodes = $volumetricChargeCodes;
        return $this;
    }
    /**
     * Get MeterReads value
     * @return \SGCIS\Array\ArrayOfServicePointMeterReadDetail|null
     */
    public function getMeterReads()
    {
        return $this->MeterReads;
    }
    /**
     * Set MeterReads value
     * @param \SGCIS\Array\ArrayOfServicePointMeterReadDetail $meterReads
     * @return \SGCIS\Struct\ServicePointMeterRead
     */
    public function setMeterReads(\SGCIS\Array\ArrayOfServicePointMeterReadDetail $meterReads = null)
    {
        $this->MeterReads = $meterReads;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\ServicePointMeterRead
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
