<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServicePointMeter Struct
 * @subpackage Structs
 */
class ServicePointMeter extends AbstractStructBase
{
    /**
     * The ServicePointMeterID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ServicePointMeterID;
    /**
     * The ServicePointID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ServicePointID;
    /**
     * The MeterID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MeterID;
    /**
     * The MeterStatusID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MeterStatusID;
    /**
     * The DistributionPointID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DistributionPointID;
    /**
     * The InstallDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $InstallDate;
    /**
     * The RemoveDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $RemoveDate;
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Active;
    /**
     * The AccountServicePointID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountServicePointID;
    /**
     * The IsError
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsError;
    /**
     * The StartRegisterValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $StartRegisterValue;
    /**
     * The MeterTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MeterTypeID;
    /**
     * The AccountID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountID;
    /**
     * The ErrorMessage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorMessage;
    /**
     * The RemoveDateDisplay
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RemoveDateDisplay;
    /**
     * The InstallDateDisplay
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InstallDateDisplay;
    /**
     * The ServiceProviderIdentifier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceProviderIdentifier;
    /**
     * The DistributionServiceProviderName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DistributionServiceProviderName;
    /**
     * The MeterTypeName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MeterTypeName;
    /**
     * The MeterSerialNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MeterSerialNumber;
    /**
     * The MeterStatusName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MeterStatusName;
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address;
    /**
     * The City
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $City;
    /**
     * The State
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $State;
    /**
     * The Zip
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Zip;
    /**
     * The AccountNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountNumber;
    /**
     * The Meter
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\Meter
     */
    public $Meter;
    /**
     * Constructor method for ServicePointMeter
     * @uses ServicePointMeter::setServicePointMeterID()
     * @uses ServicePointMeter::setServicePointID()
     * @uses ServicePointMeter::setMeterID()
     * @uses ServicePointMeter::setMeterStatusID()
     * @uses ServicePointMeter::setDistributionPointID()
     * @uses ServicePointMeter::setInstallDate()
     * @uses ServicePointMeter::setRemoveDate()
     * @uses ServicePointMeter::setActive()
     * @uses ServicePointMeter::setAccountServicePointID()
     * @uses ServicePointMeter::setIsError()
     * @uses ServicePointMeter::setStartRegisterValue()
     * @uses ServicePointMeter::setMeterTypeID()
     * @uses ServicePointMeter::setAccountID()
     * @uses ServicePointMeter::setErrorMessage()
     * @uses ServicePointMeter::setRemoveDateDisplay()
     * @uses ServicePointMeter::setInstallDateDisplay()
     * @uses ServicePointMeter::setServiceProviderIdentifier()
     * @uses ServicePointMeter::setDistributionServiceProviderName()
     * @uses ServicePointMeter::setMeterTypeName()
     * @uses ServicePointMeter::setMeterSerialNumber()
     * @uses ServicePointMeter::setMeterStatusName()
     * @uses ServicePointMeter::setAddress()
     * @uses ServicePointMeter::setCity()
     * @uses ServicePointMeter::setState()
     * @uses ServicePointMeter::setZip()
     * @uses ServicePointMeter::setAccountNumber()
     * @uses ServicePointMeter::setMeter()
     * @param int $servicePointMeterID
     * @param int $servicePointID
     * @param int $meterID
     * @param int $meterStatusID
     * @param int $distributionPointID
     * @param string $installDate
     * @param string $removeDate
     * @param bool $active
     * @param int $accountServicePointID
     * @param bool $isError
     * @param float $startRegisterValue
     * @param int $meterTypeID
     * @param int $accountID
     * @param string $errorMessage
     * @param string $removeDateDisplay
     * @param string $installDateDisplay
     * @param string $serviceProviderIdentifier
     * @param string $distributionServiceProviderName
     * @param string $meterTypeName
     * @param string $meterSerialNumber
     * @param string $meterStatusName
     * @param string $address
     * @param string $city
     * @param string $state
     * @param string $zip
     * @param string $accountNumber
     * @param \SGCIS\Struct\Meter $meter
     */
    public function __construct($servicePointMeterID = null, $servicePointID = null, $meterID = null, $meterStatusID = null, $distributionPointID = null, $installDate = null, $removeDate = null, $active = null, $accountServicePointID = null, $isError = null, $startRegisterValue = null, $meterTypeID = null, $accountID = null, $errorMessage = null, $removeDateDisplay = null, $installDateDisplay = null, $serviceProviderIdentifier = null, $distributionServiceProviderName = null, $meterTypeName = null, $meterSerialNumber = null, $meterStatusName = null, $address = null, $city = null, $state = null, $zip = null, $accountNumber = null, \SGCIS\Struct\Meter $meter = null)
    {
        $this
            ->setServicePointMeterID($servicePointMeterID)
            ->setServicePointID($servicePointID)
            ->setMeterID($meterID)
            ->setMeterStatusID($meterStatusID)
            ->setDistributionPointID($distributionPointID)
            ->setInstallDate($installDate)
            ->setRemoveDate($removeDate)
            ->setActive($active)
            ->setAccountServicePointID($accountServicePointID)
            ->setIsError($isError)
            ->setStartRegisterValue($startRegisterValue)
            ->setMeterTypeID($meterTypeID)
            ->setAccountID($accountID)
            ->setErrorMessage($errorMessage)
            ->setRemoveDateDisplay($removeDateDisplay)
            ->setInstallDateDisplay($installDateDisplay)
            ->setServiceProviderIdentifier($serviceProviderIdentifier)
            ->setDistributionServiceProviderName($distributionServiceProviderName)
            ->setMeterTypeName($meterTypeName)
            ->setMeterSerialNumber($meterSerialNumber)
            ->setMeterStatusName($meterStatusName)
            ->setAddress($address)
            ->setCity($city)
            ->setState($state)
            ->setZip($zip)
            ->setAccountNumber($accountNumber)
            ->setMeter($meter);
    }
    /**
     * Get ServicePointMeterID value
     * @return int
     */
    public function getServicePointMeterID()
    {
        return $this->ServicePointMeterID;
    }
    /**
     * Set ServicePointMeterID value
     * @param int $servicePointMeterID
     * @return \SGCIS\Struct\ServicePointMeter
     */
    public function setServicePointMeterID($servicePointMeterID = null)
    {
        // validation for constraint: int
        if (!is_null($servicePointMeterID) && !is_numeric($servicePointMeterID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($servicePointMeterID)), __LINE__);
        }
        $this->ServicePointMeterID = $servicePointMeterID;
        return $this;
    }
    /**
     * Get ServicePointID value
     * @return int
     */
    public function getServicePointID()
    {
        return $this->ServicePointID;
    }
    /**
     * Set ServicePointID value
     * @param int $servicePointID
     * @return \SGCIS\Struct\ServicePointMeter
     */
    public function setServicePointID($servicePointID = null)
    {
        // validation for constraint: int
        if (!is_null($servicePointID) && !is_numeric($servicePointID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($servicePointID)), __LINE__);
        }
        $this->ServicePointID = $servicePointID;
        return $this;
    }
    /**
     * Get MeterID value
     * @return int
     */
    public function getMeterID()
    {
        return $this->MeterID;
    }
    /**
     * Set MeterID value
     * @param int $meterID
     * @return \SGCIS\Struct\ServicePointMeter
     */
    public function setMeterID($meterID = null)
    {
        // validation for constraint: int
        if (!is_null($meterID) && !is_numeric($meterID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($meterID)), __LINE__);
        }
        $this->MeterID = $meterID;
        return $this;
    }
    /**
     * Get MeterStatusID value
     * @return int
     */
    public function getMeterStatusID()
    {
        return $this->MeterStatusID;
    }
    /**
     * Set MeterStatusID value
     * @param int $meterStatusID
     * @return \SGCIS\Struct\ServicePointMeter
     */
    public function setMeterStatusID($meterStatusID = null)
    {
        // validation for constraint: int
        if (!is_null($meterStatusID) && !is_numeric($meterStatusID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($meterStatusID)), __LINE__);
        }
        $this->MeterStatusID = $meterStatusID;
        return $this;
    }
    /**
     * Get DistributionPointID value
     * @return int
     */
    public function getDistributionPointID()
    {
        return $this->DistributionPointID;
    }
    /**
     * Set DistributionPointID value
     * @param int $distributionPointID
     * @return \SGCIS\Struct\ServicePointMeter
     */
    public function setDistributionPointID($distributionPointID = null)
    {
        // validation for constraint: int
        if (!is_null($distributionPointID) && !is_numeric($distributionPointID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($distributionPointID)), __LINE__);
        }
        $this->DistributionPointID = $distributionPointID;
        return $this;
    }
    /**
     * Get InstallDate value
     * @return string
     */
    public function getInstallDate()
    {
        return $this->InstallDate;
    }
    /**
     * Set InstallDate value
     * @param string $installDate
     * @return \SGCIS\Struct\ServicePointMeter
     */
    public function setInstallDate($installDate = null)
    {
        // validation for constraint: string
        if (!is_null($installDate) && !is_string($installDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($installDate)), __LINE__);
        }
        $this->InstallDate = $installDate;
        return $this;
    }
    /**
     * Get RemoveDate value
     * @return string
     */
    public function getRemoveDate()
    {
        return $this->RemoveDate;
    }
    /**
     * Set RemoveDate value
     * @param string $removeDate
     * @return \SGCIS\Struct\ServicePointMeter
     */
    public function setRemoveDate($removeDate = null)
    {
        // validation for constraint: string
        if (!is_null($removeDate) && !is_string($removeDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($removeDate)), __LINE__);
        }
        $this->RemoveDate = $removeDate;
        return $this;
    }
    /**
     * Get Active value
     * @return bool
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \SGCIS\Struct\ServicePointMeter
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get AccountServicePointID value
     * @return int
     */
    public function getAccountServicePointID()
    {
        return $this->AccountServicePointID;
    }
    /**
     * Set AccountServicePointID value
     * @param int $accountServicePointID
     * @return \SGCIS\Struct\ServicePointMeter
     */
    public function setAccountServicePointID($accountServicePointID = null)
    {
        // validation for constraint: int
        if (!is_null($accountServicePointID) && !is_numeric($accountServicePointID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountServicePointID)), __LINE__);
        }
        $this->AccountServicePointID = $accountServicePointID;
        return $this;
    }
    /**
     * Get IsError value
     * @return bool
     */
    public function getIsError()
    {
        return $this->IsError;
    }
    /**
     * Set IsError value
     * @param bool $isError
     * @return \SGCIS\Struct\ServicePointMeter
     */
    public function setIsError($isError = null)
    {
        // validation for constraint: boolean
        if (!is_null($isError) && !is_bool($isError)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isError)), __LINE__);
        }
        $this->IsError = $isError;
        return $this;
    }
    /**
     * Get StartRegisterValue value
     * @return float
     */
    public function getStartRegisterValue()
    {
        return $this->StartRegisterValue;
    }
    /**
     * Set StartRegisterValue value
     * @param float $startRegisterValue
     * @return \SGCIS\Struct\ServicePointMeter
     */
    public function setStartRegisterValue($startRegisterValue = null)
    {
        $this->StartRegisterValue = $startRegisterValue;
        return $this;
    }
    /**
     * Get MeterTypeID value
     * @return int
     */
    public function getMeterTypeID()
    {
        return $this->MeterTypeID;
    }
    /**
     * Set MeterTypeID value
     * @param int $meterTypeID
     * @return \SGCIS\Struct\ServicePointMeter
     */
    public function setMeterTypeID($meterTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($meterTypeID) && !is_numeric($meterTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($meterTypeID)), __LINE__);
        }
        $this->MeterTypeID = $meterTypeID;
        return $this;
    }
    /**
     * Get AccountID value
     * @return int
     */
    public function getAccountID()
    {
        return $this->AccountID;
    }
    /**
     * Set AccountID value
     * @param int $accountID
     * @return \SGCIS\Struct\ServicePointMeter
     */
    public function setAccountID($accountID = null)
    {
        // validation for constraint: int
        if (!is_null($accountID) && !is_numeric($accountID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountID)), __LINE__);
        }
        $this->AccountID = $accountID;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param string $errorMessage
     * @return \SGCIS\Struct\ServicePointMeter
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($errorMessage)), __LINE__);
        }
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
    /**
     * Get RemoveDateDisplay value
     * @return string|null
     */
    public function getRemoveDateDisplay()
    {
        return $this->RemoveDateDisplay;
    }
    /**
     * Set RemoveDateDisplay value
     * @param string $removeDateDisplay
     * @return \SGCIS\Struct\ServicePointMeter
     */
    public function setRemoveDateDisplay($removeDateDisplay = null)
    {
        // validation for constraint: string
        if (!is_null($removeDateDisplay) && !is_string($removeDateDisplay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($removeDateDisplay)), __LINE__);
        }
        $this->RemoveDateDisplay = $removeDateDisplay;
        return $this;
    }
    /**
     * Get InstallDateDisplay value
     * @return string|null
     */
    public function getInstallDateDisplay()
    {
        return $this->InstallDateDisplay;
    }
    /**
     * Set InstallDateDisplay value
     * @param string $installDateDisplay
     * @return \SGCIS\Struct\ServicePointMeter
     */
    public function setInstallDateDisplay($installDateDisplay = null)
    {
        // validation for constraint: string
        if (!is_null($installDateDisplay) && !is_string($installDateDisplay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($installDateDisplay)), __LINE__);
        }
        $this->InstallDateDisplay = $installDateDisplay;
        return $this;
    }
    /**
     * Get ServiceProviderIdentifier value
     * @return string|null
     */
    public function getServiceProviderIdentifier()
    {
        return $this->ServiceProviderIdentifier;
    }
    /**
     * Set ServiceProviderIdentifier value
     * @param string $serviceProviderIdentifier
     * @return \SGCIS\Struct\ServicePointMeter
     */
    public function setServiceProviderIdentifier($serviceProviderIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($serviceProviderIdentifier) && !is_string($serviceProviderIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceProviderIdentifier)), __LINE__);
        }
        $this->ServiceProviderIdentifier = $serviceProviderIdentifier;
        return $this;
    }
    /**
     * Get DistributionServiceProviderName value
     * @return string|null
     */
    public function getDistributionServiceProviderName()
    {
        return $this->DistributionServiceProviderName;
    }
    /**
     * Set DistributionServiceProviderName value
     * @param string $distributionServiceProviderName
     * @return \SGCIS\Struct\ServicePointMeter
     */
    public function setDistributionServiceProviderName($distributionServiceProviderName = null)
    {
        // validation for constraint: string
        if (!is_null($distributionServiceProviderName) && !is_string($distributionServiceProviderName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($distributionServiceProviderName)), __LINE__);
        }
        $this->DistributionServiceProviderName = $distributionServiceProviderName;
        return $this;
    }
    /**
     * Get MeterTypeName value
     * @return string|null
     */
    public function getMeterTypeName()
    {
        return $this->MeterTypeName;
    }
    /**
     * Set MeterTypeName value
     * @param string $meterTypeName
     * @return \SGCIS\Struct\ServicePointMeter
     */
    public function setMeterTypeName($meterTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($meterTypeName) && !is_string($meterTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($meterTypeName)), __LINE__);
        }
        $this->MeterTypeName = $meterTypeName;
        return $this;
    }
    /**
     * Get MeterSerialNumber value
     * @return string|null
     */
    public function getMeterSerialNumber()
    {
        return $this->MeterSerialNumber;
    }
    /**
     * Set MeterSerialNumber value
     * @param string $meterSerialNumber
     * @return \SGCIS\Struct\ServicePointMeter
     */
    public function setMeterSerialNumber($meterSerialNumber = null)
    {
        // validation for constraint: string
        if (!is_null($meterSerialNumber) && !is_string($meterSerialNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($meterSerialNumber)), __LINE__);
        }
        $this->MeterSerialNumber = $meterSerialNumber;
        return $this;
    }
    /**
     * Get MeterStatusName value
     * @return string|null
     */
    public function getMeterStatusName()
    {
        return $this->MeterStatusName;
    }
    /**
     * Set MeterStatusName value
     * @param string $meterStatusName
     * @return \SGCIS\Struct\ServicePointMeter
     */
    public function setMeterStatusName($meterStatusName = null)
    {
        // validation for constraint: string
        if (!is_null($meterStatusName) && !is_string($meterStatusName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($meterStatusName)), __LINE__);
        }
        $this->MeterStatusName = $meterStatusName;
        return $this;
    }
    /**
     * Get Address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param string $address
     * @return \SGCIS\Struct\ServicePointMeter
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address)), __LINE__);
        }
        $this->Address = $address;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \SGCIS\Struct\ServicePointMeter
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get State value
     * @return string|null
     */
    public function getState()
    {
        return $this->State;
    }
    /**
     * Set State value
     * @param string $state
     * @return \SGCIS\Struct\ServicePointMeter
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($state)), __LINE__);
        }
        $this->State = $state;
        return $this;
    }
    /**
     * Get Zip value
     * @return string|null
     */
    public function getZip()
    {
        return $this->Zip;
    }
    /**
     * Set Zip value
     * @param string $zip
     * @return \SGCIS\Struct\ServicePointMeter
     */
    public function setZip($zip = null)
    {
        // validation for constraint: string
        if (!is_null($zip) && !is_string($zip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zip)), __LINE__);
        }
        $this->Zip = $zip;
        return $this;
    }
    /**
     * Get AccountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->AccountNumber;
    }
    /**
     * Set AccountNumber value
     * @param string $accountNumber
     * @return \SGCIS\Struct\ServicePointMeter
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountNumber)), __LINE__);
        }
        $this->AccountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get Meter value
     * @return \SGCIS\Struct\Meter|null
     */
    public function getMeter()
    {
        return $this->Meter;
    }
    /**
     * Set Meter value
     * @param \SGCIS\Struct\Meter $meter
     * @return \SGCIS\Struct\ServicePointMeter
     */
    public function setMeter(\SGCIS\Struct\Meter $meter = null)
    {
        $this->Meter = $meter;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\ServicePointMeter
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
