<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServicePoint Struct
 * @subpackage Structs
 */
class ServicePoint extends BaseDTO
{
    /**
     * The ServicePointID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ServicePointID;
    /**
     * The IsError
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsError;
    /**
     * The CountyID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CountyID;
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Active;
    /**
     * The MarketPricingNodeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MarketPricingNodeID;
    /**
     * The Longitude
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Longitude;
    /**
     * The Latitude
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Latitude;
    /**
     * The AccountServicePointID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountServicePointID;
    /**
     * The IsEnergyAssistance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsEnergyAssistance;
    /**
     * The CommunityID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CommunityID;
    /**
     * The ServicePointStatusID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ServicePointStatusID;
    /**
     * The PremiseTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PremiseTypeID;
    /**
     * The AccountID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountID;
    /**
     * The MeterStatusID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MeterStatusID;
    /**
     * The DistributionServiceProviderID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DistributionServiceProviderID;
    /**
     * The IsWeatherMoratorium
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsWeatherMoratorium;
    /**
     * The IsSwitchHoldBillPay
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsSwitchHoldBillPay;
    /**
     * The IsSwitchHoldTampering
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsSwitchHoldTampering;
    /**
     * The IsTransfer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsTransfer;
    /**
     * The TransferredFrom
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TransferredFrom;
    /**
     * The TransferredTo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TransferredTo;
    /**
     * The IsAreaOutage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsAreaOutage;
    /**
     * The ProductID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ProductID;
    /**
     * The CurrentRatekWh
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $CurrentRatekWh;
    /**
     * The DailyBurnRate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $DailyBurnRate;
    /**
     * The IsCriticalCare
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsCriticalCare;
    /**
     * The Address1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address1;
    /**
     * The Address2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address2;
    /**
     * The City
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $City;
    /**
     * The StateCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StateCode;
    /**
     * The ZipCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ZipCode;
    /**
     * The ZipPlus4
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ZipPlus4;
    /**
     * The TaxGeocode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TaxGeocode;
    /**
     * The HostSystemID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HostSystemID;
    /**
     * The MarketPricingNodeName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MarketPricingNodeName;
    /**
     * The GeoCodeLevel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GeoCodeLevel;
    /**
     * The GeoCodeLevelDesc
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GeoCodeLevelDesc;
    /**
     * The AreaCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AreaCode;
    /**
     * The CityType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CityType;
    /**
     * The TaxingCityName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TaxingCityName;
    /**
     * The MSA
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MSA;
    /**
     * The CBSA
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CBSA;
    /**
     * The MetroArea
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MetroArea;
    /**
     * The AreaHouseholdIncome
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AreaHouseholdIncome;
    /**
     * The CountyHouseholdIncome
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CountyHouseholdIncome;
    /**
     * The CongressCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CongressCode;
    /**
     * The LoadProfile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LoadProfile;
    /**
     * The CommunityName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CommunityName;
    /**
     * The DwellingType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DwellingType;
    /**
     * The DwellingUnits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DwellingUnits;
    /**
     * The ServicePointStatusName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServicePointStatusName;
    /**
     * The AccountNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountNumber;
    /**
     * The ServiceProviderIdentifier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceProviderIdentifier;
    /**
     * The StateName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StateName;
    /**
     * The CountyName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CountyName;
    /**
     * The MeterStatusName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MeterStatusName;
    /**
     * The DistributionServiceProviderName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DistributionServiceProviderName;
    /**
     * The ServicePointMeter
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\ServicePointMeter
     */
    public $ServicePointMeter;
    /**
     * The ProductName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProductName;
    /**
     * The BlockNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BlockNumber;
    /**
     * The LotNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LotNumber;
    /**
     * The RouteNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RouteNumber;
    /**
     * The MonthlyBillingCycle
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MonthlyBillingCycle;
    /**
     * The TimeZoneCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TimeZoneCode;
    /**
     * The MeterList
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfServicePointMeter
     */
    public $MeterList;
    /**
     * The AccountList
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfAccountServicePoint
     */
    public $AccountList;
    /**
     * The ServicePointMeterGroupList
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfServicePointMeterGroup
     */
    public $ServicePointMeterGroupList;
    /**
     * Constructor method for ServicePoint
     * @uses ServicePoint::setServicePointID()
     * @uses ServicePoint::setIsError()
     * @uses ServicePoint::setCountyID()
     * @uses ServicePoint::setActive()
     * @uses ServicePoint::setMarketPricingNodeID()
     * @uses ServicePoint::setLongitude()
     * @uses ServicePoint::setLatitude()
     * @uses ServicePoint::setAccountServicePointID()
     * @uses ServicePoint::setIsEnergyAssistance()
     * @uses ServicePoint::setCommunityID()
     * @uses ServicePoint::setServicePointStatusID()
     * @uses ServicePoint::setPremiseTypeID()
     * @uses ServicePoint::setAccountID()
     * @uses ServicePoint::setMeterStatusID()
     * @uses ServicePoint::setDistributionServiceProviderID()
     * @uses ServicePoint::setIsWeatherMoratorium()
     * @uses ServicePoint::setIsSwitchHoldBillPay()
     * @uses ServicePoint::setIsSwitchHoldTampering()
     * @uses ServicePoint::setIsTransfer()
     * @uses ServicePoint::setTransferredFrom()
     * @uses ServicePoint::setTransferredTo()
     * @uses ServicePoint::setIsAreaOutage()
     * @uses ServicePoint::setProductID()
     * @uses ServicePoint::setCurrentRatekWh()
     * @uses ServicePoint::setDailyBurnRate()
     * @uses ServicePoint::setIsCriticalCare()
     * @uses ServicePoint::setAddress1()
     * @uses ServicePoint::setAddress2()
     * @uses ServicePoint::setCity()
     * @uses ServicePoint::setStateCode()
     * @uses ServicePoint::setZipCode()
     * @uses ServicePoint::setZipPlus4()
     * @uses ServicePoint::setTaxGeocode()
     * @uses ServicePoint::setHostSystemID()
     * @uses ServicePoint::setMarketPricingNodeName()
     * @uses ServicePoint::setGeoCodeLevel()
     * @uses ServicePoint::setGeoCodeLevelDesc()
     * @uses ServicePoint::setAreaCode()
     * @uses ServicePoint::setCityType()
     * @uses ServicePoint::setTaxingCityName()
     * @uses ServicePoint::setMSA()
     * @uses ServicePoint::setCBSA()
     * @uses ServicePoint::setMetroArea()
     * @uses ServicePoint::setAreaHouseholdIncome()
     * @uses ServicePoint::setCountyHouseholdIncome()
     * @uses ServicePoint::setCongressCode()
     * @uses ServicePoint::setLoadProfile()
     * @uses ServicePoint::setCommunityName()
     * @uses ServicePoint::setDwellingType()
     * @uses ServicePoint::setDwellingUnits()
     * @uses ServicePoint::setServicePointStatusName()
     * @uses ServicePoint::setAccountNumber()
     * @uses ServicePoint::setServiceProviderIdentifier()
     * @uses ServicePoint::setStateName()
     * @uses ServicePoint::setCountyName()
     * @uses ServicePoint::setMeterStatusName()
     * @uses ServicePoint::setDistributionServiceProviderName()
     * @uses ServicePoint::setServicePointMeter()
     * @uses ServicePoint::setProductName()
     * @uses ServicePoint::setBlockNumber()
     * @uses ServicePoint::setLotNumber()
     * @uses ServicePoint::setRouteNumber()
     * @uses ServicePoint::setMonthlyBillingCycle()
     * @uses ServicePoint::setTimeZoneCode()
     * @uses ServicePoint::setMeterList()
     * @uses ServicePoint::setAccountList()
     * @uses ServicePoint::setServicePointMeterGroupList()
     * @param int $servicePointID
     * @param bool $isError
     * @param int $countyID
     * @param bool $active
     * @param int $marketPricingNodeID
     * @param float $longitude
     * @param float $latitude
     * @param int $accountServicePointID
     * @param bool $isEnergyAssistance
     * @param int $communityID
     * @param int $servicePointStatusID
     * @param int $premiseTypeID
     * @param int $accountID
     * @param int $meterStatusID
     * @param int $distributionServiceProviderID
     * @param bool $isWeatherMoratorium
     * @param bool $isSwitchHoldBillPay
     * @param bool $isSwitchHoldTampering
     * @param bool $isTransfer
     * @param int $transferredFrom
     * @param int $transferredTo
     * @param bool $isAreaOutage
     * @param int $productID
     * @param float $currentRatekWh
     * @param float $dailyBurnRate
     * @param bool $isCriticalCare
     * @param string $address1
     * @param string $address2
     * @param string $city
     * @param string $stateCode
     * @param string $zipCode
     * @param string $zipPlus4
     * @param string $taxGeocode
     * @param string $hostSystemID
     * @param string $marketPricingNodeName
     * @param string $geoCodeLevel
     * @param string $geoCodeLevelDesc
     * @param string $areaCode
     * @param string $cityType
     * @param string $taxingCityName
     * @param string $mSA
     * @param string $cBSA
     * @param string $metroArea
     * @param string $areaHouseholdIncome
     * @param string $countyHouseholdIncome
     * @param string $congressCode
     * @param string $loadProfile
     * @param string $communityName
     * @param string $dwellingType
     * @param string $dwellingUnits
     * @param string $servicePointStatusName
     * @param string $accountNumber
     * @param string $serviceProviderIdentifier
     * @param string $stateName
     * @param string $countyName
     * @param string $meterStatusName
     * @param string $distributionServiceProviderName
     * @param \SGCIS\Struct\ServicePointMeter $servicePointMeter
     * @param string $productName
     * @param string $blockNumber
     * @param string $lotNumber
     * @param string $routeNumber
     * @param string $monthlyBillingCycle
     * @param string $timeZoneCode
     * @param \SGCIS\Array\ArrayOfServicePointMeter $meterList
     * @param \SGCIS\Array\ArrayOfAccountServicePoint $accountList
     * @param \SGCIS\Array\ArrayOfServicePointMeterGroup $servicePointMeterGroupList
     */
    public function __construct($servicePointID = null, $isError = null, $countyID = null, $active = null, $marketPricingNodeID = null, $longitude = null, $latitude = null, $accountServicePointID = null, $isEnergyAssistance = null, $communityID = null, $servicePointStatusID = null, $premiseTypeID = null, $accountID = null, $meterStatusID = null, $distributionServiceProviderID = null, $isWeatherMoratorium = null, $isSwitchHoldBillPay = null, $isSwitchHoldTampering = null, $isTransfer = null, $transferredFrom = null, $transferredTo = null, $isAreaOutage = null, $productID = null, $currentRatekWh = null, $dailyBurnRate = null, $isCriticalCare = null, $address1 = null, $address2 = null, $city = null, $stateCode = null, $zipCode = null, $zipPlus4 = null, $taxGeocode = null, $hostSystemID = null, $marketPricingNodeName = null, $geoCodeLevel = null, $geoCodeLevelDesc = null, $areaCode = null, $cityType = null, $taxingCityName = null, $mSA = null, $cBSA = null, $metroArea = null, $areaHouseholdIncome = null, $countyHouseholdIncome = null, $congressCode = null, $loadProfile = null, $communityName = null, $dwellingType = null, $dwellingUnits = null, $servicePointStatusName = null, $accountNumber = null, $serviceProviderIdentifier = null, $stateName = null, $countyName = null, $meterStatusName = null, $distributionServiceProviderName = null, \SGCIS\Struct\ServicePointMeter $servicePointMeter = null, $productName = null, $blockNumber = null, $lotNumber = null, $routeNumber = null, $monthlyBillingCycle = null, $timeZoneCode = null, \SGCIS\Array\ArrayOfServicePointMeter $meterList = null, \SGCIS\Array\ArrayOfAccountServicePoint $accountList = null, \SGCIS\Array\ArrayOfServicePointMeterGroup $servicePointMeterGroupList = null)
    {
        $this
            ->setServicePointID($servicePointID)
            ->setIsError($isError)
            ->setCountyID($countyID)
            ->setActive($active)
            ->setMarketPricingNodeID($marketPricingNodeID)
            ->setLongitude($longitude)
            ->setLatitude($latitude)
            ->setAccountServicePointID($accountServicePointID)
            ->setIsEnergyAssistance($isEnergyAssistance)
            ->setCommunityID($communityID)
            ->setServicePointStatusID($servicePointStatusID)
            ->setPremiseTypeID($premiseTypeID)
            ->setAccountID($accountID)
            ->setMeterStatusID($meterStatusID)
            ->setDistributionServiceProviderID($distributionServiceProviderID)
            ->setIsWeatherMoratorium($isWeatherMoratorium)
            ->setIsSwitchHoldBillPay($isSwitchHoldBillPay)
            ->setIsSwitchHoldTampering($isSwitchHoldTampering)
            ->setIsTransfer($isTransfer)
            ->setTransferredFrom($transferredFrom)
            ->setTransferredTo($transferredTo)
            ->setIsAreaOutage($isAreaOutage)
            ->setProductID($productID)
            ->setCurrentRatekWh($currentRatekWh)
            ->setDailyBurnRate($dailyBurnRate)
            ->setIsCriticalCare($isCriticalCare)
            ->setAddress1($address1)
            ->setAddress2($address2)
            ->setCity($city)
            ->setStateCode($stateCode)
            ->setZipCode($zipCode)
            ->setZipPlus4($zipPlus4)
            ->setTaxGeocode($taxGeocode)
            ->setHostSystemID($hostSystemID)
            ->setMarketPricingNodeName($marketPricingNodeName)
            ->setGeoCodeLevel($geoCodeLevel)
            ->setGeoCodeLevelDesc($geoCodeLevelDesc)
            ->setAreaCode($areaCode)
            ->setCityType($cityType)
            ->setTaxingCityName($taxingCityName)
            ->setMSA($mSA)
            ->setCBSA($cBSA)
            ->setMetroArea($metroArea)
            ->setAreaHouseholdIncome($areaHouseholdIncome)
            ->setCountyHouseholdIncome($countyHouseholdIncome)
            ->setCongressCode($congressCode)
            ->setLoadProfile($loadProfile)
            ->setCommunityName($communityName)
            ->setDwellingType($dwellingType)
            ->setDwellingUnits($dwellingUnits)
            ->setServicePointStatusName($servicePointStatusName)
            ->setAccountNumber($accountNumber)
            ->setServiceProviderIdentifier($serviceProviderIdentifier)
            ->setStateName($stateName)
            ->setCountyName($countyName)
            ->setMeterStatusName($meterStatusName)
            ->setDistributionServiceProviderName($distributionServiceProviderName)
            ->setServicePointMeter($servicePointMeter)
            ->setProductName($productName)
            ->setBlockNumber($blockNumber)
            ->setLotNumber($lotNumber)
            ->setRouteNumber($routeNumber)
            ->setMonthlyBillingCycle($monthlyBillingCycle)
            ->setTimeZoneCode($timeZoneCode)
            ->setMeterList($meterList)
            ->setAccountList($accountList)
            ->setServicePointMeterGroupList($servicePointMeterGroupList);
    }
    /**
     * Get ServicePointID value
     * @return int
     */
    public function getServicePointID()
    {
        return $this->ServicePointID;
    }
    /**
     * Set ServicePointID value
     * @param int $servicePointID
     * @return \SGCIS\Struct\ServicePoint
     */
    public function setServicePointID($servicePointID = null)
    {
        // validation for constraint: int
        if (!is_null($servicePointID) && !is_numeric($servicePointID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($servicePointID)), __LINE__);
        }
        $this->ServicePointID = $servicePointID;
        return $this;
    }
    /**
     * Get IsError value
     * @return bool
     */
    public function getIsError()
    {
        return $this->IsError;
    }
    /**
     * Set IsError value
     * @param bool $isError
     * @return \SGCIS\Struct\ServicePoint
     */
    public function setIsError($isError = null)
    {
        // validation for constraint: boolean
        if (!is_null($isError) && !is_bool($isError)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isError)), __LINE__);
        }
        $this->IsError = $isError;
        return $this;
    }
    /**
     * Get CountyID value
     * @return int
     */
    public function getCountyID()
    {
        return $this->CountyID;
    }
    /**
     * Set CountyID value
     * @param int $countyID
     * @return \SGCIS\Struct\ServicePoint
     */
    public function setCountyID($countyID = null)
    {
        // validation for constraint: int
        if (!is_null($countyID) && !is_numeric($countyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($countyID)), __LINE__);
        }
        $this->CountyID = $countyID;
        return $this;
    }
    /**
     * Get Active value
     * @return bool
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \SGCIS\Struct\ServicePoint
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get MarketPricingNodeID value
     * @return int
     */
    public function getMarketPricingNodeID()
    {
        return $this->MarketPricingNodeID;
    }
    /**
     * Set MarketPricingNodeID value
     * @param int $marketPricingNodeID
     * @return \SGCIS\Struct\ServicePoint
     */
    public function setMarketPricingNodeID($marketPricingNodeID = null)
    {
        // validation for constraint: int
        if (!is_null($marketPricingNodeID) && !is_numeric($marketPricingNodeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($marketPricingNodeID)), __LINE__);
        }
        $this->MarketPricingNodeID = $marketPricingNodeID;
        return $this;
    }
    /**
     * Get Longitude value
     * @return float
     */
    public function getLongitude()
    {
        return $this->Longitude;
    }
    /**
     * Set Longitude value
     * @param float $longitude
     * @return \SGCIS\Struct\ServicePoint
     */
    public function setLongitude($longitude = null)
    {
        $this->Longitude = $longitude;
        return $this;
    }
    /**
     * Get Latitude value
     * @return float
     */
    public function getLatitude()
    {
        return $this->Latitude;
    }
    /**
     * Set Latitude value
     * @param float $latitude
     * @return \SGCIS\Struct\ServicePoint
     */
    public function setLatitude($latitude = null)
    {
        $this->Latitude = $latitude;
        return $this;
    }
    /**
     * Get AccountServicePointID value
     * @return int
     */
    public function getAccountServicePointID()
    {
        return $this->AccountServicePointID;
    }
    /**
     * Set AccountServicePointID value
     * @param int $accountServicePointID
     * @return \SGCIS\Struct\ServicePoint
     */
    public function setAccountServicePointID($accountServicePointID = null)
    {
        // validation for constraint: int
        if (!is_null($accountServicePointID) && !is_numeric($accountServicePointID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountServicePointID)), __LINE__);
        }
        $this->AccountServicePointID = $accountServicePointID;
        return $this;
    }
    /**
     * Get IsEnergyAssistance value
     * @return bool
     */
    public function getIsEnergyAssistance()
    {
        return $this->IsEnergyAssistance;
    }
    /**
     * Set IsEnergyAssistance value
     * @param bool $isEnergyAssistance
     * @return \SGCIS\Struct\ServicePoint
     */
    public function setIsEnergyAssistance($isEnergyAssistance = null)
    {
        // validation for constraint: boolean
        if (!is_null($isEnergyAssistance) && !is_bool($isEnergyAssistance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isEnergyAssistance)), __LINE__);
        }
        $this->IsEnergyAssistance = $isEnergyAssistance;
        return $this;
    }
    /**
     * Get CommunityID value
     * @return int
     */
    public function getCommunityID()
    {
        return $this->CommunityID;
    }
    /**
     * Set CommunityID value
     * @param int $communityID
     * @return \SGCIS\Struct\ServicePoint
     */
    public function setCommunityID($communityID = null)
    {
        // validation for constraint: int
        if (!is_null($communityID) && !is_numeric($communityID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($communityID)), __LINE__);
        }
        $this->CommunityID = $communityID;
        return $this;
    }
    /**
     * Get ServicePointStatusID value
     * @return int
     */
    public function getServicePointStatusID()
    {
        return $this->ServicePointStatusID;
    }
    /**
     * Set ServicePointStatusID value
     * @param int $servicePointStatusID
     * @return \SGCIS\Struct\ServicePoint
     */
    public function setServicePointStatusID($servicePointStatusID = null)
    {
        // validation for constraint: int
        if (!is_null($servicePointStatusID) && !is_numeric($servicePointStatusID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($servicePointStatusID)), __LINE__);
        }
        $this->ServicePointStatusID = $servicePointStatusID;
        return $this;
    }
    /**
     * Get PremiseTypeID value
     * @return int
     */
    public function getPremiseTypeID()
    {
        return $this->PremiseTypeID;
    }
    /**
     * Set PremiseTypeID value
     * @param int $premiseTypeID
     * @return \SGCIS\Struct\ServicePoint
     */
    public function setPremiseTypeID($premiseTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($premiseTypeID) && !is_numeric($premiseTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($premiseTypeID)), __LINE__);
        }
        $this->PremiseTypeID = $premiseTypeID;
        return $this;
    }
    /**
     * Get AccountID value
     * @return int
     */
    public function getAccountID()
    {
        return $this->AccountID;
    }
    /**
     * Set AccountID value
     * @param int $accountID
     * @return \SGCIS\Struct\ServicePoint
     */
    public function setAccountID($accountID = null)
    {
        // validation for constraint: int
        if (!is_null($accountID) && !is_numeric($accountID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountID)), __LINE__);
        }
        $this->AccountID = $accountID;
        return $this;
    }
    /**
     * Get MeterStatusID value
     * @return int
     */
    public function getMeterStatusID()
    {
        return $this->MeterStatusID;
    }
    /**
     * Set MeterStatusID value
     * @param int $meterStatusID
     * @return \SGCIS\Struct\ServicePoint
     */
    public function setMeterStatusID($meterStatusID = null)
    {
        // validation for constraint: int
        if (!is_null($meterStatusID) && !is_numeric($meterStatusID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($meterStatusID)), __LINE__);
        }
        $this->MeterStatusID = $meterStatusID;
        return $this;
    }
    /**
     * Get DistributionServiceProviderID value
     * @return int
     */
    public function getDistributionServiceProviderID()
    {
        return $this->DistributionServiceProviderID;
    }
    /**
     * Set DistributionServiceProviderID value
     * @param int $distributionServiceProviderID
     * @return \SGCIS\Struct\ServicePoint
     */
    public function setDistributionServiceProviderID($distributionServiceProviderID = null)
    {
        // validation for constraint: int
        if (!is_null($distributionServiceProviderID) && !is_numeric($distributionServiceProviderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($distributionServiceProviderID)), __LINE__);
        }
        $this->DistributionServiceProviderID = $distributionServiceProviderID;
        return $this;
    }
    /**
     * Get IsWeatherMoratorium value
     * @return bool
     */
    public function getIsWeatherMoratorium()
    {
        return $this->IsWeatherMoratorium;
    }
    /**
     * Set IsWeatherMoratorium value
     * @param bool $isWeatherMoratorium
     * @return \SGCIS\Struct\ServicePoint
     */
    public function setIsWeatherMoratorium($isWeatherMoratorium = null)
    {
        // validation for constraint: boolean
        if (!is_null($isWeatherMoratorium) && !is_bool($isWeatherMoratorium)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isWeatherMoratorium)), __LINE__);
        }
        $this->IsWeatherMoratorium = $isWeatherMoratorium;
        return $this;
    }
    /**
     * Get IsSwitchHoldBillPay value
     * @return bool
     */
    public function getIsSwitchHoldBillPay()
    {
        return $this->IsSwitchHoldBillPay;
    }
    /**
     * Set IsSwitchHoldBillPay value
     * @param bool $isSwitchHoldBillPay
     * @return \SGCIS\Struct\ServicePoint
     */
    public function setIsSwitchHoldBillPay($isSwitchHoldBillPay = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSwitchHoldBillPay) && !is_bool($isSwitchHoldBillPay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isSwitchHoldBillPay)), __LINE__);
        }
        $this->IsSwitchHoldBillPay = $isSwitchHoldBillPay;
        return $this;
    }
    /**
     * Get IsSwitchHoldTampering value
     * @return bool
     */
    public function getIsSwitchHoldTampering()
    {
        return $this->IsSwitchHoldTampering;
    }
    /**
     * Set IsSwitchHoldTampering value
     * @param bool $isSwitchHoldTampering
     * @return \SGCIS\Struct\ServicePoint
     */
    public function setIsSwitchHoldTampering($isSwitchHoldTampering = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSwitchHoldTampering) && !is_bool($isSwitchHoldTampering)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isSwitchHoldTampering)), __LINE__);
        }
        $this->IsSwitchHoldTampering = $isSwitchHoldTampering;
        return $this;
    }
    /**
     * Get IsTransfer value
     * @return bool
     */
    public function getIsTransfer()
    {
        return $this->IsTransfer;
    }
    /**
     * Set IsTransfer value
     * @param bool $isTransfer
     * @return \SGCIS\Struct\ServicePoint
     */
    public function setIsTransfer($isTransfer = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTransfer) && !is_bool($isTransfer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isTransfer)), __LINE__);
        }
        $this->IsTransfer = $isTransfer;
        return $this;
    }
    /**
     * Get TransferredFrom value
     * @return int
     */
    public function getTransferredFrom()
    {
        return $this->TransferredFrom;
    }
    /**
     * Set TransferredFrom value
     * @param int $transferredFrom
     * @return \SGCIS\Struct\ServicePoint
     */
    public function setTransferredFrom($transferredFrom = null)
    {
        // validation for constraint: int
        if (!is_null($transferredFrom) && !is_numeric($transferredFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($transferredFrom)), __LINE__);
        }
        $this->TransferredFrom = $transferredFrom;
        return $this;
    }
    /**
     * Get TransferredTo value
     * @return int
     */
    public function getTransferredTo()
    {
        return $this->TransferredTo;
    }
    /**
     * Set TransferredTo value
     * @param int $transferredTo
     * @return \SGCIS\Struct\ServicePoint
     */
    public function setTransferredTo($transferredTo = null)
    {
        // validation for constraint: int
        if (!is_null($transferredTo) && !is_numeric($transferredTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($transferredTo)), __LINE__);
        }
        $this->TransferredTo = $transferredTo;
        return $this;
    }
    /**
     * Get IsAreaOutage value
     * @return bool
     */
    public function getIsAreaOutage()
    {
        return $this->IsAreaOutage;
    }
    /**
     * Set IsAreaOutage value
     * @param bool $isAreaOutage
     * @return \SGCIS\Struct\ServicePoint
     */
    public function setIsAreaOutage($isAreaOutage = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAreaOutage) && !is_bool($isAreaOutage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isAreaOutage)), __LINE__);
        }
        $this->IsAreaOutage = $isAreaOutage;
        return $this;
    }
    /**
     * Get ProductID value
     * @return int
     */
    public function getProductID()
    {
        return $this->ProductID;
    }
    /**
     * Set ProductID value
     * @param int $productID
     * @return \SGCIS\Struct\ServicePoint
     */
    public function setProductID($productID = null)
    {
        // validation for constraint: int
        if (!is_null($productID) && !is_numeric($productID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($productID)), __LINE__);
        }
        $this->ProductID = $productID;
        return $this;
    }
    /**
     * Get CurrentRatekWh value
     * @return float
     */
    public function getCurrentRatekWh()
    {
        return $this->CurrentRatekWh;
    }
    /**
     * Set CurrentRatekWh value
     * @param float $currentRatekWh
     * @return \SGCIS\Struct\ServicePoint
     */
    public function setCurrentRatekWh($currentRatekWh = null)
    {
        $this->CurrentRatekWh = $currentRatekWh;
        return $this;
    }
    /**
     * Get DailyBurnRate value
     * @return float
     */
    public function getDailyBurnRate()
    {
        return $this->DailyBurnRate;
    }
    /**
     * Set DailyBurnRate value
     * @param float $dailyBurnRate
     * @return \SGCIS\Struct\ServicePoint
     */
    public function setDailyBurnRate($dailyBurnRate = null)
    {
        $this->DailyBurnRate = $dailyBurnRate;
        return $this;
    }
    /**
     * Get IsCriticalCare value
     * @return bool
     */
    public function getIsCriticalCare()
    {
        return $this->IsCriticalCare;
    }
    /**
     * Set IsCriticalCare value
     * @param bool $isCriticalCare
     * @return \SGCIS\Struct\ServicePoint
     */
    public function setIsCriticalCare($isCriticalCare = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCriticalCare) && !is_bool($isCriticalCare)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isCriticalCare)), __LINE__);
        }
        $this->IsCriticalCare = $isCriticalCare;
        return $this;
    }
    /**
     * Get Address1 value
     * @return string|null
     */
    public function getAddress1()
    {
        return $this->Address1;
    }
    /**
     * Set Address1 value
     * @param string $address1
     * @return \SGCIS\Struct\ServicePoint
     */
    public function setAddress1($address1 = null)
    {
        // validation for constraint: string
        if (!is_null($address1) && !is_string($address1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address1)), __LINE__);
        }
        $this->Address1 = $address1;
        return $this;
    }
    /**
     * Get Address2 value
     * @return string|null
     */
    public function getAddress2()
    {
        return $this->Address2;
    }
    /**
     * Set Address2 value
     * @param string $address2
     * @return \SGCIS\Struct\ServicePoint
     */
    public function setAddress2($address2 = null)
    {
        // validation for constraint: string
        if (!is_null($address2) && !is_string($address2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address2)), __LINE__);
        }
        $this->Address2 = $address2;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \SGCIS\Struct\ServicePoint
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get StateCode value
     * @return string|null
     */
    public function getStateCode()
    {
        return $this->StateCode;
    }
    /**
     * Set StateCode value
     * @param string $stateCode
     * @return \SGCIS\Struct\ServicePoint
     */
    public function setStateCode($stateCode = null)
    {
        // validation for constraint: string
        if (!is_null($stateCode) && !is_string($stateCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($stateCode)), __LINE__);
        }
        $this->StateCode = $stateCode;
        return $this;
    }
    /**
     * Get ZipCode value
     * @return string|null
     */
    public function getZipCode()
    {
        return $this->ZipCode;
    }
    /**
     * Set ZipCode value
     * @param string $zipCode
     * @return \SGCIS\Struct\ServicePoint
     */
    public function setZipCode($zipCode = null)
    {
        // validation for constraint: string
        if (!is_null($zipCode) && !is_string($zipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zipCode)), __LINE__);
        }
        $this->ZipCode = $zipCode;
        return $this;
    }
    /**
     * Get ZipPlus4 value
     * @return string|null
     */
    public function getZipPlus4()
    {
        return $this->ZipPlus4;
    }
    /**
     * Set ZipPlus4 value
     * @param string $zipPlus4
     * @return \SGCIS\Struct\ServicePoint
     */
    public function setZipPlus4($zipPlus4 = null)
    {
        // validation for constraint: string
        if (!is_null($zipPlus4) && !is_string($zipPlus4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zipPlus4)), __LINE__);
        }
        $this->ZipPlus4 = $zipPlus4;
        return $this;
    }
    /**
     * Get TaxGeocode value
     * @return string|null
     */
    public function getTaxGeocode()
    {
        return $this->TaxGeocode;
    }
    /**
     * Set TaxGeocode value
     * @param string $taxGeocode
     * @return \SGCIS\Struct\ServicePoint
     */
    public function setTaxGeocode($taxGeocode = null)
    {
        // validation for constraint: string
        if (!is_null($taxGeocode) && !is_string($taxGeocode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($taxGeocode)), __LINE__);
        }
        $this->TaxGeocode = $taxGeocode;
        return $this;
    }
    /**
     * Get HostSystemID value
     * @return string|null
     */
    public function getHostSystemID()
    {
        return $this->HostSystemID;
    }
    /**
     * Set HostSystemID value
     * @param string $hostSystemID
     * @return \SGCIS\Struct\ServicePoint
     */
    public function setHostSystemID($hostSystemID = null)
    {
        // validation for constraint: string
        if (!is_null($hostSystemID) && !is_string($hostSystemID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hostSystemID)), __LINE__);
        }
        $this->HostSystemID = $hostSystemID;
        return $this;
    }
    /**
     * Get MarketPricingNodeName value
     * @return string|null
     */
    public function getMarketPricingNodeName()
    {
        return $this->MarketPricingNodeName;
    }
    /**
     * Set MarketPricingNodeName value
     * @param string $marketPricingNodeName
     * @return \SGCIS\Struct\ServicePoint
     */
    public function setMarketPricingNodeName($marketPricingNodeName = null)
    {
        // validation for constraint: string
        if (!is_null($marketPricingNodeName) && !is_string($marketPricingNodeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($marketPricingNodeName)), __LINE__);
        }
        $this->MarketPricingNodeName = $marketPricingNodeName;
        return $this;
    }
    /**
     * Get GeoCodeLevel value
     * @return string|null
     */
    public function getGeoCodeLevel()
    {
        return $this->GeoCodeLevel;
    }
    /**
     * Set GeoCodeLevel value
     * @param string $geoCodeLevel
     * @return \SGCIS\Struct\ServicePoint
     */
    public function setGeoCodeLevel($geoCodeLevel = null)
    {
        // validation for constraint: string
        if (!is_null($geoCodeLevel) && !is_string($geoCodeLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($geoCodeLevel)), __LINE__);
        }
        $this->GeoCodeLevel = $geoCodeLevel;
        return $this;
    }
    /**
     * Get GeoCodeLevelDesc value
     * @return string|null
     */
    public function getGeoCodeLevelDesc()
    {
        return $this->GeoCodeLevelDesc;
    }
    /**
     * Set GeoCodeLevelDesc value
     * @param string $geoCodeLevelDesc
     * @return \SGCIS\Struct\ServicePoint
     */
    public function setGeoCodeLevelDesc($geoCodeLevelDesc = null)
    {
        // validation for constraint: string
        if (!is_null($geoCodeLevelDesc) && !is_string($geoCodeLevelDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($geoCodeLevelDesc)), __LINE__);
        }
        $this->GeoCodeLevelDesc = $geoCodeLevelDesc;
        return $this;
    }
    /**
     * Get AreaCode value
     * @return string|null
     */
    public function getAreaCode()
    {
        return $this->AreaCode;
    }
    /**
     * Set AreaCode value
     * @param string $areaCode
     * @return \SGCIS\Struct\ServicePoint
     */
    public function setAreaCode($areaCode = null)
    {
        // validation for constraint: string
        if (!is_null($areaCode) && !is_string($areaCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($areaCode)), __LINE__);
        }
        $this->AreaCode = $areaCode;
        return $this;
    }
    /**
     * Get CityType value
     * @return string|null
     */
    public function getCityType()
    {
        return $this->CityType;
    }
    /**
     * Set CityType value
     * @param string $cityType
     * @return \SGCIS\Struct\ServicePoint
     */
    public function setCityType($cityType = null)
    {
        // validation for constraint: string
        if (!is_null($cityType) && !is_string($cityType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cityType)), __LINE__);
        }
        $this->CityType = $cityType;
        return $this;
    }
    /**
     * Get TaxingCityName value
     * @return string|null
     */
    public function getTaxingCityName()
    {
        return $this->TaxingCityName;
    }
    /**
     * Set TaxingCityName value
     * @param string $taxingCityName
     * @return \SGCIS\Struct\ServicePoint
     */
    public function setTaxingCityName($taxingCityName = null)
    {
        // validation for constraint: string
        if (!is_null($taxingCityName) && !is_string($taxingCityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($taxingCityName)), __LINE__);
        }
        $this->TaxingCityName = $taxingCityName;
        return $this;
    }
    /**
     * Get MSA value
     * @return string|null
     */
    public function getMSA()
    {
        return $this->MSA;
    }
    /**
     * Set MSA value
     * @param string $mSA
     * @return \SGCIS\Struct\ServicePoint
     */
    public function setMSA($mSA = null)
    {
        // validation for constraint: string
        if (!is_null($mSA) && !is_string($mSA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mSA)), __LINE__);
        }
        $this->MSA = $mSA;
        return $this;
    }
    /**
     * Get CBSA value
     * @return string|null
     */
    public function getCBSA()
    {
        return $this->CBSA;
    }
    /**
     * Set CBSA value
     * @param string $cBSA
     * @return \SGCIS\Struct\ServicePoint
     */
    public function setCBSA($cBSA = null)
    {
        // validation for constraint: string
        if (!is_null($cBSA) && !is_string($cBSA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cBSA)), __LINE__);
        }
        $this->CBSA = $cBSA;
        return $this;
    }
    /**
     * Get MetroArea value
     * @return string|null
     */
    public function getMetroArea()
    {
        return $this->MetroArea;
    }
    /**
     * Set MetroArea value
     * @param string $metroArea
     * @return \SGCIS\Struct\ServicePoint
     */
    public function setMetroArea($metroArea = null)
    {
        // validation for constraint: string
        if (!is_null($metroArea) && !is_string($metroArea)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($metroArea)), __LINE__);
        }
        $this->MetroArea = $metroArea;
        return $this;
    }
    /**
     * Get AreaHouseholdIncome value
     * @return string|null
     */
    public function getAreaHouseholdIncome()
    {
        return $this->AreaHouseholdIncome;
    }
    /**
     * Set AreaHouseholdIncome value
     * @param string $areaHouseholdIncome
     * @return \SGCIS\Struct\ServicePoint
     */
    public function setAreaHouseholdIncome($areaHouseholdIncome = null)
    {
        // validation for constraint: string
        if (!is_null($areaHouseholdIncome) && !is_string($areaHouseholdIncome)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($areaHouseholdIncome)), __LINE__);
        }
        $this->AreaHouseholdIncome = $areaHouseholdIncome;
        return $this;
    }
    /**
     * Get CountyHouseholdIncome value
     * @return string|null
     */
    public function getCountyHouseholdIncome()
    {
        return $this->CountyHouseholdIncome;
    }
    /**
     * Set CountyHouseholdIncome value
     * @param string $countyHouseholdIncome
     * @return \SGCIS\Struct\ServicePoint
     */
    public function setCountyHouseholdIncome($countyHouseholdIncome = null)
    {
        // validation for constraint: string
        if (!is_null($countyHouseholdIncome) && !is_string($countyHouseholdIncome)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($countyHouseholdIncome)), __LINE__);
        }
        $this->CountyHouseholdIncome = $countyHouseholdIncome;
        return $this;
    }
    /**
     * Get CongressCode value
     * @return string|null
     */
    public function getCongressCode()
    {
        return $this->CongressCode;
    }
    /**
     * Set CongressCode value
     * @param string $congressCode
     * @return \SGCIS\Struct\ServicePoint
     */
    public function setCongressCode($congressCode = null)
    {
        // validation for constraint: string
        if (!is_null($congressCode) && !is_string($congressCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($congressCode)), __LINE__);
        }
        $this->CongressCode = $congressCode;
        return $this;
    }
    /**
     * Get LoadProfile value
     * @return string|null
     */
    public function getLoadProfile()
    {
        return $this->LoadProfile;
    }
    /**
     * Set LoadProfile value
     * @param string $loadProfile
     * @return \SGCIS\Struct\ServicePoint
     */
    public function setLoadProfile($loadProfile = null)
    {
        // validation for constraint: string
        if (!is_null($loadProfile) && !is_string($loadProfile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($loadProfile)), __LINE__);
        }
        $this->LoadProfile = $loadProfile;
        return $this;
    }
    /**
     * Get CommunityName value
     * @return string|null
     */
    public function getCommunityName()
    {
        return $this->CommunityName;
    }
    /**
     * Set CommunityName value
     * @param string $communityName
     * @return \SGCIS\Struct\ServicePoint
     */
    public function setCommunityName($communityName = null)
    {
        // validation for constraint: string
        if (!is_null($communityName) && !is_string($communityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($communityName)), __LINE__);
        }
        $this->CommunityName = $communityName;
        return $this;
    }
    /**
     * Get DwellingType value
     * @return string|null
     */
    public function getDwellingType()
    {
        return $this->DwellingType;
    }
    /**
     * Set DwellingType value
     * @param string $dwellingType
     * @return \SGCIS\Struct\ServicePoint
     */
    public function setDwellingType($dwellingType = null)
    {
        // validation for constraint: string
        if (!is_null($dwellingType) && !is_string($dwellingType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dwellingType)), __LINE__);
        }
        $this->DwellingType = $dwellingType;
        return $this;
    }
    /**
     * Get DwellingUnits value
     * @return string|null
     */
    public function getDwellingUnits()
    {
        return $this->DwellingUnits;
    }
    /**
     * Set DwellingUnits value
     * @param string $dwellingUnits
     * @return \SGCIS\Struct\ServicePoint
     */
    public function setDwellingUnits($dwellingUnits = null)
    {
        // validation for constraint: string
        if (!is_null($dwellingUnits) && !is_string($dwellingUnits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dwellingUnits)), __LINE__);
        }
        $this->DwellingUnits = $dwellingUnits;
        return $this;
    }
    /**
     * Get ServicePointStatusName value
     * @return string|null
     */
    public function getServicePointStatusName()
    {
        return $this->ServicePointStatusName;
    }
    /**
     * Set ServicePointStatusName value
     * @param string $servicePointStatusName
     * @return \SGCIS\Struct\ServicePoint
     */
    public function setServicePointStatusName($servicePointStatusName = null)
    {
        // validation for constraint: string
        if (!is_null($servicePointStatusName) && !is_string($servicePointStatusName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($servicePointStatusName)), __LINE__);
        }
        $this->ServicePointStatusName = $servicePointStatusName;
        return $this;
    }
    /**
     * Get AccountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->AccountNumber;
    }
    /**
     * Set AccountNumber value
     * @param string $accountNumber
     * @return \SGCIS\Struct\ServicePoint
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountNumber)), __LINE__);
        }
        $this->AccountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get ServiceProviderIdentifier value
     * @return string|null
     */
    public function getServiceProviderIdentifier()
    {
        return $this->ServiceProviderIdentifier;
    }
    /**
     * Set ServiceProviderIdentifier value
     * @param string $serviceProviderIdentifier
     * @return \SGCIS\Struct\ServicePoint
     */
    public function setServiceProviderIdentifier($serviceProviderIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($serviceProviderIdentifier) && !is_string($serviceProviderIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceProviderIdentifier)), __LINE__);
        }
        $this->ServiceProviderIdentifier = $serviceProviderIdentifier;
        return $this;
    }
    /**
     * Get StateName value
     * @return string|null
     */
    public function getStateName()
    {
        return $this->StateName;
    }
    /**
     * Set StateName value
     * @param string $stateName
     * @return \SGCIS\Struct\ServicePoint
     */
    public function setStateName($stateName = null)
    {
        // validation for constraint: string
        if (!is_null($stateName) && !is_string($stateName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($stateName)), __LINE__);
        }
        $this->StateName = $stateName;
        return $this;
    }
    /**
     * Get CountyName value
     * @return string|null
     */
    public function getCountyName()
    {
        return $this->CountyName;
    }
    /**
     * Set CountyName value
     * @param string $countyName
     * @return \SGCIS\Struct\ServicePoint
     */
    public function setCountyName($countyName = null)
    {
        // validation for constraint: string
        if (!is_null($countyName) && !is_string($countyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($countyName)), __LINE__);
        }
        $this->CountyName = $countyName;
        return $this;
    }
    /**
     * Get MeterStatusName value
     * @return string|null
     */
    public function getMeterStatusName()
    {
        return $this->MeterStatusName;
    }
    /**
     * Set MeterStatusName value
     * @param string $meterStatusName
     * @return \SGCIS\Struct\ServicePoint
     */
    public function setMeterStatusName($meterStatusName = null)
    {
        // validation for constraint: string
        if (!is_null($meterStatusName) && !is_string($meterStatusName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($meterStatusName)), __LINE__);
        }
        $this->MeterStatusName = $meterStatusName;
        return $this;
    }
    /**
     * Get DistributionServiceProviderName value
     * @return string|null
     */
    public function getDistributionServiceProviderName()
    {
        return $this->DistributionServiceProviderName;
    }
    /**
     * Set DistributionServiceProviderName value
     * @param string $distributionServiceProviderName
     * @return \SGCIS\Struct\ServicePoint
     */
    public function setDistributionServiceProviderName($distributionServiceProviderName = null)
    {
        // validation for constraint: string
        if (!is_null($distributionServiceProviderName) && !is_string($distributionServiceProviderName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($distributionServiceProviderName)), __LINE__);
        }
        $this->DistributionServiceProviderName = $distributionServiceProviderName;
        return $this;
    }
    /**
     * Get ServicePointMeter value
     * @return \SGCIS\Struct\ServicePointMeter|null
     */
    public function getServicePointMeter()
    {
        return $this->ServicePointMeter;
    }
    /**
     * Set ServicePointMeter value
     * @param \SGCIS\Struct\ServicePointMeter $servicePointMeter
     * @return \SGCIS\Struct\ServicePoint
     */
    public function setServicePointMeter(\SGCIS\Struct\ServicePointMeter $servicePointMeter = null)
    {
        $this->ServicePointMeter = $servicePointMeter;
        return $this;
    }
    /**
     * Get ProductName value
     * @return string|null
     */
    public function getProductName()
    {
        return $this->ProductName;
    }
    /**
     * Set ProductName value
     * @param string $productName
     * @return \SGCIS\Struct\ServicePoint
     */
    public function setProductName($productName = null)
    {
        // validation for constraint: string
        if (!is_null($productName) && !is_string($productName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productName)), __LINE__);
        }
        $this->ProductName = $productName;
        return $this;
    }
    /**
     * Get BlockNumber value
     * @return string|null
     */
    public function getBlockNumber()
    {
        return $this->BlockNumber;
    }
    /**
     * Set BlockNumber value
     * @param string $blockNumber
     * @return \SGCIS\Struct\ServicePoint
     */
    public function setBlockNumber($blockNumber = null)
    {
        // validation for constraint: string
        if (!is_null($blockNumber) && !is_string($blockNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($blockNumber)), __LINE__);
        }
        $this->BlockNumber = $blockNumber;
        return $this;
    }
    /**
     * Get LotNumber value
     * @return string|null
     */
    public function getLotNumber()
    {
        return $this->LotNumber;
    }
    /**
     * Set LotNumber value
     * @param string $lotNumber
     * @return \SGCIS\Struct\ServicePoint
     */
    public function setLotNumber($lotNumber = null)
    {
        // validation for constraint: string
        if (!is_null($lotNumber) && !is_string($lotNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lotNumber)), __LINE__);
        }
        $this->LotNumber = $lotNumber;
        return $this;
    }
    /**
     * Get RouteNumber value
     * @return string|null
     */
    public function getRouteNumber()
    {
        return $this->RouteNumber;
    }
    /**
     * Set RouteNumber value
     * @param string $routeNumber
     * @return \SGCIS\Struct\ServicePoint
     */
    public function setRouteNumber($routeNumber = null)
    {
        // validation for constraint: string
        if (!is_null($routeNumber) && !is_string($routeNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($routeNumber)), __LINE__);
        }
        $this->RouteNumber = $routeNumber;
        return $this;
    }
    /**
     * Get MonthlyBillingCycle value
     * @return string|null
     */
    public function getMonthlyBillingCycle()
    {
        return $this->MonthlyBillingCycle;
    }
    /**
     * Set MonthlyBillingCycle value
     * @param string $monthlyBillingCycle
     * @return \SGCIS\Struct\ServicePoint
     */
    public function setMonthlyBillingCycle($monthlyBillingCycle = null)
    {
        // validation for constraint: string
        if (!is_null($monthlyBillingCycle) && !is_string($monthlyBillingCycle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($monthlyBillingCycle)), __LINE__);
        }
        $this->MonthlyBillingCycle = $monthlyBillingCycle;
        return $this;
    }
    /**
     * Get TimeZoneCode value
     * @return string|null
     */
    public function getTimeZoneCode()
    {
        return $this->TimeZoneCode;
    }
    /**
     * Set TimeZoneCode value
     * @param string $timeZoneCode
     * @return \SGCIS\Struct\ServicePoint
     */
    public function setTimeZoneCode($timeZoneCode = null)
    {
        // validation for constraint: string
        if (!is_null($timeZoneCode) && !is_string($timeZoneCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timeZoneCode)), __LINE__);
        }
        $this->TimeZoneCode = $timeZoneCode;
        return $this;
    }
    /**
     * Get MeterList value
     * @return \SGCIS\Array\ArrayOfServicePointMeter|null
     */
    public function getMeterList()
    {
        return $this->MeterList;
    }
    /**
     * Set MeterList value
     * @param \SGCIS\Array\ArrayOfServicePointMeter $meterList
     * @return \SGCIS\Struct\ServicePoint
     */
    public function setMeterList(\SGCIS\Array\ArrayOfServicePointMeter $meterList = null)
    {
        $this->MeterList = $meterList;
        return $this;
    }
    /**
     * Get AccountList value
     * @return \SGCIS\Array\ArrayOfAccountServicePoint|null
     */
    public function getAccountList()
    {
        return $this->AccountList;
    }
    /**
     * Set AccountList value
     * @param \SGCIS\Array\ArrayOfAccountServicePoint $accountList
     * @return \SGCIS\Struct\ServicePoint
     */
    public function setAccountList(\SGCIS\Array\ArrayOfAccountServicePoint $accountList = null)
    {
        $this->AccountList = $accountList;
        return $this;
    }
    /**
     * Get ServicePointMeterGroupList value
     * @return \SGCIS\Array\ArrayOfServicePointMeterGroup|null
     */
    public function getServicePointMeterGroupList()
    {
        return $this->ServicePointMeterGroupList;
    }
    /**
     * Set ServicePointMeterGroupList value
     * @param \SGCIS\Array\ArrayOfServicePointMeterGroup $servicePointMeterGroupList
     * @return \SGCIS\Struct\ServicePoint
     */
    public function setServicePointMeterGroupList(\SGCIS\Array\ArrayOfServicePointMeterGroup $servicePointMeterGroupList = null)
    {
        $this->ServicePointMeterGroupList = $servicePointMeterGroupList;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\ServicePoint
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
