<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceOrderNote Struct
 * @subpackage Structs
 */
class ServiceOrderNote extends BaseDTO
{
    /**
     * The ServiceOrderNoteID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ServiceOrderNoteID;
    /**
     * The ServiceOrderID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ServiceOrderID;
    /**
     * The Notes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Notes;
    /**
     * The UserName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserName;
    /**
     * Constructor method for ServiceOrderNote
     * @uses ServiceOrderNote::setServiceOrderNoteID()
     * @uses ServiceOrderNote::setServiceOrderID()
     * @uses ServiceOrderNote::setNotes()
     * @uses ServiceOrderNote::setUserName()
     * @param int $serviceOrderNoteID
     * @param int $serviceOrderID
     * @param string $notes
     * @param string $userName
     */
    public function __construct($serviceOrderNoteID = null, $serviceOrderID = null, $notes = null, $userName = null)
    {
        $this
            ->setServiceOrderNoteID($serviceOrderNoteID)
            ->setServiceOrderID($serviceOrderID)
            ->setNotes($notes)
            ->setUserName($userName);
    }
    /**
     * Get ServiceOrderNoteID value
     * @return int
     */
    public function getServiceOrderNoteID()
    {
        return $this->ServiceOrderNoteID;
    }
    /**
     * Set ServiceOrderNoteID value
     * @param int $serviceOrderNoteID
     * @return \SGCIS\Struct\ServiceOrderNote
     */
    public function setServiceOrderNoteID($serviceOrderNoteID = null)
    {
        // validation for constraint: int
        if (!is_null($serviceOrderNoteID) && !is_numeric($serviceOrderNoteID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($serviceOrderNoteID)), __LINE__);
        }
        $this->ServiceOrderNoteID = $serviceOrderNoteID;
        return $this;
    }
    /**
     * Get ServiceOrderID value
     * @return int
     */
    public function getServiceOrderID()
    {
        return $this->ServiceOrderID;
    }
    /**
     * Set ServiceOrderID value
     * @param int $serviceOrderID
     * @return \SGCIS\Struct\ServiceOrderNote
     */
    public function setServiceOrderID($serviceOrderID = null)
    {
        // validation for constraint: int
        if (!is_null($serviceOrderID) && !is_numeric($serviceOrderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($serviceOrderID)), __LINE__);
        }
        $this->ServiceOrderID = $serviceOrderID;
        return $this;
    }
    /**
     * Get Notes value
     * @return string|null
     */
    public function getNotes()
    {
        return $this->Notes;
    }
    /**
     * Set Notes value
     * @param string $notes
     * @return \SGCIS\Struct\ServiceOrderNote
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($notes)), __LINE__);
        }
        $this->Notes = $notes;
        return $this;
    }
    /**
     * Get UserName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->UserName;
    }
    /**
     * Set UserName value
     * @param string $userName
     * @return \SGCIS\Struct\ServiceOrderNote
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userName)), __LINE__);
        }
        $this->UserName = $userName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\ServiceOrderNote
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
