<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceLocationSearch Struct
 * @subpackage Structs
 */
class ServiceLocationSearch extends AbstractStructBase
{
    /**
     * The IsEsiIDSearch
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsEsiIDSearch;
    /**
     * The SwitchOrMoveInOrder
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $SwitchOrMoveInOrder;
    /**
     * The EsiID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EsiID;
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address;
    /**
     * The City
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $City;
    /**
     * The State
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $State;
    /**
     * The Zip
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Zip;
    /**
     * The CustomerLastName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerLastName;
    /**
     * The LotNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LotNumber;
    /**
     * The BlockNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BlockNumber;
    /**
     * Constructor method for ServiceLocationSearch
     * @uses ServiceLocationSearch::setIsEsiIDSearch()
     * @uses ServiceLocationSearch::setSwitchOrMoveInOrder()
     * @uses ServiceLocationSearch::setEsiID()
     * @uses ServiceLocationSearch::setAddress()
     * @uses ServiceLocationSearch::setCity()
     * @uses ServiceLocationSearch::setState()
     * @uses ServiceLocationSearch::setZip()
     * @uses ServiceLocationSearch::setCustomerLastName()
     * @uses ServiceLocationSearch::setLotNumber()
     * @uses ServiceLocationSearch::setBlockNumber()
     * @param bool $isEsiIDSearch
     * @param bool $switchOrMoveInOrder
     * @param string $esiID
     * @param string $address
     * @param string $city
     * @param string $state
     * @param string $zip
     * @param string $customerLastName
     * @param string $lotNumber
     * @param string $blockNumber
     */
    public function __construct($isEsiIDSearch = null, $switchOrMoveInOrder = null, $esiID = null, $address = null, $city = null, $state = null, $zip = null, $customerLastName = null, $lotNumber = null, $blockNumber = null)
    {
        $this
            ->setIsEsiIDSearch($isEsiIDSearch)
            ->setSwitchOrMoveInOrder($switchOrMoveInOrder)
            ->setEsiID($esiID)
            ->setAddress($address)
            ->setCity($city)
            ->setState($state)
            ->setZip($zip)
            ->setCustomerLastName($customerLastName)
            ->setLotNumber($lotNumber)
            ->setBlockNumber($blockNumber);
    }
    /**
     * Get IsEsiIDSearch value
     * @return bool
     */
    public function getIsEsiIDSearch()
    {
        return $this->IsEsiIDSearch;
    }
    /**
     * Set IsEsiIDSearch value
     * @param bool $isEsiIDSearch
     * @return \SGCIS\Struct\ServiceLocationSearch
     */
    public function setIsEsiIDSearch($isEsiIDSearch = null)
    {
        // validation for constraint: boolean
        if (!is_null($isEsiIDSearch) && !is_bool($isEsiIDSearch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isEsiIDSearch)), __LINE__);
        }
        $this->IsEsiIDSearch = $isEsiIDSearch;
        return $this;
    }
    /**
     * Get SwitchOrMoveInOrder value
     * @return bool
     */
    public function getSwitchOrMoveInOrder()
    {
        return $this->SwitchOrMoveInOrder;
    }
    /**
     * Set SwitchOrMoveInOrder value
     * @param bool $switchOrMoveInOrder
     * @return \SGCIS\Struct\ServiceLocationSearch
     */
    public function setSwitchOrMoveInOrder($switchOrMoveInOrder = null)
    {
        // validation for constraint: boolean
        if (!is_null($switchOrMoveInOrder) && !is_bool($switchOrMoveInOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($switchOrMoveInOrder)), __LINE__);
        }
        $this->SwitchOrMoveInOrder = $switchOrMoveInOrder;
        return $this;
    }
    /**
     * Get EsiID value
     * @return string|null
     */
    public function getEsiID()
    {
        return $this->EsiID;
    }
    /**
     * Set EsiID value
     * @param string $esiID
     * @return \SGCIS\Struct\ServiceLocationSearch
     */
    public function setEsiID($esiID = null)
    {
        // validation for constraint: string
        if (!is_null($esiID) && !is_string($esiID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($esiID)), __LINE__);
        }
        $this->EsiID = $esiID;
        return $this;
    }
    /**
     * Get Address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param string $address
     * @return \SGCIS\Struct\ServiceLocationSearch
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address)), __LINE__);
        }
        $this->Address = $address;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \SGCIS\Struct\ServiceLocationSearch
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get State value
     * @return string|null
     */
    public function getState()
    {
        return $this->State;
    }
    /**
     * Set State value
     * @param string $state
     * @return \SGCIS\Struct\ServiceLocationSearch
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($state)), __LINE__);
        }
        $this->State = $state;
        return $this;
    }
    /**
     * Get Zip value
     * @return string|null
     */
    public function getZip()
    {
        return $this->Zip;
    }
    /**
     * Set Zip value
     * @param string $zip
     * @return \SGCIS\Struct\ServiceLocationSearch
     */
    public function setZip($zip = null)
    {
        // validation for constraint: string
        if (!is_null($zip) && !is_string($zip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zip)), __LINE__);
        }
        $this->Zip = $zip;
        return $this;
    }
    /**
     * Get CustomerLastName value
     * @return string|null
     */
    public function getCustomerLastName()
    {
        return $this->CustomerLastName;
    }
    /**
     * Set CustomerLastName value
     * @param string $customerLastName
     * @return \SGCIS\Struct\ServiceLocationSearch
     */
    public function setCustomerLastName($customerLastName = null)
    {
        // validation for constraint: string
        if (!is_null($customerLastName) && !is_string($customerLastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerLastName)), __LINE__);
        }
        $this->CustomerLastName = $customerLastName;
        return $this;
    }
    /**
     * Get LotNumber value
     * @return string|null
     */
    public function getLotNumber()
    {
        return $this->LotNumber;
    }
    /**
     * Set LotNumber value
     * @param string $lotNumber
     * @return \SGCIS\Struct\ServiceLocationSearch
     */
    public function setLotNumber($lotNumber = null)
    {
        // validation for constraint: string
        if (!is_null($lotNumber) && !is_string($lotNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lotNumber)), __LINE__);
        }
        $this->LotNumber = $lotNumber;
        return $this;
    }
    /**
     * Get BlockNumber value
     * @return string|null
     */
    public function getBlockNumber()
    {
        return $this->BlockNumber;
    }
    /**
     * Set BlockNumber value
     * @param string $blockNumber
     * @return \SGCIS\Struct\ServiceLocationSearch
     */
    public function setBlockNumber($blockNumber = null)
    {
        // validation for constraint: string
        if (!is_null($blockNumber) && !is_string($blockNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($blockNumber)), __LINE__);
        }
        $this->BlockNumber = $blockNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\ServiceLocationSearch
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
