<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SendPasswordResponse Struct
 * @subpackage Structs
 */
class SendPasswordResponse extends ServiceResponseBase
{
    /**
     * The PersonID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PersonID;
    /**
     * The SendPasswordResult
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\SendPasswordResponse
     */
    public $SendPasswordResult;
    /**
     * Constructor method for SendPasswordResponse
     * @uses SendPasswordResponse::setPersonID()
     * @uses SendPasswordResponse::setSendPasswordResult()
     * @param int $personID
     * @param \SGCIS\Struct\SendPasswordResponse $sendPasswordResult
     */
    public function __construct($personID = null, \SGCIS\Struct\SendPasswordResponse $sendPasswordResult = null)
    {
        $this
            ->setPersonID($personID)
            ->setSendPasswordResult($sendPasswordResult);
    }
    /**
     * Get PersonID value
     * @return int
     */
    public function getPersonID()
    {
        return $this->PersonID;
    }
    /**
     * Set PersonID value
     * @param int $personID
     * @return \SGCIS\Struct\SendPasswordResponse
     */
    public function setPersonID($personID = null)
    {
        // validation for constraint: int
        if (!is_null($personID) && !is_numeric($personID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($personID)), __LINE__);
        }
        $this->PersonID = $personID;
        return $this;
    }
    /**
     * Get SendPasswordResult value
     * @return \SGCIS\Struct\SendPasswordResponse|null
     */
    public function getSendPasswordResult()
    {
        return $this->SendPasswordResult;
    }
    /**
     * Set SendPasswordResult value
     * @param \SGCIS\Struct\SendPasswordResponse $sendPasswordResult
     * @return \SGCIS\Struct\SendPasswordResponse
     */
    public function setSendPasswordResult(\SGCIS\Struct\SendPasswordResponse $sendPasswordResult = null)
    {
        $this->SendPasswordResult = $sendPasswordResult;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\SendPasswordResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
