<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SearchEntityView Struct
 * @subpackage Structs
 */
class SearchEntityView extends AbstractStructBase
{
    /**
     * The SearchEntityViewID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SearchEntityViewID;
    /**
     * The SearchEntityID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SearchEntityID;
    /**
     * The ShowDateTimePickers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ShowDateTimePickers;
    /**
     * The ShowAccountNumberAsHyperlink
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ShowAccountNumberAsHyperlink;
    /**
     * The IsVisualReportEntity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsVisualReportEntity;
    /**
     * The DisplayName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayName;
    /**
     * The DatabaseViewName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DatabaseViewName;
    /**
     * The SortByColumnName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SortByColumnName;
    /**
     * The GroupByColumnName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GroupByColumnName;
    /**
     * The HiddenColumnsNames
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HiddenColumnsNames;
    /**
     * The FromDateLabel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FromDateLabel;
    /**
     * The ToDateLabel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ToDateLabel;
    /**
     * The CurrencyColumnsNames
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CurrencyColumnsNames;
    /**
     * Constructor method for SearchEntityView
     * @uses SearchEntityView::setSearchEntityViewID()
     * @uses SearchEntityView::setSearchEntityID()
     * @uses SearchEntityView::setShowDateTimePickers()
     * @uses SearchEntityView::setShowAccountNumberAsHyperlink()
     * @uses SearchEntityView::setIsVisualReportEntity()
     * @uses SearchEntityView::setDisplayName()
     * @uses SearchEntityView::setDatabaseViewName()
     * @uses SearchEntityView::setSortByColumnName()
     * @uses SearchEntityView::setGroupByColumnName()
     * @uses SearchEntityView::setHiddenColumnsNames()
     * @uses SearchEntityView::setFromDateLabel()
     * @uses SearchEntityView::setToDateLabel()
     * @uses SearchEntityView::setCurrencyColumnsNames()
     * @param int $searchEntityViewID
     * @param int $searchEntityID
     * @param bool $showDateTimePickers
     * @param bool $showAccountNumberAsHyperlink
     * @param bool $isVisualReportEntity
     * @param string $displayName
     * @param string $databaseViewName
     * @param string $sortByColumnName
     * @param string $groupByColumnName
     * @param string $hiddenColumnsNames
     * @param string $fromDateLabel
     * @param string $toDateLabel
     * @param string $currencyColumnsNames
     */
    public function __construct($searchEntityViewID = null, $searchEntityID = null, $showDateTimePickers = null, $showAccountNumberAsHyperlink = null, $isVisualReportEntity = null, $displayName = null, $databaseViewName = null, $sortByColumnName = null, $groupByColumnName = null, $hiddenColumnsNames = null, $fromDateLabel = null, $toDateLabel = null, $currencyColumnsNames = null)
    {
        $this
            ->setSearchEntityViewID($searchEntityViewID)
            ->setSearchEntityID($searchEntityID)
            ->setShowDateTimePickers($showDateTimePickers)
            ->setShowAccountNumberAsHyperlink($showAccountNumberAsHyperlink)
            ->setIsVisualReportEntity($isVisualReportEntity)
            ->setDisplayName($displayName)
            ->setDatabaseViewName($databaseViewName)
            ->setSortByColumnName($sortByColumnName)
            ->setGroupByColumnName($groupByColumnName)
            ->setHiddenColumnsNames($hiddenColumnsNames)
            ->setFromDateLabel($fromDateLabel)
            ->setToDateLabel($toDateLabel)
            ->setCurrencyColumnsNames($currencyColumnsNames);
    }
    /**
     * Get SearchEntityViewID value
     * @return int
     */
    public function getSearchEntityViewID()
    {
        return $this->SearchEntityViewID;
    }
    /**
     * Set SearchEntityViewID value
     * @param int $searchEntityViewID
     * @return \SGCIS\Struct\SearchEntityView
     */
    public function setSearchEntityViewID($searchEntityViewID = null)
    {
        // validation for constraint: int
        if (!is_null($searchEntityViewID) && !is_numeric($searchEntityViewID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($searchEntityViewID)), __LINE__);
        }
        $this->SearchEntityViewID = $searchEntityViewID;
        return $this;
    }
    /**
     * Get SearchEntityID value
     * @return int
     */
    public function getSearchEntityID()
    {
        return $this->SearchEntityID;
    }
    /**
     * Set SearchEntityID value
     * @param int $searchEntityID
     * @return \SGCIS\Struct\SearchEntityView
     */
    public function setSearchEntityID($searchEntityID = null)
    {
        // validation for constraint: int
        if (!is_null($searchEntityID) && !is_numeric($searchEntityID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($searchEntityID)), __LINE__);
        }
        $this->SearchEntityID = $searchEntityID;
        return $this;
    }
    /**
     * Get ShowDateTimePickers value
     * @return bool
     */
    public function getShowDateTimePickers()
    {
        return $this->ShowDateTimePickers;
    }
    /**
     * Set ShowDateTimePickers value
     * @param bool $showDateTimePickers
     * @return \SGCIS\Struct\SearchEntityView
     */
    public function setShowDateTimePickers($showDateTimePickers = null)
    {
        // validation for constraint: boolean
        if (!is_null($showDateTimePickers) && !is_bool($showDateTimePickers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($showDateTimePickers)), __LINE__);
        }
        $this->ShowDateTimePickers = $showDateTimePickers;
        return $this;
    }
    /**
     * Get ShowAccountNumberAsHyperlink value
     * @return bool
     */
    public function getShowAccountNumberAsHyperlink()
    {
        return $this->ShowAccountNumberAsHyperlink;
    }
    /**
     * Set ShowAccountNumberAsHyperlink value
     * @param bool $showAccountNumberAsHyperlink
     * @return \SGCIS\Struct\SearchEntityView
     */
    public function setShowAccountNumberAsHyperlink($showAccountNumberAsHyperlink = null)
    {
        // validation for constraint: boolean
        if (!is_null($showAccountNumberAsHyperlink) && !is_bool($showAccountNumberAsHyperlink)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($showAccountNumberAsHyperlink)), __LINE__);
        }
        $this->ShowAccountNumberAsHyperlink = $showAccountNumberAsHyperlink;
        return $this;
    }
    /**
     * Get IsVisualReportEntity value
     * @return bool
     */
    public function getIsVisualReportEntity()
    {
        return $this->IsVisualReportEntity;
    }
    /**
     * Set IsVisualReportEntity value
     * @param bool $isVisualReportEntity
     * @return \SGCIS\Struct\SearchEntityView
     */
    public function setIsVisualReportEntity($isVisualReportEntity = null)
    {
        // validation for constraint: boolean
        if (!is_null($isVisualReportEntity) && !is_bool($isVisualReportEntity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isVisualReportEntity)), __LINE__);
        }
        $this->IsVisualReportEntity = $isVisualReportEntity;
        return $this;
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \SGCIS\Struct\SearchEntityView
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get DatabaseViewName value
     * @return string|null
     */
    public function getDatabaseViewName()
    {
        return $this->DatabaseViewName;
    }
    /**
     * Set DatabaseViewName value
     * @param string $databaseViewName
     * @return \SGCIS\Struct\SearchEntityView
     */
    public function setDatabaseViewName($databaseViewName = null)
    {
        // validation for constraint: string
        if (!is_null($databaseViewName) && !is_string($databaseViewName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($databaseViewName)), __LINE__);
        }
        $this->DatabaseViewName = $databaseViewName;
        return $this;
    }
    /**
     * Get SortByColumnName value
     * @return string|null
     */
    public function getSortByColumnName()
    {
        return $this->SortByColumnName;
    }
    /**
     * Set SortByColumnName value
     * @param string $sortByColumnName
     * @return \SGCIS\Struct\SearchEntityView
     */
    public function setSortByColumnName($sortByColumnName = null)
    {
        // validation for constraint: string
        if (!is_null($sortByColumnName) && !is_string($sortByColumnName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sortByColumnName)), __LINE__);
        }
        $this->SortByColumnName = $sortByColumnName;
        return $this;
    }
    /**
     * Get GroupByColumnName value
     * @return string|null
     */
    public function getGroupByColumnName()
    {
        return $this->GroupByColumnName;
    }
    /**
     * Set GroupByColumnName value
     * @param string $groupByColumnName
     * @return \SGCIS\Struct\SearchEntityView
     */
    public function setGroupByColumnName($groupByColumnName = null)
    {
        // validation for constraint: string
        if (!is_null($groupByColumnName) && !is_string($groupByColumnName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($groupByColumnName)), __LINE__);
        }
        $this->GroupByColumnName = $groupByColumnName;
        return $this;
    }
    /**
     * Get HiddenColumnsNames value
     * @return string|null
     */
    public function getHiddenColumnsNames()
    {
        return $this->HiddenColumnsNames;
    }
    /**
     * Set HiddenColumnsNames value
     * @param string $hiddenColumnsNames
     * @return \SGCIS\Struct\SearchEntityView
     */
    public function setHiddenColumnsNames($hiddenColumnsNames = null)
    {
        // validation for constraint: string
        if (!is_null($hiddenColumnsNames) && !is_string($hiddenColumnsNames)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hiddenColumnsNames)), __LINE__);
        }
        $this->HiddenColumnsNames = $hiddenColumnsNames;
        return $this;
    }
    /**
     * Get FromDateLabel value
     * @return string|null
     */
    public function getFromDateLabel()
    {
        return $this->FromDateLabel;
    }
    /**
     * Set FromDateLabel value
     * @param string $fromDateLabel
     * @return \SGCIS\Struct\SearchEntityView
     */
    public function setFromDateLabel($fromDateLabel = null)
    {
        // validation for constraint: string
        if (!is_null($fromDateLabel) && !is_string($fromDateLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fromDateLabel)), __LINE__);
        }
        $this->FromDateLabel = $fromDateLabel;
        return $this;
    }
    /**
     * Get ToDateLabel value
     * @return string|null
     */
    public function getToDateLabel()
    {
        return $this->ToDateLabel;
    }
    /**
     * Set ToDateLabel value
     * @param string $toDateLabel
     * @return \SGCIS\Struct\SearchEntityView
     */
    public function setToDateLabel($toDateLabel = null)
    {
        // validation for constraint: string
        if (!is_null($toDateLabel) && !is_string($toDateLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($toDateLabel)), __LINE__);
        }
        $this->ToDateLabel = $toDateLabel;
        return $this;
    }
    /**
     * Get CurrencyColumnsNames value
     * @return string|null
     */
    public function getCurrencyColumnsNames()
    {
        return $this->CurrencyColumnsNames;
    }
    /**
     * Set CurrencyColumnsNames value
     * @param string $currencyColumnsNames
     * @return \SGCIS\Struct\SearchEntityView
     */
    public function setCurrencyColumnsNames($currencyColumnsNames = null)
    {
        // validation for constraint: string
        if (!is_null($currencyColumnsNames) && !is_string($currencyColumnsNames)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currencyColumnsNames)), __LINE__);
        }
        $this->CurrencyColumnsNames = $currencyColumnsNames;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\SearchEntityView
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
