<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RateOtherCharge Struct
 * @subpackage Structs
 */
class RateOtherCharge extends BaseDTO
{
    /**
     * The RateOtherChargeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RateOtherChargeID;
    /**
     * The RateID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RateID;
    /**
     * The OtherChargeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OtherChargeID;
    /**
     * The IsAccountLevelCharge
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsAccountLevelCharge;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * Constructor method for RateOtherCharge
     * @uses RateOtherCharge::setRateOtherChargeID()
     * @uses RateOtherCharge::setRateID()
     * @uses RateOtherCharge::setOtherChargeID()
     * @uses RateOtherCharge::setIsAccountLevelCharge()
     * @uses RateOtherCharge::setName()
     * @param int $rateOtherChargeID
     * @param int $rateID
     * @param int $otherChargeID
     * @param bool $isAccountLevelCharge
     * @param string $name
     */
    public function __construct($rateOtherChargeID = null, $rateID = null, $otherChargeID = null, $isAccountLevelCharge = null, $name = null)
    {
        $this
            ->setRateOtherChargeID($rateOtherChargeID)
            ->setRateID($rateID)
            ->setOtherChargeID($otherChargeID)
            ->setIsAccountLevelCharge($isAccountLevelCharge)
            ->setName($name);
    }
    /**
     * Get RateOtherChargeID value
     * @return int
     */
    public function getRateOtherChargeID()
    {
        return $this->RateOtherChargeID;
    }
    /**
     * Set RateOtherChargeID value
     * @param int $rateOtherChargeID
     * @return \SGCIS\Struct\RateOtherCharge
     */
    public function setRateOtherChargeID($rateOtherChargeID = null)
    {
        // validation for constraint: int
        if (!is_null($rateOtherChargeID) && !is_numeric($rateOtherChargeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rateOtherChargeID)), __LINE__);
        }
        $this->RateOtherChargeID = $rateOtherChargeID;
        return $this;
    }
    /**
     * Get RateID value
     * @return int
     */
    public function getRateID()
    {
        return $this->RateID;
    }
    /**
     * Set RateID value
     * @param int $rateID
     * @return \SGCIS\Struct\RateOtherCharge
     */
    public function setRateID($rateID = null)
    {
        // validation for constraint: int
        if (!is_null($rateID) && !is_numeric($rateID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rateID)), __LINE__);
        }
        $this->RateID = $rateID;
        return $this;
    }
    /**
     * Get OtherChargeID value
     * @return int
     */
    public function getOtherChargeID()
    {
        return $this->OtherChargeID;
    }
    /**
     * Set OtherChargeID value
     * @param int $otherChargeID
     * @return \SGCIS\Struct\RateOtherCharge
     */
    public function setOtherChargeID($otherChargeID = null)
    {
        // validation for constraint: int
        if (!is_null($otherChargeID) && !is_numeric($otherChargeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($otherChargeID)), __LINE__);
        }
        $this->OtherChargeID = $otherChargeID;
        return $this;
    }
    /**
     * Get IsAccountLevelCharge value
     * @return bool
     */
    public function getIsAccountLevelCharge()
    {
        return $this->IsAccountLevelCharge;
    }
    /**
     * Set IsAccountLevelCharge value
     * @param bool $isAccountLevelCharge
     * @return \SGCIS\Struct\RateOtherCharge
     */
    public function setIsAccountLevelCharge($isAccountLevelCharge = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAccountLevelCharge) && !is_bool($isAccountLevelCharge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isAccountLevelCharge)), __LINE__);
        }
        $this->IsAccountLevelCharge = $isAccountLevelCharge;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \SGCIS\Struct\RateOtherCharge
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\RateOtherCharge
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
