<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RateCharacteristic Struct
 * @subpackage Structs
 */
class RateCharacteristic extends AbstractStructBase
{
    /**
     * The RateCharacteristicID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RateCharacteristicID;
    /**
     * The RateID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RateID;
    /**
     * The CreateDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreateDate;
    /**
     * The CharName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CharName;
    /**
     * The CharValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CharValue;
    /**
     * Constructor method for RateCharacteristic
     * @uses RateCharacteristic::setRateCharacteristicID()
     * @uses RateCharacteristic::setRateID()
     * @uses RateCharacteristic::setCreateDate()
     * @uses RateCharacteristic::setCharName()
     * @uses RateCharacteristic::setCharValue()
     * @param int $rateCharacteristicID
     * @param int $rateID
     * @param string $createDate
     * @param string $charName
     * @param string $charValue
     */
    public function __construct($rateCharacteristicID = null, $rateID = null, $createDate = null, $charName = null, $charValue = null)
    {
        $this
            ->setRateCharacteristicID($rateCharacteristicID)
            ->setRateID($rateID)
            ->setCreateDate($createDate)
            ->setCharName($charName)
            ->setCharValue($charValue);
    }
    /**
     * Get RateCharacteristicID value
     * @return int
     */
    public function getRateCharacteristicID()
    {
        return $this->RateCharacteristicID;
    }
    /**
     * Set RateCharacteristicID value
     * @param int $rateCharacteristicID
     * @return \SGCIS\Struct\RateCharacteristic
     */
    public function setRateCharacteristicID($rateCharacteristicID = null)
    {
        // validation for constraint: int
        if (!is_null($rateCharacteristicID) && !is_numeric($rateCharacteristicID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rateCharacteristicID)), __LINE__);
        }
        $this->RateCharacteristicID = $rateCharacteristicID;
        return $this;
    }
    /**
     * Get RateID value
     * @return int
     */
    public function getRateID()
    {
        return $this->RateID;
    }
    /**
     * Set RateID value
     * @param int $rateID
     * @return \SGCIS\Struct\RateCharacteristic
     */
    public function setRateID($rateID = null)
    {
        // validation for constraint: int
        if (!is_null($rateID) && !is_numeric($rateID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rateID)), __LINE__);
        }
        $this->RateID = $rateID;
        return $this;
    }
    /**
     * Get CreateDate value
     * @return string
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \SGCIS\Struct\RateCharacteristic
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Get CharName value
     * @return string|null
     */
    public function getCharName()
    {
        return $this->CharName;
    }
    /**
     * Set CharName value
     * @param string $charName
     * @return \SGCIS\Struct\RateCharacteristic
     */
    public function setCharName($charName = null)
    {
        // validation for constraint: string
        if (!is_null($charName) && !is_string($charName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($charName)), __LINE__);
        }
        $this->CharName = $charName;
        return $this;
    }
    /**
     * Get CharValue value
     * @return string|null
     */
    public function getCharValue()
    {
        return $this->CharValue;
    }
    /**
     * Set CharValue value
     * @param string $charValue
     * @return \SGCIS\Struct\RateCharacteristic
     */
    public function setCharValue($charValue = null)
    {
        // validation for constraint: string
        if (!is_null($charValue) && !is_string($charValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($charValue)), __LINE__);
        }
        $this->CharValue = $charValue;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\RateCharacteristic
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
