<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PromotionAccountType Struct
 * @subpackage Structs
 */
class PromotionAccountType extends AbstractStructBase
{
    /**
     * The PromotionAccountTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PromotionAccountTypeID;
    /**
     * The PromotionID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PromotionID;
    /**
     * The AccountTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountTypeID;
    /**
     * Constructor method for PromotionAccountType
     * @uses PromotionAccountType::setPromotionAccountTypeID()
     * @uses PromotionAccountType::setPromotionID()
     * @uses PromotionAccountType::setAccountTypeID()
     * @param int $promotionAccountTypeID
     * @param int $promotionID
     * @param int $accountTypeID
     */
    public function __construct($promotionAccountTypeID = null, $promotionID = null, $accountTypeID = null)
    {
        $this
            ->setPromotionAccountTypeID($promotionAccountTypeID)
            ->setPromotionID($promotionID)
            ->setAccountTypeID($accountTypeID);
    }
    /**
     * Get PromotionAccountTypeID value
     * @return int
     */
    public function getPromotionAccountTypeID()
    {
        return $this->PromotionAccountTypeID;
    }
    /**
     * Set PromotionAccountTypeID value
     * @param int $promotionAccountTypeID
     * @return \SGCIS\Struct\PromotionAccountType
     */
    public function setPromotionAccountTypeID($promotionAccountTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($promotionAccountTypeID) && !is_numeric($promotionAccountTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($promotionAccountTypeID)), __LINE__);
        }
        $this->PromotionAccountTypeID = $promotionAccountTypeID;
        return $this;
    }
    /**
     * Get PromotionID value
     * @return int
     */
    public function getPromotionID()
    {
        return $this->PromotionID;
    }
    /**
     * Set PromotionID value
     * @param int $promotionID
     * @return \SGCIS\Struct\PromotionAccountType
     */
    public function setPromotionID($promotionID = null)
    {
        // validation for constraint: int
        if (!is_null($promotionID) && !is_numeric($promotionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($promotionID)), __LINE__);
        }
        $this->PromotionID = $promotionID;
        return $this;
    }
    /**
     * Get AccountTypeID value
     * @return int
     */
    public function getAccountTypeID()
    {
        return $this->AccountTypeID;
    }
    /**
     * Set AccountTypeID value
     * @param int $accountTypeID
     * @return \SGCIS\Struct\PromotionAccountType
     */
    public function setAccountTypeID($accountTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($accountTypeID) && !is_numeric($accountTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountTypeID)), __LINE__);
        }
        $this->AccountTypeID = $accountTypeID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\PromotionAccountType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
