<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductDisplayTDSP Struct
 * @subpackage Structs
 */
class ProductDisplayTDSP extends AbstractStructBase
{
    /**
     * The ProductDisplayTDSPID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ProductDisplayTDSPID;
    /**
     * The ProductDisplayID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ProductDisplayID;
    /**
     * The DistributionServiceProviderID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DistributionServiceProviderID;
    /**
     * The CreateDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreateDate;
    /**
     * Constructor method for ProductDisplayTDSP
     * @uses ProductDisplayTDSP::setProductDisplayTDSPID()
     * @uses ProductDisplayTDSP::setProductDisplayID()
     * @uses ProductDisplayTDSP::setDistributionServiceProviderID()
     * @uses ProductDisplayTDSP::setCreateDate()
     * @param int $productDisplayTDSPID
     * @param int $productDisplayID
     * @param int $distributionServiceProviderID
     * @param string $createDate
     */
    public function __construct($productDisplayTDSPID = null, $productDisplayID = null, $distributionServiceProviderID = null, $createDate = null)
    {
        $this
            ->setProductDisplayTDSPID($productDisplayTDSPID)
            ->setProductDisplayID($productDisplayID)
            ->setDistributionServiceProviderID($distributionServiceProviderID)
            ->setCreateDate($createDate);
    }
    /**
     * Get ProductDisplayTDSPID value
     * @return int
     */
    public function getProductDisplayTDSPID()
    {
        return $this->ProductDisplayTDSPID;
    }
    /**
     * Set ProductDisplayTDSPID value
     * @param int $productDisplayTDSPID
     * @return \SGCIS\Struct\ProductDisplayTDSP
     */
    public function setProductDisplayTDSPID($productDisplayTDSPID = null)
    {
        // validation for constraint: int
        if (!is_null($productDisplayTDSPID) && !is_numeric($productDisplayTDSPID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($productDisplayTDSPID)), __LINE__);
        }
        $this->ProductDisplayTDSPID = $productDisplayTDSPID;
        return $this;
    }
    /**
     * Get ProductDisplayID value
     * @return int
     */
    public function getProductDisplayID()
    {
        return $this->ProductDisplayID;
    }
    /**
     * Set ProductDisplayID value
     * @param int $productDisplayID
     * @return \SGCIS\Struct\ProductDisplayTDSP
     */
    public function setProductDisplayID($productDisplayID = null)
    {
        // validation for constraint: int
        if (!is_null($productDisplayID) && !is_numeric($productDisplayID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($productDisplayID)), __LINE__);
        }
        $this->ProductDisplayID = $productDisplayID;
        return $this;
    }
    /**
     * Get DistributionServiceProviderID value
     * @return int
     */
    public function getDistributionServiceProviderID()
    {
        return $this->DistributionServiceProviderID;
    }
    /**
     * Set DistributionServiceProviderID value
     * @param int $distributionServiceProviderID
     * @return \SGCIS\Struct\ProductDisplayTDSP
     */
    public function setDistributionServiceProviderID($distributionServiceProviderID = null)
    {
        // validation for constraint: int
        if (!is_null($distributionServiceProviderID) && !is_numeric($distributionServiceProviderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($distributionServiceProviderID)), __LINE__);
        }
        $this->DistributionServiceProviderID = $distributionServiceProviderID;
        return $this;
    }
    /**
     * Get CreateDate value
     * @return string
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \SGCIS\Struct\ProductDisplayTDSP
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\ProductDisplayTDSP
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
