<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Product Struct
 * @subpackage Structs
 */
class Product extends BaseDTO
{
    /**
     * The ProductID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ProductID;
    /**
     * The RateID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RateID;
    /**
     * The ProductTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ProductTypeID;
    /**
     * The ContractPeriodID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ContractPeriodID;
    /**
     * The ContractStartTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ContractStartTypeID;
    /**
     * The ContractLengthTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ContractLengthTypeID;
    /**
     * The RevertToProductID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RevertToProductID;
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Active;
    /**
     * The DateApproved
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DateApproved;
    /**
     * The ApprovedByUserID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ApprovedByUserID;
    /**
     * The DepositModelID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DepositModelID;
    /**
     * The BillingFrequencyID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BillingFrequencyID;
    /**
     * The BillCalculationMethodID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BillCalculationMethodID;
    /**
     * The LineOfBusinessID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LineOfBusinessID;
    /**
     * The ProductFamilyID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ProductFamilyID;
    /**
     * The GreenEnergyPercent
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $GreenEnergyPercent;
    /**
     * The IsAutopayRequired
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsAutopayRequired;
    /**
     * The IsInitialPaymentRequired
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsInitialPaymentRequired;
    /**
     * The IsEbillRequired
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsEbillRequired;
    /**
     * The IsRenewal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsRenewal;
    /**
     * The EarlyTerminationFee
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $EarlyTerminationFee;
    /**
     * The EffectiveDateFrom
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EffectiveDateFrom;
    /**
     * The EffectiveDateTo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EffectiveDateTo;
    /**
     * The BillingTriggerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BillingTriggerID;
    /**
     * The BillingTriggerDaysOffset
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BillingTriggerDaysOffset;
    /**
     * The ReversionDateId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ReversionDateId;
    /**
     * The IsBundled
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsBundled;
    /**
     * The IsRevertCommissionModel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsRevertCommissionModel;
    /**
     * The CommodityID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CommodityID;
    /**
     * The DistributionServiceProviderID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DistributionServiceProviderID;
    /**
     * The ContractLengthTypeValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ContractLengthTypeValue;
    /**
     * The CurrentRate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $CurrentRate;
    /**
     * The Approved
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Approved;
    /**
     * The DunningModelId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DunningModelId;
    /**
     * The ProductEnrollmentMinimum
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ProductEnrollmentMinimum;
    /**
     * The DisconnectThreshold
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $DisconnectThreshold;
    /**
     * The HasDisconnectThreshold
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $HasDisconnectThreshold;
    /**
     * The ReconnectThreshold
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ReconnectThreshold;
    /**
     * The IsExternalEBillOnlyDocument
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsExternalEBillOnlyDocument;
    /**
     * The Kwh2000Price
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Kwh2000Price;
    /**
     * The ActiveAgreementsCount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ActiveAgreementsCount;
    /**
     * The IsExpired
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsExpired;
    /**
     * The ServiceAgreements
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfServiceAgreement
     */
    public $ServiceAgreements;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The ProductTypeName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProductTypeName;
    /**
     * The RevertToProductName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RevertToProductName;
    /**
     * The BillCalculationMethodName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillCalculationMethodName;
    /**
     * The ProductFamilyName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProductFamilyName;
    /**
     * The DisplayProductName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayProductName;
    /**
     * The DisplayProductDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayProductDescription;
    /**
     * The DisplayAveragePrice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayAveragePrice;
    /**
     * The AccountTypeNames
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountTypeNames;
    /**
     * The CompanyNames
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CompanyNames;
    /**
     * The Applications
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfApplication
     */
    public $Applications;
    /**
     * The productApplications
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $productApplications;
    /**
     * The CommodityName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CommodityName;
    /**
     * The ProductDocuments
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfProductDocument
     */
    public $ProductDocuments;
    /**
     * The AccountTypes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfProductAccountType
     */
    public $AccountTypes;
    /**
     * The Companies
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfCompany
     */
    public $Companies;
    /**
     * The ContractLengthName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContractLengthName;
    /**
     * The ContractPeriodName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContractPeriodName;
    /**
     * The DistributionServiceProviderName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DistributionServiceProviderName;
    /**
     * The ProductRates
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfProductRate
     */
    public $ProductRates;
    /**
     * The ContractLength
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContractLength;
    /**
     * The LineOfBusinessName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LineOfBusinessName;
    /**
     * The RateName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RateName;
    /**
     * The ApprovedByUserName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ApprovedByUserName;
    /**
     * The ProductAudit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfProductAudit
     */
    public $ProductAudit;
    /**
     * The LineOfBusinessCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LineOfBusinessCode;
    /**
     * The EnergyChargeAggregationOpt
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EnergyChargeAggregationOpt;
    /**
     * The ProductAvgPrices
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfProductAvgPrice
     */
    public $ProductAvgPrices;
    /**
     * The ProductDisplay
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\ProductDisplay
     */
    public $ProductDisplay;
    /**
     * The ExternalSystemTemplateID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExternalSystemTemplateID;
    /**
     * The ExternalSystemTemplateDesc
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExternalSystemTemplateDesc;
    /**
     * The ExternalSystemTOSTemplateID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExternalSystemTOSTemplateID;
    /**
     * The EFLExternalLink
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EFLExternalLink;
    /**
     * Constructor method for Product
     * @uses Product::setProductID()
     * @uses Product::setRateID()
     * @uses Product::setProductTypeID()
     * @uses Product::setContractPeriodID()
     * @uses Product::setContractStartTypeID()
     * @uses Product::setContractLengthTypeID()
     * @uses Product::setRevertToProductID()
     * @uses Product::setActive()
     * @uses Product::setDateApproved()
     * @uses Product::setApprovedByUserID()
     * @uses Product::setDepositModelID()
     * @uses Product::setBillingFrequencyID()
     * @uses Product::setBillCalculationMethodID()
     * @uses Product::setLineOfBusinessID()
     * @uses Product::setProductFamilyID()
     * @uses Product::setGreenEnergyPercent()
     * @uses Product::setIsAutopayRequired()
     * @uses Product::setIsInitialPaymentRequired()
     * @uses Product::setIsEbillRequired()
     * @uses Product::setIsRenewal()
     * @uses Product::setEarlyTerminationFee()
     * @uses Product::setEffectiveDateFrom()
     * @uses Product::setEffectiveDateTo()
     * @uses Product::setBillingTriggerID()
     * @uses Product::setBillingTriggerDaysOffset()
     * @uses Product::setReversionDateId()
     * @uses Product::setIsBundled()
     * @uses Product::setIsRevertCommissionModel()
     * @uses Product::setCommodityID()
     * @uses Product::setDistributionServiceProviderID()
     * @uses Product::setContractLengthTypeValue()
     * @uses Product::setCurrentRate()
     * @uses Product::setApproved()
     * @uses Product::setDunningModelId()
     * @uses Product::setProductEnrollmentMinimum()
     * @uses Product::setDisconnectThreshold()
     * @uses Product::setHasDisconnectThreshold()
     * @uses Product::setReconnectThreshold()
     * @uses Product::setIsExternalEBillOnlyDocument()
     * @uses Product::setKwh2000Price()
     * @uses Product::setActiveAgreementsCount()
     * @uses Product::setIsExpired()
     * @uses Product::setServiceAgreements()
     * @uses Product::setName()
     * @uses Product::setDescription()
     * @uses Product::setProductTypeName()
     * @uses Product::setRevertToProductName()
     * @uses Product::setBillCalculationMethodName()
     * @uses Product::setProductFamilyName()
     * @uses Product::setDisplayProductName()
     * @uses Product::setDisplayProductDescription()
     * @uses Product::setDisplayAveragePrice()
     * @uses Product::setAccountTypeNames()
     * @uses Product::setCompanyNames()
     * @uses Product::setApplications()
     * @uses Product::setProductApplications()
     * @uses Product::setCommodityName()
     * @uses Product::setProductDocuments()
     * @uses Product::setAccountTypes()
     * @uses Product::setCompanies()
     * @uses Product::setContractLengthName()
     * @uses Product::setContractPeriodName()
     * @uses Product::setDistributionServiceProviderName()
     * @uses Product::setProductRates()
     * @uses Product::setContractLength()
     * @uses Product::setLineOfBusinessName()
     * @uses Product::setRateName()
     * @uses Product::setApprovedByUserName()
     * @uses Product::setProductAudit()
     * @uses Product::setLineOfBusinessCode()
     * @uses Product::setEnergyChargeAggregationOpt()
     * @uses Product::setProductAvgPrices()
     * @uses Product::setProductDisplay()
     * @uses Product::setExternalSystemTemplateID()
     * @uses Product::setExternalSystemTemplateDesc()
     * @uses Product::setExternalSystemTOSTemplateID()
     * @uses Product::setEFLExternalLink()
     * @param int $productID
     * @param int $rateID
     * @param int $productTypeID
     * @param int $contractPeriodID
     * @param int $contractStartTypeID
     * @param int $contractLengthTypeID
     * @param int $revertToProductID
     * @param bool $active
     * @param string $dateApproved
     * @param int $approvedByUserID
     * @param int $depositModelID
     * @param int $billingFrequencyID
     * @param int $billCalculationMethodID
     * @param int $lineOfBusinessID
     * @param int $productFamilyID
     * @param float $greenEnergyPercent
     * @param bool $isAutopayRequired
     * @param bool $isInitialPaymentRequired
     * @param bool $isEbillRequired
     * @param bool $isRenewal
     * @param float $earlyTerminationFee
     * @param string $effectiveDateFrom
     * @param string $effectiveDateTo
     * @param int $billingTriggerID
     * @param int $billingTriggerDaysOffset
     * @param int $reversionDateId
     * @param bool $isBundled
     * @param bool $isRevertCommissionModel
     * @param int $commodityID
     * @param int $distributionServiceProviderID
     * @param int $contractLengthTypeValue
     * @param float $currentRate
     * @param bool $approved
     * @param int $dunningModelId
     * @param float $productEnrollmentMinimum
     * @param float $disconnectThreshold
     * @param bool $hasDisconnectThreshold
     * @param float $reconnectThreshold
     * @param bool $isExternalEBillOnlyDocument
     * @param float $kwh2000Price
     * @param int $activeAgreementsCount
     * @param bool $isExpired
     * @param \SGCIS\Array\ArrayOfServiceAgreement $serviceAgreements
     * @param string $name
     * @param string $description
     * @param string $productTypeName
     * @param string $revertToProductName
     * @param string $billCalculationMethodName
     * @param string $productFamilyName
     * @param string $displayProductName
     * @param string $displayProductDescription
     * @param string $displayAveragePrice
     * @param string $accountTypeNames
     * @param string $companyNames
     * @param \SGCIS\Array\ArrayOfApplication $applications
     * @param string $productApplications
     * @param string $commodityName
     * @param \SGCIS\Array\ArrayOfProductDocument $productDocuments
     * @param \SGCIS\Array\ArrayOfProductAccountType $accountTypes
     * @param \SGCIS\Array\ArrayOfCompany $companies
     * @param string $contractLengthName
     * @param string $contractPeriodName
     * @param string $distributionServiceProviderName
     * @param \SGCIS\Array\ArrayOfProductRate $productRates
     * @param string $contractLength
     * @param string $lineOfBusinessName
     * @param string $rateName
     * @param string $approvedByUserName
     * @param \SGCIS\Array\ArrayOfProductAudit $productAudit
     * @param string $lineOfBusinessCode
     * @param string $energyChargeAggregationOpt
     * @param \SGCIS\Array\ArrayOfProductAvgPrice $productAvgPrices
     * @param \SGCIS\Struct\ProductDisplay $productDisplay
     * @param string $externalSystemTemplateID
     * @param string $externalSystemTemplateDesc
     * @param string $externalSystemTOSTemplateID
     * @param string $eFLExternalLink
     */
    public function __construct($productID = null, $rateID = null, $productTypeID = null, $contractPeriodID = null, $contractStartTypeID = null, $contractLengthTypeID = null, $revertToProductID = null, $active = null, $dateApproved = null, $approvedByUserID = null, $depositModelID = null, $billingFrequencyID = null, $billCalculationMethodID = null, $lineOfBusinessID = null, $productFamilyID = null, $greenEnergyPercent = null, $isAutopayRequired = null, $isInitialPaymentRequired = null, $isEbillRequired = null, $isRenewal = null, $earlyTerminationFee = null, $effectiveDateFrom = null, $effectiveDateTo = null, $billingTriggerID = null, $billingTriggerDaysOffset = null, $reversionDateId = null, $isBundled = null, $isRevertCommissionModel = null, $commodityID = null, $distributionServiceProviderID = null, $contractLengthTypeValue = null, $currentRate = null, $approved = null, $dunningModelId = null, $productEnrollmentMinimum = null, $disconnectThreshold = null, $hasDisconnectThreshold = null, $reconnectThreshold = null, $isExternalEBillOnlyDocument = null, $kwh2000Price = null, $activeAgreementsCount = null, $isExpired = null, \SGCIS\Array\ArrayOfServiceAgreement $serviceAgreements = null, $name = null, $description = null, $productTypeName = null, $revertToProductName = null, $billCalculationMethodName = null, $productFamilyName = null, $displayProductName = null, $displayProductDescription = null, $displayAveragePrice = null, $accountTypeNames = null, $companyNames = null, \SGCIS\Array\ArrayOfApplication $applications = null, $productApplications = null, $commodityName = null, \SGCIS\Array\ArrayOfProductDocument $productDocuments = null, \SGCIS\Array\ArrayOfProductAccountType $accountTypes = null, \SGCIS\Array\ArrayOfCompany $companies = null, $contractLengthName = null, $contractPeriodName = null, $distributionServiceProviderName = null, \SGCIS\Array\ArrayOfProductRate $productRates = null, $contractLength = null, $lineOfBusinessName = null, $rateName = null, $approvedByUserName = null, \SGCIS\Array\ArrayOfProductAudit $productAudit = null, $lineOfBusinessCode = null, $energyChargeAggregationOpt = null, \SGCIS\Array\ArrayOfProductAvgPrice $productAvgPrices = null, \SGCIS\Struct\ProductDisplay $productDisplay = null, $externalSystemTemplateID = null, $externalSystemTemplateDesc = null, $externalSystemTOSTemplateID = null, $eFLExternalLink = null)
    {
        $this
            ->setProductID($productID)
            ->setRateID($rateID)
            ->setProductTypeID($productTypeID)
            ->setContractPeriodID($contractPeriodID)
            ->setContractStartTypeID($contractStartTypeID)
            ->setContractLengthTypeID($contractLengthTypeID)
            ->setRevertToProductID($revertToProductID)
            ->setActive($active)
            ->setDateApproved($dateApproved)
            ->setApprovedByUserID($approvedByUserID)
            ->setDepositModelID($depositModelID)
            ->setBillingFrequencyID($billingFrequencyID)
            ->setBillCalculationMethodID($billCalculationMethodID)
            ->setLineOfBusinessID($lineOfBusinessID)
            ->setProductFamilyID($productFamilyID)
            ->setGreenEnergyPercent($greenEnergyPercent)
            ->setIsAutopayRequired($isAutopayRequired)
            ->setIsInitialPaymentRequired($isInitialPaymentRequired)
            ->setIsEbillRequired($isEbillRequired)
            ->setIsRenewal($isRenewal)
            ->setEarlyTerminationFee($earlyTerminationFee)
            ->setEffectiveDateFrom($effectiveDateFrom)
            ->setEffectiveDateTo($effectiveDateTo)
            ->setBillingTriggerID($billingTriggerID)
            ->setBillingTriggerDaysOffset($billingTriggerDaysOffset)
            ->setReversionDateId($reversionDateId)
            ->setIsBundled($isBundled)
            ->setIsRevertCommissionModel($isRevertCommissionModel)
            ->setCommodityID($commodityID)
            ->setDistributionServiceProviderID($distributionServiceProviderID)
            ->setContractLengthTypeValue($contractLengthTypeValue)
            ->setCurrentRate($currentRate)
            ->setApproved($approved)
            ->setDunningModelId($dunningModelId)
            ->setProductEnrollmentMinimum($productEnrollmentMinimum)
            ->setDisconnectThreshold($disconnectThreshold)
            ->setHasDisconnectThreshold($hasDisconnectThreshold)
            ->setReconnectThreshold($reconnectThreshold)
            ->setIsExternalEBillOnlyDocument($isExternalEBillOnlyDocument)
            ->setKwh2000Price($kwh2000Price)
            ->setActiveAgreementsCount($activeAgreementsCount)
            ->setIsExpired($isExpired)
            ->setServiceAgreements($serviceAgreements)
            ->setName($name)
            ->setDescription($description)
            ->setProductTypeName($productTypeName)
            ->setRevertToProductName($revertToProductName)
            ->setBillCalculationMethodName($billCalculationMethodName)
            ->setProductFamilyName($productFamilyName)
            ->setDisplayProductName($displayProductName)
            ->setDisplayProductDescription($displayProductDescription)
            ->setDisplayAveragePrice($displayAveragePrice)
            ->setAccountTypeNames($accountTypeNames)
            ->setCompanyNames($companyNames)
            ->setApplications($applications)
            ->setProductApplications($productApplications)
            ->setCommodityName($commodityName)
            ->setProductDocuments($productDocuments)
            ->setAccountTypes($accountTypes)
            ->setCompanies($companies)
            ->setContractLengthName($contractLengthName)
            ->setContractPeriodName($contractPeriodName)
            ->setDistributionServiceProviderName($distributionServiceProviderName)
            ->setProductRates($productRates)
            ->setContractLength($contractLength)
            ->setLineOfBusinessName($lineOfBusinessName)
            ->setRateName($rateName)
            ->setApprovedByUserName($approvedByUserName)
            ->setProductAudit($productAudit)
            ->setLineOfBusinessCode($lineOfBusinessCode)
            ->setEnergyChargeAggregationOpt($energyChargeAggregationOpt)
            ->setProductAvgPrices($productAvgPrices)
            ->setProductDisplay($productDisplay)
            ->setExternalSystemTemplateID($externalSystemTemplateID)
            ->setExternalSystemTemplateDesc($externalSystemTemplateDesc)
            ->setExternalSystemTOSTemplateID($externalSystemTOSTemplateID)
            ->setEFLExternalLink($eFLExternalLink);
    }
    /**
     * Get ProductID value
     * @return int
     */
    public function getProductID()
    {
        return $this->ProductID;
    }
    /**
     * Set ProductID value
     * @param int $productID
     * @return \SGCIS\Struct\Product
     */
    public function setProductID($productID = null)
    {
        // validation for constraint: int
        if (!is_null($productID) && !is_numeric($productID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($productID)), __LINE__);
        }
        $this->ProductID = $productID;
        return $this;
    }
    /**
     * Get RateID value
     * @return int
     */
    public function getRateID()
    {
        return $this->RateID;
    }
    /**
     * Set RateID value
     * @param int $rateID
     * @return \SGCIS\Struct\Product
     */
    public function setRateID($rateID = null)
    {
        // validation for constraint: int
        if (!is_null($rateID) && !is_numeric($rateID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rateID)), __LINE__);
        }
        $this->RateID = $rateID;
        return $this;
    }
    /**
     * Get ProductTypeID value
     * @return int
     */
    public function getProductTypeID()
    {
        return $this->ProductTypeID;
    }
    /**
     * Set ProductTypeID value
     * @param int $productTypeID
     * @return \SGCIS\Struct\Product
     */
    public function setProductTypeID($productTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($productTypeID) && !is_numeric($productTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($productTypeID)), __LINE__);
        }
        $this->ProductTypeID = $productTypeID;
        return $this;
    }
    /**
     * Get ContractPeriodID value
     * @return int
     */
    public function getContractPeriodID()
    {
        return $this->ContractPeriodID;
    }
    /**
     * Set ContractPeriodID value
     * @param int $contractPeriodID
     * @return \SGCIS\Struct\Product
     */
    public function setContractPeriodID($contractPeriodID = null)
    {
        // validation for constraint: int
        if (!is_null($contractPeriodID) && !is_numeric($contractPeriodID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($contractPeriodID)), __LINE__);
        }
        $this->ContractPeriodID = $contractPeriodID;
        return $this;
    }
    /**
     * Get ContractStartTypeID value
     * @return int
     */
    public function getContractStartTypeID()
    {
        return $this->ContractStartTypeID;
    }
    /**
     * Set ContractStartTypeID value
     * @param int $contractStartTypeID
     * @return \SGCIS\Struct\Product
     */
    public function setContractStartTypeID($contractStartTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($contractStartTypeID) && !is_numeric($contractStartTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($contractStartTypeID)), __LINE__);
        }
        $this->ContractStartTypeID = $contractStartTypeID;
        return $this;
    }
    /**
     * Get ContractLengthTypeID value
     * @return int
     */
    public function getContractLengthTypeID()
    {
        return $this->ContractLengthTypeID;
    }
    /**
     * Set ContractLengthTypeID value
     * @param int $contractLengthTypeID
     * @return \SGCIS\Struct\Product
     */
    public function setContractLengthTypeID($contractLengthTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($contractLengthTypeID) && !is_numeric($contractLengthTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($contractLengthTypeID)), __LINE__);
        }
        $this->ContractLengthTypeID = $contractLengthTypeID;
        return $this;
    }
    /**
     * Get RevertToProductID value
     * @return int
     */
    public function getRevertToProductID()
    {
        return $this->RevertToProductID;
    }
    /**
     * Set RevertToProductID value
     * @param int $revertToProductID
     * @return \SGCIS\Struct\Product
     */
    public function setRevertToProductID($revertToProductID = null)
    {
        // validation for constraint: int
        if (!is_null($revertToProductID) && !is_numeric($revertToProductID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($revertToProductID)), __LINE__);
        }
        $this->RevertToProductID = $revertToProductID;
        return $this;
    }
    /**
     * Get Active value
     * @return bool
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \SGCIS\Struct\Product
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get DateApproved value
     * @return string
     */
    public function getDateApproved()
    {
        return $this->DateApproved;
    }
    /**
     * Set DateApproved value
     * @param string $dateApproved
     * @return \SGCIS\Struct\Product
     */
    public function setDateApproved($dateApproved = null)
    {
        // validation for constraint: string
        if (!is_null($dateApproved) && !is_string($dateApproved)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateApproved)), __LINE__);
        }
        $this->DateApproved = $dateApproved;
        return $this;
    }
    /**
     * Get ApprovedByUserID value
     * @return int
     */
    public function getApprovedByUserID()
    {
        return $this->ApprovedByUserID;
    }
    /**
     * Set ApprovedByUserID value
     * @param int $approvedByUserID
     * @return \SGCIS\Struct\Product
     */
    public function setApprovedByUserID($approvedByUserID = null)
    {
        // validation for constraint: int
        if (!is_null($approvedByUserID) && !is_numeric($approvedByUserID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($approvedByUserID)), __LINE__);
        }
        $this->ApprovedByUserID = $approvedByUserID;
        return $this;
    }
    /**
     * Get DepositModelID value
     * @return int
     */
    public function getDepositModelID()
    {
        return $this->DepositModelID;
    }
    /**
     * Set DepositModelID value
     * @param int $depositModelID
     * @return \SGCIS\Struct\Product
     */
    public function setDepositModelID($depositModelID = null)
    {
        // validation for constraint: int
        if (!is_null($depositModelID) && !is_numeric($depositModelID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($depositModelID)), __LINE__);
        }
        $this->DepositModelID = $depositModelID;
        return $this;
    }
    /**
     * Get BillingFrequencyID value
     * @return int
     */
    public function getBillingFrequencyID()
    {
        return $this->BillingFrequencyID;
    }
    /**
     * Set BillingFrequencyID value
     * @param int $billingFrequencyID
     * @return \SGCIS\Struct\Product
     */
    public function setBillingFrequencyID($billingFrequencyID = null)
    {
        // validation for constraint: int
        if (!is_null($billingFrequencyID) && !is_numeric($billingFrequencyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($billingFrequencyID)), __LINE__);
        }
        $this->BillingFrequencyID = $billingFrequencyID;
        return $this;
    }
    /**
     * Get BillCalculationMethodID value
     * @return int
     */
    public function getBillCalculationMethodID()
    {
        return $this->BillCalculationMethodID;
    }
    /**
     * Set BillCalculationMethodID value
     * @param int $billCalculationMethodID
     * @return \SGCIS\Struct\Product
     */
    public function setBillCalculationMethodID($billCalculationMethodID = null)
    {
        // validation for constraint: int
        if (!is_null($billCalculationMethodID) && !is_numeric($billCalculationMethodID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($billCalculationMethodID)), __LINE__);
        }
        $this->BillCalculationMethodID = $billCalculationMethodID;
        return $this;
    }
    /**
     * Get LineOfBusinessID value
     * @return int
     */
    public function getLineOfBusinessID()
    {
        return $this->LineOfBusinessID;
    }
    /**
     * Set LineOfBusinessID value
     * @param int $lineOfBusinessID
     * @return \SGCIS\Struct\Product
     */
    public function setLineOfBusinessID($lineOfBusinessID = null)
    {
        // validation for constraint: int
        if (!is_null($lineOfBusinessID) && !is_numeric($lineOfBusinessID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($lineOfBusinessID)), __LINE__);
        }
        $this->LineOfBusinessID = $lineOfBusinessID;
        return $this;
    }
    /**
     * Get ProductFamilyID value
     * @return int
     */
    public function getProductFamilyID()
    {
        return $this->ProductFamilyID;
    }
    /**
     * Set ProductFamilyID value
     * @param int $productFamilyID
     * @return \SGCIS\Struct\Product
     */
    public function setProductFamilyID($productFamilyID = null)
    {
        // validation for constraint: int
        if (!is_null($productFamilyID) && !is_numeric($productFamilyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($productFamilyID)), __LINE__);
        }
        $this->ProductFamilyID = $productFamilyID;
        return $this;
    }
    /**
     * Get GreenEnergyPercent value
     * @return float
     */
    public function getGreenEnergyPercent()
    {
        return $this->GreenEnergyPercent;
    }
    /**
     * Set GreenEnergyPercent value
     * @param float $greenEnergyPercent
     * @return \SGCIS\Struct\Product
     */
    public function setGreenEnergyPercent($greenEnergyPercent = null)
    {
        $this->GreenEnergyPercent = $greenEnergyPercent;
        return $this;
    }
    /**
     * Get IsAutopayRequired value
     * @return bool
     */
    public function getIsAutopayRequired()
    {
        return $this->IsAutopayRequired;
    }
    /**
     * Set IsAutopayRequired value
     * @param bool $isAutopayRequired
     * @return \SGCIS\Struct\Product
     */
    public function setIsAutopayRequired($isAutopayRequired = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAutopayRequired) && !is_bool($isAutopayRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isAutopayRequired)), __LINE__);
        }
        $this->IsAutopayRequired = $isAutopayRequired;
        return $this;
    }
    /**
     * Get IsInitialPaymentRequired value
     * @return bool
     */
    public function getIsInitialPaymentRequired()
    {
        return $this->IsInitialPaymentRequired;
    }
    /**
     * Set IsInitialPaymentRequired value
     * @param bool $isInitialPaymentRequired
     * @return \SGCIS\Struct\Product
     */
    public function setIsInitialPaymentRequired($isInitialPaymentRequired = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInitialPaymentRequired) && !is_bool($isInitialPaymentRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isInitialPaymentRequired)), __LINE__);
        }
        $this->IsInitialPaymentRequired = $isInitialPaymentRequired;
        return $this;
    }
    /**
     * Get IsEbillRequired value
     * @return bool
     */
    public function getIsEbillRequired()
    {
        return $this->IsEbillRequired;
    }
    /**
     * Set IsEbillRequired value
     * @param bool $isEbillRequired
     * @return \SGCIS\Struct\Product
     */
    public function setIsEbillRequired($isEbillRequired = null)
    {
        // validation for constraint: boolean
        if (!is_null($isEbillRequired) && !is_bool($isEbillRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isEbillRequired)), __LINE__);
        }
        $this->IsEbillRequired = $isEbillRequired;
        return $this;
    }
    /**
     * Get IsRenewal value
     * @return bool
     */
    public function getIsRenewal()
    {
        return $this->IsRenewal;
    }
    /**
     * Set IsRenewal value
     * @param bool $isRenewal
     * @return \SGCIS\Struct\Product
     */
    public function setIsRenewal($isRenewal = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRenewal) && !is_bool($isRenewal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isRenewal)), __LINE__);
        }
        $this->IsRenewal = $isRenewal;
        return $this;
    }
    /**
     * Get EarlyTerminationFee value
     * @return float
     */
    public function getEarlyTerminationFee()
    {
        return $this->EarlyTerminationFee;
    }
    /**
     * Set EarlyTerminationFee value
     * @param float $earlyTerminationFee
     * @return \SGCIS\Struct\Product
     */
    public function setEarlyTerminationFee($earlyTerminationFee = null)
    {
        $this->EarlyTerminationFee = $earlyTerminationFee;
        return $this;
    }
    /**
     * Get EffectiveDateFrom value
     * @return string
     */
    public function getEffectiveDateFrom()
    {
        return $this->EffectiveDateFrom;
    }
    /**
     * Set EffectiveDateFrom value
     * @param string $effectiveDateFrom
     * @return \SGCIS\Struct\Product
     */
    public function setEffectiveDateFrom($effectiveDateFrom = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDateFrom) && !is_string($effectiveDateFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effectiveDateFrom)), __LINE__);
        }
        $this->EffectiveDateFrom = $effectiveDateFrom;
        return $this;
    }
    /**
     * Get EffectiveDateTo value
     * @return string
     */
    public function getEffectiveDateTo()
    {
        return $this->EffectiveDateTo;
    }
    /**
     * Set EffectiveDateTo value
     * @param string $effectiveDateTo
     * @return \SGCIS\Struct\Product
     */
    public function setEffectiveDateTo($effectiveDateTo = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDateTo) && !is_string($effectiveDateTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effectiveDateTo)), __LINE__);
        }
        $this->EffectiveDateTo = $effectiveDateTo;
        return $this;
    }
    /**
     * Get BillingTriggerID value
     * @return int
     */
    public function getBillingTriggerID()
    {
        return $this->BillingTriggerID;
    }
    /**
     * Set BillingTriggerID value
     * @param int $billingTriggerID
     * @return \SGCIS\Struct\Product
     */
    public function setBillingTriggerID($billingTriggerID = null)
    {
        // validation for constraint: int
        if (!is_null($billingTriggerID) && !is_numeric($billingTriggerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($billingTriggerID)), __LINE__);
        }
        $this->BillingTriggerID = $billingTriggerID;
        return $this;
    }
    /**
     * Get BillingTriggerDaysOffset value
     * @return int
     */
    public function getBillingTriggerDaysOffset()
    {
        return $this->BillingTriggerDaysOffset;
    }
    /**
     * Set BillingTriggerDaysOffset value
     * @param int $billingTriggerDaysOffset
     * @return \SGCIS\Struct\Product
     */
    public function setBillingTriggerDaysOffset($billingTriggerDaysOffset = null)
    {
        // validation for constraint: int
        if (!is_null($billingTriggerDaysOffset) && !is_numeric($billingTriggerDaysOffset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($billingTriggerDaysOffset)), __LINE__);
        }
        $this->BillingTriggerDaysOffset = $billingTriggerDaysOffset;
        return $this;
    }
    /**
     * Get ReversionDateId value
     * @return int
     */
    public function getReversionDateId()
    {
        return $this->ReversionDateId;
    }
    /**
     * Set ReversionDateId value
     * @param int $reversionDateId
     * @return \SGCIS\Struct\Product
     */
    public function setReversionDateId($reversionDateId = null)
    {
        // validation for constraint: int
        if (!is_null($reversionDateId) && !is_numeric($reversionDateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($reversionDateId)), __LINE__);
        }
        $this->ReversionDateId = $reversionDateId;
        return $this;
    }
    /**
     * Get IsBundled value
     * @return bool
     */
    public function getIsBundled()
    {
        return $this->IsBundled;
    }
    /**
     * Set IsBundled value
     * @param bool $isBundled
     * @return \SGCIS\Struct\Product
     */
    public function setIsBundled($isBundled = null)
    {
        // validation for constraint: boolean
        if (!is_null($isBundled) && !is_bool($isBundled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isBundled)), __LINE__);
        }
        $this->IsBundled = $isBundled;
        return $this;
    }
    /**
     * Get IsRevertCommissionModel value
     * @return bool
     */
    public function getIsRevertCommissionModel()
    {
        return $this->IsRevertCommissionModel;
    }
    /**
     * Set IsRevertCommissionModel value
     * @param bool $isRevertCommissionModel
     * @return \SGCIS\Struct\Product
     */
    public function setIsRevertCommissionModel($isRevertCommissionModel = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRevertCommissionModel) && !is_bool($isRevertCommissionModel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isRevertCommissionModel)), __LINE__);
        }
        $this->IsRevertCommissionModel = $isRevertCommissionModel;
        return $this;
    }
    /**
     * Get CommodityID value
     * @return int
     */
    public function getCommodityID()
    {
        return $this->CommodityID;
    }
    /**
     * Set CommodityID value
     * @param int $commodityID
     * @return \SGCIS\Struct\Product
     */
    public function setCommodityID($commodityID = null)
    {
        // validation for constraint: int
        if (!is_null($commodityID) && !is_numeric($commodityID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($commodityID)), __LINE__);
        }
        $this->CommodityID = $commodityID;
        return $this;
    }
    /**
     * Get DistributionServiceProviderID value
     * @return int
     */
    public function getDistributionServiceProviderID()
    {
        return $this->DistributionServiceProviderID;
    }
    /**
     * Set DistributionServiceProviderID value
     * @param int $distributionServiceProviderID
     * @return \SGCIS\Struct\Product
     */
    public function setDistributionServiceProviderID($distributionServiceProviderID = null)
    {
        // validation for constraint: int
        if (!is_null($distributionServiceProviderID) && !is_numeric($distributionServiceProviderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($distributionServiceProviderID)), __LINE__);
        }
        $this->DistributionServiceProviderID = $distributionServiceProviderID;
        return $this;
    }
    /**
     * Get ContractLengthTypeValue value
     * @return int
     */
    public function getContractLengthTypeValue()
    {
        return $this->ContractLengthTypeValue;
    }
    /**
     * Set ContractLengthTypeValue value
     * @param int $contractLengthTypeValue
     * @return \SGCIS\Struct\Product
     */
    public function setContractLengthTypeValue($contractLengthTypeValue = null)
    {
        // validation for constraint: int
        if (!is_null($contractLengthTypeValue) && !is_numeric($contractLengthTypeValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($contractLengthTypeValue)), __LINE__);
        }
        $this->ContractLengthTypeValue = $contractLengthTypeValue;
        return $this;
    }
    /**
     * Get CurrentRate value
     * @return float
     */
    public function getCurrentRate()
    {
        return $this->CurrentRate;
    }
    /**
     * Set CurrentRate value
     * @param float $currentRate
     * @return \SGCIS\Struct\Product
     */
    public function setCurrentRate($currentRate = null)
    {
        $this->CurrentRate = $currentRate;
        return $this;
    }
    /**
     * Get Approved value
     * @return bool
     */
    public function getApproved()
    {
        return $this->Approved;
    }
    /**
     * Set Approved value
     * @param bool $approved
     * @return \SGCIS\Struct\Product
     */
    public function setApproved($approved = null)
    {
        // validation for constraint: boolean
        if (!is_null($approved) && !is_bool($approved)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($approved)), __LINE__);
        }
        $this->Approved = $approved;
        return $this;
    }
    /**
     * Get DunningModelId value
     * @return int
     */
    public function getDunningModelId()
    {
        return $this->DunningModelId;
    }
    /**
     * Set DunningModelId value
     * @param int $dunningModelId
     * @return \SGCIS\Struct\Product
     */
    public function setDunningModelId($dunningModelId = null)
    {
        // validation for constraint: int
        if (!is_null($dunningModelId) && !is_numeric($dunningModelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($dunningModelId)), __LINE__);
        }
        $this->DunningModelId = $dunningModelId;
        return $this;
    }
    /**
     * Get ProductEnrollmentMinimum value
     * @return float
     */
    public function getProductEnrollmentMinimum()
    {
        return $this->ProductEnrollmentMinimum;
    }
    /**
     * Set ProductEnrollmentMinimum value
     * @param float $productEnrollmentMinimum
     * @return \SGCIS\Struct\Product
     */
    public function setProductEnrollmentMinimum($productEnrollmentMinimum = null)
    {
        $this->ProductEnrollmentMinimum = $productEnrollmentMinimum;
        return $this;
    }
    /**
     * Get DisconnectThreshold value
     * @return float
     */
    public function getDisconnectThreshold()
    {
        return $this->DisconnectThreshold;
    }
    /**
     * Set DisconnectThreshold value
     * @param float $disconnectThreshold
     * @return \SGCIS\Struct\Product
     */
    public function setDisconnectThreshold($disconnectThreshold = null)
    {
        $this->DisconnectThreshold = $disconnectThreshold;
        return $this;
    }
    /**
     * Get HasDisconnectThreshold value
     * @return bool
     */
    public function getHasDisconnectThreshold()
    {
        return $this->HasDisconnectThreshold;
    }
    /**
     * Set HasDisconnectThreshold value
     * @param bool $hasDisconnectThreshold
     * @return \SGCIS\Struct\Product
     */
    public function setHasDisconnectThreshold($hasDisconnectThreshold = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasDisconnectThreshold) && !is_bool($hasDisconnectThreshold)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($hasDisconnectThreshold)), __LINE__);
        }
        $this->HasDisconnectThreshold = $hasDisconnectThreshold;
        return $this;
    }
    /**
     * Get ReconnectThreshold value
     * @return float
     */
    public function getReconnectThreshold()
    {
        return $this->ReconnectThreshold;
    }
    /**
     * Set ReconnectThreshold value
     * @param float $reconnectThreshold
     * @return \SGCIS\Struct\Product
     */
    public function setReconnectThreshold($reconnectThreshold = null)
    {
        $this->ReconnectThreshold = $reconnectThreshold;
        return $this;
    }
    /**
     * Get IsExternalEBillOnlyDocument value
     * @return bool
     */
    public function getIsExternalEBillOnlyDocument()
    {
        return $this->IsExternalEBillOnlyDocument;
    }
    /**
     * Set IsExternalEBillOnlyDocument value
     * @param bool $isExternalEBillOnlyDocument
     * @return \SGCIS\Struct\Product
     */
    public function setIsExternalEBillOnlyDocument($isExternalEBillOnlyDocument = null)
    {
        // validation for constraint: boolean
        if (!is_null($isExternalEBillOnlyDocument) && !is_bool($isExternalEBillOnlyDocument)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isExternalEBillOnlyDocument)), __LINE__);
        }
        $this->IsExternalEBillOnlyDocument = $isExternalEBillOnlyDocument;
        return $this;
    }
    /**
     * Get Kwh2000Price value
     * @return float
     */
    public function getKwh2000Price()
    {
        return $this->Kwh2000Price;
    }
    /**
     * Set Kwh2000Price value
     * @param float $kwh2000Price
     * @return \SGCIS\Struct\Product
     */
    public function setKwh2000Price($kwh2000Price = null)
    {
        $this->Kwh2000Price = $kwh2000Price;
        return $this;
    }
    /**
     * Get ActiveAgreementsCount value
     * @return int
     */
    public function getActiveAgreementsCount()
    {
        return $this->ActiveAgreementsCount;
    }
    /**
     * Set ActiveAgreementsCount value
     * @param int $activeAgreementsCount
     * @return \SGCIS\Struct\Product
     */
    public function setActiveAgreementsCount($activeAgreementsCount = null)
    {
        // validation for constraint: int
        if (!is_null($activeAgreementsCount) && !is_numeric($activeAgreementsCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($activeAgreementsCount)), __LINE__);
        }
        $this->ActiveAgreementsCount = $activeAgreementsCount;
        return $this;
    }
    /**
     * Get IsExpired value
     * @return bool
     */
    public function getIsExpired()
    {
        return $this->IsExpired;
    }
    /**
     * Set IsExpired value
     * @param bool $isExpired
     * @return \SGCIS\Struct\Product
     */
    public function setIsExpired($isExpired = null)
    {
        // validation for constraint: boolean
        if (!is_null($isExpired) && !is_bool($isExpired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isExpired)), __LINE__);
        }
        $this->IsExpired = $isExpired;
        return $this;
    }
    /**
     * Get ServiceAgreements value
     * @return \SGCIS\Array\ArrayOfServiceAgreement|null
     */
    public function getServiceAgreements()
    {
        return $this->ServiceAgreements;
    }
    /**
     * Set ServiceAgreements value
     * @param \SGCIS\Array\ArrayOfServiceAgreement $serviceAgreements
     * @return \SGCIS\Struct\Product
     */
    public function setServiceAgreements(\SGCIS\Array\ArrayOfServiceAgreement $serviceAgreements = null)
    {
        $this->ServiceAgreements = $serviceAgreements;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \SGCIS\Struct\Product
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \SGCIS\Struct\Product
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get ProductTypeName value
     * @return string|null
     */
    public function getProductTypeName()
    {
        return $this->ProductTypeName;
    }
    /**
     * Set ProductTypeName value
     * @param string $productTypeName
     * @return \SGCIS\Struct\Product
     */
    public function setProductTypeName($productTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($productTypeName) && !is_string($productTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productTypeName)), __LINE__);
        }
        $this->ProductTypeName = $productTypeName;
        return $this;
    }
    /**
     * Get RevertToProductName value
     * @return string|null
     */
    public function getRevertToProductName()
    {
        return $this->RevertToProductName;
    }
    /**
     * Set RevertToProductName value
     * @param string $revertToProductName
     * @return \SGCIS\Struct\Product
     */
    public function setRevertToProductName($revertToProductName = null)
    {
        // validation for constraint: string
        if (!is_null($revertToProductName) && !is_string($revertToProductName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($revertToProductName)), __LINE__);
        }
        $this->RevertToProductName = $revertToProductName;
        return $this;
    }
    /**
     * Get BillCalculationMethodName value
     * @return string|null
     */
    public function getBillCalculationMethodName()
    {
        return $this->BillCalculationMethodName;
    }
    /**
     * Set BillCalculationMethodName value
     * @param string $billCalculationMethodName
     * @return \SGCIS\Struct\Product
     */
    public function setBillCalculationMethodName($billCalculationMethodName = null)
    {
        // validation for constraint: string
        if (!is_null($billCalculationMethodName) && !is_string($billCalculationMethodName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billCalculationMethodName)), __LINE__);
        }
        $this->BillCalculationMethodName = $billCalculationMethodName;
        return $this;
    }
    /**
     * Get ProductFamilyName value
     * @return string|null
     */
    public function getProductFamilyName()
    {
        return $this->ProductFamilyName;
    }
    /**
     * Set ProductFamilyName value
     * @param string $productFamilyName
     * @return \SGCIS\Struct\Product
     */
    public function setProductFamilyName($productFamilyName = null)
    {
        // validation for constraint: string
        if (!is_null($productFamilyName) && !is_string($productFamilyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productFamilyName)), __LINE__);
        }
        $this->ProductFamilyName = $productFamilyName;
        return $this;
    }
    /**
     * Get DisplayProductName value
     * @return string|null
     */
    public function getDisplayProductName()
    {
        return $this->DisplayProductName;
    }
    /**
     * Set DisplayProductName value
     * @param string $displayProductName
     * @return \SGCIS\Struct\Product
     */
    public function setDisplayProductName($displayProductName = null)
    {
        // validation for constraint: string
        if (!is_null($displayProductName) && !is_string($displayProductName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($displayProductName)), __LINE__);
        }
        $this->DisplayProductName = $displayProductName;
        return $this;
    }
    /**
     * Get DisplayProductDescription value
     * @return string|null
     */
    public function getDisplayProductDescription()
    {
        return $this->DisplayProductDescription;
    }
    /**
     * Set DisplayProductDescription value
     * @param string $displayProductDescription
     * @return \SGCIS\Struct\Product
     */
    public function setDisplayProductDescription($displayProductDescription = null)
    {
        // validation for constraint: string
        if (!is_null($displayProductDescription) && !is_string($displayProductDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($displayProductDescription)), __LINE__);
        }
        $this->DisplayProductDescription = $displayProductDescription;
        return $this;
    }
    /**
     * Get DisplayAveragePrice value
     * @return string|null
     */
    public function getDisplayAveragePrice()
    {
        return $this->DisplayAveragePrice;
    }
    /**
     * Set DisplayAveragePrice value
     * @param string $displayAveragePrice
     * @return \SGCIS\Struct\Product
     */
    public function setDisplayAveragePrice($displayAveragePrice = null)
    {
        // validation for constraint: string
        if (!is_null($displayAveragePrice) && !is_string($displayAveragePrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($displayAveragePrice)), __LINE__);
        }
        $this->DisplayAveragePrice = $displayAveragePrice;
        return $this;
    }
    /**
     * Get AccountTypeNames value
     * @return string|null
     */
    public function getAccountTypeNames()
    {
        return $this->AccountTypeNames;
    }
    /**
     * Set AccountTypeNames value
     * @param string $accountTypeNames
     * @return \SGCIS\Struct\Product
     */
    public function setAccountTypeNames($accountTypeNames = null)
    {
        // validation for constraint: string
        if (!is_null($accountTypeNames) && !is_string($accountTypeNames)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountTypeNames)), __LINE__);
        }
        $this->AccountTypeNames = $accountTypeNames;
        return $this;
    }
    /**
     * Get CompanyNames value
     * @return string|null
     */
    public function getCompanyNames()
    {
        return $this->CompanyNames;
    }
    /**
     * Set CompanyNames value
     * @param string $companyNames
     * @return \SGCIS\Struct\Product
     */
    public function setCompanyNames($companyNames = null)
    {
        // validation for constraint: string
        if (!is_null($companyNames) && !is_string($companyNames)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($companyNames)), __LINE__);
        }
        $this->CompanyNames = $companyNames;
        return $this;
    }
    /**
     * Get Applications value
     * @return \SGCIS\Array\ArrayOfApplication|null
     */
    public function getApplications()
    {
        return $this->Applications;
    }
    /**
     * Set Applications value
     * @param \SGCIS\Array\ArrayOfApplication $applications
     * @return \SGCIS\Struct\Product
     */
    public function setApplications(\SGCIS\Array\ArrayOfApplication $applications = null)
    {
        $this->Applications = $applications;
        return $this;
    }
    /**
     * Get productApplications value
     * @return string|null
     */
    public function getProductApplications()
    {
        return $this->productApplications;
    }
    /**
     * Set productApplications value
     * @param string $productApplications
     * @return \SGCIS\Struct\Product
     */
    public function setProductApplications($productApplications = null)
    {
        // validation for constraint: string
        if (!is_null($productApplications) && !is_string($productApplications)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productApplications)), __LINE__);
        }
        $this->productApplications = $productApplications;
        return $this;
    }
    /**
     * Get CommodityName value
     * @return string|null
     */
    public function getCommodityName()
    {
        return $this->CommodityName;
    }
    /**
     * Set CommodityName value
     * @param string $commodityName
     * @return \SGCIS\Struct\Product
     */
    public function setCommodityName($commodityName = null)
    {
        // validation for constraint: string
        if (!is_null($commodityName) && !is_string($commodityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($commodityName)), __LINE__);
        }
        $this->CommodityName = $commodityName;
        return $this;
    }
    /**
     * Get ProductDocuments value
     * @return \SGCIS\Array\ArrayOfProductDocument|null
     */
    public function getProductDocuments()
    {
        return $this->ProductDocuments;
    }
    /**
     * Set ProductDocuments value
     * @param \SGCIS\Array\ArrayOfProductDocument $productDocuments
     * @return \SGCIS\Struct\Product
     */
    public function setProductDocuments(\SGCIS\Array\ArrayOfProductDocument $productDocuments = null)
    {
        $this->ProductDocuments = $productDocuments;
        return $this;
    }
    /**
     * Get AccountTypes value
     * @return \SGCIS\Array\ArrayOfProductAccountType|null
     */
    public function getAccountTypes()
    {
        return $this->AccountTypes;
    }
    /**
     * Set AccountTypes value
     * @param \SGCIS\Array\ArrayOfProductAccountType $accountTypes
     * @return \SGCIS\Struct\Product
     */
    public function setAccountTypes(\SGCIS\Array\ArrayOfProductAccountType $accountTypes = null)
    {
        $this->AccountTypes = $accountTypes;
        return $this;
    }
    /**
     * Get Companies value
     * @return \SGCIS\Array\ArrayOfCompany|null
     */
    public function getCompanies()
    {
        return $this->Companies;
    }
    /**
     * Set Companies value
     * @param \SGCIS\Array\ArrayOfCompany $companies
     * @return \SGCIS\Struct\Product
     */
    public function setCompanies(\SGCIS\Array\ArrayOfCompany $companies = null)
    {
        $this->Companies = $companies;
        return $this;
    }
    /**
     * Get ContractLengthName value
     * @return string|null
     */
    public function getContractLengthName()
    {
        return $this->ContractLengthName;
    }
    /**
     * Set ContractLengthName value
     * @param string $contractLengthName
     * @return \SGCIS\Struct\Product
     */
    public function setContractLengthName($contractLengthName = null)
    {
        // validation for constraint: string
        if (!is_null($contractLengthName) && !is_string($contractLengthName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contractLengthName)), __LINE__);
        }
        $this->ContractLengthName = $contractLengthName;
        return $this;
    }
    /**
     * Get ContractPeriodName value
     * @return string|null
     */
    public function getContractPeriodName()
    {
        return $this->ContractPeriodName;
    }
    /**
     * Set ContractPeriodName value
     * @param string $contractPeriodName
     * @return \SGCIS\Struct\Product
     */
    public function setContractPeriodName($contractPeriodName = null)
    {
        // validation for constraint: string
        if (!is_null($contractPeriodName) && !is_string($contractPeriodName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contractPeriodName)), __LINE__);
        }
        $this->ContractPeriodName = $contractPeriodName;
        return $this;
    }
    /**
     * Get DistributionServiceProviderName value
     * @return string|null
     */
    public function getDistributionServiceProviderName()
    {
        return $this->DistributionServiceProviderName;
    }
    /**
     * Set DistributionServiceProviderName value
     * @param string $distributionServiceProviderName
     * @return \SGCIS\Struct\Product
     */
    public function setDistributionServiceProviderName($distributionServiceProviderName = null)
    {
        // validation for constraint: string
        if (!is_null($distributionServiceProviderName) && !is_string($distributionServiceProviderName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($distributionServiceProviderName)), __LINE__);
        }
        $this->DistributionServiceProviderName = $distributionServiceProviderName;
        return $this;
    }
    /**
     * Get ProductRates value
     * @return \SGCIS\Array\ArrayOfProductRate|null
     */
    public function getProductRates()
    {
        return $this->ProductRates;
    }
    /**
     * Set ProductRates value
     * @param \SGCIS\Array\ArrayOfProductRate $productRates
     * @return \SGCIS\Struct\Product
     */
    public function setProductRates(\SGCIS\Array\ArrayOfProductRate $productRates = null)
    {
        $this->ProductRates = $productRates;
        return $this;
    }
    /**
     * Get ContractLength value
     * @return string|null
     */
    public function getContractLength()
    {
        return $this->ContractLength;
    }
    /**
     * Set ContractLength value
     * @param string $contractLength
     * @return \SGCIS\Struct\Product
     */
    public function setContractLength($contractLength = null)
    {
        // validation for constraint: string
        if (!is_null($contractLength) && !is_string($contractLength)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contractLength)), __LINE__);
        }
        $this->ContractLength = $contractLength;
        return $this;
    }
    /**
     * Get LineOfBusinessName value
     * @return string|null
     */
    public function getLineOfBusinessName()
    {
        return $this->LineOfBusinessName;
    }
    /**
     * Set LineOfBusinessName value
     * @param string $lineOfBusinessName
     * @return \SGCIS\Struct\Product
     */
    public function setLineOfBusinessName($lineOfBusinessName = null)
    {
        // validation for constraint: string
        if (!is_null($lineOfBusinessName) && !is_string($lineOfBusinessName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lineOfBusinessName)), __LINE__);
        }
        $this->LineOfBusinessName = $lineOfBusinessName;
        return $this;
    }
    /**
     * Get RateName value
     * @return string|null
     */
    public function getRateName()
    {
        return $this->RateName;
    }
    /**
     * Set RateName value
     * @param string $rateName
     * @return \SGCIS\Struct\Product
     */
    public function setRateName($rateName = null)
    {
        // validation for constraint: string
        if (!is_null($rateName) && !is_string($rateName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rateName)), __LINE__);
        }
        $this->RateName = $rateName;
        return $this;
    }
    /**
     * Get ApprovedByUserName value
     * @return string|null
     */
    public function getApprovedByUserName()
    {
        return $this->ApprovedByUserName;
    }
    /**
     * Set ApprovedByUserName value
     * @param string $approvedByUserName
     * @return \SGCIS\Struct\Product
     */
    public function setApprovedByUserName($approvedByUserName = null)
    {
        // validation for constraint: string
        if (!is_null($approvedByUserName) && !is_string($approvedByUserName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($approvedByUserName)), __LINE__);
        }
        $this->ApprovedByUserName = $approvedByUserName;
        return $this;
    }
    /**
     * Get ProductAudit value
     * @return \SGCIS\Array\ArrayOfProductAudit|null
     */
    public function getProductAudit()
    {
        return $this->ProductAudit;
    }
    /**
     * Set ProductAudit value
     * @param \SGCIS\Array\ArrayOfProductAudit $productAudit
     * @return \SGCIS\Struct\Product
     */
    public function setProductAudit(\SGCIS\Array\ArrayOfProductAudit $productAudit = null)
    {
        $this->ProductAudit = $productAudit;
        return $this;
    }
    /**
     * Get LineOfBusinessCode value
     * @return string|null
     */
    public function getLineOfBusinessCode()
    {
        return $this->LineOfBusinessCode;
    }
    /**
     * Set LineOfBusinessCode value
     * @param string $lineOfBusinessCode
     * @return \SGCIS\Struct\Product
     */
    public function setLineOfBusinessCode($lineOfBusinessCode = null)
    {
        // validation for constraint: string
        if (!is_null($lineOfBusinessCode) && !is_string($lineOfBusinessCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lineOfBusinessCode)), __LINE__);
        }
        $this->LineOfBusinessCode = $lineOfBusinessCode;
        return $this;
    }
    /**
     * Get EnergyChargeAggregationOpt value
     * @return string|null
     */
    public function getEnergyChargeAggregationOpt()
    {
        return $this->EnergyChargeAggregationOpt;
    }
    /**
     * Set EnergyChargeAggregationOpt value
     * @param string $energyChargeAggregationOpt
     * @return \SGCIS\Struct\Product
     */
    public function setEnergyChargeAggregationOpt($energyChargeAggregationOpt = null)
    {
        // validation for constraint: string
        if (!is_null($energyChargeAggregationOpt) && !is_string($energyChargeAggregationOpt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($energyChargeAggregationOpt)), __LINE__);
        }
        $this->EnergyChargeAggregationOpt = $energyChargeAggregationOpt;
        return $this;
    }
    /**
     * Get ProductAvgPrices value
     * @return \SGCIS\Array\ArrayOfProductAvgPrice|null
     */
    public function getProductAvgPrices()
    {
        return $this->ProductAvgPrices;
    }
    /**
     * Set ProductAvgPrices value
     * @param \SGCIS\Array\ArrayOfProductAvgPrice $productAvgPrices
     * @return \SGCIS\Struct\Product
     */
    public function setProductAvgPrices(\SGCIS\Array\ArrayOfProductAvgPrice $productAvgPrices = null)
    {
        $this->ProductAvgPrices = $productAvgPrices;
        return $this;
    }
    /**
     * Get ProductDisplay value
     * @return \SGCIS\Struct\ProductDisplay|null
     */
    public function getProductDisplay()
    {
        return $this->ProductDisplay;
    }
    /**
     * Set ProductDisplay value
     * @param \SGCIS\Struct\ProductDisplay $productDisplay
     * @return \SGCIS\Struct\Product
     */
    public function setProductDisplay(\SGCIS\Struct\ProductDisplay $productDisplay = null)
    {
        $this->ProductDisplay = $productDisplay;
        return $this;
    }
    /**
     * Get ExternalSystemTemplateID value
     * @return string|null
     */
    public function getExternalSystemTemplateID()
    {
        return $this->ExternalSystemTemplateID;
    }
    /**
     * Set ExternalSystemTemplateID value
     * @param string $externalSystemTemplateID
     * @return \SGCIS\Struct\Product
     */
    public function setExternalSystemTemplateID($externalSystemTemplateID = null)
    {
        // validation for constraint: string
        if (!is_null($externalSystemTemplateID) && !is_string($externalSystemTemplateID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($externalSystemTemplateID)), __LINE__);
        }
        $this->ExternalSystemTemplateID = $externalSystemTemplateID;
        return $this;
    }
    /**
     * Get ExternalSystemTemplateDesc value
     * @return string|null
     */
    public function getExternalSystemTemplateDesc()
    {
        return $this->ExternalSystemTemplateDesc;
    }
    /**
     * Set ExternalSystemTemplateDesc value
     * @param string $externalSystemTemplateDesc
     * @return \SGCIS\Struct\Product
     */
    public function setExternalSystemTemplateDesc($externalSystemTemplateDesc = null)
    {
        // validation for constraint: string
        if (!is_null($externalSystemTemplateDesc) && !is_string($externalSystemTemplateDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($externalSystemTemplateDesc)), __LINE__);
        }
        $this->ExternalSystemTemplateDesc = $externalSystemTemplateDesc;
        return $this;
    }
    /**
     * Get ExternalSystemTOSTemplateID value
     * @return string|null
     */
    public function getExternalSystemTOSTemplateID()
    {
        return $this->ExternalSystemTOSTemplateID;
    }
    /**
     * Set ExternalSystemTOSTemplateID value
     * @param string $externalSystemTOSTemplateID
     * @return \SGCIS\Struct\Product
     */
    public function setExternalSystemTOSTemplateID($externalSystemTOSTemplateID = null)
    {
        // validation for constraint: string
        if (!is_null($externalSystemTOSTemplateID) && !is_string($externalSystemTOSTemplateID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($externalSystemTOSTemplateID)), __LINE__);
        }
        $this->ExternalSystemTOSTemplateID = $externalSystemTOSTemplateID;
        return $this;
    }
    /**
     * Get EFLExternalLink value
     * @return string|null
     */
    public function getEFLExternalLink()
    {
        return $this->EFLExternalLink;
    }
    /**
     * Set EFLExternalLink value
     * @param string $eFLExternalLink
     * @return \SGCIS\Struct\Product
     */
    public function setEFLExternalLink($eFLExternalLink = null)
    {
        // validation for constraint: string
        if (!is_null($eFLExternalLink) && !is_string($eFLExternalLink)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eFLExternalLink)), __LINE__);
        }
        $this->EFLExternalLink = $eFLExternalLink;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\Product
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
