<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PersonContact Struct
 * @subpackage Structs
 */
class PersonContact extends BaseDTO
{
    /**
     * The PersonContactID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PersonContactID;
    /**
     * The PersonID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PersonID;
    /**
     * The ContactTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ContactTypeID;
    /**
     * The AccountID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountID;
    /**
     * The ContactTypeName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContactTypeName;
    /**
     * The ContactValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContactValue;
    /**
     * The ContactType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\ContactType
     */
    public $ContactType;
    /**
     * Constructor method for PersonContact
     * @uses PersonContact::setPersonContactID()
     * @uses PersonContact::setPersonID()
     * @uses PersonContact::setContactTypeID()
     * @uses PersonContact::setAccountID()
     * @uses PersonContact::setContactTypeName()
     * @uses PersonContact::setContactValue()
     * @uses PersonContact::setContactType()
     * @param int $personContactID
     * @param int $personID
     * @param int $contactTypeID
     * @param int $accountID
     * @param string $contactTypeName
     * @param string $contactValue
     * @param \SGCIS\Struct\ContactType $contactType
     */
    public function __construct($personContactID = null, $personID = null, $contactTypeID = null, $accountID = null, $contactTypeName = null, $contactValue = null, \SGCIS\Struct\ContactType $contactType = null)
    {
        $this
            ->setPersonContactID($personContactID)
            ->setPersonID($personID)
            ->setContactTypeID($contactTypeID)
            ->setAccountID($accountID)
            ->setContactTypeName($contactTypeName)
            ->setContactValue($contactValue)
            ->setContactType($contactType);
    }
    /**
     * Get PersonContactID value
     * @return int
     */
    public function getPersonContactID()
    {
        return $this->PersonContactID;
    }
    /**
     * Set PersonContactID value
     * @param int $personContactID
     * @return \SGCIS\Struct\PersonContact
     */
    public function setPersonContactID($personContactID = null)
    {
        // validation for constraint: int
        if (!is_null($personContactID) && !is_numeric($personContactID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($personContactID)), __LINE__);
        }
        $this->PersonContactID = $personContactID;
        return $this;
    }
    /**
     * Get PersonID value
     * @return int
     */
    public function getPersonID()
    {
        return $this->PersonID;
    }
    /**
     * Set PersonID value
     * @param int $personID
     * @return \SGCIS\Struct\PersonContact
     */
    public function setPersonID($personID = null)
    {
        // validation for constraint: int
        if (!is_null($personID) && !is_numeric($personID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($personID)), __LINE__);
        }
        $this->PersonID = $personID;
        return $this;
    }
    /**
     * Get ContactTypeID value
     * @return int
     */
    public function getContactTypeID()
    {
        return $this->ContactTypeID;
    }
    /**
     * Set ContactTypeID value
     * @param int $contactTypeID
     * @return \SGCIS\Struct\PersonContact
     */
    public function setContactTypeID($contactTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($contactTypeID) && !is_numeric($contactTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($contactTypeID)), __LINE__);
        }
        $this->ContactTypeID = $contactTypeID;
        return $this;
    }
    /**
     * Get AccountID value
     * @return int
     */
    public function getAccountID()
    {
        return $this->AccountID;
    }
    /**
     * Set AccountID value
     * @param int $accountID
     * @return \SGCIS\Struct\PersonContact
     */
    public function setAccountID($accountID = null)
    {
        // validation for constraint: int
        if (!is_null($accountID) && !is_numeric($accountID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountID)), __LINE__);
        }
        $this->AccountID = $accountID;
        return $this;
    }
    /**
     * Get ContactTypeName value
     * @return string|null
     */
    public function getContactTypeName()
    {
        return $this->ContactTypeName;
    }
    /**
     * Set ContactTypeName value
     * @param string $contactTypeName
     * @return \SGCIS\Struct\PersonContact
     */
    public function setContactTypeName($contactTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($contactTypeName) && !is_string($contactTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contactTypeName)), __LINE__);
        }
        $this->ContactTypeName = $contactTypeName;
        return $this;
    }
    /**
     * Get ContactValue value
     * @return string|null
     */
    public function getContactValue()
    {
        return $this->ContactValue;
    }
    /**
     * Set ContactValue value
     * @param string $contactValue
     * @return \SGCIS\Struct\PersonContact
     */
    public function setContactValue($contactValue = null)
    {
        // validation for constraint: string
        if (!is_null($contactValue) && !is_string($contactValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contactValue)), __LINE__);
        }
        $this->ContactValue = $contactValue;
        return $this;
    }
    /**
     * Get ContactType value
     * @return \SGCIS\Struct\ContactType|null
     */
    public function getContactType()
    {
        return $this->ContactType;
    }
    /**
     * Set ContactType value
     * @param \SGCIS\Struct\ContactType $contactType
     * @return \SGCIS\Struct\PersonContact
     */
    public function setContactType(\SGCIS\Struct\ContactType $contactType = null)
    {
        $this->ContactType = $contactType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\PersonContact
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
