<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentVendorProcess Struct
 * @subpackage Structs
 */
class PaymentVendorProcess extends AbstractStructBase
{
    /**
     * The PaymentVendorProcessID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PaymentVendorProcessID;
    /**
     * The PaymentVendorProcessTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PaymentVendorProcessTypeID;
    /**
     * The CompanyID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CompanyID;
    /**
     * The EffectiveFrom
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EffectiveFrom;
    /**
     * The EffectiveTo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EffectiveTo;
    /**
     * The PaymentGatewayUserID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentGatewayUserID;
    /**
     * The PaymentGatewayPassword
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentGatewayPassword;
    /**
     * The PaymentGatewaySystemID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentGatewaySystemID;
    /**
     * The AgentID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AgentID;
    /**
     * The VendorName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VendorName;
    /**
     * Constructor method for PaymentVendorProcess
     * @uses PaymentVendorProcess::setPaymentVendorProcessID()
     * @uses PaymentVendorProcess::setPaymentVendorProcessTypeID()
     * @uses PaymentVendorProcess::setCompanyID()
     * @uses PaymentVendorProcess::setEffectiveFrom()
     * @uses PaymentVendorProcess::setEffectiveTo()
     * @uses PaymentVendorProcess::setPaymentGatewayUserID()
     * @uses PaymentVendorProcess::setPaymentGatewayPassword()
     * @uses PaymentVendorProcess::setPaymentGatewaySystemID()
     * @uses PaymentVendorProcess::setAgentID()
     * @uses PaymentVendorProcess::setVendorName()
     * @param int $paymentVendorProcessID
     * @param int $paymentVendorProcessTypeID
     * @param int $companyID
     * @param string $effectiveFrom
     * @param string $effectiveTo
     * @param string $paymentGatewayUserID
     * @param string $paymentGatewayPassword
     * @param string $paymentGatewaySystemID
     * @param string $agentID
     * @param string $vendorName
     */
    public function __construct($paymentVendorProcessID = null, $paymentVendorProcessTypeID = null, $companyID = null, $effectiveFrom = null, $effectiveTo = null, $paymentGatewayUserID = null, $paymentGatewayPassword = null, $paymentGatewaySystemID = null, $agentID = null, $vendorName = null)
    {
        $this
            ->setPaymentVendorProcessID($paymentVendorProcessID)
            ->setPaymentVendorProcessTypeID($paymentVendorProcessTypeID)
            ->setCompanyID($companyID)
            ->setEffectiveFrom($effectiveFrom)
            ->setEffectiveTo($effectiveTo)
            ->setPaymentGatewayUserID($paymentGatewayUserID)
            ->setPaymentGatewayPassword($paymentGatewayPassword)
            ->setPaymentGatewaySystemID($paymentGatewaySystemID)
            ->setAgentID($agentID)
            ->setVendorName($vendorName);
    }
    /**
     * Get PaymentVendorProcessID value
     * @return int
     */
    public function getPaymentVendorProcessID()
    {
        return $this->PaymentVendorProcessID;
    }
    /**
     * Set PaymentVendorProcessID value
     * @param int $paymentVendorProcessID
     * @return \SGCIS\Struct\PaymentVendorProcess
     */
    public function setPaymentVendorProcessID($paymentVendorProcessID = null)
    {
        // validation for constraint: int
        if (!is_null($paymentVendorProcessID) && !is_numeric($paymentVendorProcessID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($paymentVendorProcessID)), __LINE__);
        }
        $this->PaymentVendorProcessID = $paymentVendorProcessID;
        return $this;
    }
    /**
     * Get PaymentVendorProcessTypeID value
     * @return int
     */
    public function getPaymentVendorProcessTypeID()
    {
        return $this->PaymentVendorProcessTypeID;
    }
    /**
     * Set PaymentVendorProcessTypeID value
     * @param int $paymentVendorProcessTypeID
     * @return \SGCIS\Struct\PaymentVendorProcess
     */
    public function setPaymentVendorProcessTypeID($paymentVendorProcessTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($paymentVendorProcessTypeID) && !is_numeric($paymentVendorProcessTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($paymentVendorProcessTypeID)), __LINE__);
        }
        $this->PaymentVendorProcessTypeID = $paymentVendorProcessTypeID;
        return $this;
    }
    /**
     * Get CompanyID value
     * @return int
     */
    public function getCompanyID()
    {
        return $this->CompanyID;
    }
    /**
     * Set CompanyID value
     * @param int $companyID
     * @return \SGCIS\Struct\PaymentVendorProcess
     */
    public function setCompanyID($companyID = null)
    {
        // validation for constraint: int
        if (!is_null($companyID) && !is_numeric($companyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($companyID)), __LINE__);
        }
        $this->CompanyID = $companyID;
        return $this;
    }
    /**
     * Get EffectiveFrom value
     * @return string
     */
    public function getEffectiveFrom()
    {
        return $this->EffectiveFrom;
    }
    /**
     * Set EffectiveFrom value
     * @param string $effectiveFrom
     * @return \SGCIS\Struct\PaymentVendorProcess
     */
    public function setEffectiveFrom($effectiveFrom = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveFrom) && !is_string($effectiveFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effectiveFrom)), __LINE__);
        }
        $this->EffectiveFrom = $effectiveFrom;
        return $this;
    }
    /**
     * Get EffectiveTo value
     * @return string
     */
    public function getEffectiveTo()
    {
        return $this->EffectiveTo;
    }
    /**
     * Set EffectiveTo value
     * @param string $effectiveTo
     * @return \SGCIS\Struct\PaymentVendorProcess
     */
    public function setEffectiveTo($effectiveTo = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveTo) && !is_string($effectiveTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effectiveTo)), __LINE__);
        }
        $this->EffectiveTo = $effectiveTo;
        return $this;
    }
    /**
     * Get PaymentGatewayUserID value
     * @return string|null
     */
    public function getPaymentGatewayUserID()
    {
        return $this->PaymentGatewayUserID;
    }
    /**
     * Set PaymentGatewayUserID value
     * @param string $paymentGatewayUserID
     * @return \SGCIS\Struct\PaymentVendorProcess
     */
    public function setPaymentGatewayUserID($paymentGatewayUserID = null)
    {
        // validation for constraint: string
        if (!is_null($paymentGatewayUserID) && !is_string($paymentGatewayUserID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentGatewayUserID)), __LINE__);
        }
        $this->PaymentGatewayUserID = $paymentGatewayUserID;
        return $this;
    }
    /**
     * Get PaymentGatewayPassword value
     * @return string|null
     */
    public function getPaymentGatewayPassword()
    {
        return $this->PaymentGatewayPassword;
    }
    /**
     * Set PaymentGatewayPassword value
     * @param string $paymentGatewayPassword
     * @return \SGCIS\Struct\PaymentVendorProcess
     */
    public function setPaymentGatewayPassword($paymentGatewayPassword = null)
    {
        // validation for constraint: string
        if (!is_null($paymentGatewayPassword) && !is_string($paymentGatewayPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentGatewayPassword)), __LINE__);
        }
        $this->PaymentGatewayPassword = $paymentGatewayPassword;
        return $this;
    }
    /**
     * Get PaymentGatewaySystemID value
     * @return string|null
     */
    public function getPaymentGatewaySystemID()
    {
        return $this->PaymentGatewaySystemID;
    }
    /**
     * Set PaymentGatewaySystemID value
     * @param string $paymentGatewaySystemID
     * @return \SGCIS\Struct\PaymentVendorProcess
     */
    public function setPaymentGatewaySystemID($paymentGatewaySystemID = null)
    {
        // validation for constraint: string
        if (!is_null($paymentGatewaySystemID) && !is_string($paymentGatewaySystemID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentGatewaySystemID)), __LINE__);
        }
        $this->PaymentGatewaySystemID = $paymentGatewaySystemID;
        return $this;
    }
    /**
     * Get AgentID value
     * @return string|null
     */
    public function getAgentID()
    {
        return $this->AgentID;
    }
    /**
     * Set AgentID value
     * @param string $agentID
     * @return \SGCIS\Struct\PaymentVendorProcess
     */
    public function setAgentID($agentID = null)
    {
        // validation for constraint: string
        if (!is_null($agentID) && !is_string($agentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($agentID)), __LINE__);
        }
        $this->AgentID = $agentID;
        return $this;
    }
    /**
     * Get VendorName value
     * @return string|null
     */
    public function getVendorName()
    {
        return $this->VendorName;
    }
    /**
     * Set VendorName value
     * @param string $vendorName
     * @return \SGCIS\Struct\PaymentVendorProcess
     */
    public function setVendorName($vendorName = null)
    {
        // validation for constraint: string
        if (!is_null($vendorName) && !is_string($vendorName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vendorName)), __LINE__);
        }
        $this->VendorName = $vendorName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\PaymentVendorProcess
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
