<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentTenderType Struct
 * @subpackage Structs
 */
class PaymentTenderType extends AbstractStructBase
{
    /**
     * The PaymentTenderTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PaymentTenderTypeID;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The PaymentProcessor
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentProcessor;
    /**
     * Constructor method for PaymentTenderType
     * @uses PaymentTenderType::setPaymentTenderTypeID()
     * @uses PaymentTenderType::setName()
     * @uses PaymentTenderType::setDescription()
     * @uses PaymentTenderType::setPaymentProcessor()
     * @param int $paymentTenderTypeID
     * @param string $name
     * @param string $description
     * @param string $paymentProcessor
     */
    public function __construct($paymentTenderTypeID = null, $name = null, $description = null, $paymentProcessor = null)
    {
        $this
            ->setPaymentTenderTypeID($paymentTenderTypeID)
            ->setName($name)
            ->setDescription($description)
            ->setPaymentProcessor($paymentProcessor);
    }
    /**
     * Get PaymentTenderTypeID value
     * @return int
     */
    public function getPaymentTenderTypeID()
    {
        return $this->PaymentTenderTypeID;
    }
    /**
     * Set PaymentTenderTypeID value
     * @param int $paymentTenderTypeID
     * @return \SGCIS\Struct\PaymentTenderType
     */
    public function setPaymentTenderTypeID($paymentTenderTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($paymentTenderTypeID) && !is_numeric($paymentTenderTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($paymentTenderTypeID)), __LINE__);
        }
        $this->PaymentTenderTypeID = $paymentTenderTypeID;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \SGCIS\Struct\PaymentTenderType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \SGCIS\Struct\PaymentTenderType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get PaymentProcessor value
     * @return string|null
     */
    public function getPaymentProcessor()
    {
        return $this->PaymentProcessor;
    }
    /**
     * Set PaymentProcessor value
     * @param string $paymentProcessor
     * @return \SGCIS\Struct\PaymentTenderType
     */
    public function setPaymentProcessor($paymentProcessor = null)
    {
        // validation for constraint: string
        if (!is_null($paymentProcessor) && !is_string($paymentProcessor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentProcessor)), __LINE__);
        }
        $this->PaymentProcessor = $paymentProcessor;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\PaymentTenderType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
