<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentEvent Struct
 * @subpackage Structs
 */
class PaymentEvent extends BaseDTO
{
    /**
     * The PaymentEventID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PaymentEventID;
    /**
     * The PaymentEventTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PaymentEventTypeID;
    /**
     * The ReasonCodeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ReasonCodeID;
    /**
     * The CreditTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CreditTypeID;
    /**
     * The AccountID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountID;
    /**
     * The PaymentSourceID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PaymentSourceID;
    /**
     * The AccountAutoPayID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountAutoPayID;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Amount;
    /**
     * The PaymentAccountID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PaymentAccountID;
    /**
     * The AccountBalance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AccountBalance;
    /**
     * The MinPaymentAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $MinPaymentAmount;
    /**
     * The MinPaymentMet
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $MinPaymentMet;
    /**
     * The PaymentTenderTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PaymentTenderTypeID;
    /**
     * The PaymentEventReversalID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PaymentEventReversalID;
    /**
     * The DebtPaymentAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $DebtPaymentAmount;
    /**
     * The CreditPaymentAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $CreditPaymentAmount;
    /**
     * The DuringEnrollment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $DuringEnrollment;
    /**
     * The GatewayTransactionId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $GatewayTransactionId;
    /**
     * The PaymentEventTypeName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentEventTypeName;
    /**
     * The ReasonCodeName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReasonCodeName;
    /**
     * The CreditTypeName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CreditTypeName;
    /**
     * The AccountNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountNumber;
    /**
     * The PaymentSourceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentSourceName;
    /**
     * The Notes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Notes;
    /**
     * The ZipCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ZipCode;
    /**
     * The OrderID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderID;
    /**
     * The FeeType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FeeType;
    /**
     * The PayReference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PayReference;
    /**
     * The ReceiptInformation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReceiptInformation;
    /**
     * The IpAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IpAddress;
    /**
     * The PaymentTender
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\PaymentTender
     */
    public $PaymentTender;
    /**
     * The AccountFees
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfAccountFee
     */
    public $AccountFees;
    /**
     * Constructor method for PaymentEvent
     * @uses PaymentEvent::setPaymentEventID()
     * @uses PaymentEvent::setPaymentEventTypeID()
     * @uses PaymentEvent::setReasonCodeID()
     * @uses PaymentEvent::setCreditTypeID()
     * @uses PaymentEvent::setAccountID()
     * @uses PaymentEvent::setPaymentSourceID()
     * @uses PaymentEvent::setAccountAutoPayID()
     * @uses PaymentEvent::setAmount()
     * @uses PaymentEvent::setPaymentAccountID()
     * @uses PaymentEvent::setAccountBalance()
     * @uses PaymentEvent::setMinPaymentAmount()
     * @uses PaymentEvent::setMinPaymentMet()
     * @uses PaymentEvent::setPaymentTenderTypeID()
     * @uses PaymentEvent::setPaymentEventReversalID()
     * @uses PaymentEvent::setDebtPaymentAmount()
     * @uses PaymentEvent::setCreditPaymentAmount()
     * @uses PaymentEvent::setDuringEnrollment()
     * @uses PaymentEvent::setGatewayTransactionId()
     * @uses PaymentEvent::setPaymentEventTypeName()
     * @uses PaymentEvent::setReasonCodeName()
     * @uses PaymentEvent::setCreditTypeName()
     * @uses PaymentEvent::setAccountNumber()
     * @uses PaymentEvent::setPaymentSourceName()
     * @uses PaymentEvent::setNotes()
     * @uses PaymentEvent::setZipCode()
     * @uses PaymentEvent::setOrderID()
     * @uses PaymentEvent::setFeeType()
     * @uses PaymentEvent::setPayReference()
     * @uses PaymentEvent::setReceiptInformation()
     * @uses PaymentEvent::setIpAddress()
     * @uses PaymentEvent::setPaymentTender()
     * @uses PaymentEvent::setAccountFees()
     * @param int $paymentEventID
     * @param int $paymentEventTypeID
     * @param int $reasonCodeID
     * @param int $creditTypeID
     * @param int $accountID
     * @param int $paymentSourceID
     * @param int $accountAutoPayID
     * @param float $amount
     * @param int $paymentAccountID
     * @param float $accountBalance
     * @param float $minPaymentAmount
     * @param bool $minPaymentMet
     * @param int $paymentTenderTypeID
     * @param int $paymentEventReversalID
     * @param float $debtPaymentAmount
     * @param float $creditPaymentAmount
     * @param bool $duringEnrollment
     * @param int $gatewayTransactionId
     * @param string $paymentEventTypeName
     * @param string $reasonCodeName
     * @param string $creditTypeName
     * @param string $accountNumber
     * @param string $paymentSourceName
     * @param string $notes
     * @param string $zipCode
     * @param string $orderID
     * @param string $feeType
     * @param string $payReference
     * @param string $receiptInformation
     * @param string $ipAddress
     * @param \SGCIS\Struct\PaymentTender $paymentTender
     * @param \SGCIS\Array\ArrayOfAccountFee $accountFees
     */
    public function __construct($paymentEventID = null, $paymentEventTypeID = null, $reasonCodeID = null, $creditTypeID = null, $accountID = null, $paymentSourceID = null, $accountAutoPayID = null, $amount = null, $paymentAccountID = null, $accountBalance = null, $minPaymentAmount = null, $minPaymentMet = null, $paymentTenderTypeID = null, $paymentEventReversalID = null, $debtPaymentAmount = null, $creditPaymentAmount = null, $duringEnrollment = null, $gatewayTransactionId = null, $paymentEventTypeName = null, $reasonCodeName = null, $creditTypeName = null, $accountNumber = null, $paymentSourceName = null, $notes = null, $zipCode = null, $orderID = null, $feeType = null, $payReference = null, $receiptInformation = null, $ipAddress = null, \SGCIS\Struct\PaymentTender $paymentTender = null, \SGCIS\Array\ArrayOfAccountFee $accountFees = null)
    {
        $this
            ->setPaymentEventID($paymentEventID)
            ->setPaymentEventTypeID($paymentEventTypeID)
            ->setReasonCodeID($reasonCodeID)
            ->setCreditTypeID($creditTypeID)
            ->setAccountID($accountID)
            ->setPaymentSourceID($paymentSourceID)
            ->setAccountAutoPayID($accountAutoPayID)
            ->setAmount($amount)
            ->setPaymentAccountID($paymentAccountID)
            ->setAccountBalance($accountBalance)
            ->setMinPaymentAmount($minPaymentAmount)
            ->setMinPaymentMet($minPaymentMet)
            ->setPaymentTenderTypeID($paymentTenderTypeID)
            ->setPaymentEventReversalID($paymentEventReversalID)
            ->setDebtPaymentAmount($debtPaymentAmount)
            ->setCreditPaymentAmount($creditPaymentAmount)
            ->setDuringEnrollment($duringEnrollment)
            ->setGatewayTransactionId($gatewayTransactionId)
            ->setPaymentEventTypeName($paymentEventTypeName)
            ->setReasonCodeName($reasonCodeName)
            ->setCreditTypeName($creditTypeName)
            ->setAccountNumber($accountNumber)
            ->setPaymentSourceName($paymentSourceName)
            ->setNotes($notes)
            ->setZipCode($zipCode)
            ->setOrderID($orderID)
            ->setFeeType($feeType)
            ->setPayReference($payReference)
            ->setReceiptInformation($receiptInformation)
            ->setIpAddress($ipAddress)
            ->setPaymentTender($paymentTender)
            ->setAccountFees($accountFees);
    }
    /**
     * Get PaymentEventID value
     * @return int
     */
    public function getPaymentEventID()
    {
        return $this->PaymentEventID;
    }
    /**
     * Set PaymentEventID value
     * @param int $paymentEventID
     * @return \SGCIS\Struct\PaymentEvent
     */
    public function setPaymentEventID($paymentEventID = null)
    {
        // validation for constraint: int
        if (!is_null($paymentEventID) && !is_numeric($paymentEventID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($paymentEventID)), __LINE__);
        }
        $this->PaymentEventID = $paymentEventID;
        return $this;
    }
    /**
     * Get PaymentEventTypeID value
     * @return int
     */
    public function getPaymentEventTypeID()
    {
        return $this->PaymentEventTypeID;
    }
    /**
     * Set PaymentEventTypeID value
     * @param int $paymentEventTypeID
     * @return \SGCIS\Struct\PaymentEvent
     */
    public function setPaymentEventTypeID($paymentEventTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($paymentEventTypeID) && !is_numeric($paymentEventTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($paymentEventTypeID)), __LINE__);
        }
        $this->PaymentEventTypeID = $paymentEventTypeID;
        return $this;
    }
    /**
     * Get ReasonCodeID value
     * @return int
     */
    public function getReasonCodeID()
    {
        return $this->ReasonCodeID;
    }
    /**
     * Set ReasonCodeID value
     * @param int $reasonCodeID
     * @return \SGCIS\Struct\PaymentEvent
     */
    public function setReasonCodeID($reasonCodeID = null)
    {
        // validation for constraint: int
        if (!is_null($reasonCodeID) && !is_numeric($reasonCodeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($reasonCodeID)), __LINE__);
        }
        $this->ReasonCodeID = $reasonCodeID;
        return $this;
    }
    /**
     * Get CreditTypeID value
     * @return int
     */
    public function getCreditTypeID()
    {
        return $this->CreditTypeID;
    }
    /**
     * Set CreditTypeID value
     * @param int $creditTypeID
     * @return \SGCIS\Struct\PaymentEvent
     */
    public function setCreditTypeID($creditTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($creditTypeID) && !is_numeric($creditTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($creditTypeID)), __LINE__);
        }
        $this->CreditTypeID = $creditTypeID;
        return $this;
    }
    /**
     * Get AccountID value
     * @return int
     */
    public function getAccountID()
    {
        return $this->AccountID;
    }
    /**
     * Set AccountID value
     * @param int $accountID
     * @return \SGCIS\Struct\PaymentEvent
     */
    public function setAccountID($accountID = null)
    {
        // validation for constraint: int
        if (!is_null($accountID) && !is_numeric($accountID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountID)), __LINE__);
        }
        $this->AccountID = $accountID;
        return $this;
    }
    /**
     * Get PaymentSourceID value
     * @return int
     */
    public function getPaymentSourceID()
    {
        return $this->PaymentSourceID;
    }
    /**
     * Set PaymentSourceID value
     * @param int $paymentSourceID
     * @return \SGCIS\Struct\PaymentEvent
     */
    public function setPaymentSourceID($paymentSourceID = null)
    {
        // validation for constraint: int
        if (!is_null($paymentSourceID) && !is_numeric($paymentSourceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($paymentSourceID)), __LINE__);
        }
        $this->PaymentSourceID = $paymentSourceID;
        return $this;
    }
    /**
     * Get AccountAutoPayID value
     * @return int
     */
    public function getAccountAutoPayID()
    {
        return $this->AccountAutoPayID;
    }
    /**
     * Set AccountAutoPayID value
     * @param int $accountAutoPayID
     * @return \SGCIS\Struct\PaymentEvent
     */
    public function setAccountAutoPayID($accountAutoPayID = null)
    {
        // validation for constraint: int
        if (!is_null($accountAutoPayID) && !is_numeric($accountAutoPayID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountAutoPayID)), __LINE__);
        }
        $this->AccountAutoPayID = $accountAutoPayID;
        return $this;
    }
    /**
     * Get Amount value
     * @return float
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \SGCIS\Struct\PaymentEvent
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get PaymentAccountID value
     * @return int
     */
    public function getPaymentAccountID()
    {
        return $this->PaymentAccountID;
    }
    /**
     * Set PaymentAccountID value
     * @param int $paymentAccountID
     * @return \SGCIS\Struct\PaymentEvent
     */
    public function setPaymentAccountID($paymentAccountID = null)
    {
        // validation for constraint: int
        if (!is_null($paymentAccountID) && !is_numeric($paymentAccountID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($paymentAccountID)), __LINE__);
        }
        $this->PaymentAccountID = $paymentAccountID;
        return $this;
    }
    /**
     * Get AccountBalance value
     * @return float
     */
    public function getAccountBalance()
    {
        return $this->AccountBalance;
    }
    /**
     * Set AccountBalance value
     * @param float $accountBalance
     * @return \SGCIS\Struct\PaymentEvent
     */
    public function setAccountBalance($accountBalance = null)
    {
        $this->AccountBalance = $accountBalance;
        return $this;
    }
    /**
     * Get MinPaymentAmount value
     * @return float
     */
    public function getMinPaymentAmount()
    {
        return $this->MinPaymentAmount;
    }
    /**
     * Set MinPaymentAmount value
     * @param float $minPaymentAmount
     * @return \SGCIS\Struct\PaymentEvent
     */
    public function setMinPaymentAmount($minPaymentAmount = null)
    {
        $this->MinPaymentAmount = $minPaymentAmount;
        return $this;
    }
    /**
     * Get MinPaymentMet value
     * @return bool
     */
    public function getMinPaymentMet()
    {
        return $this->MinPaymentMet;
    }
    /**
     * Set MinPaymentMet value
     * @param bool $minPaymentMet
     * @return \SGCIS\Struct\PaymentEvent
     */
    public function setMinPaymentMet($minPaymentMet = null)
    {
        // validation for constraint: boolean
        if (!is_null($minPaymentMet) && !is_bool($minPaymentMet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($minPaymentMet)), __LINE__);
        }
        $this->MinPaymentMet = $minPaymentMet;
        return $this;
    }
    /**
     * Get PaymentTenderTypeID value
     * @return int
     */
    public function getPaymentTenderTypeID()
    {
        return $this->PaymentTenderTypeID;
    }
    /**
     * Set PaymentTenderTypeID value
     * @param int $paymentTenderTypeID
     * @return \SGCIS\Struct\PaymentEvent
     */
    public function setPaymentTenderTypeID($paymentTenderTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($paymentTenderTypeID) && !is_numeric($paymentTenderTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($paymentTenderTypeID)), __LINE__);
        }
        $this->PaymentTenderTypeID = $paymentTenderTypeID;
        return $this;
    }
    /**
     * Get PaymentEventReversalID value
     * @return int
     */
    public function getPaymentEventReversalID()
    {
        return $this->PaymentEventReversalID;
    }
    /**
     * Set PaymentEventReversalID value
     * @param int $paymentEventReversalID
     * @return \SGCIS\Struct\PaymentEvent
     */
    public function setPaymentEventReversalID($paymentEventReversalID = null)
    {
        // validation for constraint: int
        if (!is_null($paymentEventReversalID) && !is_numeric($paymentEventReversalID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($paymentEventReversalID)), __LINE__);
        }
        $this->PaymentEventReversalID = $paymentEventReversalID;
        return $this;
    }
    /**
     * Get DebtPaymentAmount value
     * @return float
     */
    public function getDebtPaymentAmount()
    {
        return $this->DebtPaymentAmount;
    }
    /**
     * Set DebtPaymentAmount value
     * @param float $debtPaymentAmount
     * @return \SGCIS\Struct\PaymentEvent
     */
    public function setDebtPaymentAmount($debtPaymentAmount = null)
    {
        $this->DebtPaymentAmount = $debtPaymentAmount;
        return $this;
    }
    /**
     * Get CreditPaymentAmount value
     * @return float
     */
    public function getCreditPaymentAmount()
    {
        return $this->CreditPaymentAmount;
    }
    /**
     * Set CreditPaymentAmount value
     * @param float $creditPaymentAmount
     * @return \SGCIS\Struct\PaymentEvent
     */
    public function setCreditPaymentAmount($creditPaymentAmount = null)
    {
        $this->CreditPaymentAmount = $creditPaymentAmount;
        return $this;
    }
    /**
     * Get DuringEnrollment value
     * @return bool
     */
    public function getDuringEnrollment()
    {
        return $this->DuringEnrollment;
    }
    /**
     * Set DuringEnrollment value
     * @param bool $duringEnrollment
     * @return \SGCIS\Struct\PaymentEvent
     */
    public function setDuringEnrollment($duringEnrollment = null)
    {
        // validation for constraint: boolean
        if (!is_null($duringEnrollment) && !is_bool($duringEnrollment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($duringEnrollment)), __LINE__);
        }
        $this->DuringEnrollment = $duringEnrollment;
        return $this;
    }
    /**
     * Get GatewayTransactionId value
     * @return int
     */
    public function getGatewayTransactionId()
    {
        return $this->GatewayTransactionId;
    }
    /**
     * Set GatewayTransactionId value
     * @param int $gatewayTransactionId
     * @return \SGCIS\Struct\PaymentEvent
     */
    public function setGatewayTransactionId($gatewayTransactionId = null)
    {
        // validation for constraint: int
        if (!is_null($gatewayTransactionId) && !is_numeric($gatewayTransactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($gatewayTransactionId)), __LINE__);
        }
        $this->GatewayTransactionId = $gatewayTransactionId;
        return $this;
    }
    /**
     * Get PaymentEventTypeName value
     * @return string|null
     */
    public function getPaymentEventTypeName()
    {
        return $this->PaymentEventTypeName;
    }
    /**
     * Set PaymentEventTypeName value
     * @param string $paymentEventTypeName
     * @return \SGCIS\Struct\PaymentEvent
     */
    public function setPaymentEventTypeName($paymentEventTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($paymentEventTypeName) && !is_string($paymentEventTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentEventTypeName)), __LINE__);
        }
        $this->PaymentEventTypeName = $paymentEventTypeName;
        return $this;
    }
    /**
     * Get ReasonCodeName value
     * @return string|null
     */
    public function getReasonCodeName()
    {
        return $this->ReasonCodeName;
    }
    /**
     * Set ReasonCodeName value
     * @param string $reasonCodeName
     * @return \SGCIS\Struct\PaymentEvent
     */
    public function setReasonCodeName($reasonCodeName = null)
    {
        // validation for constraint: string
        if (!is_null($reasonCodeName) && !is_string($reasonCodeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reasonCodeName)), __LINE__);
        }
        $this->ReasonCodeName = $reasonCodeName;
        return $this;
    }
    /**
     * Get CreditTypeName value
     * @return string|null
     */
    public function getCreditTypeName()
    {
        return $this->CreditTypeName;
    }
    /**
     * Set CreditTypeName value
     * @param string $creditTypeName
     * @return \SGCIS\Struct\PaymentEvent
     */
    public function setCreditTypeName($creditTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($creditTypeName) && !is_string($creditTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($creditTypeName)), __LINE__);
        }
        $this->CreditTypeName = $creditTypeName;
        return $this;
    }
    /**
     * Get AccountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->AccountNumber;
    }
    /**
     * Set AccountNumber value
     * @param string $accountNumber
     * @return \SGCIS\Struct\PaymentEvent
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountNumber)), __LINE__);
        }
        $this->AccountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get PaymentSourceName value
     * @return string|null
     */
    public function getPaymentSourceName()
    {
        return $this->PaymentSourceName;
    }
    /**
     * Set PaymentSourceName value
     * @param string $paymentSourceName
     * @return \SGCIS\Struct\PaymentEvent
     */
    public function setPaymentSourceName($paymentSourceName = null)
    {
        // validation for constraint: string
        if (!is_null($paymentSourceName) && !is_string($paymentSourceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentSourceName)), __LINE__);
        }
        $this->PaymentSourceName = $paymentSourceName;
        return $this;
    }
    /**
     * Get Notes value
     * @return string|null
     */
    public function getNotes()
    {
        return $this->Notes;
    }
    /**
     * Set Notes value
     * @param string $notes
     * @return \SGCIS\Struct\PaymentEvent
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($notes)), __LINE__);
        }
        $this->Notes = $notes;
        return $this;
    }
    /**
     * Get ZipCode value
     * @return string|null
     */
    public function getZipCode()
    {
        return $this->ZipCode;
    }
    /**
     * Set ZipCode value
     * @param string $zipCode
     * @return \SGCIS\Struct\PaymentEvent
     */
    public function setZipCode($zipCode = null)
    {
        // validation for constraint: string
        if (!is_null($zipCode) && !is_string($zipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zipCode)), __LINE__);
        }
        $this->ZipCode = $zipCode;
        return $this;
    }
    /**
     * Get OrderID value
     * @return string|null
     */
    public function getOrderID()
    {
        return $this->OrderID;
    }
    /**
     * Set OrderID value
     * @param string $orderID
     * @return \SGCIS\Struct\PaymentEvent
     */
    public function setOrderID($orderID = null)
    {
        // validation for constraint: string
        if (!is_null($orderID) && !is_string($orderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderID)), __LINE__);
        }
        $this->OrderID = $orderID;
        return $this;
    }
    /**
     * Get FeeType value
     * @return string|null
     */
    public function getFeeType()
    {
        return $this->FeeType;
    }
    /**
     * Set FeeType value
     * @param string $feeType
     * @return \SGCIS\Struct\PaymentEvent
     */
    public function setFeeType($feeType = null)
    {
        // validation for constraint: string
        if (!is_null($feeType) && !is_string($feeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($feeType)), __LINE__);
        }
        $this->FeeType = $feeType;
        return $this;
    }
    /**
     * Get PayReference value
     * @return string|null
     */
    public function getPayReference()
    {
        return $this->PayReference;
    }
    /**
     * Set PayReference value
     * @param string $payReference
     * @return \SGCIS\Struct\PaymentEvent
     */
    public function setPayReference($payReference = null)
    {
        // validation for constraint: string
        if (!is_null($payReference) && !is_string($payReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($payReference)), __LINE__);
        }
        $this->PayReference = $payReference;
        return $this;
    }
    /**
     * Get ReceiptInformation value
     * @return string|null
     */
    public function getReceiptInformation()
    {
        return $this->ReceiptInformation;
    }
    /**
     * Set ReceiptInformation value
     * @param string $receiptInformation
     * @return \SGCIS\Struct\PaymentEvent
     */
    public function setReceiptInformation($receiptInformation = null)
    {
        // validation for constraint: string
        if (!is_null($receiptInformation) && !is_string($receiptInformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($receiptInformation)), __LINE__);
        }
        $this->ReceiptInformation = $receiptInformation;
        return $this;
    }
    /**
     * Get IpAddress value
     * @return string|null
     */
    public function getIpAddress()
    {
        return $this->IpAddress;
    }
    /**
     * Set IpAddress value
     * @param string $ipAddress
     * @return \SGCIS\Struct\PaymentEvent
     */
    public function setIpAddress($ipAddress = null)
    {
        // validation for constraint: string
        if (!is_null($ipAddress) && !is_string($ipAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ipAddress)), __LINE__);
        }
        $this->IpAddress = $ipAddress;
        return $this;
    }
    /**
     * Get PaymentTender value
     * @return \SGCIS\Struct\PaymentTender|null
     */
    public function getPaymentTender()
    {
        return $this->PaymentTender;
    }
    /**
     * Set PaymentTender value
     * @param \SGCIS\Struct\PaymentTender $paymentTender
     * @return \SGCIS\Struct\PaymentEvent
     */
    public function setPaymentTender(\SGCIS\Struct\PaymentTender $paymentTender = null)
    {
        $this->PaymentTender = $paymentTender;
        return $this;
    }
    /**
     * Get AccountFees value
     * @return \SGCIS\Array\ArrayOfAccountFee|null
     */
    public function getAccountFees()
    {
        return $this->AccountFees;
    }
    /**
     * Set AccountFees value
     * @param \SGCIS\Array\ArrayOfAccountFee $accountFees
     * @return \SGCIS\Struct\PaymentEvent
     */
    public function setAccountFees(\SGCIS\Array\ArrayOfAccountFee $accountFees = null)
    {
        $this->AccountFees = $accountFees;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\PaymentEvent
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
