<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentArrangementRequest Struct
 * @subpackage Structs
 */
class PaymentArrangementRequest extends ServiceRequestBase
{
    /**
     * The AccountID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountID;
    /**
     * The PaymentArrangementID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PaymentArrangementID;
    /**
     * The AddNewInstallments
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $AddNewInstallments;
    /**
     * The PaymentArrangement
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\PaymentArrangement
     */
    public $PaymentArrangement;
    /**
     * Constructor method for PaymentArrangementRequest
     * @uses PaymentArrangementRequest::setAccountID()
     * @uses PaymentArrangementRequest::setPaymentArrangementID()
     * @uses PaymentArrangementRequest::setAddNewInstallments()
     * @uses PaymentArrangementRequest::setPaymentArrangement()
     * @param int $accountID
     * @param int $paymentArrangementID
     * @param bool $addNewInstallments
     * @param \SGCIS\Struct\PaymentArrangement $paymentArrangement
     */
    public function __construct($accountID = null, $paymentArrangementID = null, $addNewInstallments = null, \SGCIS\Struct\PaymentArrangement $paymentArrangement = null)
    {
        $this
            ->setAccountID($accountID)
            ->setPaymentArrangementID($paymentArrangementID)
            ->setAddNewInstallments($addNewInstallments)
            ->setPaymentArrangement($paymentArrangement);
    }
    /**
     * Get AccountID value
     * @return int
     */
    public function getAccountID()
    {
        return $this->AccountID;
    }
    /**
     * Set AccountID value
     * @param int $accountID
     * @return \SGCIS\Struct\PaymentArrangementRequest
     */
    public function setAccountID($accountID = null)
    {
        // validation for constraint: int
        if (!is_null($accountID) && !is_numeric($accountID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountID)), __LINE__);
        }
        $this->AccountID = $accountID;
        return $this;
    }
    /**
     * Get PaymentArrangementID value
     * @return int
     */
    public function getPaymentArrangementID()
    {
        return $this->PaymentArrangementID;
    }
    /**
     * Set PaymentArrangementID value
     * @param int $paymentArrangementID
     * @return \SGCIS\Struct\PaymentArrangementRequest
     */
    public function setPaymentArrangementID($paymentArrangementID = null)
    {
        // validation for constraint: int
        if (!is_null($paymentArrangementID) && !is_numeric($paymentArrangementID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($paymentArrangementID)), __LINE__);
        }
        $this->PaymentArrangementID = $paymentArrangementID;
        return $this;
    }
    /**
     * Get AddNewInstallments value
     * @return bool
     */
    public function getAddNewInstallments()
    {
        return $this->AddNewInstallments;
    }
    /**
     * Set AddNewInstallments value
     * @param bool $addNewInstallments
     * @return \SGCIS\Struct\PaymentArrangementRequest
     */
    public function setAddNewInstallments($addNewInstallments = null)
    {
        // validation for constraint: boolean
        if (!is_null($addNewInstallments) && !is_bool($addNewInstallments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($addNewInstallments)), __LINE__);
        }
        $this->AddNewInstallments = $addNewInstallments;
        return $this;
    }
    /**
     * Get PaymentArrangement value
     * @return \SGCIS\Struct\PaymentArrangement|null
     */
    public function getPaymentArrangement()
    {
        return $this->PaymentArrangement;
    }
    /**
     * Set PaymentArrangement value
     * @param \SGCIS\Struct\PaymentArrangement $paymentArrangement
     * @return \SGCIS\Struct\PaymentArrangementRequest
     */
    public function setPaymentArrangement(\SGCIS\Struct\PaymentArrangement $paymentArrangement = null)
    {
        $this->PaymentArrangement = $paymentArrangement;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\PaymentArrangementRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
