<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentAccountResponse Struct
 * @subpackage Structs
 */
class PaymentAccountResponse extends ServiceResponseBase
{
    /**
     * The ConfirmMessage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ConfirmMessage;
    /**
     * The PaymentAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\PaymentAccount
     */
    public $PaymentAccount;
    /**
     * The PaymentAccounts
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfPaymentAccount
     */
    public $PaymentAccounts;
    /**
     * The Persons
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfPerson
     */
    public $Persons;
    /**
     * The PersonIDTypes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\PersonIDType
     */
    public $PersonIDTypes;
    /**
     * The VisaTransactionResponseCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VisaTransactionResponseCode;
    /**
     * Constructor method for PaymentAccountResponse
     * @uses PaymentAccountResponse::setConfirmMessage()
     * @uses PaymentAccountResponse::setPaymentAccount()
     * @uses PaymentAccountResponse::setPaymentAccounts()
     * @uses PaymentAccountResponse::setPersons()
     * @uses PaymentAccountResponse::setPersonIDTypes()
     * @uses PaymentAccountResponse::setVisaTransactionResponseCode()
     * @param bool $confirmMessage
     * @param \SGCIS\Struct\PaymentAccount $paymentAccount
     * @param \SGCIS\Array\ArrayOfPaymentAccount $paymentAccounts
     * @param \SGCIS\Array\ArrayOfPerson $persons
     * @param \SGCIS\Struct\PersonIDType $personIDTypes
     * @param string $visaTransactionResponseCode
     */
    public function __construct($confirmMessage = null, \SGCIS\Struct\PaymentAccount $paymentAccount = null, \SGCIS\Array\ArrayOfPaymentAccount $paymentAccounts = null, \SGCIS\Array\ArrayOfPerson $persons = null, \SGCIS\Struct\PersonIDType $personIDTypes = null, $visaTransactionResponseCode = null)
    {
        $this
            ->setConfirmMessage($confirmMessage)
            ->setPaymentAccount($paymentAccount)
            ->setPaymentAccounts($paymentAccounts)
            ->setPersons($persons)
            ->setPersonIDTypes($personIDTypes)
            ->setVisaTransactionResponseCode($visaTransactionResponseCode);
    }
    /**
     * Get ConfirmMessage value
     * @return bool
     */
    public function getConfirmMessage()
    {
        return $this->ConfirmMessage;
    }
    /**
     * Set ConfirmMessage value
     * @param bool $confirmMessage
     * @return \SGCIS\Struct\PaymentAccountResponse
     */
    public function setConfirmMessage($confirmMessage = null)
    {
        // validation for constraint: boolean
        if (!is_null($confirmMessage) && !is_bool($confirmMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($confirmMessage)), __LINE__);
        }
        $this->ConfirmMessage = $confirmMessage;
        return $this;
    }
    /**
     * Get PaymentAccount value
     * @return \SGCIS\Struct\PaymentAccount|null
     */
    public function getPaymentAccount()
    {
        return $this->PaymentAccount;
    }
    /**
     * Set PaymentAccount value
     * @param \SGCIS\Struct\PaymentAccount $paymentAccount
     * @return \SGCIS\Struct\PaymentAccountResponse
     */
    public function setPaymentAccount(\SGCIS\Struct\PaymentAccount $paymentAccount = null)
    {
        $this->PaymentAccount = $paymentAccount;
        return $this;
    }
    /**
     * Get PaymentAccounts value
     * @return \SGCIS\Array\ArrayOfPaymentAccount|null
     */
    public function getPaymentAccounts()
    {
        return $this->PaymentAccounts;
    }
    /**
     * Set PaymentAccounts value
     * @param \SGCIS\Array\ArrayOfPaymentAccount $paymentAccounts
     * @return \SGCIS\Struct\PaymentAccountResponse
     */
    public function setPaymentAccounts(\SGCIS\Array\ArrayOfPaymentAccount $paymentAccounts = null)
    {
        $this->PaymentAccounts = $paymentAccounts;
        return $this;
    }
    /**
     * Get Persons value
     * @return \SGCIS\Array\ArrayOfPerson|null
     */
    public function getPersons()
    {
        return $this->Persons;
    }
    /**
     * Set Persons value
     * @param \SGCIS\Array\ArrayOfPerson $persons
     * @return \SGCIS\Struct\PaymentAccountResponse
     */
    public function setPersons(\SGCIS\Array\ArrayOfPerson $persons = null)
    {
        $this->Persons = $persons;
        return $this;
    }
    /**
     * Get PersonIDTypes value
     * @return \SGCIS\Struct\PersonIDType|null
     */
    public function getPersonIDTypes()
    {
        return $this->PersonIDTypes;
    }
    /**
     * Set PersonIDTypes value
     * @param \SGCIS\Struct\PersonIDType $personIDTypes
     * @return \SGCIS\Struct\PaymentAccountResponse
     */
    public function setPersonIDTypes(\SGCIS\Struct\PersonIDType $personIDTypes = null)
    {
        $this->PersonIDTypes = $personIDTypes;
        return $this;
    }
    /**
     * Get VisaTransactionResponseCode value
     * @return string|null
     */
    public function getVisaTransactionResponseCode()
    {
        return $this->VisaTransactionResponseCode;
    }
    /**
     * Set VisaTransactionResponseCode value
     * @param string $visaTransactionResponseCode
     * @return \SGCIS\Struct\PaymentAccountResponse
     */
    public function setVisaTransactionResponseCode($visaTransactionResponseCode = null)
    {
        // validation for constraint: string
        if (!is_null($visaTransactionResponseCode) && !is_string($visaTransactionResponseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($visaTransactionResponseCode)), __LINE__);
        }
        $this->VisaTransactionResponseCode = $visaTransactionResponseCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\PaymentAccountResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
