<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentAccountRequest Struct
 * @subpackage Structs
 */
class PaymentAccountRequest extends ServiceRequestBase
{
    /**
     * The AccountID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountID;
    /**
     * The PaymentAccountID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PaymentAccountID;
    /**
     * The createActiveAcct
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $createActiveAcct;
    /**
     * The DeleteMode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DeleteMode;
    /**
     * The IncludeInactive
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IncludeInactive;
    /**
     * The PaymentAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\PaymentAccount
     */
    public $PaymentAccount;
    /**
     * The ReqPerson
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\Person
     */
    public $ReqPerson;
    /**
     * The CurrentUser
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\User
     */
    public $CurrentUser;
    /**
     * Constructor method for PaymentAccountRequest
     * @uses PaymentAccountRequest::setAccountID()
     * @uses PaymentAccountRequest::setPaymentAccountID()
     * @uses PaymentAccountRequest::setCreateActiveAcct()
     * @uses PaymentAccountRequest::setDeleteMode()
     * @uses PaymentAccountRequest::setIncludeInactive()
     * @uses PaymentAccountRequest::setPaymentAccount()
     * @uses PaymentAccountRequest::setReqPerson()
     * @uses PaymentAccountRequest::setCurrentUser()
     * @param int $accountID
     * @param int $paymentAccountID
     * @param bool $createActiveAcct
     * @param string $deleteMode
     * @param bool $includeInactive
     * @param \SGCIS\Struct\PaymentAccount $paymentAccount
     * @param \SGCIS\Struct\Person $reqPerson
     * @param \SGCIS\Struct\User $currentUser
     */
    public function __construct($accountID = null, $paymentAccountID = null, $createActiveAcct = null, $deleteMode = null, $includeInactive = null, \SGCIS\Struct\PaymentAccount $paymentAccount = null, \SGCIS\Struct\Person $reqPerson = null, \SGCIS\Struct\User $currentUser = null)
    {
        $this
            ->setAccountID($accountID)
            ->setPaymentAccountID($paymentAccountID)
            ->setCreateActiveAcct($createActiveAcct)
            ->setDeleteMode($deleteMode)
            ->setIncludeInactive($includeInactive)
            ->setPaymentAccount($paymentAccount)
            ->setReqPerson($reqPerson)
            ->setCurrentUser($currentUser);
    }
    /**
     * Get AccountID value
     * @return int
     */
    public function getAccountID()
    {
        return $this->AccountID;
    }
    /**
     * Set AccountID value
     * @param int $accountID
     * @return \SGCIS\Struct\PaymentAccountRequest
     */
    public function setAccountID($accountID = null)
    {
        // validation for constraint: int
        if (!is_null($accountID) && !is_numeric($accountID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountID)), __LINE__);
        }
        $this->AccountID = $accountID;
        return $this;
    }
    /**
     * Get PaymentAccountID value
     * @return int
     */
    public function getPaymentAccountID()
    {
        return $this->PaymentAccountID;
    }
    /**
     * Set PaymentAccountID value
     * @param int $paymentAccountID
     * @return \SGCIS\Struct\PaymentAccountRequest
     */
    public function setPaymentAccountID($paymentAccountID = null)
    {
        // validation for constraint: int
        if (!is_null($paymentAccountID) && !is_numeric($paymentAccountID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($paymentAccountID)), __LINE__);
        }
        $this->PaymentAccountID = $paymentAccountID;
        return $this;
    }
    /**
     * Get createActiveAcct value
     * @return bool
     */
    public function getCreateActiveAcct()
    {
        return $this->createActiveAcct;
    }
    /**
     * Set createActiveAcct value
     * @param bool $createActiveAcct
     * @return \SGCIS\Struct\PaymentAccountRequest
     */
    public function setCreateActiveAcct($createActiveAcct = null)
    {
        // validation for constraint: boolean
        if (!is_null($createActiveAcct) && !is_bool($createActiveAcct)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($createActiveAcct)), __LINE__);
        }
        $this->createActiveAcct = $createActiveAcct;
        return $this;
    }
    /**
     * Get DeleteMode value
     * @return string
     */
    public function getDeleteMode()
    {
        return $this->DeleteMode;
    }
    /**
     * Set DeleteMode value
     * @uses \SGCIS\Enum\DeletePaymentAccountMode::valueIsValid()
     * @uses \SGCIS\Enum\DeletePaymentAccountMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deleteMode
     * @return \SGCIS\Struct\PaymentAccountRequest
     */
    public function setDeleteMode($deleteMode = null)
    {
        // validation for constraint: enumeration
        if (!\SGCIS\Enum\DeletePaymentAccountMode::valueIsValid($deleteMode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $deleteMode, implode(', ', \SGCIS\Enum\DeletePaymentAccountMode::getValidValues())), __LINE__);
        }
        $this->DeleteMode = $deleteMode;
        return $this;
    }
    /**
     * Get IncludeInactive value
     * @return bool
     */
    public function getIncludeInactive()
    {
        return $this->IncludeInactive;
    }
    /**
     * Set IncludeInactive value
     * @param bool $includeInactive
     * @return \SGCIS\Struct\PaymentAccountRequest
     */
    public function setIncludeInactive($includeInactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeInactive) && !is_bool($includeInactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($includeInactive)), __LINE__);
        }
        $this->IncludeInactive = $includeInactive;
        return $this;
    }
    /**
     * Get PaymentAccount value
     * @return \SGCIS\Struct\PaymentAccount|null
     */
    public function getPaymentAccount()
    {
        return $this->PaymentAccount;
    }
    /**
     * Set PaymentAccount value
     * @param \SGCIS\Struct\PaymentAccount $paymentAccount
     * @return \SGCIS\Struct\PaymentAccountRequest
     */
    public function setPaymentAccount(\SGCIS\Struct\PaymentAccount $paymentAccount = null)
    {
        $this->PaymentAccount = $paymentAccount;
        return $this;
    }
    /**
     * Get ReqPerson value
     * @return \SGCIS\Struct\Person|null
     */
    public function getReqPerson()
    {
        return $this->ReqPerson;
    }
    /**
     * Set ReqPerson value
     * @param \SGCIS\Struct\Person $reqPerson
     * @return \SGCIS\Struct\PaymentAccountRequest
     */
    public function setReqPerson(\SGCIS\Struct\Person $reqPerson = null)
    {
        $this->ReqPerson = $reqPerson;
        return $this;
    }
    /**
     * Get CurrentUser value
     * @return \SGCIS\Struct\User|null
     */
    public function getCurrentUser()
    {
        return $this->CurrentUser;
    }
    /**
     * Set CurrentUser value
     * @param \SGCIS\Struct\User $currentUser
     * @return \SGCIS\Struct\PaymentAccountRequest
     */
    public function setCurrentUser(\SGCIS\Struct\User $currentUser = null)
    {
        $this->CurrentUser = $currentUser;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\PaymentAccountRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
