<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentAccount Struct
 * @subpackage Structs
 */
class PaymentAccount extends BaseDTO
{
    /**
     * The PaymentAccountID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PaymentAccountID;
    /**
     * The AccountID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountID;
    /**
     * The PaymentAccountTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PaymentAccountTypeID;
    /**
     * The CardTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CardTypeID;
    /**
     * The ExpireMonth
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ExpireMonth;
    /**
     * The ExpireYear
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ExpireYear;
    /**
     * The IsAutoPayAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsAutoPayAccount;
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Active;
    /**
     * The IsDeleted
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsDeleted;
    /**
     * The PaymentVendorProcessID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PaymentVendorProcessID;
    /**
     * The ExternalProfileIdentifier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExternalProfileIdentifier;
    /**
     * The AccountName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountName;
    /**
     * The AccountNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountNumber;
    /**
     * The NameOnAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NameOnAccount;
    /**
     * The RoutingNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RoutingNumber;
    /**
     * The BankName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BankName;
    /**
     * The BankAccountType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BankAccountType;
    /**
     * The Ccv
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ccv;
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\AccountAddress
     */
    public $Address;
    /**
     * The BillingZipCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillingZipCode;
    /**
     * The BillingName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillingName;
    /**
     * The ReceiptConfirmationNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReceiptConfirmationNumber;
    /**
     * The AccountNumberLast4
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountNumberLast4;
    /**
     * The PaymentAccountTypeName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentAccountTypeName;
    /**
     * The PaymentToken
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentToken;
    /**
     * The I4GoCardType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $I4GoCardType;
    /**
     * Constructor method for PaymentAccount
     * @uses PaymentAccount::setPaymentAccountID()
     * @uses PaymentAccount::setAccountID()
     * @uses PaymentAccount::setPaymentAccountTypeID()
     * @uses PaymentAccount::setCardTypeID()
     * @uses PaymentAccount::setExpireMonth()
     * @uses PaymentAccount::setExpireYear()
     * @uses PaymentAccount::setIsAutoPayAccount()
     * @uses PaymentAccount::setActive()
     * @uses PaymentAccount::setIsDeleted()
     * @uses PaymentAccount::setPaymentVendorProcessID()
     * @uses PaymentAccount::setExternalProfileIdentifier()
     * @uses PaymentAccount::setAccountName()
     * @uses PaymentAccount::setAccountNumber()
     * @uses PaymentAccount::setNameOnAccount()
     * @uses PaymentAccount::setRoutingNumber()
     * @uses PaymentAccount::setBankName()
     * @uses PaymentAccount::setBankAccountType()
     * @uses PaymentAccount::setCcv()
     * @uses PaymentAccount::setAddress()
     * @uses PaymentAccount::setBillingZipCode()
     * @uses PaymentAccount::setBillingName()
     * @uses PaymentAccount::setReceiptConfirmationNumber()
     * @uses PaymentAccount::setAccountNumberLast4()
     * @uses PaymentAccount::setPaymentAccountTypeName()
     * @uses PaymentAccount::setPaymentToken()
     * @uses PaymentAccount::setI4GoCardType()
     * @param int $paymentAccountID
     * @param int $accountID
     * @param int $paymentAccountTypeID
     * @param int $cardTypeID
     * @param int $expireMonth
     * @param int $expireYear
     * @param bool $isAutoPayAccount
     * @param bool $active
     * @param bool $isDeleted
     * @param int $paymentVendorProcessID
     * @param string $externalProfileIdentifier
     * @param string $accountName
     * @param string $accountNumber
     * @param string $nameOnAccount
     * @param string $routingNumber
     * @param string $bankName
     * @param string $bankAccountType
     * @param string $ccv
     * @param \SGCIS\Struct\AccountAddress $address
     * @param string $billingZipCode
     * @param string $billingName
     * @param string $receiptConfirmationNumber
     * @param string $accountNumberLast4
     * @param string $paymentAccountTypeName
     * @param string $paymentToken
     * @param string $i4GoCardType
     */
    public function __construct($paymentAccountID = null, $accountID = null, $paymentAccountTypeID = null, $cardTypeID = null, $expireMonth = null, $expireYear = null, $isAutoPayAccount = null, $active = null, $isDeleted = null, $paymentVendorProcessID = null, $externalProfileIdentifier = null, $accountName = null, $accountNumber = null, $nameOnAccount = null, $routingNumber = null, $bankName = null, $bankAccountType = null, $ccv = null, \SGCIS\Struct\AccountAddress $address = null, $billingZipCode = null, $billingName = null, $receiptConfirmationNumber = null, $accountNumberLast4 = null, $paymentAccountTypeName = null, $paymentToken = null, $i4GoCardType = null)
    {
        $this
            ->setPaymentAccountID($paymentAccountID)
            ->setAccountID($accountID)
            ->setPaymentAccountTypeID($paymentAccountTypeID)
            ->setCardTypeID($cardTypeID)
            ->setExpireMonth($expireMonth)
            ->setExpireYear($expireYear)
            ->setIsAutoPayAccount($isAutoPayAccount)
            ->setActive($active)
            ->setIsDeleted($isDeleted)
            ->setPaymentVendorProcessID($paymentVendorProcessID)
            ->setExternalProfileIdentifier($externalProfileIdentifier)
            ->setAccountName($accountName)
            ->setAccountNumber($accountNumber)
            ->setNameOnAccount($nameOnAccount)
            ->setRoutingNumber($routingNumber)
            ->setBankName($bankName)
            ->setBankAccountType($bankAccountType)
            ->setCcv($ccv)
            ->setAddress($address)
            ->setBillingZipCode($billingZipCode)
            ->setBillingName($billingName)
            ->setReceiptConfirmationNumber($receiptConfirmationNumber)
            ->setAccountNumberLast4($accountNumberLast4)
            ->setPaymentAccountTypeName($paymentAccountTypeName)
            ->setPaymentToken($paymentToken)
            ->setI4GoCardType($i4GoCardType);
    }
    /**
     * Get PaymentAccountID value
     * @return int
     */
    public function getPaymentAccountID()
    {
        return $this->PaymentAccountID;
    }
    /**
     * Set PaymentAccountID value
     * @param int $paymentAccountID
     * @return \SGCIS\Struct\PaymentAccount
     */
    public function setPaymentAccountID($paymentAccountID = null)
    {
        // validation for constraint: int
        if (!is_null($paymentAccountID) && !is_numeric($paymentAccountID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($paymentAccountID)), __LINE__);
        }
        $this->PaymentAccountID = $paymentAccountID;
        return $this;
    }
    /**
     * Get AccountID value
     * @return int
     */
    public function getAccountID()
    {
        return $this->AccountID;
    }
    /**
     * Set AccountID value
     * @param int $accountID
     * @return \SGCIS\Struct\PaymentAccount
     */
    public function setAccountID($accountID = null)
    {
        // validation for constraint: int
        if (!is_null($accountID) && !is_numeric($accountID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountID)), __LINE__);
        }
        $this->AccountID = $accountID;
        return $this;
    }
    /**
     * Get PaymentAccountTypeID value
     * @return int
     */
    public function getPaymentAccountTypeID()
    {
        return $this->PaymentAccountTypeID;
    }
    /**
     * Set PaymentAccountTypeID value
     * @param int $paymentAccountTypeID
     * @return \SGCIS\Struct\PaymentAccount
     */
    public function setPaymentAccountTypeID($paymentAccountTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($paymentAccountTypeID) && !is_numeric($paymentAccountTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($paymentAccountTypeID)), __LINE__);
        }
        $this->PaymentAccountTypeID = $paymentAccountTypeID;
        return $this;
    }
    /**
     * Get CardTypeID value
     * @return int
     */
    public function getCardTypeID()
    {
        return $this->CardTypeID;
    }
    /**
     * Set CardTypeID value
     * @param int $cardTypeID
     * @return \SGCIS\Struct\PaymentAccount
     */
    public function setCardTypeID($cardTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($cardTypeID) && !is_numeric($cardTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($cardTypeID)), __LINE__);
        }
        $this->CardTypeID = $cardTypeID;
        return $this;
    }
    /**
     * Get ExpireMonth value
     * @return int
     */
    public function getExpireMonth()
    {
        return $this->ExpireMonth;
    }
    /**
     * Set ExpireMonth value
     * @param int $expireMonth
     * @return \SGCIS\Struct\PaymentAccount
     */
    public function setExpireMonth($expireMonth = null)
    {
        // validation for constraint: int
        if (!is_null($expireMonth) && !is_numeric($expireMonth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($expireMonth)), __LINE__);
        }
        $this->ExpireMonth = $expireMonth;
        return $this;
    }
    /**
     * Get ExpireYear value
     * @return int
     */
    public function getExpireYear()
    {
        return $this->ExpireYear;
    }
    /**
     * Set ExpireYear value
     * @param int $expireYear
     * @return \SGCIS\Struct\PaymentAccount
     */
    public function setExpireYear($expireYear = null)
    {
        // validation for constraint: int
        if (!is_null($expireYear) && !is_numeric($expireYear)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($expireYear)), __LINE__);
        }
        $this->ExpireYear = $expireYear;
        return $this;
    }
    /**
     * Get IsAutoPayAccount value
     * @return bool
     */
    public function getIsAutoPayAccount()
    {
        return $this->IsAutoPayAccount;
    }
    /**
     * Set IsAutoPayAccount value
     * @param bool $isAutoPayAccount
     * @return \SGCIS\Struct\PaymentAccount
     */
    public function setIsAutoPayAccount($isAutoPayAccount = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAutoPayAccount) && !is_bool($isAutoPayAccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isAutoPayAccount)), __LINE__);
        }
        $this->IsAutoPayAccount = $isAutoPayAccount;
        return $this;
    }
    /**
     * Get Active value
     * @return bool
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \SGCIS\Struct\PaymentAccount
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get IsDeleted value
     * @return bool
     */
    public function getIsDeleted()
    {
        return $this->IsDeleted;
    }
    /**
     * Set IsDeleted value
     * @param bool $isDeleted
     * @return \SGCIS\Struct\PaymentAccount
     */
    public function setIsDeleted($isDeleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeleted) && !is_bool($isDeleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isDeleted)), __LINE__);
        }
        $this->IsDeleted = $isDeleted;
        return $this;
    }
    /**
     * Get PaymentVendorProcessID value
     * @return int
     */
    public function getPaymentVendorProcessID()
    {
        return $this->PaymentVendorProcessID;
    }
    /**
     * Set PaymentVendorProcessID value
     * @param int $paymentVendorProcessID
     * @return \SGCIS\Struct\PaymentAccount
     */
    public function setPaymentVendorProcessID($paymentVendorProcessID = null)
    {
        // validation for constraint: int
        if (!is_null($paymentVendorProcessID) && !is_numeric($paymentVendorProcessID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($paymentVendorProcessID)), __LINE__);
        }
        $this->PaymentVendorProcessID = $paymentVendorProcessID;
        return $this;
    }
    /**
     * Get ExternalProfileIdentifier value
     * @return string|null
     */
    public function getExternalProfileIdentifier()
    {
        return $this->ExternalProfileIdentifier;
    }
    /**
     * Set ExternalProfileIdentifier value
     * @param string $externalProfileIdentifier
     * @return \SGCIS\Struct\PaymentAccount
     */
    public function setExternalProfileIdentifier($externalProfileIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($externalProfileIdentifier) && !is_string($externalProfileIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($externalProfileIdentifier)), __LINE__);
        }
        $this->ExternalProfileIdentifier = $externalProfileIdentifier;
        return $this;
    }
    /**
     * Get AccountName value
     * @return string|null
     */
    public function getAccountName()
    {
        return $this->AccountName;
    }
    /**
     * Set AccountName value
     * @param string $accountName
     * @return \SGCIS\Struct\PaymentAccount
     */
    public function setAccountName($accountName = null)
    {
        // validation for constraint: string
        if (!is_null($accountName) && !is_string($accountName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountName)), __LINE__);
        }
        $this->AccountName = $accountName;
        return $this;
    }
    /**
     * Get AccountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->AccountNumber;
    }
    /**
     * Set AccountNumber value
     * @param string $accountNumber
     * @return \SGCIS\Struct\PaymentAccount
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountNumber)), __LINE__);
        }
        $this->AccountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get NameOnAccount value
     * @return string|null
     */
    public function getNameOnAccount()
    {
        return $this->NameOnAccount;
    }
    /**
     * Set NameOnAccount value
     * @param string $nameOnAccount
     * @return \SGCIS\Struct\PaymentAccount
     */
    public function setNameOnAccount($nameOnAccount = null)
    {
        // validation for constraint: string
        if (!is_null($nameOnAccount) && !is_string($nameOnAccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nameOnAccount)), __LINE__);
        }
        $this->NameOnAccount = $nameOnAccount;
        return $this;
    }
    /**
     * Get RoutingNumber value
     * @return string|null
     */
    public function getRoutingNumber()
    {
        return $this->RoutingNumber;
    }
    /**
     * Set RoutingNumber value
     * @param string $routingNumber
     * @return \SGCIS\Struct\PaymentAccount
     */
    public function setRoutingNumber($routingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($routingNumber) && !is_string($routingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($routingNumber)), __LINE__);
        }
        $this->RoutingNumber = $routingNumber;
        return $this;
    }
    /**
     * Get BankName value
     * @return string|null
     */
    public function getBankName()
    {
        return $this->BankName;
    }
    /**
     * Set BankName value
     * @param string $bankName
     * @return \SGCIS\Struct\PaymentAccount
     */
    public function setBankName($bankName = null)
    {
        // validation for constraint: string
        if (!is_null($bankName) && !is_string($bankName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankName)), __LINE__);
        }
        $this->BankName = $bankName;
        return $this;
    }
    /**
     * Get BankAccountType value
     * @return string|null
     */
    public function getBankAccountType()
    {
        return $this->BankAccountType;
    }
    /**
     * Set BankAccountType value
     * @param string $bankAccountType
     * @return \SGCIS\Struct\PaymentAccount
     */
    public function setBankAccountType($bankAccountType = null)
    {
        // validation for constraint: string
        if (!is_null($bankAccountType) && !is_string($bankAccountType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankAccountType)), __LINE__);
        }
        $this->BankAccountType = $bankAccountType;
        return $this;
    }
    /**
     * Get Ccv value
     * @return string|null
     */
    public function getCcv()
    {
        return $this->Ccv;
    }
    /**
     * Set Ccv value
     * @param string $ccv
     * @return \SGCIS\Struct\PaymentAccount
     */
    public function setCcv($ccv = null)
    {
        // validation for constraint: string
        if (!is_null($ccv) && !is_string($ccv)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ccv)), __LINE__);
        }
        $this->Ccv = $ccv;
        return $this;
    }
    /**
     * Get Address value
     * @return \SGCIS\Struct\AccountAddress|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \SGCIS\Struct\AccountAddress $address
     * @return \SGCIS\Struct\PaymentAccount
     */
    public function setAddress(\SGCIS\Struct\AccountAddress $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get BillingZipCode value
     * @return string|null
     */
    public function getBillingZipCode()
    {
        return $this->BillingZipCode;
    }
    /**
     * Set BillingZipCode value
     * @param string $billingZipCode
     * @return \SGCIS\Struct\PaymentAccount
     */
    public function setBillingZipCode($billingZipCode = null)
    {
        // validation for constraint: string
        if (!is_null($billingZipCode) && !is_string($billingZipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billingZipCode)), __LINE__);
        }
        $this->BillingZipCode = $billingZipCode;
        return $this;
    }
    /**
     * Get BillingName value
     * @return string|null
     */
    public function getBillingName()
    {
        return $this->BillingName;
    }
    /**
     * Set BillingName value
     * @param string $billingName
     * @return \SGCIS\Struct\PaymentAccount
     */
    public function setBillingName($billingName = null)
    {
        // validation for constraint: string
        if (!is_null($billingName) && !is_string($billingName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billingName)), __LINE__);
        }
        $this->BillingName = $billingName;
        return $this;
    }
    /**
     * Get ReceiptConfirmationNumber value
     * @return string|null
     */
    public function getReceiptConfirmationNumber()
    {
        return $this->ReceiptConfirmationNumber;
    }
    /**
     * Set ReceiptConfirmationNumber value
     * @param string $receiptConfirmationNumber
     * @return \SGCIS\Struct\PaymentAccount
     */
    public function setReceiptConfirmationNumber($receiptConfirmationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($receiptConfirmationNumber) && !is_string($receiptConfirmationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($receiptConfirmationNumber)), __LINE__);
        }
        $this->ReceiptConfirmationNumber = $receiptConfirmationNumber;
        return $this;
    }
    /**
     * Get AccountNumberLast4 value
     * @return string|null
     */
    public function getAccountNumberLast4()
    {
        return $this->AccountNumberLast4;
    }
    /**
     * Set AccountNumberLast4 value
     * @param string $accountNumberLast4
     * @return \SGCIS\Struct\PaymentAccount
     */
    public function setAccountNumberLast4($accountNumberLast4 = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumberLast4) && !is_string($accountNumberLast4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountNumberLast4)), __LINE__);
        }
        $this->AccountNumberLast4 = $accountNumberLast4;
        return $this;
    }
    /**
     * Get PaymentAccountTypeName value
     * @return string|null
     */
    public function getPaymentAccountTypeName()
    {
        return $this->PaymentAccountTypeName;
    }
    /**
     * Set PaymentAccountTypeName value
     * @param string $paymentAccountTypeName
     * @return \SGCIS\Struct\PaymentAccount
     */
    public function setPaymentAccountTypeName($paymentAccountTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($paymentAccountTypeName) && !is_string($paymentAccountTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentAccountTypeName)), __LINE__);
        }
        $this->PaymentAccountTypeName = $paymentAccountTypeName;
        return $this;
    }
    /**
     * Get PaymentToken value
     * @return string|null
     */
    public function getPaymentToken()
    {
        return $this->PaymentToken;
    }
    /**
     * Set PaymentToken value
     * @param string $paymentToken
     * @return \SGCIS\Struct\PaymentAccount
     */
    public function setPaymentToken($paymentToken = null)
    {
        // validation for constraint: string
        if (!is_null($paymentToken) && !is_string($paymentToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentToken)), __LINE__);
        }
        $this->PaymentToken = $paymentToken;
        return $this;
    }
    /**
     * Get I4GoCardType value
     * @return string|null
     */
    public function getI4GoCardType()
    {
        return $this->I4GoCardType;
    }
    /**
     * Set I4GoCardType value
     * @param string $i4GoCardType
     * @return \SGCIS\Struct\PaymentAccount
     */
    public function setI4GoCardType($i4GoCardType = null)
    {
        // validation for constraint: string
        if (!is_null($i4GoCardType) && !is_string($i4GoCardType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($i4GoCardType)), __LINE__);
        }
        $this->I4GoCardType = $i4GoCardType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\PaymentAccount
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
