<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MonthlyBillingCycle Struct
 * @subpackage Structs
 */
class MonthlyBillingCycle extends BaseDTO
{
    /**
     * The MonthlyBillingCycleID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MonthlyBillingCycleID;
    /**
     * The DistributionServiceProviderID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DistributionServiceProviderID;
    /**
     * The CycleYear
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CycleYear;
    /**
     * The CycleMonth
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CycleMonth;
    /**
     * The StartDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $StartDate;
    /**
     * The ReadDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ReadDate;
    /**
     * The BillDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $BillDate;
    /**
     * The IsIDRSchedule
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsIDRSchedule;
    /**
     * The PaymentDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PaymentDate;
    /**
     * The BillingCycleIdentifier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillingCycleIdentifier;
    /**
     * The DistributionServiceProviderName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DistributionServiceProviderName;
    /**
     * Constructor method for MonthlyBillingCycle
     * @uses MonthlyBillingCycle::setMonthlyBillingCycleID()
     * @uses MonthlyBillingCycle::setDistributionServiceProviderID()
     * @uses MonthlyBillingCycle::setCycleYear()
     * @uses MonthlyBillingCycle::setCycleMonth()
     * @uses MonthlyBillingCycle::setStartDate()
     * @uses MonthlyBillingCycle::setReadDate()
     * @uses MonthlyBillingCycle::setBillDate()
     * @uses MonthlyBillingCycle::setIsIDRSchedule()
     * @uses MonthlyBillingCycle::setPaymentDate()
     * @uses MonthlyBillingCycle::setBillingCycleIdentifier()
     * @uses MonthlyBillingCycle::setDistributionServiceProviderName()
     * @param int $monthlyBillingCycleID
     * @param int $distributionServiceProviderID
     * @param int $cycleYear
     * @param int $cycleMonth
     * @param string $startDate
     * @param string $readDate
     * @param string $billDate
     * @param bool $isIDRSchedule
     * @param string $paymentDate
     * @param string $billingCycleIdentifier
     * @param string $distributionServiceProviderName
     */
    public function __construct($monthlyBillingCycleID = null, $distributionServiceProviderID = null, $cycleYear = null, $cycleMonth = null, $startDate = null, $readDate = null, $billDate = null, $isIDRSchedule = null, $paymentDate = null, $billingCycleIdentifier = null, $distributionServiceProviderName = null)
    {
        $this
            ->setMonthlyBillingCycleID($monthlyBillingCycleID)
            ->setDistributionServiceProviderID($distributionServiceProviderID)
            ->setCycleYear($cycleYear)
            ->setCycleMonth($cycleMonth)
            ->setStartDate($startDate)
            ->setReadDate($readDate)
            ->setBillDate($billDate)
            ->setIsIDRSchedule($isIDRSchedule)
            ->setPaymentDate($paymentDate)
            ->setBillingCycleIdentifier($billingCycleIdentifier)
            ->setDistributionServiceProviderName($distributionServiceProviderName);
    }
    /**
     * Get MonthlyBillingCycleID value
     * @return int
     */
    public function getMonthlyBillingCycleID()
    {
        return $this->MonthlyBillingCycleID;
    }
    /**
     * Set MonthlyBillingCycleID value
     * @param int $monthlyBillingCycleID
     * @return \SGCIS\Struct\MonthlyBillingCycle
     */
    public function setMonthlyBillingCycleID($monthlyBillingCycleID = null)
    {
        // validation for constraint: int
        if (!is_null($monthlyBillingCycleID) && !is_numeric($monthlyBillingCycleID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($monthlyBillingCycleID)), __LINE__);
        }
        $this->MonthlyBillingCycleID = $monthlyBillingCycleID;
        return $this;
    }
    /**
     * Get DistributionServiceProviderID value
     * @return int
     */
    public function getDistributionServiceProviderID()
    {
        return $this->DistributionServiceProviderID;
    }
    /**
     * Set DistributionServiceProviderID value
     * @param int $distributionServiceProviderID
     * @return \SGCIS\Struct\MonthlyBillingCycle
     */
    public function setDistributionServiceProviderID($distributionServiceProviderID = null)
    {
        // validation for constraint: int
        if (!is_null($distributionServiceProviderID) && !is_numeric($distributionServiceProviderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($distributionServiceProviderID)), __LINE__);
        }
        $this->DistributionServiceProviderID = $distributionServiceProviderID;
        return $this;
    }
    /**
     * Get CycleYear value
     * @return int
     */
    public function getCycleYear()
    {
        return $this->CycleYear;
    }
    /**
     * Set CycleYear value
     * @param int $cycleYear
     * @return \SGCIS\Struct\MonthlyBillingCycle
     */
    public function setCycleYear($cycleYear = null)
    {
        // validation for constraint: int
        if (!is_null($cycleYear) && !is_numeric($cycleYear)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($cycleYear)), __LINE__);
        }
        $this->CycleYear = $cycleYear;
        return $this;
    }
    /**
     * Get CycleMonth value
     * @return int
     */
    public function getCycleMonth()
    {
        return $this->CycleMonth;
    }
    /**
     * Set CycleMonth value
     * @param int $cycleMonth
     * @return \SGCIS\Struct\MonthlyBillingCycle
     */
    public function setCycleMonth($cycleMonth = null)
    {
        // validation for constraint: int
        if (!is_null($cycleMonth) && !is_numeric($cycleMonth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($cycleMonth)), __LINE__);
        }
        $this->CycleMonth = $cycleMonth;
        return $this;
    }
    /**
     * Get StartDate value
     * @return string
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \SGCIS\Struct\MonthlyBillingCycle
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get ReadDate value
     * @return string
     */
    public function getReadDate()
    {
        return $this->ReadDate;
    }
    /**
     * Set ReadDate value
     * @param string $readDate
     * @return \SGCIS\Struct\MonthlyBillingCycle
     */
    public function setReadDate($readDate = null)
    {
        // validation for constraint: string
        if (!is_null($readDate) && !is_string($readDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($readDate)), __LINE__);
        }
        $this->ReadDate = $readDate;
        return $this;
    }
    /**
     * Get BillDate value
     * @return string
     */
    public function getBillDate()
    {
        return $this->BillDate;
    }
    /**
     * Set BillDate value
     * @param string $billDate
     * @return \SGCIS\Struct\MonthlyBillingCycle
     */
    public function setBillDate($billDate = null)
    {
        // validation for constraint: string
        if (!is_null($billDate) && !is_string($billDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billDate)), __LINE__);
        }
        $this->BillDate = $billDate;
        return $this;
    }
    /**
     * Get IsIDRSchedule value
     * @return bool
     */
    public function getIsIDRSchedule()
    {
        return $this->IsIDRSchedule;
    }
    /**
     * Set IsIDRSchedule value
     * @param bool $isIDRSchedule
     * @return \SGCIS\Struct\MonthlyBillingCycle
     */
    public function setIsIDRSchedule($isIDRSchedule = null)
    {
        // validation for constraint: boolean
        if (!is_null($isIDRSchedule) && !is_bool($isIDRSchedule)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isIDRSchedule)), __LINE__);
        }
        $this->IsIDRSchedule = $isIDRSchedule;
        return $this;
    }
    /**
     * Get PaymentDate value
     * @return string
     */
    public function getPaymentDate()
    {
        return $this->PaymentDate;
    }
    /**
     * Set PaymentDate value
     * @param string $paymentDate
     * @return \SGCIS\Struct\MonthlyBillingCycle
     */
    public function setPaymentDate($paymentDate = null)
    {
        // validation for constraint: string
        if (!is_null($paymentDate) && !is_string($paymentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentDate)), __LINE__);
        }
        $this->PaymentDate = $paymentDate;
        return $this;
    }
    /**
     * Get BillingCycleIdentifier value
     * @return string|null
     */
    public function getBillingCycleIdentifier()
    {
        return $this->BillingCycleIdentifier;
    }
    /**
     * Set BillingCycleIdentifier value
     * @param string $billingCycleIdentifier
     * @return \SGCIS\Struct\MonthlyBillingCycle
     */
    public function setBillingCycleIdentifier($billingCycleIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($billingCycleIdentifier) && !is_string($billingCycleIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billingCycleIdentifier)), __LINE__);
        }
        $this->BillingCycleIdentifier = $billingCycleIdentifier;
        return $this;
    }
    /**
     * Get DistributionServiceProviderName value
     * @return string|null
     */
    public function getDistributionServiceProviderName()
    {
        return $this->DistributionServiceProviderName;
    }
    /**
     * Set DistributionServiceProviderName value
     * @param string $distributionServiceProviderName
     * @return \SGCIS\Struct\MonthlyBillingCycle
     */
    public function setDistributionServiceProviderName($distributionServiceProviderName = null)
    {
        // validation for constraint: string
        if (!is_null($distributionServiceProviderName) && !is_string($distributionServiceProviderName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($distributionServiceProviderName)), __LINE__);
        }
        $this->DistributionServiceProviderName = $distributionServiceProviderName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\MonthlyBillingCycle
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
