<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MeterReadRatingComponentDetail Struct
 * @subpackage Structs
 */
class MeterReadRatingComponentDetail extends AbstractStructBase
{
    /**
     * The MeterReadRatingComponentDetailID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MeterReadRatingComponentDetailID;
    /**
     * The MeterReadRatingComponentID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MeterReadRatingComponentID;
    /**
     * The ChargeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ChargeID;
    /**
     * The RateValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $RateValue;
    /**
     * The ChargeAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ChargeAmount;
    /**
     * The ConsumptionValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ConsumptionValue;
    /**
     * The BillValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $BillValue;
    /**
     * The CreateDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreateDate;
    /**
     * The ChargeCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ChargeCode;
    /**
     * The ChargeName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ChargeName;
    /**
     * Constructor method for MeterReadRatingComponentDetail
     * @uses MeterReadRatingComponentDetail::setMeterReadRatingComponentDetailID()
     * @uses MeterReadRatingComponentDetail::setMeterReadRatingComponentID()
     * @uses MeterReadRatingComponentDetail::setChargeID()
     * @uses MeterReadRatingComponentDetail::setRateValue()
     * @uses MeterReadRatingComponentDetail::setChargeAmount()
     * @uses MeterReadRatingComponentDetail::setConsumptionValue()
     * @uses MeterReadRatingComponentDetail::setBillValue()
     * @uses MeterReadRatingComponentDetail::setCreateDate()
     * @uses MeterReadRatingComponentDetail::setChargeCode()
     * @uses MeterReadRatingComponentDetail::setChargeName()
     * @param int $meterReadRatingComponentDetailID
     * @param int $meterReadRatingComponentID
     * @param int $chargeID
     * @param float $rateValue
     * @param float $chargeAmount
     * @param float $consumptionValue
     * @param float $billValue
     * @param string $createDate
     * @param string $chargeCode
     * @param string $chargeName
     */
    public function __construct($meterReadRatingComponentDetailID = null, $meterReadRatingComponentID = null, $chargeID = null, $rateValue = null, $chargeAmount = null, $consumptionValue = null, $billValue = null, $createDate = null, $chargeCode = null, $chargeName = null)
    {
        $this
            ->setMeterReadRatingComponentDetailID($meterReadRatingComponentDetailID)
            ->setMeterReadRatingComponentID($meterReadRatingComponentID)
            ->setChargeID($chargeID)
            ->setRateValue($rateValue)
            ->setChargeAmount($chargeAmount)
            ->setConsumptionValue($consumptionValue)
            ->setBillValue($billValue)
            ->setCreateDate($createDate)
            ->setChargeCode($chargeCode)
            ->setChargeName($chargeName);
    }
    /**
     * Get MeterReadRatingComponentDetailID value
     * @return int
     */
    public function getMeterReadRatingComponentDetailID()
    {
        return $this->MeterReadRatingComponentDetailID;
    }
    /**
     * Set MeterReadRatingComponentDetailID value
     * @param int $meterReadRatingComponentDetailID
     * @return \SGCIS\Struct\MeterReadRatingComponentDetail
     */
    public function setMeterReadRatingComponentDetailID($meterReadRatingComponentDetailID = null)
    {
        // validation for constraint: int
        if (!is_null($meterReadRatingComponentDetailID) && !is_numeric($meterReadRatingComponentDetailID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($meterReadRatingComponentDetailID)), __LINE__);
        }
        $this->MeterReadRatingComponentDetailID = $meterReadRatingComponentDetailID;
        return $this;
    }
    /**
     * Get MeterReadRatingComponentID value
     * @return int
     */
    public function getMeterReadRatingComponentID()
    {
        return $this->MeterReadRatingComponentID;
    }
    /**
     * Set MeterReadRatingComponentID value
     * @param int $meterReadRatingComponentID
     * @return \SGCIS\Struct\MeterReadRatingComponentDetail
     */
    public function setMeterReadRatingComponentID($meterReadRatingComponentID = null)
    {
        // validation for constraint: int
        if (!is_null($meterReadRatingComponentID) && !is_numeric($meterReadRatingComponentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($meterReadRatingComponentID)), __LINE__);
        }
        $this->MeterReadRatingComponentID = $meterReadRatingComponentID;
        return $this;
    }
    /**
     * Get ChargeID value
     * @return int
     */
    public function getChargeID()
    {
        return $this->ChargeID;
    }
    /**
     * Set ChargeID value
     * @param int $chargeID
     * @return \SGCIS\Struct\MeterReadRatingComponentDetail
     */
    public function setChargeID($chargeID = null)
    {
        // validation for constraint: int
        if (!is_null($chargeID) && !is_numeric($chargeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($chargeID)), __LINE__);
        }
        $this->ChargeID = $chargeID;
        return $this;
    }
    /**
     * Get RateValue value
     * @return float
     */
    public function getRateValue()
    {
        return $this->RateValue;
    }
    /**
     * Set RateValue value
     * @param float $rateValue
     * @return \SGCIS\Struct\MeterReadRatingComponentDetail
     */
    public function setRateValue($rateValue = null)
    {
        $this->RateValue = $rateValue;
        return $this;
    }
    /**
     * Get ChargeAmount value
     * @return float
     */
    public function getChargeAmount()
    {
        return $this->ChargeAmount;
    }
    /**
     * Set ChargeAmount value
     * @param float $chargeAmount
     * @return \SGCIS\Struct\MeterReadRatingComponentDetail
     */
    public function setChargeAmount($chargeAmount = null)
    {
        $this->ChargeAmount = $chargeAmount;
        return $this;
    }
    /**
     * Get ConsumptionValue value
     * @return float
     */
    public function getConsumptionValue()
    {
        return $this->ConsumptionValue;
    }
    /**
     * Set ConsumptionValue value
     * @param float $consumptionValue
     * @return \SGCIS\Struct\MeterReadRatingComponentDetail
     */
    public function setConsumptionValue($consumptionValue = null)
    {
        $this->ConsumptionValue = $consumptionValue;
        return $this;
    }
    /**
     * Get BillValue value
     * @return float
     */
    public function getBillValue()
    {
        return $this->BillValue;
    }
    /**
     * Set BillValue value
     * @param float $billValue
     * @return \SGCIS\Struct\MeterReadRatingComponentDetail
     */
    public function setBillValue($billValue = null)
    {
        $this->BillValue = $billValue;
        return $this;
    }
    /**
     * Get CreateDate value
     * @return string
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \SGCIS\Struct\MeterReadRatingComponentDetail
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Get ChargeCode value
     * @return string|null
     */
    public function getChargeCode()
    {
        return $this->ChargeCode;
    }
    /**
     * Set ChargeCode value
     * @param string $chargeCode
     * @return \SGCIS\Struct\MeterReadRatingComponentDetail
     */
    public function setChargeCode($chargeCode = null)
    {
        // validation for constraint: string
        if (!is_null($chargeCode) && !is_string($chargeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($chargeCode)), __LINE__);
        }
        $this->ChargeCode = $chargeCode;
        return $this;
    }
    /**
     * Get ChargeName value
     * @return string|null
     */
    public function getChargeName()
    {
        return $this->ChargeName;
    }
    /**
     * Set ChargeName value
     * @param string $chargeName
     * @return \SGCIS\Struct\MeterReadRatingComponentDetail
     */
    public function setChargeName($chargeName = null)
    {
        // validation for constraint: string
        if (!is_null($chargeName) && !is_string($chargeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($chargeName)), __LINE__);
        }
        $this->ChargeName = $chargeName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\MeterReadRatingComponentDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
