<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MeterReadDetail Struct
 * @subpackage Structs
 */
class MeterReadDetail extends AbstractStructBase
{
    /**
     * The MeterReadDetailID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MeterReadDetailID;
    /**
     * The MeterReadID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MeterReadID;
    /**
     * The MeterReadDetailStatusID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MeterReadDetailStatusID;
    /**
     * The VersionedMeterReadDetailID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $VersionedMeterReadDetailID;
    /**
     * The VersionNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $VersionNumber;
    /**
     * The ReadDateTimeFrom
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ReadDateTimeFrom;
    /**
     * The ReadDateTimeTo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ReadDateTimeTo;
    /**
     * The ReadValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ReadValue;
    /**
     * The RawConsumptionValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $RawConsumptionValue;
    /**
     * The ConsumptionValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ConsumptionValue;
    /**
     * The RateValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $RateValue;
    /**
     * The ChargeValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ChargeValue;
    /**
     * The EstimationRuleAppliedID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $EstimationRuleAppliedID;
    /**
     * The UnitOfMeasureID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UnitOfMeasureID;
    /**
     * The IsEstimatedFromSource
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsEstimatedFromSource;
    /**
     * The CreateDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreateDate;
    /**
     * The LastUpdateDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $LastUpdateDate;
    /**
     * The ChargeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ChargeID;
    /**
     * The TOUChargeValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TOUChargeValue;
    /**
     * The ConsumptionDollarsDiscounted
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ConsumptionDollarsDiscounted;
    /**
     * The RateDiscounted
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $RateDiscounted;
    /**
     * The TotalRate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalRate;
    /**
     * The TotalCharges
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalCharges;
    /**
     * The MissingDetailIndex
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MissingDetailIndex;
    /**
     * The IsMissingRead
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsMissingRead;
    /**
     * The EnergyCharge
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $EnergyCharge;
    /**
     * The PreviousReadConsumptionValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PreviousReadConsumptionValue;
    /**
     * The PreviousReadChargeValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PreviousReadChargeValue;
    /**
     * The EstimationRuleAppliedName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EstimationRuleAppliedName;
    /**
     * The Notes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Notes;
    /**
     * The UnitOfMeasureName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UnitOfMeasureName;
    /**
     * The EditedByUserName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EditedByUserName;
    /**
     * The MeterReadDetailStatusName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MeterReadDetailStatusName;
    /**
     * The VEEValidationRuleStringArray
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VEEValidationRuleStringArray;
    /**
     * The FailedValidationRules
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfMeterReadDetailFailedValidationRule
     */
    public $FailedValidationRules;
    /**
     * The VEEValidationRules
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfVEEValidationRule
     */
    public $VEEValidationRules;
    /**
     * Constructor method for MeterReadDetail
     * @uses MeterReadDetail::setMeterReadDetailID()
     * @uses MeterReadDetail::setMeterReadID()
     * @uses MeterReadDetail::setMeterReadDetailStatusID()
     * @uses MeterReadDetail::setVersionedMeterReadDetailID()
     * @uses MeterReadDetail::setVersionNumber()
     * @uses MeterReadDetail::setReadDateTimeFrom()
     * @uses MeterReadDetail::setReadDateTimeTo()
     * @uses MeterReadDetail::setReadValue()
     * @uses MeterReadDetail::setRawConsumptionValue()
     * @uses MeterReadDetail::setConsumptionValue()
     * @uses MeterReadDetail::setRateValue()
     * @uses MeterReadDetail::setChargeValue()
     * @uses MeterReadDetail::setEstimationRuleAppliedID()
     * @uses MeterReadDetail::setUnitOfMeasureID()
     * @uses MeterReadDetail::setIsEstimatedFromSource()
     * @uses MeterReadDetail::setCreateDate()
     * @uses MeterReadDetail::setLastUpdateDate()
     * @uses MeterReadDetail::setChargeID()
     * @uses MeterReadDetail::setTOUChargeValue()
     * @uses MeterReadDetail::setConsumptionDollarsDiscounted()
     * @uses MeterReadDetail::setRateDiscounted()
     * @uses MeterReadDetail::setTotalRate()
     * @uses MeterReadDetail::setTotalCharges()
     * @uses MeterReadDetail::setMissingDetailIndex()
     * @uses MeterReadDetail::setIsMissingRead()
     * @uses MeterReadDetail::setEnergyCharge()
     * @uses MeterReadDetail::setPreviousReadConsumptionValue()
     * @uses MeterReadDetail::setPreviousReadChargeValue()
     * @uses MeterReadDetail::setEstimationRuleAppliedName()
     * @uses MeterReadDetail::setNotes()
     * @uses MeterReadDetail::setUnitOfMeasureName()
     * @uses MeterReadDetail::setEditedByUserName()
     * @uses MeterReadDetail::setMeterReadDetailStatusName()
     * @uses MeterReadDetail::setVEEValidationRuleStringArray()
     * @uses MeterReadDetail::setFailedValidationRules()
     * @uses MeterReadDetail::setVEEValidationRules()
     * @param int $meterReadDetailID
     * @param int $meterReadID
     * @param int $meterReadDetailStatusID
     * @param int $versionedMeterReadDetailID
     * @param int $versionNumber
     * @param string $readDateTimeFrom
     * @param string $readDateTimeTo
     * @param float $readValue
     * @param float $rawConsumptionValue
     * @param float $consumptionValue
     * @param float $rateValue
     * @param float $chargeValue
     * @param int $estimationRuleAppliedID
     * @param int $unitOfMeasureID
     * @param bool $isEstimatedFromSource
     * @param string $createDate
     * @param string $lastUpdateDate
     * @param int $chargeID
     * @param float $tOUChargeValue
     * @param float $consumptionDollarsDiscounted
     * @param float $rateDiscounted
     * @param float $totalRate
     * @param float $totalCharges
     * @param int $missingDetailIndex
     * @param bool $isMissingRead
     * @param float $energyCharge
     * @param float $previousReadConsumptionValue
     * @param float $previousReadChargeValue
     * @param string $estimationRuleAppliedName
     * @param string $notes
     * @param string $unitOfMeasureName
     * @param string $editedByUserName
     * @param string $meterReadDetailStatusName
     * @param string $vEEValidationRuleStringArray
     * @param \SGCIS\Array\ArrayOfMeterReadDetailFailedValidationRule $failedValidationRules
     * @param \SGCIS\Array\ArrayOfVEEValidationRule $vEEValidationRules
     */
    public function __construct($meterReadDetailID = null, $meterReadID = null, $meterReadDetailStatusID = null, $versionedMeterReadDetailID = null, $versionNumber = null, $readDateTimeFrom = null, $readDateTimeTo = null, $readValue = null, $rawConsumptionValue = null, $consumptionValue = null, $rateValue = null, $chargeValue = null, $estimationRuleAppliedID = null, $unitOfMeasureID = null, $isEstimatedFromSource = null, $createDate = null, $lastUpdateDate = null, $chargeID = null, $tOUChargeValue = null, $consumptionDollarsDiscounted = null, $rateDiscounted = null, $totalRate = null, $totalCharges = null, $missingDetailIndex = null, $isMissingRead = null, $energyCharge = null, $previousReadConsumptionValue = null, $previousReadChargeValue = null, $estimationRuleAppliedName = null, $notes = null, $unitOfMeasureName = null, $editedByUserName = null, $meterReadDetailStatusName = null, $vEEValidationRuleStringArray = null, \SGCIS\Array\ArrayOfMeterReadDetailFailedValidationRule $failedValidationRules = null, \SGCIS\Array\ArrayOfVEEValidationRule $vEEValidationRules = null)
    {
        $this
            ->setMeterReadDetailID($meterReadDetailID)
            ->setMeterReadID($meterReadID)
            ->setMeterReadDetailStatusID($meterReadDetailStatusID)
            ->setVersionedMeterReadDetailID($versionedMeterReadDetailID)
            ->setVersionNumber($versionNumber)
            ->setReadDateTimeFrom($readDateTimeFrom)
            ->setReadDateTimeTo($readDateTimeTo)
            ->setReadValue($readValue)
            ->setRawConsumptionValue($rawConsumptionValue)
            ->setConsumptionValue($consumptionValue)
            ->setRateValue($rateValue)
            ->setChargeValue($chargeValue)
            ->setEstimationRuleAppliedID($estimationRuleAppliedID)
            ->setUnitOfMeasureID($unitOfMeasureID)
            ->setIsEstimatedFromSource($isEstimatedFromSource)
            ->setCreateDate($createDate)
            ->setLastUpdateDate($lastUpdateDate)
            ->setChargeID($chargeID)
            ->setTOUChargeValue($tOUChargeValue)
            ->setConsumptionDollarsDiscounted($consumptionDollarsDiscounted)
            ->setRateDiscounted($rateDiscounted)
            ->setTotalRate($totalRate)
            ->setTotalCharges($totalCharges)
            ->setMissingDetailIndex($missingDetailIndex)
            ->setIsMissingRead($isMissingRead)
            ->setEnergyCharge($energyCharge)
            ->setPreviousReadConsumptionValue($previousReadConsumptionValue)
            ->setPreviousReadChargeValue($previousReadChargeValue)
            ->setEstimationRuleAppliedName($estimationRuleAppliedName)
            ->setNotes($notes)
            ->setUnitOfMeasureName($unitOfMeasureName)
            ->setEditedByUserName($editedByUserName)
            ->setMeterReadDetailStatusName($meterReadDetailStatusName)
            ->setVEEValidationRuleStringArray($vEEValidationRuleStringArray)
            ->setFailedValidationRules($failedValidationRules)
            ->setVEEValidationRules($vEEValidationRules);
    }
    /**
     * Get MeterReadDetailID value
     * @return int
     */
    public function getMeterReadDetailID()
    {
        return $this->MeterReadDetailID;
    }
    /**
     * Set MeterReadDetailID value
     * @param int $meterReadDetailID
     * @return \SGCIS\Struct\MeterReadDetail
     */
    public function setMeterReadDetailID($meterReadDetailID = null)
    {
        // validation for constraint: int
        if (!is_null($meterReadDetailID) && !is_numeric($meterReadDetailID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($meterReadDetailID)), __LINE__);
        }
        $this->MeterReadDetailID = $meterReadDetailID;
        return $this;
    }
    /**
     * Get MeterReadID value
     * @return int
     */
    public function getMeterReadID()
    {
        return $this->MeterReadID;
    }
    /**
     * Set MeterReadID value
     * @param int $meterReadID
     * @return \SGCIS\Struct\MeterReadDetail
     */
    public function setMeterReadID($meterReadID = null)
    {
        // validation for constraint: int
        if (!is_null($meterReadID) && !is_numeric($meterReadID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($meterReadID)), __LINE__);
        }
        $this->MeterReadID = $meterReadID;
        return $this;
    }
    /**
     * Get MeterReadDetailStatusID value
     * @return int
     */
    public function getMeterReadDetailStatusID()
    {
        return $this->MeterReadDetailStatusID;
    }
    /**
     * Set MeterReadDetailStatusID value
     * @param int $meterReadDetailStatusID
     * @return \SGCIS\Struct\MeterReadDetail
     */
    public function setMeterReadDetailStatusID($meterReadDetailStatusID = null)
    {
        // validation for constraint: int
        if (!is_null($meterReadDetailStatusID) && !is_numeric($meterReadDetailStatusID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($meterReadDetailStatusID)), __LINE__);
        }
        $this->MeterReadDetailStatusID = $meterReadDetailStatusID;
        return $this;
    }
    /**
     * Get VersionedMeterReadDetailID value
     * @return int
     */
    public function getVersionedMeterReadDetailID()
    {
        return $this->VersionedMeterReadDetailID;
    }
    /**
     * Set VersionedMeterReadDetailID value
     * @param int $versionedMeterReadDetailID
     * @return \SGCIS\Struct\MeterReadDetail
     */
    public function setVersionedMeterReadDetailID($versionedMeterReadDetailID = null)
    {
        // validation for constraint: int
        if (!is_null($versionedMeterReadDetailID) && !is_numeric($versionedMeterReadDetailID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($versionedMeterReadDetailID)), __LINE__);
        }
        $this->VersionedMeterReadDetailID = $versionedMeterReadDetailID;
        return $this;
    }
    /**
     * Get VersionNumber value
     * @return int
     */
    public function getVersionNumber()
    {
        return $this->VersionNumber;
    }
    /**
     * Set VersionNumber value
     * @param int $versionNumber
     * @return \SGCIS\Struct\MeterReadDetail
     */
    public function setVersionNumber($versionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($versionNumber) && !is_numeric($versionNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($versionNumber)), __LINE__);
        }
        $this->VersionNumber = $versionNumber;
        return $this;
    }
    /**
     * Get ReadDateTimeFrom value
     * @return string
     */
    public function getReadDateTimeFrom()
    {
        return $this->ReadDateTimeFrom;
    }
    /**
     * Set ReadDateTimeFrom value
     * @param string $readDateTimeFrom
     * @return \SGCIS\Struct\MeterReadDetail
     */
    public function setReadDateTimeFrom($readDateTimeFrom = null)
    {
        // validation for constraint: string
        if (!is_null($readDateTimeFrom) && !is_string($readDateTimeFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($readDateTimeFrom)), __LINE__);
        }
        $this->ReadDateTimeFrom = $readDateTimeFrom;
        return $this;
    }
    /**
     * Get ReadDateTimeTo value
     * @return string
     */
    public function getReadDateTimeTo()
    {
        return $this->ReadDateTimeTo;
    }
    /**
     * Set ReadDateTimeTo value
     * @param string $readDateTimeTo
     * @return \SGCIS\Struct\MeterReadDetail
     */
    public function setReadDateTimeTo($readDateTimeTo = null)
    {
        // validation for constraint: string
        if (!is_null($readDateTimeTo) && !is_string($readDateTimeTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($readDateTimeTo)), __LINE__);
        }
        $this->ReadDateTimeTo = $readDateTimeTo;
        return $this;
    }
    /**
     * Get ReadValue value
     * @return float
     */
    public function getReadValue()
    {
        return $this->ReadValue;
    }
    /**
     * Set ReadValue value
     * @param float $readValue
     * @return \SGCIS\Struct\MeterReadDetail
     */
    public function setReadValue($readValue = null)
    {
        $this->ReadValue = $readValue;
        return $this;
    }
    /**
     * Get RawConsumptionValue value
     * @return float
     */
    public function getRawConsumptionValue()
    {
        return $this->RawConsumptionValue;
    }
    /**
     * Set RawConsumptionValue value
     * @param float $rawConsumptionValue
     * @return \SGCIS\Struct\MeterReadDetail
     */
    public function setRawConsumptionValue($rawConsumptionValue = null)
    {
        $this->RawConsumptionValue = $rawConsumptionValue;
        return $this;
    }
    /**
     * Get ConsumptionValue value
     * @return float
     */
    public function getConsumptionValue()
    {
        return $this->ConsumptionValue;
    }
    /**
     * Set ConsumptionValue value
     * @param float $consumptionValue
     * @return \SGCIS\Struct\MeterReadDetail
     */
    public function setConsumptionValue($consumptionValue = null)
    {
        $this->ConsumptionValue = $consumptionValue;
        return $this;
    }
    /**
     * Get RateValue value
     * @return float
     */
    public function getRateValue()
    {
        return $this->RateValue;
    }
    /**
     * Set RateValue value
     * @param float $rateValue
     * @return \SGCIS\Struct\MeterReadDetail
     */
    public function setRateValue($rateValue = null)
    {
        $this->RateValue = $rateValue;
        return $this;
    }
    /**
     * Get ChargeValue value
     * @return float
     */
    public function getChargeValue()
    {
        return $this->ChargeValue;
    }
    /**
     * Set ChargeValue value
     * @param float $chargeValue
     * @return \SGCIS\Struct\MeterReadDetail
     */
    public function setChargeValue($chargeValue = null)
    {
        $this->ChargeValue = $chargeValue;
        return $this;
    }
    /**
     * Get EstimationRuleAppliedID value
     * @return int
     */
    public function getEstimationRuleAppliedID()
    {
        return $this->EstimationRuleAppliedID;
    }
    /**
     * Set EstimationRuleAppliedID value
     * @param int $estimationRuleAppliedID
     * @return \SGCIS\Struct\MeterReadDetail
     */
    public function setEstimationRuleAppliedID($estimationRuleAppliedID = null)
    {
        // validation for constraint: int
        if (!is_null($estimationRuleAppliedID) && !is_numeric($estimationRuleAppliedID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($estimationRuleAppliedID)), __LINE__);
        }
        $this->EstimationRuleAppliedID = $estimationRuleAppliedID;
        return $this;
    }
    /**
     * Get UnitOfMeasureID value
     * @return int
     */
    public function getUnitOfMeasureID()
    {
        return $this->UnitOfMeasureID;
    }
    /**
     * Set UnitOfMeasureID value
     * @param int $unitOfMeasureID
     * @return \SGCIS\Struct\MeterReadDetail
     */
    public function setUnitOfMeasureID($unitOfMeasureID = null)
    {
        // validation for constraint: int
        if (!is_null($unitOfMeasureID) && !is_numeric($unitOfMeasureID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($unitOfMeasureID)), __LINE__);
        }
        $this->UnitOfMeasureID = $unitOfMeasureID;
        return $this;
    }
    /**
     * Get IsEstimatedFromSource value
     * @return bool
     */
    public function getIsEstimatedFromSource()
    {
        return $this->IsEstimatedFromSource;
    }
    /**
     * Set IsEstimatedFromSource value
     * @param bool $isEstimatedFromSource
     * @return \SGCIS\Struct\MeterReadDetail
     */
    public function setIsEstimatedFromSource($isEstimatedFromSource = null)
    {
        // validation for constraint: boolean
        if (!is_null($isEstimatedFromSource) && !is_bool($isEstimatedFromSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isEstimatedFromSource)), __LINE__);
        }
        $this->IsEstimatedFromSource = $isEstimatedFromSource;
        return $this;
    }
    /**
     * Get CreateDate value
     * @return string
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \SGCIS\Struct\MeterReadDetail
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Get LastUpdateDate value
     * @return string
     */
    public function getLastUpdateDate()
    {
        return $this->LastUpdateDate;
    }
    /**
     * Set LastUpdateDate value
     * @param string $lastUpdateDate
     * @return \SGCIS\Struct\MeterReadDetail
     */
    public function setLastUpdateDate($lastUpdateDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastUpdateDate) && !is_string($lastUpdateDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastUpdateDate)), __LINE__);
        }
        $this->LastUpdateDate = $lastUpdateDate;
        return $this;
    }
    /**
     * Get ChargeID value
     * @return int
     */
    public function getChargeID()
    {
        return $this->ChargeID;
    }
    /**
     * Set ChargeID value
     * @param int $chargeID
     * @return \SGCIS\Struct\MeterReadDetail
     */
    public function setChargeID($chargeID = null)
    {
        // validation for constraint: int
        if (!is_null($chargeID) && !is_numeric($chargeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($chargeID)), __LINE__);
        }
        $this->ChargeID = $chargeID;
        return $this;
    }
    /**
     * Get TOUChargeValue value
     * @return float
     */
    public function getTOUChargeValue()
    {
        return $this->TOUChargeValue;
    }
    /**
     * Set TOUChargeValue value
     * @param float $tOUChargeValue
     * @return \SGCIS\Struct\MeterReadDetail
     */
    public function setTOUChargeValue($tOUChargeValue = null)
    {
        $this->TOUChargeValue = $tOUChargeValue;
        return $this;
    }
    /**
     * Get ConsumptionDollarsDiscounted value
     * @return float
     */
    public function getConsumptionDollarsDiscounted()
    {
        return $this->ConsumptionDollarsDiscounted;
    }
    /**
     * Set ConsumptionDollarsDiscounted value
     * @param float $consumptionDollarsDiscounted
     * @return \SGCIS\Struct\MeterReadDetail
     */
    public function setConsumptionDollarsDiscounted($consumptionDollarsDiscounted = null)
    {
        $this->ConsumptionDollarsDiscounted = $consumptionDollarsDiscounted;
        return $this;
    }
    /**
     * Get RateDiscounted value
     * @return float
     */
    public function getRateDiscounted()
    {
        return $this->RateDiscounted;
    }
    /**
     * Set RateDiscounted value
     * @param float $rateDiscounted
     * @return \SGCIS\Struct\MeterReadDetail
     */
    public function setRateDiscounted($rateDiscounted = null)
    {
        $this->RateDiscounted = $rateDiscounted;
        return $this;
    }
    /**
     * Get TotalRate value
     * @return float
     */
    public function getTotalRate()
    {
        return $this->TotalRate;
    }
    /**
     * Set TotalRate value
     * @param float $totalRate
     * @return \SGCIS\Struct\MeterReadDetail
     */
    public function setTotalRate($totalRate = null)
    {
        $this->TotalRate = $totalRate;
        return $this;
    }
    /**
     * Get TotalCharges value
     * @return float
     */
    public function getTotalCharges()
    {
        return $this->TotalCharges;
    }
    /**
     * Set TotalCharges value
     * @param float $totalCharges
     * @return \SGCIS\Struct\MeterReadDetail
     */
    public function setTotalCharges($totalCharges = null)
    {
        $this->TotalCharges = $totalCharges;
        return $this;
    }
    /**
     * Get MissingDetailIndex value
     * @return int
     */
    public function getMissingDetailIndex()
    {
        return $this->MissingDetailIndex;
    }
    /**
     * Set MissingDetailIndex value
     * @param int $missingDetailIndex
     * @return \SGCIS\Struct\MeterReadDetail
     */
    public function setMissingDetailIndex($missingDetailIndex = null)
    {
        // validation for constraint: int
        if (!is_null($missingDetailIndex) && !is_numeric($missingDetailIndex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($missingDetailIndex)), __LINE__);
        }
        $this->MissingDetailIndex = $missingDetailIndex;
        return $this;
    }
    /**
     * Get IsMissingRead value
     * @return bool
     */
    public function getIsMissingRead()
    {
        return $this->IsMissingRead;
    }
    /**
     * Set IsMissingRead value
     * @param bool $isMissingRead
     * @return \SGCIS\Struct\MeterReadDetail
     */
    public function setIsMissingRead($isMissingRead = null)
    {
        // validation for constraint: boolean
        if (!is_null($isMissingRead) && !is_bool($isMissingRead)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isMissingRead)), __LINE__);
        }
        $this->IsMissingRead = $isMissingRead;
        return $this;
    }
    /**
     * Get EnergyCharge value
     * @return float
     */
    public function getEnergyCharge()
    {
        return $this->EnergyCharge;
    }
    /**
     * Set EnergyCharge value
     * @param float $energyCharge
     * @return \SGCIS\Struct\MeterReadDetail
     */
    public function setEnergyCharge($energyCharge = null)
    {
        $this->EnergyCharge = $energyCharge;
        return $this;
    }
    /**
     * Get PreviousReadConsumptionValue value
     * @return float
     */
    public function getPreviousReadConsumptionValue()
    {
        return $this->PreviousReadConsumptionValue;
    }
    /**
     * Set PreviousReadConsumptionValue value
     * @param float $previousReadConsumptionValue
     * @return \SGCIS\Struct\MeterReadDetail
     */
    public function setPreviousReadConsumptionValue($previousReadConsumptionValue = null)
    {
        $this->PreviousReadConsumptionValue = $previousReadConsumptionValue;
        return $this;
    }
    /**
     * Get PreviousReadChargeValue value
     * @return float
     */
    public function getPreviousReadChargeValue()
    {
        return $this->PreviousReadChargeValue;
    }
    /**
     * Set PreviousReadChargeValue value
     * @param float $previousReadChargeValue
     * @return \SGCIS\Struct\MeterReadDetail
     */
    public function setPreviousReadChargeValue($previousReadChargeValue = null)
    {
        $this->PreviousReadChargeValue = $previousReadChargeValue;
        return $this;
    }
    /**
     * Get EstimationRuleAppliedName value
     * @return string|null
     */
    public function getEstimationRuleAppliedName()
    {
        return $this->EstimationRuleAppliedName;
    }
    /**
     * Set EstimationRuleAppliedName value
     * @param string $estimationRuleAppliedName
     * @return \SGCIS\Struct\MeterReadDetail
     */
    public function setEstimationRuleAppliedName($estimationRuleAppliedName = null)
    {
        // validation for constraint: string
        if (!is_null($estimationRuleAppliedName) && !is_string($estimationRuleAppliedName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($estimationRuleAppliedName)), __LINE__);
        }
        $this->EstimationRuleAppliedName = $estimationRuleAppliedName;
        return $this;
    }
    /**
     * Get Notes value
     * @return string|null
     */
    public function getNotes()
    {
        return $this->Notes;
    }
    /**
     * Set Notes value
     * @param string $notes
     * @return \SGCIS\Struct\MeterReadDetail
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($notes)), __LINE__);
        }
        $this->Notes = $notes;
        return $this;
    }
    /**
     * Get UnitOfMeasureName value
     * @return string|null
     */
    public function getUnitOfMeasureName()
    {
        return $this->UnitOfMeasureName;
    }
    /**
     * Set UnitOfMeasureName value
     * @param string $unitOfMeasureName
     * @return \SGCIS\Struct\MeterReadDetail
     */
    public function setUnitOfMeasureName($unitOfMeasureName = null)
    {
        // validation for constraint: string
        if (!is_null($unitOfMeasureName) && !is_string($unitOfMeasureName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unitOfMeasureName)), __LINE__);
        }
        $this->UnitOfMeasureName = $unitOfMeasureName;
        return $this;
    }
    /**
     * Get EditedByUserName value
     * @return string|null
     */
    public function getEditedByUserName()
    {
        return $this->EditedByUserName;
    }
    /**
     * Set EditedByUserName value
     * @param string $editedByUserName
     * @return \SGCIS\Struct\MeterReadDetail
     */
    public function setEditedByUserName($editedByUserName = null)
    {
        // validation for constraint: string
        if (!is_null($editedByUserName) && !is_string($editedByUserName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($editedByUserName)), __LINE__);
        }
        $this->EditedByUserName = $editedByUserName;
        return $this;
    }
    /**
     * Get MeterReadDetailStatusName value
     * @return string|null
     */
    public function getMeterReadDetailStatusName()
    {
        return $this->MeterReadDetailStatusName;
    }
    /**
     * Set MeterReadDetailStatusName value
     * @param string $meterReadDetailStatusName
     * @return \SGCIS\Struct\MeterReadDetail
     */
    public function setMeterReadDetailStatusName($meterReadDetailStatusName = null)
    {
        // validation for constraint: string
        if (!is_null($meterReadDetailStatusName) && !is_string($meterReadDetailStatusName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($meterReadDetailStatusName)), __LINE__);
        }
        $this->MeterReadDetailStatusName = $meterReadDetailStatusName;
        return $this;
    }
    /**
     * Get VEEValidationRuleStringArray value
     * @return string|null
     */
    public function getVEEValidationRuleStringArray()
    {
        return $this->VEEValidationRuleStringArray;
    }
    /**
     * Set VEEValidationRuleStringArray value
     * @param string $vEEValidationRuleStringArray
     * @return \SGCIS\Struct\MeterReadDetail
     */
    public function setVEEValidationRuleStringArray($vEEValidationRuleStringArray = null)
    {
        // validation for constraint: string
        if (!is_null($vEEValidationRuleStringArray) && !is_string($vEEValidationRuleStringArray)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vEEValidationRuleStringArray)), __LINE__);
        }
        $this->VEEValidationRuleStringArray = $vEEValidationRuleStringArray;
        return $this;
    }
    /**
     * Get FailedValidationRules value
     * @return \SGCIS\Array\ArrayOfMeterReadDetailFailedValidationRule|null
     */
    public function getFailedValidationRules()
    {
        return $this->FailedValidationRules;
    }
    /**
     * Set FailedValidationRules value
     * @param \SGCIS\Array\ArrayOfMeterReadDetailFailedValidationRule $failedValidationRules
     * @return \SGCIS\Struct\MeterReadDetail
     */
    public function setFailedValidationRules(\SGCIS\Array\ArrayOfMeterReadDetailFailedValidationRule $failedValidationRules = null)
    {
        $this->FailedValidationRules = $failedValidationRules;
        return $this;
    }
    /**
     * Get VEEValidationRules value
     * @return \SGCIS\Array\ArrayOfVEEValidationRule|null
     */
    public function getVEEValidationRules()
    {
        return $this->VEEValidationRules;
    }
    /**
     * Set VEEValidationRules value
     * @param \SGCIS\Array\ArrayOfVEEValidationRule $vEEValidationRules
     * @return \SGCIS\Struct\MeterReadDetail
     */
    public function setVEEValidationRules(\SGCIS\Array\ArrayOfVEEValidationRule $vEEValidationRules = null)
    {
        $this->VEEValidationRules = $vEEValidationRules;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\MeterReadDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
